/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.auth.jaas;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.Permission;
import java.util.StringTokenizer;

public class MQDestinationPermission
extends Permission {
    private static final long serialVersionUID = -2435224016059811024L;
    private static final int PRODUCE = 1;
    private static final int CONSUME = 2;
    private static final int BROWSE = 4;
    private static final int NONE = 0;
    private static final int ALL = 7;
    private transient boolean wildcard = false;
    private transient boolean isQueue = false;
    private transient String destName = null;
    private transient int mask = 0;
    private String actions = null;

    public MQDestinationPermission(String name, String actions) {
        super(name);
        this.init(name, actions);
    }

    private void init(String name, String actions) {
        if (name == null) {
            throw new NullPointerException("name null");
        }
        if (name.trim().startsWith("queue:")) {
            this.isQueue = true;
            this.destName = name.trim().substring("queue:".length()).trim();
        } else if (name.trim().startsWith("topic:")) {
            this.isQueue = false;
            this.destName = name.trim().substring("topic:".length()).trim();
        } else {
            throw new IllegalArgumentException("invalid name " + name);
        }
        int len = this.destName.length();
        if (len == 1 && this.destName.equals("*")) {
            this.wildcard = true;
        }
        if (actions == null) {
            throw new NullPointerException("actions null");
        }
        this.mask = this.computeMask(actions);
    }

    public int getMask() {
        return this.mask;
    }

    private int computeMask(String actions) throws IllegalArgumentException {
        int mask = 0;
        StringTokenizer token = new StringTokenizer(actions, ",", false);
        String t = null;
        while (token.hasMoreElements()) {
            t = token.nextToken().trim().toLowerCase();
            int i = 0;
            while (i < t.length() && Character.isSpaceChar(t.charAt(i++))) {
            }
            if (i > 0) {
                t = t.substring(i - 1);
            }
            for (i = t.length() - 1; i != -1 && Character.isSpaceChar(t.charAt(i)); --i) {
            }
            if (i < t.length() - 1) {
                t = t.substring(0, i + 1);
            }
            if (t.equals("produce")) {
                mask |= 1;
                continue;
            }
            if (t.equals("consume")) {
                mask |= 2;
                continue;
            }
            if (!t.equals("browse")) continue;
            mask |= 4;
        }
        if (mask == 0) {
            throw new IllegalArgumentException("invalid actions " + actions);
        }
        return mask;
    }

    @Override
    public boolean implies(Permission p) {
        if (!(p instanceof MQDestinationPermission)) {
            return false;
        }
        MQDestinationPermission that = (MQDestinationPermission)p;
        if (this.isQueue != that.isQueue) {
            return false;
        }
        return (this.mask & that.mask) == that.mask && this.impliesDestName(that);
    }

    private boolean impliesDestName(MQDestinationPermission that) {
        if (this.wildcard) {
            return true;
        }
        if (that.wildcard) {
            return false;
        }
        return this.destName.equals(that.destName);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof MQDestinationPermission)) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        MQDestinationPermission that = (MQDestinationPermission)obj;
        return this.mask == that.mask && this.isQueue == that.isQueue && this.destName.equals(that.destName);
    }

    @Override
    public int hashCode() {
        return this.getName().hashCode();
    }

    @Override
    public String getActions() {
        if (this.actions != null) {
            return this.actions;
        }
        StringBuffer s = new StringBuffer();
        boolean comma = false;
        if ((this.mask & 1) == 1) {
            comma = true;
            s.append("produce");
        }
        if ((this.mask & 2) == 2) {
            if (comma) {
                s.append(',');
            }
            comma = true;
            s.append("consume");
        }
        if ((this.mask & 4) == 4) {
            if (comma) {
                s.append(',');
            }
            comma = true;
            s.append("browse");
        }
        return s.toString();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        if (this.actions == null) {
            this.getActions();
        }
        s.defaultWriteObject();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.init(this.getName(), this.actions);
    }
}

