/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.AdministeredObject;
import com.sun.messaging.BasicQueue;
import com.sun.messaging.BasicTopic;
import com.sun.messaging.Destination;
import com.sun.messaging.jmq.io.JMQByteArrayOutputStream;
import com.sun.messaging.jmq.io.ReadWritePacket;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsclient.ExceptionHandler;
import com.sun.messaging.jmq.jmsclient.SessionImpl;
import com.sun.messaging.jmq.jmsclient.TemporaryQueueImpl;
import com.sun.messaging.jmq.jmsclient.TemporaryTopicImpl;
import com.sun.messaging.jmq.jmsclient.Traceable;
import com.sun.messaging.jmq.jmsclient.ValueConvert;
import com.sun.messaging.jmq.jmsclient.zip.Compressor;
import com.sun.messaging.jmq.jmsclient.zip.Decompressor;
import com.sun.messaging.jms.MessageFormatException;
import jakarta.jms.BytesMessage;
import jakarta.jms.JMSException;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.MessageNotReadableException;
import jakarta.jms.MessageNotWriteableException;
import jakarta.jms.ObjectMessage;
import jakarta.jms.StreamMessage;
import jakarta.jms.TextMessage;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;

public class MessageImpl
implements Message,
com.sun.messaging.jms.Message,
Traceable {
    public static final String UTF8 = "UTF8";
    protected Hashtable properties = null;
    protected ReadWritePacket pkt = null;
    protected boolean readMode = false;
    protected boolean propReadMode = false;
    protected SessionImpl session = null;
    protected SysMessageID messageID = null;
    protected long interestID = 0L;
    protected boolean isOnAckList = false;
    protected boolean isQBrowserMsg = false;
    protected boolean doAcknowledge = true;
    protected boolean consumerInRA = false;
    protected jakarta.jms.Destination destination = null;
    protected jakarta.jms.Destination replyTo = null;
    protected boolean jmsMessageIDSet = false;
    protected String jmsMessageID = null;
    protected boolean shouldCompress = false;
    protected int clientRetries = 0;
    public static final String JMS_SUN_COMPRESS = "JMS_SUN_COMPRESS";
    public static final String JMS_SUN_UNCOMPRESSED_SIZE = "JMS_SUN_UNCOMPRESSED_SIZE";
    public static final String JMS_SUN_COMPRESSED_SIZE = "JMS_SUN_COMPRESSED_SIZE";

    protected void setSession(SessionImpl session) {
        this.session = session;
        if (session.setJMSXConsumerTXID && session.transaction != null) {
            if (this.properties == null) {
                this.properties = new Hashtable();
            }
            this.properties.put("JMSXConsumerTXID", String.valueOf(session.transaction.getTransactionID()));
        }
    }

    public SessionImpl _getSession() {
        return this.session;
    }

    protected void setPacket(ReadWritePacket pkt) {
        this.pkt = pkt;
    }

    protected ReadWritePacket getPacket() {
        return this.pkt;
    }

    protected void setMessageBodyToPacket() throws JMSException {
    }

    protected void getMessageBodyFromPacket() throws JMSException {
    }

    protected void setPropertiesToPacket() throws JMSException {
        try {
            this.pkt.setProperties(this.properties);
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, "C4006", true);
        }
    }

    protected void getPropertiesFromPacket() throws JMSException {
        try {
            this.properties = this.pkt.getProperties();
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, "C4005", true);
        }
    }

    protected void setMessageBody(byte[] messageBody) {
        this.pkt.setMessageBody(messageBody);
    }

    protected InputStream getMessageBodyStream() {
        return this.pkt.getMessageBodyStream();
    }

    protected byte[] getMessageBody() throws JMSException {
        if (this.pkt.getFlag(1024)) {
            this.decompress();
        }
        return this.pkt.getMessageBody();
    }

    protected void compress() throws JMSException {
        try {
            byte[] body = this.pkt.getMessageBody();
            int offset = this.pkt.getMessageBodyOffset();
            int unzipSize = this.pkt.getMessageBodyLength();
            if (body == null) {
                this.setProperty(JMS_SUN_UNCOMPRESSED_SIZE, 0);
                this.setProperty(JMS_SUN_COMPRESSED_SIZE, 0);
                return;
            }
            JMQByteArrayOutputStream baos = new JMQByteArrayOutputStream(new byte[32]);
            Compressor compressor = Compressor.getInstance();
            compressor.compress(body, offset, unzipSize, baos);
            baos.flush();
            byte[] zipbody = baos.getBuf();
            int zipSize = baos.getCount();
            baos.close();
            this.pkt.setMessageBody(zipbody, 0, zipSize);
            this.setProperty(JMS_SUN_UNCOMPRESSED_SIZE, unzipSize);
            this.setProperty(JMS_SUN_COMPRESSED_SIZE, zipSize);
            this.pkt.setFlag(1024, true);
        }
        catch (Exception ioe) {
            ioe.printStackTrace();
            JMSException jmse = new JMSException(ioe.toString());
            jmse.setLinkedException(ioe);
            ExceptionHandler.throwJMSException(jmse);
        }
    }

    protected void decompress() throws JMSException {
        Decompressor decomp = Decompressor.getInstance();
        byte[] zipBody = this.pkt.getMessageBody();
        int unzipSize = this.getIntProperty(JMS_SUN_UNCOMPRESSED_SIZE);
        byte[] unzipBody = new byte[unzipSize];
        decomp.decompress(zipBody, unzipBody);
        this.pkt.setMessageBody(unzipBody, 0, unzipSize);
        this.pkt.setFlag(1024, false);
        this.shouldCompress = true;
    }

    protected static void checkValidPropertyName(String name) throws JMSException {
        char[] namechars;
        if ("NULL".equalsIgnoreCase(name) || "TRUE".equalsIgnoreCase(name) || "FALSE".equalsIgnoreCase(name) || "NOT".equalsIgnoreCase(name) || "AND".equalsIgnoreCase(name) || "OR".equalsIgnoreCase(name) || "BETWEEN".equalsIgnoreCase(name) || "LIKE".equalsIgnoreCase(name) || "IN".equalsIgnoreCase(name) || "IS".equalsIgnoreCase(name)) {
            String errorString = AdministeredObject.cr.getKString("C4041", name);
            JMSException jmse = new JMSException(errorString, "C4041");
            ExceptionHandler.throwJMSException(jmse);
        }
        if (Character.isJavaIdentifierStart((namechars = name.toCharArray())[0])) {
            for (int i = 1; i < namechars.length; ++i) {
                if (Character.isJavaIdentifierPart(namechars[i])) continue;
                String errorString = AdministeredObject.cr.getKString("C4043", String.valueOf(namechars[i]), name);
                JMSException jmse = new JMSException(errorString, "C4043");
                ExceptionHandler.throwJMSException(jmse);
            }
        } else {
            String errorString = AdministeredObject.cr.getKString("C4042", String.valueOf(namechars[0]), name);
            JMSException jmse = new JMSException(errorString, "C4042");
            ExceptionHandler.throwJMSException(jmse);
        }
    }

    protected void checkAndSetProperty(String name, Object value) throws JMSException {
        MessageImpl.checkPropertyNameSet(name);
        if (this.propReadMode) {
            String errorString = AdministeredObject.cr.getKString("C4011");
            MessageNotWriteableException jmse = new MessageNotWriteableException(errorString, "C4011");
            ExceptionHandler.throwJMSException(jmse);
        }
        MessageImpl.checkValidPropertyValue(name, value);
        MessageImpl.checkValidPropertyName(name);
        this.setProperty(name, value);
    }

    protected static void checkPropertyNameSet(String name) {
        if (name == null || "".equals(name)) {
            String errorString = AdministeredObject.cr.getKString("C4072");
            throw new IllegalArgumentException(errorString);
        }
    }

    protected static void checkValidPropertyValue(String name, Object value) throws JMSException {
        if (!(value instanceof Boolean || value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double || value instanceof String)) {
            String errorString = AdministeredObject.cr.getKString("C4040", value == null ? "null" : value.getClass().getName(), name);
            MessageFormatException jmse = new MessageFormatException(errorString, "C4040");
            ExceptionHandler.throwJMSException(jmse);
        }
    }

    private void setProperty(String name, Object value) {
        if (this.properties == null) {
            this.properties = new Hashtable();
        }
        this.properties.put(name, value);
    }

    protected void checkMessageAccess() throws JMSException {
        if (this.readMode) {
            String errorString = AdministeredObject.cr.getKString("C4008");
            MessageNotWriteableException jmse = new MessageNotWriteableException(errorString, "C4008");
            ExceptionHandler.throwJMSException(jmse);
        }
    }

    protected void checkReadAccess() throws JMSException {
        if (!this.readMode) {
            String errorString = AdministeredObject.cr.getKString("C4009");
            MessageNotReadableException jmse = new MessageNotReadableException(errorString, "C4009");
            ExceptionHandler.throwJMSException(jmse);
        }
    }

    protected void setMessageReadMode(boolean state) {
        this.readMode = state;
    }

    protected void setPropertiesReadMode(boolean state) {
        this.propReadMode = state;
    }

    protected void setIsOnAckList(boolean state) {
        this.isOnAckList = state;
    }

    protected boolean getIsOnAckList() {
        return this.isOnAckList;
    }

    protected MessageImpl() throws JMSException {
        this.init();
    }

    protected void setMessageID(SysMessageID mID) {
        this.messageID = (SysMessageID)mID.clone();
    }

    protected SysMessageID getMessageID() {
        return this.messageID;
    }

    protected long getInterestID() {
        return this.interestID;
    }

    protected void setInterestID(long id) {
        this.interestID = id;
    }

    protected jakarta.jms.Destination getJMQDestination(String destName) throws JMSException {
        Destination dest = null;
        boolean isQ = this.pkt.getIsQueue();
        dest = destName.startsWith("temporary_destination://queue/") ? new TemporaryQueueImpl(destName) : (destName.startsWith("temporary_destination://topic/") ? new TemporaryTopicImpl(destName) : (isQ ? new BasicQueue(destName) : new BasicTopic(destName)));
        return dest;
    }

    private void init() throws JMSException {
        this.pkt = new ReadWritePacket();
        this.setJMSDeliveryMode(2);
        this.setJMSPriority(4);
        this.setJMSExpiration(0L);
        this.setJMSDeliveryTime(0L);
        this.setPacketType(6);
    }

    protected void setPacketType(int type) {
        this.pkt.setPacketType(type);
    }

    public boolean getSendAcknowledge() {
        return this.pkt.getSendAcknowledge();
    }

    @Override
    public String getJMSMessageID() throws JMSException {
        if (this.jmsMessageIDSet) {
            return this.jmsMessageID;
        }
        return "ID:" + this.pkt.getMessageID();
    }

    @Override
    public void setJMSMessageID(String id) throws JMSException {
        this.jmsMessageID = id;
        this.jmsMessageIDSet = true;
    }

    public void resetJMSMessageID() {
        this.jmsMessageIDSet = false;
    }

    @Override
    public long getJMSTimestamp() throws JMSException {
        return this.pkt.getTimestamp();
    }

    @Override
    public void setJMSTimestamp(long timestamp) throws JMSException {
        this.pkt.setTimestamp(timestamp);
    }

    @Override
    public byte[] getJMSCorrelationIDAsBytes() throws JMSException {
        byte[] ret = null;
        try {
            ret = this.pkt.getCorrelationID().getBytes(UTF8);
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, "C4038");
        }
        return ret;
    }

    @Override
    public void setJMSCorrelationIDAsBytes(byte[] correlationID) throws JMSException {
        try {
            String id = new String(correlationID, UTF8);
            this.pkt.setCorrelationID(id);
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, "C4038");
        }
    }

    @Override
    public void setJMSCorrelationID(String correlationID) throws JMSException {
        this.pkt.setCorrelationID(correlationID);
    }

    @Override
    public String getJMSCorrelationID() throws JMSException {
        return this.pkt.getCorrelationID();
    }

    @Override
    public jakarta.jms.Destination getJMSReplyTo() throws JMSException {
        String destName = null;
        String className = null;
        if (this.replyTo == null && this.messageID != null) {
            if (this.pkt.getReplyTo() == null) {
                return null;
            }
            try {
                destName = this.pkt.getReplyTo();
                className = this.pkt.getReplyToClass();
                this.replyTo = (Destination)Class.forName(className).newInstance();
                ((Destination)this.replyTo).setProperty("imqDestinationName", destName);
            }
            catch (Exception e) {
                this.replyTo = this.getJMQDestination(destName);
            }
        }
        return this.replyTo;
    }

    @Override
    public void setJMSReplyTo(jakarta.jms.Destination replyTo) throws JMSException {
        this.replyTo = replyTo;
    }

    @Override
    public jakarta.jms.Destination getJMSDestination() throws JMSException {
        String destName = null;
        String className = null;
        if (this.destination == null && this.messageID != null) {
            try {
                destName = this.pkt.getDestination();
                className = this.pkt.getDestinationClass();
                this.destination = (Destination)Class.forName(className).newInstance();
                ((Destination)this.destination).setProperty("imqDestinationName", destName);
            }
            catch (Exception e) {
                this.destination = this.getJMQDestination(destName);
            }
        }
        return this.destination;
    }

    @Override
    public void setJMSDestination(jakarta.jms.Destination destination) throws JMSException {
        this.destination = destination;
    }

    @Override
    public int getJMSDeliveryMode() throws JMSException {
        if (this.pkt.getPersistent()) {
            return 2;
        }
        return 1;
    }

    @Override
    public void setJMSDeliveryMode(int deliveryMode) throws JMSException {
        if (deliveryMode != 1 && deliveryMode != 2) {
            String errorString = AdministeredObject.cr.getKString("C4051", "DeliveryMode", String.valueOf(deliveryMode));
            JMSException jmse = new JMSException(errorString, "C4051");
            ExceptionHandler.throwJMSException(jmse);
        }
        if (deliveryMode == 2) {
            this.pkt.setPersistent(true);
        } else {
            this.pkt.setPersistent(false);
        }
    }

    @Override
    public boolean getJMSRedelivered() throws JMSException {
        return this.pkt.getRedelivered();
    }

    @Override
    public void setJMSRedelivered(boolean redelivered) throws JMSException {
        this.pkt.setRedelivered(redelivered);
    }

    @Override
    public String getJMSType() throws JMSException {
        return this.pkt.getMessageType();
    }

    @Override
    public void setJMSType(String type) throws JMSException {
        this.pkt.setMessageType(type);
    }

    @Override
    public long getJMSExpiration() throws JMSException {
        return this.pkt.getExpiration();
    }

    @Override
    public void setJMSExpiration(long expiration) throws JMSException {
        this.pkt.setExpiration(expiration);
    }

    @Override
    public long getJMSDeliveryTime() throws JMSException {
        return this.pkt.getDeliveryTime();
    }

    @Override
    public void setJMSDeliveryTime(long deliveryTime) throws JMSException {
        this.pkt.setDeliveryTime(deliveryTime);
    }

    @Override
    public int getJMSPriority() throws JMSException {
        return this.pkt.getPriority();
    }

    @Override
    public void setJMSPriority(int priority) throws JMSException {
        if (priority < 0 || priority > 9) {
            String errorString = AdministeredObject.cr.getKString("C4051", "DeliveryPriority", String.valueOf(priority));
            JMSException jmse = new JMSException(errorString, "C4051");
            ExceptionHandler.throwJMSException(jmse);
        }
        this.pkt.setPriority(priority);
    }

    @Override
    public void clearProperties() throws JMSException {
        if (this.properties != null) {
            this.properties.clear();
        }
        this.setPropertiesReadMode(false);
        this.shouldCompress = false;
    }

    @Override
    public boolean propertyExists(String name) throws JMSException {
        if (this.properties == null) {
            return false;
        }
        try {
            return this.properties.containsKey(name);
        }
        catch (Exception e) {
            ExceptionHandler.handleException(e, "C4038");
            return false;
        }
    }

    @Override
    public boolean getBooleanProperty(String name) throws JMSException {
        Object obj = null;
        if (this.properties != null) {
            obj = this.properties.get(name);
        }
        return ValueConvert.toBoolean(obj);
    }

    @Override
    public byte getByteProperty(String name) throws JMSException {
        Object obj = null;
        if (this.properties != null) {
            obj = this.properties.get(name);
        }
        return ValueConvert.toByte(obj);
    }

    @Override
    public short getShortProperty(String name) throws JMSException {
        Object obj = null;
        if (this.properties != null) {
            obj = this.properties.get(name);
        }
        return ValueConvert.toShort(obj);
    }

    @Override
    public int getIntProperty(String name) throws JMSException {
        Object obj = null;
        if (this.properties != null) {
            obj = this.properties.get(name);
        }
        return ValueConvert.toInt(obj);
    }

    @Override
    public long getLongProperty(String name) throws JMSException {
        Object obj = null;
        if (this.properties != null) {
            obj = this.properties.get(name);
        }
        return ValueConvert.toLong(obj);
    }

    @Override
    public float getFloatProperty(String name) throws JMSException {
        Object obj = null;
        if (this.properties != null) {
            obj = this.properties.get(name);
        }
        return ValueConvert.toFloat(obj);
    }

    @Override
    public double getDoubleProperty(String name) throws JMSException {
        Object obj = null;
        if (this.properties != null) {
            obj = this.properties.get(name);
        }
        return ValueConvert.toDouble(obj);
    }

    @Override
    public String getStringProperty(String name) throws JMSException {
        Object obj;
        if (this.properties == null || (obj = this.properties.get(name)) == null) {
            return null;
        }
        return ValueConvert.toString(obj);
    }

    @Override
    public Object getObjectProperty(String name) throws JMSException {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(name);
    }

    @Override
    public Enumeration getPropertyNames() throws JMSException {
        if (this.properties == null) {
            this.properties = new Hashtable();
        }
        return this.properties.keys();
    }

    @Override
    public void setBooleanProperty(String name, boolean value) throws JMSException {
        this.checkAndSetProperty(name, value);
        if (JMS_SUN_COMPRESS.equals(name)) {
            this.shouldCompress = value;
        }
    }

    @Override
    public void setByteProperty(String name, byte value) throws JMSException {
        this.checkAndSetProperty(name, value);
    }

    @Override
    public void setShortProperty(String name, short value) throws JMSException {
        this.checkAndSetProperty(name, value);
    }

    @Override
    public void setIntProperty(String name, int value) throws JMSException {
        this.checkAndSetProperty(name, value);
    }

    @Override
    public void setLongProperty(String name, long value) throws JMSException {
        this.checkAndSetProperty(name, value);
    }

    @Override
    public void setFloatProperty(String name, float value) throws JMSException {
        this.checkAndSetProperty(name, Float.valueOf(value));
    }

    @Override
    public void setDoubleProperty(String name, double value) throws JMSException {
        this.checkAndSetProperty(name, value);
    }

    @Override
    public void setStringProperty(String name, String value) throws JMSException {
        this.checkAndSetProperty(name, value);
    }

    @Override
    public void setObjectProperty(String name, Object value) throws JMSException {
        this.checkAndSetProperty(name, value);
    }

    @Override
    public void acknowledge() throws JMSException {
        if (this.session != null && this.session.acknowledgeMode == 2 && !this.isQBrowserMsg) {
            this.session.clientAcknowledge(this);
        }
    }

    @Override
    public void acknowledgeThisMessage() throws JMSException {
        if (this.session != null && this.session.acknowledgeMode == 2 && !this.isQBrowserMsg) {
            this.session.clientAcknowledgeThisMessage(this);
        }
    }

    @Override
    public void acknowledgeUpThroughThisMessage() throws JMSException {
        if (this.session != null && this.session.acknowledgeMode == 2 && !this.isQBrowserMsg) {
            this.session.clientAcknowledgeUpThroughThisMessage(this);
        }
    }

    @Override
    public void clearBody() throws JMSException {
    }

    public boolean _getPersistent() {
        return this.pkt.getPersistent();
    }

    public boolean _getSendAcknowledge() {
        return this.pkt.getSendAcknowledge();
    }

    public void _setConsumerInRA() {
        this.consumerInRA = true;
    }

    protected void setIsBrowserMsg(boolean flag) {
        this.isQBrowserMsg = flag;
    }

    protected boolean isBrowserMessage() {
        return this.isQBrowserMsg;
    }

    protected boolean _isExpired() {
        long exptime = this.pkt.getExpiration();
        if (exptime <= 0L) {
            return false;
        }
        return System.currentTimeMillis() > exptime;
    }

    @Override
    public void dump(PrintStream ps) {
        ps.println("------ MessageImpl dump ------");
        if (this.pkt != null) {
            this.pkt.dump(ps);
        }
    }

    public String toString() {
        String temp = null;
        try {
            temp = new StringBuffer().append("\nClass:\t\t\t").append(this.getClass().getName()).append("\ngetJMSMessageID():\t").append(this.getJMSMessageID()).append("\ngetJMSTimestamp():\t").append(Long.toString(this.getJMSTimestamp())).append("\ngetJMSCorrelationID():\t").append(this.getJMSCorrelationID()).append("\nJMSReplyTo:\t\t").append(this.getJMSReplyTo() != null ? ((Destination)this.getJMSReplyTo()).getName() : "null").append("\nJMSDestination:\t\t").append(this.getJMSDestination() != null ? ((Destination)this.getJMSDestination()).getName() : "null").append("\ngetJMSDeliveryMode():\t").append(this.getJMSDeliveryMode() == 2 ? "PERSISTENT" : "NON PERSISTENT").append("\ngetJMSRedelivered():\t").append(Boolean.toString(this.getJMSRedelivered())).append("\ngetJMSType():\t\t").append(this.getJMSType()).append("\ngetJMSExpiration():\t").append(Long.toString(this.getJMSExpiration())).append("\ngetJMSDeliveryTime():\t").append(Long.toString(this.getJMSDeliveryTime())).append("\ngetJMSPriority():\t").append(Integer.toString(this.getJMSPriority())).append("\nProperties:\t\t").append(this.properties == null ? "null" : this.properties.toString()).toString();
        }
        catch (JMSException ex) {
            ex.printStackTrace();
        }
        return temp;
    }

    @Override
    public <T> T getBody(Class<T> c) throws JMSException {
        return MessageImpl._getBody(this, c);
    }

    public static <T> T _getBody(Message message, Class<T> c) throws JMSException {
        if (message instanceof TextMessage) {
            TextMessage textMessage = (TextMessage)message;
            String payload = textMessage.getText();
            if (payload == null) {
                return null;
            }
            if (c.isAssignableFrom(String.class)) {
                return (T)payload;
            }
            String errorString = AdministeredObject.cr.getKString("C4321", String.class, c);
            MessageFormatException mfre = new MessageFormatException(errorString, "C4321");
            ExceptionHandler.throwJMSException(mfre);
        } else if (message instanceof ObjectMessage) {
            ObjectMessage objectMessage = (ObjectMessage)message;
            Serializable payload = objectMessage.getObject();
            if (payload == null) {
                return null;
            }
            if (c.isAssignableFrom(payload.getClass())) {
                return (T)payload;
            }
            String errorString = AdministeredObject.cr.getKString("C4321", payload.getClass(), c);
            MessageFormatException mfre = new MessageFormatException(errorString, "C4321");
            ExceptionHandler.throwJMSException(mfre);
        } else if (message instanceof BytesMessage) {
            BytesMessage bytesMessage = (BytesMessage)message;
            bytesMessage.reset();
            long numBytes = bytesMessage.getBodyLength();
            if (numBytes == 0L) {
                return null;
            }
            byte[] payload = new byte[(int)numBytes];
            bytesMessage.readBytes(payload);
            bytesMessage.reset();
            if (c.isAssignableFrom(byte[].class)) {
                return (T)payload;
            }
            String errorString = AdministeredObject.cr.getKString("C4321", byte[].class, c);
            MessageFormatException mfre = new MessageFormatException(errorString, "C4321");
            ExceptionHandler.throwJMSException(mfre);
        } else if (message instanceof MapMessage) {
            MapMessage mapMessage = (MapMessage)message;
            if (!mapMessage.getMapNames().hasMoreElements()) {
                return null;
            }
            HashMap<String, Object> payload = new HashMap<String, Object>();
            Enumeration mapNamesEnum = mapMessage.getMapNames();
            while (mapNamesEnum.hasMoreElements()) {
                String thisName = (String)mapNamesEnum.nextElement();
                payload.put(thisName, mapMessage.getObject(thisName));
            }
            if (c.isAssignableFrom(Map.class)) {
                return (T)payload;
            }
            String errorString = AdministeredObject.cr.getKString("C4321", Map.class, c);
            MessageFormatException mfre = new MessageFormatException(errorString, "C4321");
            ExceptionHandler.throwJMSException(mfre);
        } else if (message instanceof StreamMessage) {
            String errorString = AdministeredObject.cr.getKString("C4322");
            MessageFormatException mfre = new MessageFormatException(errorString, "C4322");
            ExceptionHandler.throwJMSException(mfre);
        } else {
            return null;
        }
        return null;
    }

    @Override
    public boolean isBodyAssignableTo(Class c) throws JMSException {
        return MessageImpl._isBodyAssignableTo(this, c);
    }

    public static boolean _isBodyAssignableTo(Message message, Class c) throws JMSException {
        try {
            message.getBody(c);
        }
        catch (jakarta.jms.MessageFormatException mfe) {
            return false;
        }
        return true;
    }

    public void updateDeliveryCount(int newDeliveryCount) {
        this.setProperty("JMSXDeliveryCount", newDeliveryCount);
    }

    public int getClientRetries() {
        return this.clientRetries;
    }

    public void setClientRetries(int retryCount) {
        this.clientRetries = retryCount;
    }
}

