/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.AdministeredObject;
import com.sun.messaging.jmq.io.ReadWritePacket;
import com.sun.messaging.jmq.jmsclient.AsyncSendCallback;
import com.sun.messaging.jmq.jmsclient.Debug;
import com.sun.messaging.jmq.jmsclient.MessageImpl;
import com.sun.messaging.jmq.jmsclient.ProtocolHandler;
import com.sun.messaging.jmq.jmsclient.SessionImpl;
import com.sun.messaging.jmq.jmsclient.WriteChannel;
import com.sun.messaging.jmq.util.JMQXid;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.TransactionRolledBackException;
import java.util.logging.Level;

public class Transaction {
    protected SessionImpl session = null;
    protected ProtocolHandler protocolHandler = null;
    protected WriteChannel writeChannel = null;
    private long transactionID = -1L;
    private long nextTransactionID = -1L;
    private JMQXid jmqXid = null;
    private boolean setJMSXProducerTXID = false;
    private boolean debug = Debug.debug;
    private boolean resetFailOverFlag = false;
    protected static final int TRANSACTION_STARTED = 0;
    protected static final int TRANSACTION_ENDED = 1;
    protected static final int TRANSACTION_PREPARED = 2;
    protected static final int TRANSACTION_COMMITTED = 3;
    protected static final int TRANSACTION_ROLLBACK_ONLY = 4;
    protected static final int TRANSACTION_VERIFY_STATUS_COMMITTED = 7;
    protected static final int TRANSACTION_VERIFY_STATUS_ROLLEDBACK = 8;

    protected Transaction(SessionImpl session, boolean startLocal) throws JMSException {
        this.session = session;
        this.writeChannel = session.connection.getWriteChannel();
        this.protocolHandler = session.protocolHandler;
        this.setJMSXProducerTXID = session.connection.connectionMetaData.setJMSXProducerTXID;
        if (startLocal) {
            if (session.connection.isConnectedToHABroker) {
                session.protocolHandler.twoPhaseCommitFlag = true;
            }
            this.startNewLocalTransaction();
        }
    }

    protected void setProtocolHandler(ProtocolHandler pHandler) {
        this.protocolHandler = pHandler;
    }

    protected void init() throws JMSException {
        this.startNewLocalTransaction();
        this.setJMSXProducerTXID = this.session.connection.connectionMetaData.setJMSXProducerTXID;
    }

    protected synchronized void commit() throws JMSException {
        try {
            if (this.session.connection.isConnectedToHABroker) {
                this.commitHATransaction();
                this.session.clearUnackedMessageQ();
                this.startHANewLocalTransaction();
            } else {
                this.nextTransactionID = this.protocolHandler.commit(this.transactionID, -1, null);
                this.session.clearUnackedMessageQ();
                this.startNewLocalTransaction();
            }
        }
        catch (JMSException jmse) {
            this.checkCommitException(jmse);
        }
    }

    private void checkCommitException(JMSException jmse) throws JMSException {
        try {
            if (jmse instanceof TransactionRolledBackException) {
                this.session.clearUnackedMessageQ();
            } else {
                String ecode = jmse.getErrorCode();
                if ("C4001".equals(ecode) || "C4000".equals(ecode)) {
                    this.session.clearUnackedMessageQ();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        throw jmse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitHATransaction() throws JMSException {
        block9: {
            this.resetFailOverFlag = false;
            int tstate = -1;
            try {
                this.protocolHandler.endHATransaction(this.transactionID);
                tstate = 1;
                this.protocolHandler.prepareHATransaction(this.transactionID);
                tstate = 2;
                this.protocolHandler.commitHATransaction(this.transactionID);
                tstate = 3;
                this.resetFailOverFlag = true;
            }
            catch (TransactionRolledBackException tre) {
                this.resetFailOverFlag = true;
                this.throwRollbackException(tre);
            }
            catch (JMSException e) {
                String ecode = e.getErrorCode();
                if ("C4001".equals(ecode) || "C4000".equals(ecode)) {
                    this.checkCommitStatus(e, tstate);
                    this.resetFailOverFlag = true;
                    break block9;
                }
                throw e;
            }
            finally {
                if (this.resetFailOverFlag) {
                    this.session.failoverOccurred = false;
                    this.resetFailOverFlag = false;
                }
            }
        }
    }

    private void startHANewLocalTransaction() throws JMSException {
        block7: {
            try {
                this.startNewLocalTransaction();
                if (this.session.failoverOccurred) {
                    this.session.failoverOccurred = false;
                }
            }
            catch (JMSException jmse) {
                SessionImpl.yield();
                this.session.connection.checkReconnecting(null);
                if (this.session.connection.isCloseCalled || this.session.connection.connectionIsBroken) {
                    throw jmse;
                }
                String ecode = jmse.getErrorCode();
                if (!"C4001".equals(ecode) && !"C4000".equals(ecode)) break block7;
                try {
                    this.startNewLocalTransaction();
                    if (this.session.failoverOccurred) {
                        this.session.failoverOccurred = false;
                    }
                }
                catch (JMSException jmse2) {
                    SessionImpl.sessionLogger.log(Level.WARNING, "C4105", jmse2);
                }
            }
        }
    }

    private void checkCommitStatus(JMSException jmse, int tstate) throws JMSException {
        if (!this.session.connection.imqReconnect) {
            throw jmse;
        }
        SessionImpl.yield();
        this.session.connection.checkReconnecting(null);
        if (this.session.connection.isCloseCalled || this.session.connection.connectionIsBroken) {
            throw jmse;
        }
        try {
            this.verifyTransaction(tstate);
        }
        catch (TransactionRolledBackException tre) {
            this.resetFailOverFlag = true;
            this.session.failoverOccurred = false;
            if (this.debug) {
                Debug.println("*** in checkCommitStatus(), reset session.failoverOccurred flag to false.");
            }
            throw tre;
        }
        catch (JMSException jmsexception) {
            throw jmsexception;
        }
    }

    private void verifyTransaction(int tstate) throws JMSException {
        if (tstate < 1) {
            this.createAndThrowFailoverRollbackException();
        }
        int state = this.protocolHandler.verifyHATransaction(this.transactionID, tstate);
        switch (state) {
            case 7: {
                if (this.debug) {
                    Debug.println("transaction verified: state is successful");
                }
                return;
            }
            case 6: {
                try {
                    SessionImpl.sessionLogger.log(Level.INFO, "verifyTransaction(): transaction is in prepred state, committing the transaction: " + this.transactionID);
                    this.protocolHandler.commitHATransaction(this.transactionID);
                    SessionImpl.sessionLogger.log(Level.INFO, "verifyTransaction(): prepared transaction committed successfully: " + this.transactionID);
                    return;
                }
                catch (JMSException jmse) {
                    if (!this.session.connection.imqReconnect) {
                        throw jmse;
                    }
                    SessionImpl.yield();
                    this.session.connection.checkReconnecting(null);
                    if (this.session.connection.isCloseCalled || this.session.connection.connectionIsBroken) {
                        throw jmse;
                    }
                    this.protocolHandler.rollback(this.transactionID);
                }
            }
        }
        this.createAndThrowFailoverRollbackException();
    }

    private void createAndThrowFailoverRollbackException() throws TransactionRolledBackException {
        String errorString = AdministeredObject.cr.getKString("C4074");
        TransactionRolledBackException tre = new TransactionRolledBackException(errorString, "C4074");
        this.throwRollbackException(tre);
    }

    private void throwRollbackException(TransactionRolledBackException tre) throws TransactionRolledBackException {
        try {
            this.startNewLocalTransaction();
        }
        catch (Exception e) {
            this.transactionID = -1L;
            Debug.printStackTrace(e);
        }
        throw tre;
    }

    protected synchronized void rollback() throws JMSException {
        if (!this.session.failoverOccurred) {
            this.protocolHandler.rollback(this.transactionID);
        } else {
            Debug.println("*** rollback pkt not sent because failover occurred.");
        }
        this.startNewLocalTransaction();
    }

    protected void rollbackToXA() throws JMSException {
        this.protocolHandler.rollback(this.transactionID);
        this.transactionID = -1L;
    }

    protected void send(Message message, AsyncSendCallback asynccb) throws JMSException {
        if (asynccb != null) {
            asynccb.setTransactionID(this.transactionID);
        }
        MessageImpl messageImpl = (MessageImpl)message;
        if (this.setJMSXProducerTXID) {
            messageImpl.setStringProperty("JMSXProducerTXID", String.valueOf(this.transactionID));
        }
        ReadWritePacket pkt = messageImpl.getPacket();
        pkt.setTransactionID(this.transactionID);
        this.writeChannel.writeJMSMessage(message, asynccb);
    }

    protected JMQXid[] recoverXATransactions(int flags) throws JMSException {
        return this.protocolHandler.recover(flags);
    }

    protected void prepareXATransaction(JMQXid xid) throws JMSException {
        this.protocolHandler.prepare(this.jmqXid != null && this.jmqXid.equals(xid) ? this.transactionID : 0L, xid);
    }

    protected void commitXATransaction(JMQXid xid, boolean onePhase) throws JMSException {
        try {
            int flags = onePhase ? 0x40000000 : 0;
            this.protocolHandler.commit(this.jmqXid != null && this.jmqXid.equals(xid) ? this.transactionID : 0L, flags, xid);
            this.session.clearUnackedMessageQ();
        }
        catch (JMSException jmse) {
            this.checkCommitException(jmse);
        }
    }

    protected void rollbackXATransaction(JMQXid xid) throws JMSException {
        this.protocolHandler.rollback(this.jmqXid != null && this.jmqXid.equals(xid) ? this.transactionID : 0L, xid);
    }

    protected void startXATransaction(int xaflags, JMQXid xid) throws JMSException {
        this.startTransaction(xaflags, xid);
    }

    protected void endXATransaction(int xaflags, JMQXid xid) throws JMSException {
        this.protocolHandler.endTransaction(this.jmqXid != null && this.jmqXid.equals(xid) ? this.transactionID : 0L, xaflags, xid);
    }

    protected void startNewLocalTransaction() throws JMSException {
        this.transactionID = -1L;
        this.jmqXid = null;
        this.startTransaction(-1, null);
    }

    protected synchronized void startTransaction(int flags, JMQXid xid) throws JMSException {
        if (this.nextTransactionID != -1L) {
            this.transactionID = this.nextTransactionID;
            this.nextTransactionID = -1L;
            return;
        }
        if (this.transactionID == -1L) {
            boolean found = false;
            while (!found) {
                try {
                    this.transactionID = xid == null ? this.protocolHandler.startTransaction(0L, flags, xid, this.session.getBrokerSessionID()) : this.protocolHandler.startTransaction(0L, flags, xid);
                    found = true;
                }
                catch (JMSException jmse) {
                    String errorCode = jmse.getErrorCode();
                    if (errorCode == "C4028") continue;
                    throw jmse;
                }
            }
            if (xid != null) {
                this.jmqXid = xid;
            }
        } else {
            this.transactionID = this.protocolHandler.startTransaction(this.jmqXid != null && this.jmqXid.equals(xid) ? this.transactionID : 0L, flags, xid);
            if (xid != null) {
                this.jmqXid = xid;
            }
        }
        if (this.debug) {
            Debug.println("*** in Transaction.startTransaction(), new txID: " + this.transactionID);
        }
    }

    protected void releaseBrokerResource() throws JMSException {
        this.protocolHandler.rollback(this.transactionID, true);
    }

    protected synchronized long getTransactionID() {
        return this.transactionID;
    }

    public synchronized void setTransactionID(long transactionID) {
        this.transactionID = transactionID;
    }
}

