/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.admin.apps.objmgr;

import com.sun.messaging.AdministeredObject;
import com.sun.messaging.ConnectionFactory;
import com.sun.messaging.Queue;
import com.sun.messaging.QueueConnectionFactory;
import com.sun.messaging.Topic;
import com.sun.messaging.TopicConnectionFactory;
import com.sun.messaging.XAConnectionFactory;
import com.sun.messaging.XAQueueConnectionFactory;
import com.sun.messaging.XATopicConnectionFactory;
import com.sun.messaging.jmq.admin.resources.AdminResources;
import com.sun.messaging.jmq.admin.util.Globals;
import com.sun.messaging.jmq.util.MultiColumnPrinter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class ObjMgrPrinter
extends MultiColumnPrinter {
    private static AdminResources ar = Globals.getAdminResources();

    @Deprecated
    public ObjMgrPrinter(int numCol, int gap, String border, int align, boolean sort) {
        super(numCol, gap, border, align, sort);
    }

    @Deprecated
    public ObjMgrPrinter(int numCol, int gap, String border, int align) {
        super(numCol, gap, border, align);
    }

    @Deprecated
    public ObjMgrPrinter(int numCol, int gap, String border) {
        super(numCol, gap, border);
    }

    public ObjMgrPrinter(int numCol, int gap) {
        super(numCol, gap);
    }

    public ObjMgrPrinter(Hashtable h, int numCol, int gap) {
        super(numCol, gap);
        Object[] row = new String[2];
        Enumeration e = h.keys();
        while (e.hasMoreElements()) {
            String propName = (String)e.nextElement();
            String propValue = (String)h.get(propName);
            row[0] = propName;
            row[1] = propValue;
            this.add(row);
        }
    }

    public void printJMSObject(Object obj) {
        if (obj instanceof Topic) {
            Globals.stdOutPrintln(ar.getString("A1046"));
        } else if (obj instanceof Queue) {
            Globals.stdOutPrintln(ar.getString("A1047"));
        } else if (obj instanceof XATopicConnectionFactory) {
            Globals.stdOutPrintln(ar.getString("A1078"));
        } else if (obj instanceof XAQueueConnectionFactory) {
            Globals.stdOutPrintln(ar.getString("A1079"));
        } else if (obj instanceof XAConnectionFactory) {
            Globals.stdOutPrintln(ar.getString("A1080"));
        } else if (obj instanceof TopicConnectionFactory) {
            Globals.stdOutPrintln(ar.getString("A1048"));
        } else if (obj instanceof QueueConnectionFactory) {
            Globals.stdOutPrintln(ar.getString("A1049"));
        } else if (obj instanceof ConnectionFactory) {
            Globals.stdOutPrintln(ar.getString("A1081"));
        }
        if (obj instanceof AdministeredObject) {
            this.printObjPropertiesFromObj((AdministeredObject)obj);
        }
    }

    public void printObjPropertiesFromObj(AdministeredObject obj) {
        Properties props = obj.getConfiguration();
        Enumeration e = obj.enumeratePropertyNames();
        while (e.hasMoreElements()) {
            String propName = (String)e.nextElement();
            try {
                if (obj.isPropertyHidden(propName)) {
                    continue;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            String value = props.getProperty(propName);
            String propLabel = "";
            try {
                propLabel = obj.getPropertyLabel(propName);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String printLabel = propName + " [" + propLabel + "]";
            String printValue = value;
            Object[] row = new String[]{printLabel, printValue};
            this.add(row);
        }
        this.print();
    }

    public void printObjPropertiesFromProp(Properties p, AdministeredObject obj) {
        Enumeration<?> e = p.propertyNames();
        while (e.hasMoreElements()) {
            String propLabel;
            String propName = (String)e.nextElement();
            String value = p.getProperty(propName);
            try {
                propLabel = obj.getPropertyLabel(propName);
            }
            catch (Exception ex) {
                propLabel = "";
            }
            String printLabel = propName + " [" + propLabel + "]";
            Object[] row = new String[]{printLabel, value};
            this.add(row);
        }
        this.print();
    }

    public static void printReadOnly(String value) {
        if (value != null) {
            Globals.stdOutPrintln(ar.getString("A1113", value));
        } else {
            Globals.stdOutPrintln(ar.getString("A1113", Boolean.FALSE.toString()));
        }
    }

    public static void printReadOnly(boolean value) {
        if (value) {
            Globals.stdOutPrintln(ar.getString("A1113", Boolean.TRUE.toString()));
        } else {
            Globals.stdOutPrintln(ar.getString("A1113", Boolean.FALSE.toString()));
        }
    }

    @Override
    public void doPrint(String str) {
        Globals.stdOutPrint(str);
    }

    @Override
    public void doPrintln(String str) {
        Globals.stdOutPrintln(str);
    }
}

