/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.license;

import com.sun.messaging.jmq.jmsserver.license.LicenseBase;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Calendar;
import java.util.Properties;

public class FileLicense
extends LicenseBase {
    private File myLicenseFile = null;
    private static final int CHECKSUM_LEN = 16;
    private static final int BLOW_FACTOR = 3;
    private static final int FAKE_FACTOR = 2;
    private static final int CUT_FACTOR = 2;
    private static MessageDigest digest;
    private static int ROTORSZ;
    private static int MASK;
    private static int[] t1;
    private static int[] t2;
    private static int[] t3;

    protected FileLicense() {
    }

    public FileLicense(File myLicenseFile, boolean autoChecking) throws BrokerException {
        this.myLicenseFile = myLicenseFile;
        this.setAutoChecking(autoChecking);
        this.readLicense();
    }

    public FileLicense(File myLicenseFile) throws BrokerException {
        this(myLicenseFile, true);
    }

    public File getLicenseFile() {
        return this.myLicenseFile;
    }

    protected void writeLicense(File file) throws IOException, BrokerException {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
        }
        catch (IOException e) {
            if (file.exists() && !file.canWrite()) {
                throw new BrokerException(br.getString("B3112", file));
            }
            throw e;
        }
        DataOutputStream dos = new DataOutputStream(fos);
        digest.reset();
        byte[] data = this.getEncryptedData();
        byte[] checksum = digest.digest(data);
        dos.writeLong(1011902605893L);
        dos.write(checksum, 0, checksum.length);
        dos.writeInt(data.length * 3);
        int cut = data.length / 2;
        dos.write(data, 0, cut);
        dos.write(data, 0, data.length);
        dos.write(data, 0, data.length);
        dos.write(data, cut, data.length - cut);
        dos.flush();
        dos.close();
        fos.close();
    }

    private byte[] getEncryptedData() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.props.store(baos, null);
        byte[] buf = baos.toByteArray();
        baos.close();
        return FileLicense.scramble(buf);
    }

    public void rewriteLicense() throws IOException, BrokerException {
        String dateString = this.props.getProperty("date_string");
        if (dateString == null) {
            return;
        }
        if (dateString.startsWith("TRY")) {
            Calendar cal = Calendar.getInstance();
            this.setStartDate(cal.getTime());
            cal.add(5, this.getDaysToTry());
            this.setExpirationDate(cal.getTime());
            dateString = this.generateDateString();
            this.props.setProperty("date_string", dateString);
            this.writeLicense(this.myLicenseFile);
        }
    }

    private String generateDateString() {
        String string;
        if (!this.willExpire()) {
            string = "NONE";
        } else if (this.getStartDate() != null || this.getExpirationDate() != null) {
            String start = this.getStartDate() != null ? String.valueOf(this.getStartDate().getTime()) : "";
            String end = this.getExpirationDate() != null ? String.valueOf(this.getExpirationDate().getTime()) : "";
            string = this.formatString("VALID", start + "-" + end);
        } else {
            string = this.formatString("TRY", String.valueOf(this.getDaysToTry()));
        }
        return string;
    }

    private String formatString(String prefix, String content) {
        return prefix + "[" + content + "]";
    }

    private void readLicense() throws BrokerException {
        try {
            FileInputStream fis = new FileInputStream(this.myLicenseFile);
            DataInputStream dis = new DataInputStream(fis);
            long magic = dis.readLong();
            if (magic != 1011902605893L) {
                throw new BrokerException(br.getString("B3054"));
            }
            byte[] checksum = new byte[16];
            dis.readFully(checksum);
            int fakesize = dis.readInt();
            int size = fakesize / 3;
            int cut = size / 2;
            byte[] data = new byte[size];
            dis.read(data, 0, cut);
            dis.skipBytes(size * 2);
            dis.read(data, cut, size - cut);
            dis.close();
            fis.close();
            digest.reset();
            byte[] computed = digest.digest(data);
            if (!this.goodChecksum(checksum, computed)) {
                throw new BrokerException(br.getString("B3054"));
            }
            this.parseData(FileLicense.scramble(data));
        }
        catch (IOException e) {
            throw new BrokerException(br.getString("B3054"), e);
        }
    }

    private boolean goodChecksum(byte[] b1, byte[] b2) {
        if (b1 == null || b2 == null) {
            return false;
        }
        if (b1.length != b2.length) {
            return false;
        }
        for (int i = 0; i < b1.length; ++i) {
            if (b1[i] == b2[i]) continue;
            return false;
        }
        return true;
    }

    private void parseData(byte[] data) throws IOException, BrokerException {
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        Properties tmp = new Properties();
        tmp.load(bais);
        this.superimpose(tmp);
    }

    public static byte[] scramble(byte[] data) {
        int n1 = 0;
        int n2 = 0;
        byte[] newdata = new byte[data.length];
        for (int i = 0; i < data.length; ++i) {
            newdata[i] = (byte)(t2[t3[t1[data[i] + n1 & MASK] + n2 & MASK] - n2 & MASK] - n1);
            if (++n1 != ROTORSZ) continue;
            n1 = 0;
            if (++n2 != ROTORSZ) continue;
            n2 = 0;
        }
        return newdata;
    }

    static {
        int i;
        ROTORSZ = 256;
        MASK = 255;
        t1 = new int[ROTORSZ];
        t2 = new int[ROTORSZ];
        t3 = new int[ROTORSZ];
        try {
            digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e.getMessage());
        }
        int seed = 12345;
        for (i = 0; i < ROTORSZ; ++i) {
            FileLicense.t1[i] = i;
            FileLicense.t3[i] = 0;
        }
        for (i = 0; i < ROTORSZ; ++i) {
            int random = 5 * seed % 65521;
            int k = ROTORSZ - 1 - i;
            int ic = (random & MASK) % (k + 1);
            random >>= 8;
            int temp = t1[k];
            FileLicense.t1[k] = t1[ic];
            FileLicense.t1[ic] = temp;
            if (t3[k] != 0) continue;
            ic = (random & MASK) % k;
            while (t3[ic] != 0) {
                ic = (ic + 1) % k;
            }
            FileLicense.t3[k] = ic;
            FileLicense.t3[ic] = k;
        }
        for (i = 0; i < ROTORSZ; ++i) {
            FileLicense.t2[FileLicense.t1[i] & FileLicense.MASK] = i;
        }
    }
}

