/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.service.imq.dedicated;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.data.PacketRouter;
import com.sun.messaging.jmq.jmsserver.net.Protocol;
import com.sun.messaging.jmq.jmsserver.pool.RunnableFactory;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQIPConnection;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQIPService;
import com.sun.messaging.jmq.jmsserver.service.imq.OperationRunnable;
import com.sun.messaging.jmq.jmsserver.service.imq.OperationRunnableFactory;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import java.io.IOException;
import java.util.Hashtable;
import java.util.MissingResourceException;

public class DedicatedService
extends IMQIPService {
    public DedicatedService(String name, Protocol protocol, int type, PacketRouter router, int min, int max) {
        super(name, protocol, type, router, min, max);
    }

    @Override
    public RunnableFactory getRunnableFactory() {
        return new OperationRunnableFactory(true);
    }

    @Override
    public Hashtable getDebugState() {
        return super.getDebugState();
    }

    @Override
    public void acceptConnection(IMQIPConnection con) throws IOException, BrokerException {
        OperationRunnable read = (OperationRunnable)this.pool.getAvailRunnable(false);
        OperationRunnable write = (OperationRunnable)this.pool.getAvailRunnable(false);
        if (read == null || write == null) {
            if (read != null) {
                read.release();
            }
            if (write != null) {
                write.release();
            }
            Object[] args = new String[]{this.toString(), String.valueOf(this.pool.getAssignedCnt()), String.valueOf(this.pool.getMaximum())};
            this.logger.log(16, "B3004", args);
            this.pool.debug();
            con.destroyConnection(true, 4, Globals.getBrokerResources().getKString("B3004", args));
            throw new BrokerException(Globals.getBrokerResources().getKString("B3004", args), "B3004", null, 405);
        }
        this.startWriterThread(con, read, write);
        this.startReaderThread(con, read, write);
    }

    private void startReaderThread(IMQIPConnection con, OperationRunnable read, OperationRunnable write) throws MissingResourceException, BrokerException {
        boolean assigned = false;
        while (!assigned) {
            try {
                read.assignOperation(con, 1, -1);
                assigned = true;
            }
            catch (IllegalAccessException ex) {
                this.logger.logStack(32, "B3100", "assigning read for " + con + " to available thread " + read, (Throwable)ex);
                this.pool.debug();
                read = (OperationRunnable)this.pool.getAvailRunnable(false);
                this.logger.log(4, "Recovering: Assigning new read for " + con + " to available thread " + read);
                if (read != null) continue;
                Object[] args = new String[]{this.toString(), String.valueOf(this.pool.getAssignedCnt()), String.valueOf(this.pool.getMaximum())};
                if (write != null) {
                    write.destroy();
                }
                this.logger.log(32, "B3004", args);
                this.pool.debug();
                con.destroyConnection(true, 4, Globals.getBrokerResources().getKString("B3004"));
                throw new BrokerException(Globals.getBrokerResources().getKString("B3004", args), "B3004", null, 500);
            }
        }
    }

    private void startWriterThread(IMQIPConnection con, OperationRunnable read, OperationRunnable write) throws MissingResourceException, BrokerException {
        boolean assigned = false;
        while (!assigned) {
            try {
                write.assignOperation(con, 4, -1);
                assigned = true;
            }
            catch (IllegalAccessException ex) {
                this.logger.logStack(32, "B3100", "assigning write for " + con + " to available thread " + read, (Throwable)ex);
                this.pool.debug();
                write = (OperationRunnable)this.pool.getAvailRunnable(false);
                this.logger.log(4, "Recovering: Assigning new write for " + con + " to available thread " + read);
                if (write != null) continue;
                Object[] args = new String[]{this.toString(), String.valueOf(this.pool.getAssignedCnt()), String.valueOf(this.pool.getMaximum())};
                if (read != null) {
                    read.release();
                }
                this.logger.log(32, "B3004", args);
                this.pool.debug();
                con.destroyConnection(true, 4, Globals.getBrokerResources().getKString("B3004"));
                throw new BrokerException(Globals.getBrokerResources().getKString("B3004", args), "B3004", null, 500);
            }
        }
    }
}

