/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.service.imq.websocket.stomp;

import com.sun.messaging.bridge.api.StompFrameMessage;
import com.sun.messaging.bridge.api.StompFrameParseException;
import com.sun.messaging.bridge.api.StompOutputHandler;
import com.sun.messaging.bridge.api.StompProtocolHandler;
import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.api.ClusterBroadcast;
import com.sun.messaging.jmq.jmsserver.service.imq.JMSServiceImpl;
import com.sun.messaging.jmq.jmsserver.service.imq.websocket.MQWebSocket;
import com.sun.messaging.jmq.jmsserver.service.imq.websocket.MQWebSocketServiceApp;
import com.sun.messaging.jmq.jmsserver.service.imq.websocket.stomp.StompFrameMessageImpl;
import com.sun.messaging.jmq.jmsserver.service.imq.websocket.stomp.StompProtocolHandlerImpl;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.websockets.DataFrame;
import org.glassfish.grizzly.websockets.ProtocolHandler;
import org.glassfish.grizzly.websockets.WebSocketListener;

public class STOMPWebSocket
extends MQWebSocket
implements StompOutputHandler {
    protected static final Logger logger = Globals.getLogger();
    private final FrameParseState parseState = new FrameParseState();
    private StompProtocolHandler stompProtocolHandler = null;

    public STOMPWebSocket(MQWebSocketServiceApp app, ProtocolHandler protocolHandler, HttpRequestPacket request, WebSocketListener ... listeners) {
        super(app, protocolHandler, request, listeners);
        JMSServiceImpl jmss = new JMSServiceImpl(app.getMQService(), Globals.getProtocol());
        this.stompProtocolHandler = new StompProtocolHandlerImpl(this, jmss);
    }

    @Override
    protected String getLogString() {
        return super.getLogString() + "[" + this.stompProtocolHandler.toString() + "]";
    }

    public String toString() {
        return "[" + this.getClass().getSimpleName() + "@" + this.hashCode() + "[" + super.getLogString() + "[" + this.stompProtocolHandler.toString() + "]]]";
    }

    @Override
    public void onClose(DataFrame frame) {
        try {
            this.stompProtocolHandler.close(false);
        }
        finally {
            super.onClose(frame);
        }
    }

    @Override
    protected void writePacket(Packet pkt) throws IOException {
        Object[] args = new String[]{this.getClass().getSimpleName() + ".writPacket(): unexpected call"};
        throw new IOException(this.getLogString() + this.br.getKTString("B3100", args));
    }

    @Override
    protected void processData(String text) throws Exception {
        if (DEBUG) {
            logger.log(8, this.toString() + ".processData(text=" + text + ")");
        }
        byte[] data = text.getBytes("UTF-8");
        Buffer buf = Buffers.wrap((MemoryManager)this.memManager, (byte[])data);
        this.processData(buf);
    }

    @Override
    protected void processData(byte[] data) throws Exception {
        Buffer buf = Buffers.wrap((MemoryManager)this.memManager, (byte[])data);
        this.processData(buf);
    }

    private void processData(Buffer buf) throws Exception {
        if (DEBUG) {
            logger.log(8, Thread.currentThread() + " processData:buf.remaining=" + buf.remaining());
        }
        if (this.parseState.buf != null) {
            this.parseState.buf.shrink();
        }
        Buffer input = this.parseState.buf = Buffers.appendBuffers((MemoryManager)this.memManager, (Buffer)this.parseState.buf, (Buffer)buf);
        if (this.parseState.message == null && input.remaining() >= 3) {
            this.parseState.message = StompFrameMessageImpl.parseCommand(input);
            if (DEBUG) {
                logger.log(8, "returned from parseCommand with " + this.parseState.message);
            }
        }
        if (this.parseState.message == null) {
            return;
        }
        StompFrameMessageImpl message = this.parseState.message;
        if (message.getNextParseStage() == StompFrameMessage.ParseStage.HEADER) {
            message.parseHeader(input);
            if (DEBUG) {
                logger.log(8, "returned from parseHeader");
            }
        }
        if (message.getNextParseStage() == StompFrameMessage.ParseStage.BODY) {
            message.readBody(input);
        }
        if (message.getNextParseStage() == StompFrameMessage.ParseStage.NULL) {
            message.readNULL(input);
        }
        if (DEBUG) {
            logger.log(8, "position=" + buf.position() + ", input=" + input + ", nextParseState=" + (Object)((Object)message.getNextParseStage()));
        }
        if (message.getNextParseStage() != StompFrameMessage.ParseStage.DONE) {
            if (DEBUG) {
                logger.log(8, "parseData with position=" + input.position() + ", hasRemaining=" + input.hasRemaining());
            }
            return;
        }
        Exception ex = message.getParseException();
        if (ex != null) {
            message = ex instanceof StompFrameParseException ? (StompFrameMessageImpl)((StompFrameParseException)ex).getStompMessageERROR(StompFrameMessageImpl.getFactory(), logger) : (StompFrameMessageImpl)new StompFrameParseException(ex.getMessage(), ex).getStompMessageERROR(StompFrameMessageImpl.getFactory(), logger);
            message.setFatalERROR();
            this.parseState.reset();
            this.sendToClient(message, this.stompProtocolHandler, null);
            return;
        }
        Buffer remainder = input.split(input.position());
        this.parseState.reset();
        this.parseState.buf = remainder;
        this.dispatchMessage(message);
    }

    protected void dispatchMessage(StompFrameMessageImpl m) throws Exception {
        StompFrameMessageImpl msg = m;
        switch (msg.getCommand()) {
            case CONNECT: 
            case STOMP: {
                ClusterBroadcast cbc = Globals.getClusterBroadcast();
                if (cbc.waitForConfigSync()) {
                    String emsg = this.br.getKString("B4480", Globals.getClusterManager().getMasterBroker());
                    this.sendFatalError(new BrokerException("CONNECT: " + emsg + ", " + 449));
                    break;
                }
                this.stompProtocolHandler.onCONNECT(msg, this, null);
                break;
            }
            case SEND: {
                if (DEBUG) {
                    logger.log(8, "StompWebSocket.processData(SEND): " + msg);
                }
                this.stompProtocolHandler.onSEND(msg, this, null);
                break;
            }
            case SUBSCRIBE: {
                this.stompProtocolHandler.onSUBSCRIBE(msg, this, this, null);
                break;
            }
            case UNSUBSCRIBE: {
                this.stompProtocolHandler.onUNSUBSCRIBE(msg, this, null);
                break;
            }
            case BEGIN: {
                this.stompProtocolHandler.onBEGIN(msg, this, null);
                break;
            }
            case COMMIT: {
                this.stompProtocolHandler.onCOMMIT(msg, this, null);
                break;
            }
            case ABORT: {
                this.stompProtocolHandler.onABORT(msg, this, null);
                break;
            }
            case ACK: {
                this.stompProtocolHandler.onACK(msg, this, null);
                break;
            }
            case NACK: {
                this.stompProtocolHandler.onNACK(msg, this, null);
                break;
            }
            case DISCONNECT: {
                this.stompProtocolHandler.onDISCONNECT(msg, this, null);
                this.close(1000, "DISCONNECT");
                break;
            }
            case ERROR: {
                this.sendToClient(msg, this.stompProtocolHandler, null);
                break;
            }
            default: {
                IOException e = new IOException(msg.getKStringX_UNKNOWN_STOMP_CMD(msg.getCommand().toString()));
                logger.log(32, e.getMessage());
                this.sendFatalError(e);
            }
        }
    }

    protected void sendFatalError(Exception e) {
        logger.log(32, e.getMessage());
        try {
            StompFrameMessage err = this.stompProtocolHandler.toStompErrorMessage(this.getClass().getSimpleName(), e);
            err.setFatalERROR();
            this.sendToClient(err, this.stompProtocolHandler, null);
        }
        catch (Exception ee) {
            logger.log(32, "br.E_UNABLE_SEND_ERROR_MSG: " + e.toString() + ": " + ee.toString(), ee);
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendToClient(StompFrameMessage msg, StompProtocolHandler sph, Object ctx) throws Exception {
        if (DEBUG) {
            logger.log(8, this.toString() + " sendToClient(" + msg + ")");
        }
        boolean closechannel = false;
        try {
            if (msg.getCommand() == StompFrameMessage.Command.ERROR && msg.isFatalERROR()) {
                closechannel = true;
            }
            Object object = this.closeLock;
            synchronized (object) {
                block15: {
                    if (!this.isClosed()) break block15;
                    logger.log(8, this.toString() + " closed");
                    return;
                }
                this.doSend(msg);
            }
        }
        catch (Exception e) {
            if (e instanceof ClosedChannelException || e.getCause() instanceof ClosedChannelException) {
                logger.logStack(16, "I18NXX-Exception on sending message stomp websocket client:" + msg, e);
                if (sph != null) {
                    sph.close(false);
                }
            }
            throw e;
        }
        finally {
            if (closechannel) {
                this.close();
            }
        }
    }

    protected void doSend(StompFrameMessage frame) throws Exception {
        Buffer buf = (Buffer)frame.marshall(this.memManager).getWrapped();
        byte[] bb = new byte[buf.remaining()];
        buf.get(bb);
        this.send(bb);
        if (DEBUG) {
            logger.log(8, this.getClass().getSimpleName() + "@" + this.hashCode() + " SENT " + bb.length + " bytes");
        }
    }

    @Override
    public void sendToClient(StompFrameMessage msg) throws Exception {
        this.sendToClient(msg, null, null);
    }

    static class FrameParseState {
        public Buffer buf = null;
        public StompFrameMessageImpl message = null;

        FrameParseState() {
        }

        public void reset() {
            this.buf = null;
            this.message = null;
        }
    }
}

