/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.util.selector;

import com.sun.messaging.jmq.util.lists.WeakValueHashMap;
import com.sun.messaging.jmq.util.selector.RegularExpression;
import com.sun.messaging.jmq.util.selector.SelectorFormatException;
import com.sun.messaging.jmq.util.selector.SelectorToken;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Stack;

public class Selector {
    private static boolean DEBUG = false;
    private static boolean VERBOSE_DEBUG = false;
    static final int INVALID = 500;
    static final int STARTING = 0;
    static final int OR = 1;
    static final int AND = 2;
    static final int NOT = 3;
    static final int NOT_EQUALS = 4;
    static final int LTE = 5;
    static final int LT = 6;
    static final int GTE = 7;
    static final int GT = 8;
    static final int EQUALS = 9;
    static final int UNARY_PLUS = 10;
    static final int UNARY_MINUS = 11;
    static final int MULTIPLY = 12;
    static final int DIVIDE = 13;
    static final int PLUS = 14;
    static final int MINUS = 15;
    static final int BETWEEN = 16;
    static final int NOT_BETWEEN = 17;
    static final int IN = 18;
    static final int NOT_IN = 19;
    static final int LIKE = 20;
    static final int ESCAPE = 21;
    static final int NOT_LIKE = 22;
    static final int IS_NULL = 23;
    static final int IS_NOT_NULL = 24;
    static final int IS = 25;
    static final int IS_NOT = 26;
    static final int LEFT_PAREN = 27;
    static final int RIGHT_PAREN = 28;
    static final int COMMA = 29;
    static final int IDENTIFIER = 101;
    static final int STRING = 102;
    static final int DOUBLE = 103;
    static final int LONG = 104;
    static final int TRUE = 105;
    static final int FALSE = 106;
    static final int JMS_FIELD = 107;
    static final int RANGE = 108;
    static final int LIST = 109;
    static final int WHITESPACE = 110;
    static final int NULL = 111;
    static final int UNKNOWN = 112;
    static final int RE = 113;
    static final int AND_MARKER = 200;
    static final int OR_MARKER = 201;
    private static boolean convertTypes = false;
    private static boolean shortCircuit = true;
    private static boolean shortCircuitCompileTimeTest = true;
    private boolean usesProperties = false;
    private boolean usesFields = false;
    private static HashMap<String, Integer> keywords = null;
    private static HashSet<String> headers = null;
    private String selector = null;
    private SelectorToken[] compiledSelector = null;
    private Stack<SelectorToken> stack = new Stack();
    private static WeakValueHashMap<String, Selector> selectorCache = null;

    public static void setConvertTypes(boolean b) {
        convertTypes = b;
    }

    public static boolean getConvertTypes() {
        return convertTypes;
    }

    public static void setShortCircuit(boolean b) {
        shortCircuit = b;
    }

    public static boolean getShortCircuit() {
        return shortCircuit;
    }

    public static void setShortCircuitCompileTimeTest(boolean b) {
        shortCircuitCompileTimeTest = b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Selector compile(String selector) throws SelectorFormatException {
        if (selector == null || selector.length() == 0) {
            return null;
        }
        Selector o = null;
        WeakValueHashMap<String, Selector> weakValueHashMap = selectorCache;
        synchronized (weakValueHashMap) {
            o = selectorCache.get(selector);
            if (o == null) {
                o = new Selector(selector);
                o.compile();
                selectorCache.put(selector, o);
            }
        }
        return o;
    }

    private Selector(String selector) {
        this.selector = selector;
    }

    public synchronized void compile() throws SelectorFormatException {
        LinkedList<SelectorToken> l = this.tokenize(this.selector + " ");
        if (VERBOSE_DEBUG) {
            Selector.dumpTokens(l);
        }
        l = this.aggregate(l);
        if (VERBOSE_DEBUG) {
            Selector.dumpTokens(l);
            System.out.println();
        }
        l = this.prepare(l);
        if (VERBOSE_DEBUG) {
            Selector.dumpTokens(l);
            System.out.println();
        }
        this.validate(l);
        this.compiledSelector = this.convertToRPN(l);
        if (DEBUG) {
            System.out.println(this.toDebugString());
        }
        this.match(new HashMap<Object, Object>(0), new HashMap<Object, Object>(0));
        if (shortCircuitCompileTimeTest) {
            this.match(new HashMap<Object, Object>(0), new HashMap<Object, Object>(0), true);
        }
    }

    private LinkedList<SelectorToken> tokenize(String selector) throws SelectorFormatException {
        LinkedList<SelectorToken> buf = new LinkedList<SelectorToken>();
        int len = selector.length();
        int state = 0;
        StringBuffer tokenBuf = new StringBuffer(80);
        int token = 0;
        int lastToken = 0;
        int radix = 10;
        int i = 0;
        for (i = 0; i < len; ++i) {
            char c = selector.charAt(i);
            Object value = null;
            block4 : switch (state) {
                case 0: {
                    tokenBuf.delete(0, tokenBuf.length());
                    switch (c) {
                        case ',': {
                            token = 29;
                            tokenBuf.append(c);
                            value = tokenBuf.toString();
                            break block4;
                        }
                        case '=': {
                            if (lastToken == 9) {
                                throw new SelectorFormatException("Invalid operator ==, use =", selector, i);
                            }
                            token = 9;
                            tokenBuf.append(c);
                            value = tokenBuf.toString();
                            break block4;
                        }
                        case '/': {
                            token = 13;
                            tokenBuf.append(c);
                            value = tokenBuf.toString();
                            break block4;
                        }
                        case '*': {
                            token = 12;
                            tokenBuf.append(c);
                            value = tokenBuf.toString();
                            break block4;
                        }
                        case '(': {
                            token = 27;
                            tokenBuf.append(c);
                            value = tokenBuf.toString();
                            break block4;
                        }
                        case ')': {
                            token = 28;
                            tokenBuf.append(c);
                            value = tokenBuf.toString();
                            break block4;
                        }
                        case '-': {
                            if (lastToken == 0 || Selector.isOperator(lastToken) && lastToken != 28) {
                                token = 11;
                                tokenBuf.append(c);
                                value = tokenBuf.toString();
                                break block4;
                            }
                            token = 15;
                            tokenBuf.append(c);
                            value = tokenBuf.toString();
                            break block4;
                        }
                        case '+': {
                            if (lastToken == 0 || Selector.isOperator(lastToken) && lastToken != 28) {
                                token = 10;
                                tokenBuf.append(c);
                                value = tokenBuf.toString();
                                break block4;
                            }
                            token = 14;
                            tokenBuf.append(c);
                            value = tokenBuf.toString();
                            break block4;
                        }
                        case '>': {
                            tokenBuf.append(c);
                            state = 1;
                            break block4;
                        }
                        case '<': {
                            tokenBuf.append(c);
                            state = 2;
                            break block4;
                        }
                        case '\'': {
                            state = 9;
                            break block4;
                        }
                        case '.': {
                            tokenBuf.append(c);
                            state = 6;
                            break block4;
                        }
                        case '0': {
                            tokenBuf.append(c);
                            state = 3;
                            break block4;
                        }
                    }
                    if (Character.isJavaIdentifierStart(c)) {
                        tokenBuf.append(c);
                        state = 11;
                        break;
                    }
                    if (Character.isDigit(c)) {
                        tokenBuf.append(c);
                        state = 5;
                        break;
                    }
                    if (Character.isWhitespace(c)) {
                        token = 110;
                        break;
                    }
                    throw new SelectorFormatException("Invalid character " + c, selector, i);
                }
                case 1: {
                    switch (c) {
                        case '=': {
                            tokenBuf.append(c);
                            token = 7;
                            value = tokenBuf.toString();
                            state = 0;
                            break block4;
                        }
                    }
                    token = 8;
                    value = tokenBuf.toString();
                    state = 0;
                    --i;
                    break;
                }
                case 2: {
                    switch (c) {
                        case '=': {
                            tokenBuf.append(c);
                            token = 5;
                            value = tokenBuf.toString();
                            state = 0;
                            break block4;
                        }
                        case '>': {
                            tokenBuf.append(c);
                            token = 4;
                            value = tokenBuf.toString();
                            state = 0;
                            break block4;
                        }
                    }
                    token = 6;
                    value = tokenBuf.toString();
                    state = 0;
                    --i;
                    break;
                }
                case 3: {
                    if (c == 'x' || c == 'X') {
                        radix = 16;
                        state = 5;
                        break;
                    }
                    if (Character.isDigit(c)) {
                        radix = 8;
                        tokenBuf.append(c);
                        state = 5;
                        break;
                    }
                    --i;
                    state = 5;
                    break;
                }
                case 5: {
                    if (radix == 16 && this.isHexDigit(c) || Character.isDigit(c)) {
                        tokenBuf.append(c);
                        break;
                    }
                    if (c == '.') {
                        tokenBuf.append(c);
                        state = 6;
                        break;
                    }
                    if (c == 'E' || c == 'e') {
                        tokenBuf.append(c);
                        state = 7;
                        break;
                    }
                    token = 104;
                    if (lastToken == 11) {
                        tokenBuf.insert(0, '-');
                        buf.removeLast();
                    }
                    try {
                        value = Long.valueOf(tokenBuf.toString(), radix);
                        radix = 10;
                    }
                    catch (NumberFormatException e) {
                        throw new SelectorFormatException("Invalid numeric constant: " + e.getMessage(), selector, i);
                    }
                    state = 0;
                    if (c == 'l' || c == 'L') break;
                    --i;
                    break;
                }
                case 6: {
                    if (Character.isDigit(c)) {
                        tokenBuf.append(c);
                        break;
                    }
                    if (c == 'E' || c == 'e') {
                        tokenBuf.append(c);
                        state = 7;
                        break;
                    }
                    token = 103;
                    try {
                        value = Double.valueOf(tokenBuf.toString());
                    }
                    catch (NumberFormatException e) {
                        throw new SelectorFormatException("Invalid numeric constant: " + e.getMessage(), selector, i);
                    }
                    state = 0;
                    if (c == 'd' || c == 'D' || c == 'f' || c == 'F') break;
                    --i;
                    break;
                }
                case 7: {
                    if (Character.isDigit(c)) {
                        tokenBuf.append(c);
                        state = 8;
                        break;
                    }
                    if (c == '-') {
                        tokenBuf.append(c);
                        state = 8;
                        break;
                    }
                    token = 103;
                    try {
                        value = Double.valueOf(tokenBuf.toString());
                    }
                    catch (NumberFormatException e) {
                        throw new SelectorFormatException("Invalid numeric constant: " + e.getMessage(), selector, i);
                    }
                    state = 0;
                    if (c == 'd' || c == 'D' || c == 'f' || c == 'F') break;
                    --i;
                    break;
                }
                case 8: {
                    if (Character.isDigit(c)) {
                        tokenBuf.append(c);
                        break;
                    }
                    token = 103;
                    try {
                        value = Double.valueOf(tokenBuf.toString());
                    }
                    catch (NumberFormatException e) {
                        throw new SelectorFormatException("Invalid numeric constant: " + e.getMessage(), selector, i);
                    }
                    state = 0;
                    if (c == 'd' || c == 'D' || c == 'f' || c == 'F') break;
                    --i;
                    break;
                }
                case 9: {
                    if (c == '\'') {
                        state = 10;
                        break;
                    }
                    tokenBuf.append(c);
                    break;
                }
                case 10: {
                    if (c == '\'') {
                        state = 9;
                        tokenBuf.append(c);
                        break;
                    }
                    token = 102;
                    value = tokenBuf.toString();
                    state = 0;
                    --i;
                    break;
                }
                case 11: {
                    if (Character.isJavaIdentifierPart(c)) {
                        tokenBuf.append(c);
                        break;
                    }
                    value = tokenBuf.toString();
                    token = this.identifierToKeyWord((String)value);
                    state = 0;
                    --i;
                    break;
                }
                default: {
                    throw new SelectorFormatException("Selector tokenizer in bad state: " + state + " tokenBuf=" + tokenBuf + " char=" + c, selector, i);
                }
            }
            if (token == 101) {
                this.usesProperties = true;
            } else if (token == 107) {
                this.usesFields = true;
            }
            if (state == 0 && token == 500) {
                throw new SelectorFormatException("Unknown token: " + token + " tokenBuf=" + tokenBuf, selector, i);
            }
            if (state != 0 || token == 110) continue;
            buf.add(SelectorToken.getInstance(token, value));
            lastToken = token;
            radix = 10;
        }
        if (state == 9) {
            throw new SelectorFormatException("Missing closing quote", selector, i);
        }
        if (state != 0) {
            throw new SelectorFormatException("Invalid Expression", selector, i);
        }
        return buf;
    }

    private int identifierToKeyWord(String s) {
        Integer n = keywords.get(s.toUpperCase());
        if (n != null) {
            return n;
        }
        if (s.startsWith("JMS")) {
            if (headers.contains(s)) {
                return 107;
            }
            return 101;
        }
        return 101;
    }

    private boolean isHexDigit(char c) {
        return Character.isDigit(c) || c == 'a' || c == 'A' || c == 'b' || c == 'B' || c == 'c' || c == 'C' || c == 'd' || c == 'D' || c == 'e' || c == 'E' || c == 'f' || c == 'F';
    }

    private LinkedList<SelectorToken> aggregate(LinkedList<SelectorToken> in) throws SelectorFormatException {
        LinkedList<SelectorToken> out = new LinkedList<SelectorToken>();
        int len = in.size();
        block4: for (int i = 0; i < len; ++i) {
            SelectorToken token0 = in.get(i);
            SelectorToken token1 = null;
            SelectorToken token2 = null;
            if (i + 1 < len) {
                token1 = in.get(i + 1);
            }
            if (i + 2 < len) {
                token2 = in.get(i + 2);
            }
            switch (token0.getToken()) {
                case 3: {
                    if (token1 == null) {
                        out.add(token0);
                        continue block4;
                    }
                    if (token1.getToken() == 16) {
                        out.add(SelectorToken.getInstance(17, (String)token0.getValue() + " " + (String)token1.getValue()));
                        ++i;
                        continue block4;
                    }
                    if (token1.getToken() == 18) {
                        out.add(SelectorToken.getInstance(19, (String)token0.getValue() + " " + (String)token1.getValue()));
                        ++i;
                        continue block4;
                    }
                    if (token1.getToken() == 20) {
                        out.add(SelectorToken.getInstance(22, (String)token0.getValue() + " " + (String)token1.getValue()));
                        ++i;
                        continue block4;
                    }
                    out.add(token0);
                    continue block4;
                }
                case 25: {
                    if (token1 == null) {
                        out.add(token0);
                        continue block4;
                    }
                    if (token1.getToken() == 111) {
                        out.add(SelectorToken.getInstance(23, (String)token0.getValue() + " " + (String)token1.getValue()));
                        ++i;
                        continue block4;
                    }
                    if (token1.getToken() == 3) {
                        if (token2 == null) {
                            out.add(SelectorToken.getInstance(26, (String)token0.getValue() + " " + (String)token1.getValue()));
                            ++i;
                            continue block4;
                        }
                        if (token2.getToken() == 111) {
                            out.add(SelectorToken.getInstance(24, (String)token0.getValue() + " " + (String)token1.getValue() + " " + (String)token2.getValue()));
                            ++i;
                            ++i;
                            continue block4;
                        }
                        out.add(SelectorToken.getInstance(26, (String)token0.getValue() + " " + (String)token1.getValue()));
                        ++i;
                        continue block4;
                    }
                    out.add(token0);
                    continue block4;
                }
                default: {
                    out.add(token0);
                }
            }
        }
        return out;
    }

    private LinkedList<SelectorToken> prepare(LinkedList<SelectorToken> in) throws SelectorFormatException {
        LinkedList<SelectorToken> out = new LinkedList<SelectorToken>();
        int len = in.size();
        block5: for (int i = 0; i < len; ++i) {
            SelectorToken token0 = in.get(i);
            switch (token0.getToken()) {
                case 16: 
                case 17: {
                    out.add(token0);
                    ++i;
                    while (i < len) {
                        token0 = in.get(i);
                        if (token0.getToken() == 2) {
                            out.add(SelectorToken.getInstance(29, ","));
                            continue block5;
                        }
                        out.add(token0);
                        ++i;
                    }
                    continue block5;
                }
                case 18: 
                case 19: {
                    out.add(token0);
                    token0 = in.get(++i);
                    if (token0.getToken() != 27) {
                        throw new SelectorFormatException("Missing ( in IN statement", this.selector);
                    }
                    ++i;
                    HashSet<Object> set = new HashSet<Object>();
                    while (i < len && (token0 = in.get(i)).getToken() != 28) {
                        if (token0.getToken() == 29) {
                            ++i;
                            continue;
                        }
                        if (token0.getToken() != 102) {
                            throw new SelectorFormatException("IN requires string literal: " + token0.getValue(), this.selector);
                        }
                        set.add(token0.getValue());
                        ++i;
                    }
                    out.add(SelectorToken.getInstance(109, set));
                    continue block5;
                }
                case 20: 
                case 22: {
                    out.add(token0);
                    token0 = in.get(++i);
                    if (token0.getToken() != 102) {
                        throw new SelectorFormatException("LIKE requires string literal: " + token0.getValue(), this.selector);
                    }
                    String re = (String)token0.getValue();
                    String escape = null;
                    if (++i < len) {
                        token0 = in.get(i);
                        if (token0.getToken() == 21) {
                            if ((token0 = in.get(++i)).getToken() != 102) {
                                throw new SelectorFormatException("ESCAPE requires string literal: " + token0.getValue(), this.selector);
                            }
                            escape = (String)token0.getValue();
                        } else {
                            --i;
                        }
                    }
                    out.add(SelectorToken.getInstance(113, new RegularExpression(re, escape)));
                    continue block5;
                }
                default: {
                    out.add(token0);
                }
            }
        }
        return out;
    }

    private void validate(LinkedList<SelectorToken> in) throws SelectorFormatException {
        int len = in.size();
        int prevToken = 0;
        for (int i = 0; i < len; ++i) {
            SelectorToken token = in.get(i);
            if (!Selector.isOperator(token)) {
                if (prevToken != 0 && !Selector.isOperator(prevToken)) {
                    throw new SelectorFormatException("Missing operator", this.selector);
                }
            } else if (prevToken == token.getToken() && prevToken != 27 && prevToken != 28) {
                throw new SelectorFormatException("Missing operand", this.selector);
            }
            prevToken = token.getToken();
        }
    }

    private SelectorToken[] convertToRPN(LinkedList<SelectorToken> in) throws SelectorFormatException {
        Stack<SelectorToken> stack = new Stack<SelectorToken>();
        SelectorToken[] out = new SelectorToken[(int)((double)in.size() * 1.5)];
        int i = 0;
        for (SelectorToken token : in) {
            if (!Selector.isOperator(token)) {
                out[i++] = token;
                continue;
            }
            if (token.getToken() == 27) {
                stack.push(token);
                continue;
            }
            SelectorToken t = null;
            if (token.getToken() == 28) {
                do {
                    if (stack.empty()) {
                        throw new SelectorFormatException("Missing (", this.selector);
                    }
                    t = (SelectorToken)stack.pop();
                    if (t.getToken() == 27) continue;
                    out[i++] = t;
                } while (t.getToken() != 27);
                continue;
            }
            while (!stack.empty() && (t = (SelectorToken)stack.peek()).getToken() != 27 && Selector.getPrecedence(t) >= Selector.getPrecedence(token)) {
                out[i++] = (SelectorToken)stack.pop();
            }
            stack.push(token);
            if (!shortCircuit) continue;
            if (token.getToken() == 2) {
                out[i++] = SelectorToken.getInstance(200);
                continue;
            }
            if (token.getToken() != 1) continue;
            out[i++] = SelectorToken.getInstance(201);
        }
        while (!stack.empty()) {
            try {
                out[i] = (SelectorToken)stack.pop();
            }
            catch (IndexOutOfBoundsException e) {
                SelectorFormatException ex = new SelectorFormatException("Bad selector ", this.selector);
                ex.initCause(e);
                throw ex;
            }
            if (out[i].getToken() == 27) {
                throw new SelectorFormatException("Missing )", this.selector);
            }
            ++i;
        }
        return out;
    }

    public synchronized boolean match(Map<Object, Object> properties, Map<Object, Object> fields) throws SelectorFormatException {
        return this.match(properties, fields, false);
    }

    /*
     * Unable to fully structure code
     */
    private synchronized boolean match(Map<Object, Object> properties, Map<Object, Object> fields, boolean compileTestShortCircuit) throws SelectorFormatException {
        this.stack.clear();
        markers = 0;
lbl3:
        // 3 sources

        try {
            block19: for (i = 0; i < this.compiledSelector.length && (token = this.compiledSelector[i]) != null; ++i) {
                block61: {
                    block62: {
                        if (!Selector.shortCircuit) break block61;
                        if (token.getToken() != 200) break block62;
                        t = this.stack.peek().getToken();
                        if (compileTestShortCircuit) {
                            t = 105;
                        }
                        if (t != 106) continue;
                        markers = 1;
                        while (markers > 0) {
                            if ((token = this.compiledSelector[++i]).getToken() == 200) {
                                ++markers;
                                continue;
                            }
                            if (token.getToken() != 2) continue;
                            --markers;
                        }
                        ** GOTO lbl3
                    }
                    if (token.getToken() != 201) break block61;
                    t = this.stack.peek().getToken();
                    if (compileTestShortCircuit) {
                        t = 105;
                    }
                    if (t != 105) continue;
                    markers = 1;
                    while (markers > 0) {
                        if ((token = this.compiledSelector[++i]).getToken() == 201) {
                            ++markers;
                            continue;
                        }
                        if (token.getToken() != 1) continue;
                        --markers;
                    }
                    ** GOTO lbl3
                }
                if (!Selector.isOperator(token)) {
                    if (token.getToken() == 101) {
                        value = properties == null ? null : properties.get(token.getValue());
                        if (value == null) {
                            this.stack.push(SelectorToken.getInstance(112, null));
                            continue;
                        }
                        this.stack.push(this.propertyToToken(value));
                        continue;
                    }
                    if (token.getToken() == 107) {
                        value = fields == null ? null : fields.get(token.getValue());
                        if (value == null) {
                            this.stack.push(SelectorToken.getInstance(112, null));
                            continue;
                        }
                        this.stack.push(this.propertyToToken(value));
                        continue;
                    }
                    this.stack.push(token);
                    continue;
                }
                if (token.getToken() == 29) continue;
                operand1 = this.stack.pop();
                switch (token.getToken()) {
                    case 1: {
                        operand2 = this.stack.pop();
                        if (operand1.getToken() == 105 || operand2.getToken() == 105) {
                            this.stack.push(SelectorToken.getInstance(105));
                            continue block19;
                        }
                        if (operand1.getToken() == 106 && operand2.getToken() == 106) {
                            this.stack.push(SelectorToken.getInstance(106));
                            continue block19;
                        }
                        this.stack.push(SelectorToken.getInstance(112));
                        continue block19;
                    }
                    case 2: {
                        operand2 = this.stack.pop();
                        if (operand1.getToken() == 105 && operand2.getToken() == 105) {
                            this.stack.push(SelectorToken.getInstance(105));
                            continue block19;
                        }
                        if (operand1.getToken() == 106 || operand2.getToken() == 106) {
                            this.stack.push(SelectorToken.getInstance(106));
                            continue block19;
                        }
                        this.stack.push(SelectorToken.getInstance(112));
                        continue block19;
                    }
                    case 3: {
                        if (operand1.getToken() == 105) {
                            this.stack.push(SelectorToken.getInstance(106));
                            continue block19;
                        }
                        if (operand1.getToken() == 106) {
                            this.stack.push(SelectorToken.getInstance(105));
                            continue block19;
                        }
                        this.stack.push(SelectorToken.getInstance(112));
                        continue block19;
                    }
                    case 9: {
                        operand2 = this.stack.pop();
                        if (Selector.isNumeric(operand1) || Selector.isNumeric(operand2)) {
                            this.stack.push(this.doNumericOperation(token, operand2, operand1));
                            continue block19;
                        }
                        if (operand1.equals(operand2)) {
                            this.stack.push(SelectorToken.getInstance(105));
                            continue block19;
                        }
                        this.stack.push(SelectorToken.getInstance(106));
                        continue block19;
                    }
                    case 4: {
                        operand2 = this.stack.pop();
                        if (Selector.isNumeric(operand1) || Selector.isNumeric(operand2)) {
                            this.stack.push(this.doNumericOperation(token, operand2, operand1));
                            continue block19;
                        }
                        if (operand1.equals(operand2)) {
                            this.stack.push(SelectorToken.getInstance(106));
                            continue block19;
                        }
                        this.stack.push(SelectorToken.getInstance(105));
                        continue block19;
                    }
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        operand2 = this.stack.pop();
                        this.stack.push(this.doNumericOperation(token, operand2, operand1));
                        continue block19;
                    }
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: {
                        operand2 = this.stack.pop();
                        this.stack.push(this.doNumericOperation(token, operand2, operand1));
                        continue block19;
                    }
                    case 11: {
                        this.stack.push(this.doNumericOperation(token, operand1, null));
                        continue block19;
                    }
                    case 10: {
                        this.stack.push(this.doNumericOperation(token, operand1, null));
                        continue block19;
                    }
                    case 16: 
                    case 17: {
                        max = operand1;
                        min = this.stack.pop();
                        operand = this.stack.pop();
                        between = false;
                        if (this.doNumericOperation(SelectorToken.getInstance(7), operand, min).getToken() == 105 && this.doNumericOperation(SelectorToken.getInstance(5), operand, max).getToken() == 105) {
                            between = true;
                        }
                        if (token.getToken() == 16) {
                            if (between) {
                                this.stack.push(SelectorToken.getInstance(105));
                                continue block19;
                            }
                            this.stack.push(SelectorToken.getInstance(106));
                            continue block19;
                        }
                        if (between) {
                            this.stack.push(SelectorToken.getInstance(106));
                            continue block19;
                        }
                        this.stack.push(SelectorToken.getInstance(105));
                        continue block19;
                    }
                    case 18: 
                    case 19: {
                        operand2 = this.stack.pop();
                        if (!(operand2.getValue() instanceof String)) {
                            throw new SelectorFormatException("IN requires string operand: " + operand2.getValue(), this.selector);
                        }
                        set = (HashSet)operand1.getValue();
                        if (operand2.getToken() == 112) {
                            this.stack.push(SelectorToken.getInstance(106));
                            continue block19;
                        }
                        if (set.contains(operand2.getValue())) {
                            if (token.getToken() == 18) {
                                this.stack.push(SelectorToken.getInstance(105));
                                continue block19;
                            }
                            this.stack.push(SelectorToken.getInstance(106));
                            continue block19;
                        }
                        if (token.getToken() == 18) {
                            this.stack.push(SelectorToken.getInstance(106));
                            continue block19;
                        }
                        this.stack.push(SelectorToken.getInstance(105));
                        continue block19;
                    }
                    case 20: 
                    case 22: {
                        operand2 = this.stack.pop();
                        if (!(operand2.getValue() instanceof String)) {
                            throw new SelectorFormatException("LIKE requires string operand: " + operand2.getValue(), this.selector);
                        }
                        re = (RegularExpression)operand1.getValue();
                        if (operand2.getToken() == 112) {
                            this.stack.push(SelectorToken.getInstance(106));
                            continue block19;
                        }
                        if (re.match((String)operand2.getValue())) {
                            if (token.getToken() == 20) {
                                this.stack.push(SelectorToken.getInstance(105));
                                continue block19;
                            }
                            this.stack.push(SelectorToken.getInstance(106));
                            continue block19;
                        }
                        if (token.getToken() == 20) {
                            this.stack.push(SelectorToken.getInstance(106));
                            continue block19;
                        }
                        this.stack.push(SelectorToken.getInstance(105));
                        continue block19;
                    }
                    case 23: {
                        if (operand1.getToken() == 112) {
                            this.stack.push(SelectorToken.getInstance(105));
                            continue block19;
                        }
                        this.stack.push(SelectorToken.getInstance(106));
                        continue block19;
                    }
                    case 24: {
                        if (operand1.getToken() != 112) {
                            this.stack.push(SelectorToken.getInstance(105));
                            continue block19;
                        }
                        this.stack.push(SelectorToken.getInstance(106));
                        continue block19;
                    }
                    default: {
                        throw new SelectorFormatException("Unknown operator: " + token, this.selector);
                    }
                }
            }
            token = this.stack.pop();
        }
        catch (EmptyStackException e) {
            ex = new SelectorFormatException("Missing operand", this.selector);
            ex.initCause(e);
            throw ex;
        }
        catch (ArithmeticException e) {
            ex = new SelectorFormatException(e.toString(), this.selector);
            ex.initCause(e);
            throw ex;
        }
        if (!this.stack.empty()) {
            throw new SelectorFormatException("Missing operator", this.selector);
        }
        if (token.getToken() == 105) {
            return true;
        }
        if (token.getToken() == 106) {
            return false;
        }
        if (token.getToken() == 112) {
            return false;
        }
        throw new SelectorFormatException("Non-boolean expression", this.selector);
    }

    private SelectorToken propertyToToken(Object value) {
        if (value instanceof String) {
            return SelectorToken.getInstance(102, value);
        }
        if (value instanceof Boolean) {
            boolean b = (Boolean)value;
            if (b) {
                return SelectorToken.getInstance(105);
            }
            return SelectorToken.getInstance(106);
        }
        if (value instanceof Double) {
            return SelectorToken.getInstance(103, value);
        }
        if (value instanceof Float) {
            double d = ((Float)value).floatValue();
            return SelectorToken.getInstance(103, d);
        }
        if (value instanceof Long) {
            return SelectorToken.getInstance(104, value);
        }
        if (value instanceof Integer) {
            long l = ((Integer)value).intValue();
            return SelectorToken.getInstance(104, l);
        }
        if (value instanceof Short) {
            long l = ((Short)value).shortValue();
            return SelectorToken.getInstance(104, l);
        }
        if (value instanceof Byte) {
            long l = ((Byte)value).byteValue();
            return SelectorToken.getInstance(104, l);
        }
        return null;
    }

    private SelectorToken convertStringToNumber(String s) throws SelectorFormatException {
        try {
            Long l = Long.valueOf(s);
            return SelectorToken.getInstance(104, l);
        }
        catch (NumberFormatException e) {
            try {
                Double d = Double.valueOf(s);
                return SelectorToken.getInstance(103, d);
            }
            catch (NumberFormatException e2) {
                throw new SelectorFormatException("Cannot convert string to number '" + s + "'", this.selector);
            }
        }
    }

    private SelectorToken doNumericOperation(SelectorToken t, SelectorToken op1, SelectorToken op2) throws SelectorFormatException {
        boolean b = false;
        boolean is1L = false;
        boolean is2L = false;
        long val1L = 0L;
        long val2L = 0L;
        double val1D = 0.0;
        double val2D = 0.0;
        if (!Selector.isNumeric(op1) && op1.getToken() != 112) {
            if (convertTypes && op1.getToken() == 102) {
                op1 = this.convertStringToNumber((String)op1.getValue());
            } else {
                throw new SelectorFormatException("Non-numeric argument '" + op1.getValue() + "'", this.selector);
            }
        }
        if (op2 != null && !Selector.isNumeric(op2) && op2.getToken() != 112) {
            if (convertTypes && op2.getToken() == 102) {
                op2 = this.convertStringToNumber((String)op2.getValue());
            } else {
                throw new SelectorFormatException("Non-numeric argument '" + op2.getValue() + "'", this.selector);
            }
        }
        if (op1.getToken() == 112 || op2 != null && op2.getToken() == 112) {
            return SelectorToken.getInstance(112);
        }
        if (op1.getValue() instanceof Long) {
            is1L = true;
            val1L = (Long)op1.getValue();
            val1D = ((Long)op1.getValue()).doubleValue();
        } else {
            is1L = false;
            val1L = ((Double)op1.getValue()).longValue();
            val1D = (Double)op1.getValue();
        }
        if (op2 != null) {
            if (op2.getValue() instanceof Long) {
                is2L = true;
                val2L = (Long)op2.getValue();
                val2D = ((Long)op2.getValue()).doubleValue();
            } else {
                is2L = false;
                val2L = ((Double)op2.getValue()).longValue();
                val2D = (Double)op2.getValue();
            }
        }
        switch (t.getToken()) {
            case 4: 
            case 9: {
                if (is1L && is2L) {
                    b = val1L == val2L;
                } else if (is1L) {
                    b = (double)val1L == val2D;
                } else if (is2L) {
                    b = val1D == (double)val2L;
                } else {
                    boolean bl = b = val1D == val2D;
                }
                if (t.getToken() == 9) {
                    return SelectorToken.getInstance(b ? 105 : 106);
                }
                return SelectorToken.getInstance(b ? 106 : 105);
            }
            case 6: {
                b = is1L && is2L ? val1L < val2L : (is1L ? (double)val1L < val2D : (is2L ? val1D < (double)val2L : val1D < val2D));
                return SelectorToken.getInstance(b ? 105 : 106);
            }
            case 5: {
                b = is1L && is2L ? val1L <= val2L : (is1L ? (double)val1L <= val2D : (is2L ? val1D <= (double)val2L : val1D <= val2D));
                return SelectorToken.getInstance(b ? 105 : 106);
            }
            case 8: {
                b = is1L && is2L ? val1L > val2L : (is1L ? (double)val1L > val2D : (is2L ? val1D > (double)val2L : val1D > val2D));
                return SelectorToken.getInstance(b ? 105 : 106);
            }
            case 7: {
                b = is1L && is2L ? val1L >= val2L : (is1L ? (double)val1L >= val2D : (is2L ? val1D >= (double)val2L : val1D >= val2D));
                return SelectorToken.getInstance(b ? 105 : 106);
            }
            case 14: {
                if (is1L && is2L) {
                    long v = val1L + val2L;
                    return SelectorToken.getInstance(104, v);
                }
                double d = val1D + val2D;
                return SelectorToken.getInstance(103, d);
            }
            case 10: {
                return op1;
            }
            case 15: {
                if (is1L && is2L) {
                    long v = val1L - val2L;
                    return SelectorToken.getInstance(104, v);
                }
                double d = val1D - val2D;
                return SelectorToken.getInstance(103, d);
            }
            case 11: {
                if (is1L) {
                    long v = -val1L;
                    return SelectorToken.getInstance(104, v);
                }
                double d = -val1D;
                return SelectorToken.getInstance(103, d);
            }
            case 12: {
                if (is1L && is2L) {
                    long v = val1L * val2L;
                    return SelectorToken.getInstance(104, v);
                }
                double d = val1D * val2D;
                return SelectorToken.getInstance(103, d);
            }
            case 13: {
                if (is1L && is2L) {
                    long v = val1L / val2L;
                    return SelectorToken.getInstance(104, v);
                }
                double d = val1D / val2D;
                return SelectorToken.getInstance(103, d);
            }
        }
        throw new SelectorFormatException("Unknown numeric operation: " + t, this.selector);
    }

    private static boolean isNumeric(SelectorToken t) {
        int tok = t.getToken();
        return tok == 103 || tok == 104;
    }

    private static boolean isOperator(SelectorToken t) {
        return t.getToken() < 100;
    }

    private static boolean isOperator(int t) {
        return t < 100;
    }

    private static int getPrecedence(SelectorToken t) {
        switch (t.getToken()) {
            case 1: {
                return 10;
            }
            case 2: {
                return 11;
            }
            case 3: {
                return 12;
            }
            case 4: 
            case 9: {
                return 20;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return 21;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: {
                return 30;
            }
            case 14: 
            case 15: {
                return 40;
            }
            case 12: 
            case 13: {
                return 41;
            }
            case 29: {
                return 42;
            }
            case 10: 
            case 11: {
                return 43;
            }
            case 27: 
            case 28: {
                return 50;
            }
        }
        return 1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Selector)) {
            return false;
        }
        Selector obj = (Selector)o;
        return this.selector.equals(obj.selector);
    }

    public int hashCode() {
        return this.selector.hashCode();
    }

    public String toString() {
        return this.selector;
    }

    public boolean usesProperties() {
        return this.usesProperties;
    }

    public boolean usesFields() {
        return this.usesFields;
    }

    private static void dumpTokens(LinkedList<SelectorToken> tokenList) {
        for (SelectorToken token : tokenList) {
            System.out.print(token.toString());
        }
        System.out.println();
    }

    public String toDebugString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.compiledSelector.length; ++i) {
            if (this.compiledSelector[i] == null) continue;
            sb.append(this.compiledSelector[i].toString());
        }
        return sb.toString() + " cachesize=" + selectorCache.size();
    }

    public static void main(String[] args) {
        HashMap<Object, Object> props = new HashMap<Object, Object>();
        HashMap<Object, Object> fields = new HashMap<Object, Object>();
        boolean convert = false;
        int loop = 0;
        props.put("color", "red");
        props.put("description", "Dark hot chocolate with nuts");
        props.put("size", 1024);
        props.put("msgnum", 5);
        props.put("msgnumStr", "5");
        props.put("price", new Float(1.5));
        props.put("quantity", 500L);
        props.put("minlong", Long.MIN_VALUE);
        props.put("maxlong", Long.MAX_VALUE);
        props.put("trueProp", true);
        props.put("falseProp", false);
        props.put("byteProp", (byte)4);
        props.put("shortProp", (short)4);
        props.put("intProp", 4);
        props.put("negIntProp", -4);
        props.put("floatProp", new Float(4.0));
        props.put("stringProp", "4");
        props.put("nullProp", null);
        props.put("Event", "*Service Change*Restart*");
        props.put("Region", "*EA*SO*WE*BC*");
        props.put("Airspace", "*ASSS*ARCC*BVNF*");
        props.put("LIDFAC", "*ZDC/ARTCC*EKN/RCAG*");
        props.put("SVCPDC", "*ECOM/CA*YTR/RCG*");
        props.put("CLASS", "*1*2*3*4*5*");
        props.put("USI", "*USISAMPLEUSI000*");
        props.put("JMSXUserID", "testUser");
        fields.put("JMSDeliveryMode", "PERSISTENT");
        fields.put("JMSPriority", 7);
        fields.put("JMSTimestamp", System.currentTimeMillis());
        fields.put("JMSCorrelationID", "123456789");
        fields.put("JMSType", "order");
        fields.put("JMSMessageID", "messageid_" + System.currentTimeMillis());
        System.out.println("\nProperties=" + props + "\n");
        System.out.println("\nFields=" + fields + "\n");
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-d")) {
                DEBUG = true;
                continue;
            }
            if (args[i].equals("-D")) {
                DEBUG = true;
                VERBOSE_DEBUG = true;
                continue;
            }
            if (args[i].equals("-l")) {
                loop = 500000;
                continue;
            }
            if (args[i].equals("-n")) {
                Selector.setShortCircuit(false);
                continue;
            }
            if (args[i].equals("-c")) {
                convert = true;
                Selector.setConvertTypes(convert);
                continue;
            }
            System.out.println("\nshortCircuit=" + shortCircuit);
            Selector selector = null;
            try {
                selector = Selector.compile(args[i]);
            }
            catch (SelectorFormatException e) {
                System.out.println("Compile Error:\n" + e);
                System.exit(1);
            }
            try {
                System.out.println(selector.match(props, fields));
            }
            catch (SelectorFormatException e) {
                System.out.println("Runtime Error:\n" + e);
                System.exit(1);
            }
            if (loop > 0) {
                long start = System.currentTimeMillis();
                for (int n = 0; n < loop; ++n) {
                    try {
                        selector.match(props, fields);
                        continue;
                    }
                    catch (SelectorFormatException e) {
                        System.out.println("Runtime Error:\n" + e);
                        System.exit(1);
                    }
                }
                long stop = System.currentTimeMillis();
                System.out.println("Evaluated " + loop + " matches in " + (double)(stop - start) / 1000.0 + " secs");
                System.out.println((double)loop / ((double)(stop - start) / 1000.0) + " matches/sec");
            }
            System.exit(0);
        }
        String[][] tests = new String[][]{{"color = 'red'", "true"}, {"color = 'blue'", "false"}, {"color <> 'red'", "false"}, {"color <> 'blue'", "true"}, {"color in ('red', 'white', 'blue')", "true"}, {"color in ('orange', 'white', 'blue')", "false"}, {"color not in ('orange', 'white', 'blue')", "true"}, {"description like '%hot%'", "true"}, {"description not like '%hot%'", "false"}, {"color like 'r_d'", "true"}, {"color like 'r_d' or color like 'bl_e'", "true"}, {"color like 'r_d' and (color like 'b%' or color like '%d')", "true"}, {"quantity between 400 and 1000.0", "true"}, {"price between 1.10 and 2", "true"}, {"price not between 5 and 10e2", "true"}, {"price not between 5 and 10e2 and price between 1 and 2", "true"}, {"price not between 5 and 10e2 or price between 1 and 2", "true"}, {"nullProp is null and price is not null", "true"}, {"nullProp is null or  price is not null", "true"}, {"price is not null", "true"}, {"price > 0.75", "true"}, {"price < 9.75", "true"}, {"price >= 1.50", "true"}, {"price <= 1.50", "true"}, {"price > 9.75", "false"}, {"price >= 9.75", "false"}, {"msgnum > 1.75", "true"}, {"size > msgnum", "true"}, {"size > price", "true"}, {"size > price + msgnum", "true"}, {"size > price * msgnum", "true"}, {"quantity * price > 3.00", "true"}, {"JMSXUserID = 'testUser'", "true"}, {"JMSMessageID like '%~_%' escape '~'", "true"}, {"JMSTimestamp > 4", "true"}, {"JMSCorrelationID like '1_34__%9'", "true"}, {"JMSType <> 'quote'", "true"}, {"JMSPriority > 5", "true"}, {"JMSPriority < JMSTimestamp", "true"}, {"byteProp = 4", "true"}, {"byteProp <> 5.0", "true"}, {"shortProp <> 5.0", "true"}, {"intProp <> 5.0", "true"}, {"byteProp = shortProp", "true"}, {"byteProp = floatProp", "true"}, {"floatProp = 4.0 ", "true"}, {"floatProp * 2 > byteProp", "true"}, {"stringProp = '4'", "true"}, {"stringProp =  4", "error"}, {"stringProp <> '5'", "true"}, {"stringProp <>  5", "error"}, {"byteProp <> 4", "false"}, {"byteProp = 5.0", "false"}, {"shortProp = 5.0", "false"}, {"intProp = 5.0", "false"}, {"1 + 4 * 5 = 21", "true"}, {"1+4*5=21", "true"}, {"1 + -4 * 5 = -19", "true"}, {"(1 + 4) * +5 = 25", "true"}, {"(1 + 4) * -5 = -25", "true"}, {"(1 + 4) * 5 = (3 + 2) * 5", "true"}, {"1 + (4 * 5) = 21", "true"}, {"1 +  4 * 5  = 21", "true"}, {"(1 +  4) * 5 = 25", "true"}, {"(1 +  4) - 5 = 0 ", "true"}, {"2.0 * 4E2 + 5 = 805.0", "true"}, {"2.0 * 4E2 + 5 = 805", "true"}, {"2.0 = 2.0", "true"}, {"1.0+2.0*3.0-4.0/4.0 = 6", "true"}, {"price > 0.75 OR color <> 'blue'", "true"}, {"(price > 0.75 OR color <> 'blue') AND color <> 'green'", "true"}, {"     2 * quantity between msgnum AND msgnum * size", "true"}, {"NOT (2 * quantity between msgnum AND msgnum * size)", "false"}, {"-price < 0 AND +negIntProp < 0", "true"}, {"negIntProp+4 = 0 AND intProp-1 = 3", "true"}, {"- intProp + intProp = 0", "true"}, {"intProp between -1 and 5", "true"}, {"intProp between 1 and 5 AND intProp between -1 and 5", "true"}, {"minlong=-9223372036854775808 AND maxlong=9223372036854775807", "true"}, {"unknownProp NOT IN ('foo','jms','test')", "false"}, {"nullProp NOT IN ('foo','jms','test')", "false"}, {"unknownProp NOT LIKE '1_3'", "false"}, {"nullProp    NOT LIKE '1_3'", "false"}, {"0x1d = 29", "true"}, {"0x1D = 29", "true"}, {"035 = 29", "true"}, {"29L = 29", "true"}, {"29l = 29", "true"}, {"18. = 1.8e1", "true"}, {"18. = .18e2", "true"}, {"18.0f = .18e2", "true"}, {"18.0F = .18e2", "true"}, {"18.0d = .18e2", "true"}, {"18.0D = .18e2", "true"}, {".7e4 = 7000.0", "true"}, {" is null nullProp", "true"}, {"NOT is null nullProp", "false"}, {" is null unknownProp", "true"}, {" is not null nullProp", "false"}, {"NOT is not null nullProp", "true"}, {" is not null unknownProp", "false"}, {"TRUE", "true"}, {"NOT TRUE", "false"}, {"(NOT (NOT (NOT (NOT TRUE))))", "true"}, {"FALSE", "false"}, {"NOT FALSE", "true"}, {"trueProp", "true"}, {"NOT trueProp", "false"}, {"trueProp = TRUE", "true"}, {"trueProp = FALSE", "false"}, {"trueProp <> FALSE", "true"}, {"falseProp", "false"}, {"falseProp = TRUE", "false"}, {"falseProp = FALSE", "true"}, {"falseProp <> TRUE", "true"}, {"NOT falseProp", "true"}, {"description LIKE '%nuts%' AND color in ('black', 'white') OR color = 'blue'", "false"}, {"description LIKE '%nuts%' OR color in ('black', 'white') OR color = 'blue'", "true"}, {"Event LIKE '%*Service Change*%' OR Event LIKE '%*Restart*%' AND Region LIKE '%*EA*%' AND Airspace LIKE '%*ARCC*%'", "true"}, {"color = 'red' OR color <> 'blue' AND color <> 'green'", "true"}, {"color = 'white' OR color <> 'blue' AND color <> 'green'", "true"}, {"color = 'white' OR color <> 'red' AND color <> 'green'", "false"}, {"color = 'red' OR color <> 'blue' AND color <> 'red'", "true"}, {"(color = 'red' OR color <> 'blue') AND color <> 'red'", "false"}, {"(color = 'red' OR color <> 'blue') AND NOT color <> 'red'", "true"}, {"true OR true OR true OR true", "true"}, {"(true OR true) OR (true OR true)", "true"}, {"true OR false OR true OR false", "true"}, {"false OR false OR false OR true", "true"}, {"true OR false OR false OR false", "true"}, {"false OR false OR false OR false", "false"}, {"false OR false OR false OR true", "true"}, {"true AND true AND true AND true", "true"}, {"(true AND false) AND (true AND false)", "false"}, {"false AND false AND false AND true", "false"}, {"true AND false AND false AND false", "false"}, {"false AND true AND true AND true", "false"}, {"true AND true AND true AND false", "false"}, {"true AND false OR true AND true", "true"}, {"true OR false AND true OR false", "true"}, {"(true OR false) AND (true OR false)", "true"}, {"NOT ((true OR false) AND (true OR false))", "false"}, {"color in ('red', 'white', 'blue'(", "error"}, {"size not between 'red'  and 'green'", "error"}, {"+ + + +", "error"}, {"1 2 3 4", "error"}, {"= = = =", "error"}, {"((1 + 2) * 4 = 3", "error"}, {"red red red", "error"}, {"4 >> 1", "error"}, {"color = 'red", "error"}, {"color == 'red'", "error"}, {"intProp BETWEEN 'foo' and 'test'", "error"}, {"intProp > 'foo'", "error"}, {"color    > 'foo'", "error"}, {"unknownProp > 'foo'", "error"}, {"unknownProp < 'foo'", "error"}, {"unknownProp =< 'foo'", "error"}, {"unknownProp >= 'foo'", "error"}, {"intProp >= 'foo'", "error"}, {"intProp < 'foo'", "error"}, {"intProp <= 'foo'", "error"}, {"intProp between 'foo' and 'bar'", "error"}, {"color    between 1 and 7", "error"}, {"'color'    between 1 and 7", "error"}, {"7 in ('red', 'blue')", "error"}, {"intProp in ('red', 'blue')", "error"}, {"7 not in ('red', 'blue')", "error"}, {"intProp not in ('red', 'blue')", "error"}, {"NULL = 0", "error"}, {"=color 'red'", "error"}, {"size like '7'", "error"}, {"size not like '7'", "error"}, {"4 = 'red'", "error"}, {"4 <> 'red'", "error"}, {"'red' <> 4", "error"}, {"'red' =  4", "error"}, {"intProp = 'red'", "error"}, {"intProp <> 'red'", "error"}, {"'red' = intProp", "error"}, {"'red' <> intProp", "error"}, {"msgnumStr = 5", "error"}, {"msgnum    = '5'", "error"}, {"300 + 150 / 0 = 300", "error"}};
        int failCnt = 0;
        for (String[] test : tests) {
            String result;
            String actual;
            String expected;
            block21: {
                Selector selector = null;
                expected = test[1];
                actual = null;
                HashMap<Object, Object> _props = null;
                HashMap<Object, Object> _fields = null;
                try {
                    selector = Selector.compile(test[0]);
                    _props = selector.usesProperties() ? props : null;
                    _fields = selector.usesFields() ? fields : null;
                    actual = selector.match(_props, _fields) ? "true" : "false";
                }
                catch (SelectorFormatException e) {
                    actual = "error";
                    if (actual.equals(expected)) break block21;
                    System.out.println(e);
                }
            }
            if (actual.equals(expected)) {
                result = "      PASS";
            } else {
                result = "***** FAIL";
                ++failCnt;
            }
            System.out.println(result + " " + test[0] + " : expected=" + expected + " actual=" + actual);
        }
        System.out.println(tests.length + " tests: " + (tests.length - failCnt) + " passed " + failCnt + " failed ");
        if (failCnt > 0) {
            System.exit(1);
        } else {
            System.exit(0);
        }
    }

    static {
        keywords = new HashMap();
        keywords.put("NOT", 3);
        keywords.put("AND", 2);
        keywords.put("OR", 1);
        keywords.put("BETWEEN", 16);
        keywords.put("LIKE", 20);
        keywords.put("IN", 18);
        keywords.put("IS", 25);
        keywords.put("ESCAPE", 21);
        keywords.put("NULL", 111);
        keywords.put("TRUE", 105);
        keywords.put("FALSE", 106);
        headers = new HashSet(6);
        headers.add("JMSDeliveryMode");
        headers.add("JMSPriority");
        headers.add("JMSMessageID");
        headers.add("JMSTimestamp");
        headers.add("JMSCorrelationID");
        headers.add("JMSType");
        selectorCache = new WeakValueHashMap("SelectorCache");
    }
}

