/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.PacketUtil;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.BrokerStateHandler;
import com.sun.messaging.jmq.jmsserver.FaultInjection;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationList;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.core.Session;
import com.sun.messaging.jmq.jmsserver.core.SessionUID;
import com.sun.messaging.jmq.jmsserver.data.PacketHandler;
import com.sun.messaging.jmq.jmsserver.data.TransactionList;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.persist.api.PartitionedStore;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQBasicConnection;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.TransactionAckExistException;
import com.sun.messaging.jmq.jmsserver.util.UnknownTransactionException;
import com.sun.messaging.jmq.jmsserver.util.lists.RemoveReason;
import com.sun.messaging.jmq.util.JMQXid;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.DataInputStream;
import java.io.IOException;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;

public class AckHandler
extends PacketHandler {
    static final int ACK_BLOCK_SIZE = 40;
    private int ackProcessCnt = 0;
    private FaultInjection fi = null;
    private final Logger logger = Globals.getLogger();
    private static boolean DEBUG = false;
    public static final int ACKNOWLEDGE_REQUEST = 0;
    public static final int UNDELIVERABLE_REQUEST = 1;
    public static final int DEAD_REQUEST = 2;
    public static final int DEAD_REASON_UNDELIVERABLE = 0;
    public static final int DEAD_REASON_EXPIRED = 1;

    public static void checkRequestType(int ackType) throws BrokerException {
        if (ackType > 2 || ackType < 0) {
            throw new BrokerException("Internal Error: unknown ackType " + ackType);
        }
    }

    public AckHandler() {
        this.fi = FaultInjection.getInjection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handle(IMQConnection con, Packet msg) throws BrokerException {
        int size = msg.getMessageBodySize();
        int ackcount = size / 40;
        int mod = size % 40;
        int status = 200;
        String reason = null;
        if (DEBUG) {
            this.logger.log(8, "AckHandler: processing packet " + msg.toString() + ", on connection " + con);
        }
        PartitionedStore pstore = con.getPartitionedStore();
        TransactionList[] tls = DestinationList.getTransactionList(pstore);
        TransactionList translist = tls[0];
        this.ackProcessCnt = !con.isAdminConnection() && this.fi.FAULT_INJECTION ? ++this.ackProcessCnt : 0;
        if (ackcount == 0) {
            this.logger.log(32, "B3100", "Internal Error: Empty Ack Message " + msg.getSysMessageID().toString());
            reason = "Empty ack message";
            status = 500;
        }
        if (mod != 0) {
            this.logger.log(32, "B3100", "Internal Error: Invalid Ack Message Size " + String.valueOf(size) + " for message " + msg.getSysMessageID().toString());
            reason = "corrupted ack message";
            status = 500;
        }
        TransactionUID tid = null;
        if (msg.getTransactionID() != 0L) {
            try {
                tid = new TransactionUID(msg.getTransactionID());
            }
            catch (Exception ex) {
                this.logger.logStack(32, "B3100", "Internal Error: can not create transactionID for " + msg, (Throwable)ex);
                status = 500;
            }
        }
        ArrayList cleanList = new ArrayList();
        try {
            HashMap<Object, Object> m;
            Hashtable props;
            block53: {
                Hashtable<String, Object> hash;
                Packet pkt;
                block55: {
                    block54: {
                        StringBuilder remoteConsumerUIDs;
                        boolean remoteStatus;
                        block51: {
                            props = null;
                            Throwable deadthr = null;
                            String deadcmt = null;
                            int deadrs = 0;
                            int deliverCnt = 0;
                            boolean deliverCntUpdateOnly = false;
                            int ackType = 0;
                            boolean JMQValidate = false;
                            try {
                                Constable val;
                                props = msg.getProperties();
                                Integer iackType = props == null ? null : (Integer)props.get("JMQAckType");
                                ackType = iackType == null ? 0 : iackType;
                                Boolean validateFlag = props == null ? null : (Boolean)props.get("JMQValidate");
                                JMQValidate = validateFlag == null ? false : validateFlag;
                                AckHandler.checkRequestType(ackType);
                                if (ackType == 2) {
                                    deadthr = (Throwable)props.get("JMQException");
                                    deadcmt = (String)props.get("JMQComment");
                                    val = (Integer)props.get("JMQDeadReason");
                                    if (val != null) {
                                        deadrs = (Integer)val;
                                    }
                                }
                                if (props != null) {
                                    if (ackType == 2 || ackType == 1 || tid != null) {
                                        val = (Integer)props.get("JMSXDeliveryCount");
                                        int n = deliverCnt = val == null ? -1 : (Integer)val;
                                        if (tid == null && deliverCnt >= 0) {
                                            ++deliverCnt;
                                        }
                                    }
                                    if (ackType == 1) {
                                        val = (Boolean)props.get("JMSXDeliveryCountUpdateOnly");
                                        deliverCntUpdateOnly = val == null ? false : (Boolean)val;
                                    }
                                }
                            }
                            catch (Exception ex) {
                                this.logger.logStack(8, "Internal Error: bad protocol", ex);
                                ackType = 0;
                            }
                            if (!con.isAdminConnection() && this.fi.FAULT_INJECTION) {
                                HashMap<Object, Object> m2 = new HashMap<Object, Object>();
                                if (props != null) {
                                    m2.putAll(props);
                                }
                                m2.put("mqAckCount", this.ackProcessCnt);
                                m2.put("mqIsTransacted", tid != null);
                                this.fi.checkFaultAndExit("msg.ack.1", m2, 2, false);
                            }
                            remoteStatus = false;
                            remoteConsumerUIDs = null;
                            SysMessageID[] ids = null;
                            ConsumerUID[] cids = null;
                            try {
                                if (status == 200) {
                                    DataInputStream is = new DataInputStream(msg.getMessageBodyStream());
                                    ids = new SysMessageID[ackcount];
                                    cids = new ConsumerUID[ackcount];
                                    for (int i = 0; i < ackcount; ++i) {
                                        long newid = is.readLong();
                                        cids[i] = new ConsumerUID(newid);
                                        cids[i].setConnectionUID(con.getConnectionUID());
                                        ids[i] = new SysMessageID();
                                        ids[i].readID(is);
                                    }
                                    if (JMQValidate) {
                                        if (ackType == 2 || ackType == 1) {
                                            status = 400;
                                            reason = "Can not use JMQValidate with ackType of " + ackType;
                                        } else if (tid == null) {
                                            status = 400;
                                            reason = "Can not use JMQValidate with no tid ";
                                        } else if (!this.validateMessages(translist, tid, ids, cids)) {
                                            status = 404;
                                            reason = "Acknowledgement not processed";
                                        }
                                    } else if (ackType == 2) {
                                        this.handleDeadMsgs(con, ids, cids, deadrs, deadthr, deadcmt, deliverCnt, cleanList);
                                    } else if (ackType == 1) {
                                        this.handleUndeliverableMsgs(con, ids, cids, cleanList, deliverCnt, deliverCntUpdateOnly);
                                    } else if (tid != null) {
                                        this.handleTransaction(translist, con, tid, ids, cids, deliverCnt);
                                    } else {
                                        this.handleAcks(con, ids, cids, msg.getSendAcknowledge(), cleanList);
                                    }
                                }
                            }
                            catch (Throwable thr) {
                                status = 500;
                                if (thr instanceof BrokerException) {
                                    status = ((BrokerException)thr).getStatusCode();
                                    remoteStatus = ((BrokerException)thr).isRemote();
                                    if (remoteStatus && ids != null && cids != null) {
                                        remoteConsumerUIDs = new StringBuilder();
                                        remoteConsumerUIDs.append(((BrokerException)thr).getRemoteConsumerUIDs());
                                        remoteConsumerUIDs.append(' ');
                                        String cidstr = null;
                                        ArrayList<String> remoteConsumerUIDa = new ArrayList<String>();
                                        for (int i = 0; i < ids.length; ++i) {
                                            ConsumerUID sid;
                                            PacketReference ref = DestinationList.get(pstore, ids[i]);
                                            Consumer c = Consumer.getConsumer(cids[i]);
                                            if (c == null || (sid = c.getStoredConsumerUID()) == null || sid.equals(cids[i])) continue;
                                            BrokerAddress ba = ref == null ? null : ref.getBrokerAddress();
                                            BrokerAddress rba = (BrokerAddress)((BrokerException)thr).getRemoteBrokerAddress();
                                            if (ref == null || ba == null || rba == null || !ba.equals(rba) || remoteConsumerUIDa.contains(cidstr = String.valueOf(c.getConsumerUID().longValue()))) continue;
                                            remoteConsumerUIDa.add(cidstr);
                                            remoteConsumerUIDs.append(cidstr);
                                            remoteConsumerUIDs.append(' ');
                                        }
                                    }
                                }
                                reason = thr.getMessage();
                                if (status != 500) break block51;
                                this.logger.logStack(32, "B3100", "-------------------------------------------Internal Error: Invalid Acknowledge Packet processing\n " + (msg.getSendAcknowledge() ? " notifying client\n" : " can not notify the client") + PacketUtil.dumpPacket(msg) + "--------------------------------------------", thr);
                            }
                        }
                        if (!con.isAdminConnection() && this.fi.FAULT_INJECTION) {
                            m = new HashMap<Object, Object>();
                            if (props != null) {
                                m.putAll(props);
                            }
                            m.put("mqAckCount", this.ackProcessCnt);
                            m.put("mqIsTransacted", tid != null);
                            this.fi.checkFaultAndExit("msg.ack.2", m, 2, false);
                        }
                        if (!msg.getSendAcknowledge()) break block53;
                        pkt = new Packet(con.useDirectBuffers());
                        pkt.setPacketType(25);
                        pkt.setConsumerID(msg.getConsumerID());
                        hash = new Hashtable<String, Object>();
                        hash.put("JMQStatus", status);
                        if (reason != null) {
                            hash.put("JMQReason", reason);
                        }
                        if (remoteStatus) {
                            hash.put("JMQRemote", true);
                            if (remoteConsumerUIDs != null) {
                                hash.put("JMQRemoteConsumerIDs", remoteConsumerUIDs.toString());
                            }
                        }
                        IMQBasicConnection cfr_ignored_0 = (IMQBasicConnection)con;
                        if (IMQBasicConnection.getDumpPacket()) break block54;
                        IMQBasicConnection cfr_ignored_1 = (IMQBasicConnection)con;
                        if (!IMQBasicConnection.getDumpOutPacket()) break block55;
                    }
                    hash.put("JMQReqID", msg.getSysMessageID().toString());
                }
                pkt.setProperties(hash);
                con.sendControlMessage(pkt);
            }
            if (!con.isAdminConnection() && this.fi.FAULT_INJECTION) {
                m = new HashMap();
                if (props != null) {
                    m.putAll(props);
                }
                m.put("mqAckCount", this.ackProcessCnt);
                m.put("mqIsTransacted", tid != null);
                this.fi.checkFaultAndExit("msg.ack.3", m, 2, false);
            }
        }
        finally {
            this.cleanUp(cleanList);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanUp(List cleanList) {
        if (cleanList == null || cleanList.isEmpty()) {
            return;
        }
        try {
            Iterator itr = cleanList.iterator();
            while (itr.hasNext()) {
                PacketReference ref = (PacketReference)itr.next();
                if (ref == null) continue;
                try {
                    Destination d = ref.getDestination();
                    try {
                        if (ref.isDead()) {
                            d.removeDeadMessage(ref);
                            continue;
                        }
                        d.removeMessage(ref.getSysMessageID(), RemoveReason.ACKNOWLEDGED);
                    }
                    catch (Exception ex) {
                        Object[] eparam = new Object[]{"" + ref.toString(), d == null ? "null" : d.getUniqueName(), ex.getMessage()};
                        String emsg = Globals.getBrokerResources().getKString("B3277", eparam);
                        if (DEBUG) {
                            this.logger.logStack(8, emsg, ex);
                            continue;
                        }
                        this.logger.log(8, emsg);
                    }
                }
                finally {
                    ref.postAcknowledgedRemoval();
                    itr.remove();
                }
            }
        }
        finally {
            if (!cleanList.isEmpty()) {
                for (PacketReference ref : cleanList) {
                    if (ref == null) continue;
                    ref.postAcknowledgedRemoval();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleAcks(IMQConnection con, SysMessageID[] ids, ConsumerUID[] cids, boolean ackack, List cleanList) throws BrokerException, IOException {
        for (int i = 0; i < ids.length; ++i) {
            PacketReference ref;
            Session s;
            if (DEBUG) {
                this.logger.log(8, "handleAcks[" + i + ", " + ids.length + "]:sysid=" + ids[i] + ", cid=" + cids[i] + ", on connection " + con);
            }
            if ((s = Session.getSession(cids[i])) == null) {
                Consumer c = Consumer.getConsumer(cids[i]);
                if (c == null) {
                    if (!con.isValid() || con.isBeingDestroyed()) {
                        if (!DEBUG) continue;
                        this.logger.log(8, "Received ack for consumer " + cids[i] + " on closing connection " + con);
                        continue;
                    }
                    if (BrokerStateHandler.isShutdownStarted()) {
                        throw new BrokerException("B1248");
                    }
                    throw new BrokerException(this.br.getKString("B1260", cids[i]), 404);
                }
                if (c.getConsumerUID().getBrokerAddress() != Globals.getClusterBroadcast().getMyAddress()) {
                    PacketReference ref2 = DestinationList.get(null, ids[i]);
                    if (ref2 == null) {
                        BrokerException bex = new BrokerException(this.br.getKString("B1290", ids[i]) + "[" + cids[i] + "]", 410);
                        bex.setRemoteConsumerUIDs(String.valueOf(cids[i].longValue()));
                        bex.setRemote(true);
                        throw bex;
                    }
                    ConsumerUID cuid = c.getConsumerUID();
                    if (!ref2.acknowledged(cuid, c.getStoredConsumerUID(), !cuid.isDupsOK(), true, ackack)) continue;
                    cleanList.add(ref2);
                    continue;
                }
                String emsg = this.br.getKString("B1444", "[" + ids[i] + ", " + cids[i] + "]", cids[i]);
                this.logger.log(16, emsg);
                throw new BrokerException(emsg);
            }
            if (this.fi.FAULT_INJECTION) {
                ref = DestinationList.get(null, ids[i]);
                if (ref != null && !ref.getDestination().isAdmin() && !ref.getDestination().isInternal()) {
                    if (this.fi.checkFault("msg.ack.1_5", null)) {
                        this.fi.unsetFault("msg.ack.1_5");
                        BrokerException bex = new BrokerException("FAULT:" + "msg.ack.1_5", 410);
                        bex.setRemoteConsumerUIDs(String.valueOf(cids[i].longValue()));
                        bex.setRemote(true);
                        throw bex;
                    }
                }
            }
            ref = (PacketReference)s.ackMessage(cids[i], ids[i], ackack);
            try {
                s.postAckMessage(cids[i], ids[i], ackack);
                continue;
            }
            finally {
                if (ref != null) {
                    cleanList.add(ref);
                }
            }
        }
    }

    public void handleTransaction(TransactionList translist, IMQConnection con, TransactionUID tid, SysMessageID[] ids, ConsumerUID[] cids, int deliverCnt) throws BrokerException {
        for (int i = 0; i < ids.length; ++i) {
            Consumer consumer = null;
            try {
                boolean isxa;
                BrokerAddress addr;
                Session s = Session.getSession(cids[i]);
                consumer = Consumer.getConsumer(cids[i]);
                if (consumer == null) {
                    throw new BrokerException(Globals.getBrokerResources().getKString("B1260", cids[i]) + "[TID=" + tid + "]", 404);
                }
                ConsumerUID sid = consumer.getStoredConsumerUID();
                if (s == null) {
                    SessionUID suid = consumer.getSessionUID();
                    s = Session.getSession(suid);
                }
                if (s == null) {
                    if (BrokerStateHandler.isShutdownStarted()) {
                        throw new BrokerException("B1248");
                    }
                    throw new BrokerException(this.br.getKString("B1443", "[" + ids[i] + ", " + cids[i] + "]TID=" + tid));
                }
                if (DEBUG) {
                    this.logger.log(8, "handleTransaction.addAck[" + i + ", " + ids.length + "]:tid=" + tid + ", sysid=" + ids[i] + ", cid=" + cids[i] + ", sid=" + sid + " on connection " + con);
                }
                if ((addr = (BrokerAddress)s.ackInTransaction(cids[i], ids[i], tid, isxa = translist.addAcknowledgement(tid, ids[i], cids[i], sid), deliverCnt)) != null && addr != Globals.getMyAddress()) {
                    translist.setAckBrokerAddress(tid, ids[i], cids[i], addr);
                }
                if (!this.fi.FAULT_INJECTION) continue;
                if (!this.fi.checkFault("txn.ack.1_5", null)) continue;
                this.fi.unsetFault("txn.ack.1_5");
                TransactionAckExistException tae = new TransactionAckExistException("FAULT:" + "txn.ack.1_5", 410);
                tae.setRemoteConsumerUIDs(String.valueOf(cids[i].longValue()));
                tae.setRemote(true);
                consumer.recreationRequested();
                throw tae;
            }
            catch (Exception ex) {
                block17: {
                    String emsg = "[" + ids[i] + ", " + cids[i] + "]TUID=" + tid;
                    if (ex instanceof BrokerException && ((BrokerException)ex).getStatusCode() != 500) {
                        this.logger.log(16, Globals.getBrokerResources().getKString("B3229", emsg, ex.getMessage()), ex);
                    } else {
                        this.logger.log(32, Globals.getBrokerResources().getKString("B3229", emsg, ex.getMessage()), ex);
                    }
                    int state = -1;
                    JMQXid xid = null;
                    try {
                        TransactionState ts = translist.retrieveState(tid);
                        if (ts != null) {
                            state = ts.getState();
                            xid = ts.getXid();
                        }
                        translist.updateState(tid, 2, true);
                    }
                    catch (Exception e) {
                        if (e instanceof UnknownTransactionException) break block17;
                        Object[] args = new String[]{TransactionState.toString(state), TransactionState.toString(2), tid.toString(), xid == null ? "null" : xid.toString()};
                        this.logger.log(16, Globals.getBrokerResources().getKString("B2179", args));
                    }
                }
                if (ex instanceof TransactionAckExistException) {
                    PacketReference ref = DestinationList.get(null, ids[i]);
                    if (ref != null && (ref.isOverrided() || ref.isOverriding())) {
                        ((BrokerException)ex).overrideStatusCode(410);
                        ((BrokerException)ex).setRemoteConsumerUIDs(String.valueOf(cids[i].longValue()));
                        ((BrokerException)ex).setRemote(true);
                        consumer.recreationRequested();
                    }
                }
                if (ex instanceof BrokerException) {
                    throw (BrokerException)ex;
                }
                throw new BrokerException("Internal Error: Unable to  complete processing acknowledgements in a tranaction: " + ex, ex);
            }
        }
    }

    public boolean validateMessages(TransactionList translist, TransactionUID tid, SysMessageID[] ids, ConsumerUID[] cids) throws BrokerException {
        boolean openTransaction = false;
        try {
            translist.getTransactionMap(tid, false);
            openTransaction = true;
        }
        catch (BrokerException brokerException) {
            // empty catch block
        }
        if (openTransaction) {
            for (int i = 0; i < ids.length; ++i) {
                Consumer c = Consumer.getConsumer(cids[i]);
                if (c == null) {
                    throw new BrokerException("Internal Error, unknown consumer " + cids[i], 400);
                }
                if (translist.checkAcknowledgement(tid, ids[i], c.getConsumerUID())) continue;
                return false;
            }
        } else {
            for (int i = 0; i < ids.length; ++i) {
                Consumer c = Consumer.getConsumer(cids[i]);
                if (c == null) {
                    throw new BrokerException("Internal Error, unknown consumer " + cids[i], 400);
                }
                PacketReference ref = DestinationList.get(null, ids[i]);
                if (ref == null) {
                    if (!DEBUG) continue;
                    this.logger.log(8, "AckHandler.validateMessages(): message reference Could not find " + ids[i] + "[" + cids[i] + "]");
                    continue;
                }
                if (ref.hasConsumerAcked(c.getStoredConsumerUID())) continue;
                return false;
            }
        }
        return true;
    }

    public void handleDeadMsgs(IMQConnection con, SysMessageID[] ids, ConsumerUID[] cids, int deadrs, Throwable thr, String comment, int deliverCnt, List cleanList) throws BrokerException {
        RemoveReason deadReason = RemoveReason.UNDELIVERABLE;
        if (deadrs == 1) {
            deadReason = RemoveReason.EXPIRED_BY_CLIENT;
        }
        for (int i = 0; i < ids.length; ++i) {
            PacketReference ref;
            Session s = Session.getSession(cids[i]);
            if (s == null) {
                this.logger.log(4, "Dead message for Unknown Consumer/Session" + cids[i]);
                continue;
            }
            if (DEBUG) {
                this.logger.log(8, "handleDead[" + i + ", " + ids.length + "]:sysid=" + ids[i] + ", cid=" + cids[i] + ", on connection " + con);
            }
            if ((ref = (PacketReference)s.handleDead(cids[i], ids[i], deadReason, thr, comment, deliverCnt)) == null) continue;
            cleanList.add(ref);
        }
    }

    public void handleUndeliverableMsgs(IMQConnection con, SysMessageID[] ids, ConsumerUID[] cids, List cleanList, int deliverCnt, boolean deliverCntUpdateOnly) throws BrokerException {
        for (int i = 0; i < ids.length; ++i) {
            PacketReference ref;
            Session s = Session.getSession(cids[i]);
            if (s == null && DEBUG) {
                this.logger.log(8, "Undeliverable message for Unknown Consumer/Session" + cids[i]);
            }
            if (DEBUG) {
                this.logger.log(8, "handleUndeliverable[" + i + ", " + ids.length + "]:sysid=" + ids[i] + ", cid=" + cids[i] + ", on connection " + con);
            }
            PacketReference packetReference = ref = s == null ? null : (PacketReference)s.handleUndeliverable(cids[i], ids[i], deliverCnt, deliverCntUpdateOnly);
            if (ref == null) continue;
            cleanList.add(ref);
        }
    }

    static {
        if (Globals.getLogger().getLevel() <= 4) {
            DEBUG = true;
        }
    }
}

