/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.service.imq.group;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQIPConnection;
import com.sun.messaging.jmq.jmsserver.service.imq.NotificationInfo;
import com.sun.messaging.jmq.jmsserver.service.imq.group.SelectThread;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.EOFException;
import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.util.Hashtable;

public class GroupNotificationInfo
implements NotificationInfo {
    private static int NEXTID = 1;
    Logger logger = Globals.getLogger();
    SelectThread readthr;
    SelectThread writethr;
    SelectThread targetRead;
    SelectThread targetWrite;
    SelectionKey readkey;
    SelectionKey writekey;
    boolean valid = true;
    boolean readyToWrite = false;
    int id = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GroupNotificationInfo() {
        Class<GroupNotificationInfo> clazz = GroupNotificationInfo.class;
        synchronized (GroupNotificationInfo.class) {
            this.id = NEXTID++;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    void targetThreads(SelectThread tr, SelectThread tw) {
        this.targetRead = tr;
        this.targetWrite = tw;
    }

    @Override
    public String getStateInfo() {
        String ret = "[rt,wt]=[" + this.readthr + "," + this.writethr + "]\n\tReadState: " + (this.readthr == null ? null : this.readthr.getStateInfo()) + "\n\tWriteState: " + (this.writethr == null ? null : this.writethr.getStateInfo()) + "\n";
        return ret;
    }

    public String toString() {
        return "GroupNotificationInfo[" + this.id + "]";
    }

    public void setThread(int mask, SelectThread thr, SelectionKey key) {
        if ((mask & 1) != 0) {
            this.setReader(thr, key);
        }
        if ((mask & 4) != 0) {
            this.setWriter(thr, key);
        }
    }

    private synchronized void setReader(SelectThread readthr, SelectionKey readkey) {
        this.readthr = readthr;
        this.targetRead = null;
        this.readkey = readkey;
    }

    private synchronized void setWriter(SelectThread writethr, SelectionKey writekey) {
        this.writethr = writethr;
        this.targetWrite = null;
        this.writekey = writekey;
        this.setReadyToWrite((IMQConnection)writekey.attachment(), this.readyToWrite);
    }

    @Override
    public synchronized void setReadyToWrite(IMQConnection con, boolean ready) {
        try {
            if (this.writethr != null) {
                this.writethr.changeInterest(this.writekey, ready ? 4 : 0, "changeState");
            }
            this.readyToWrite = ready;
        }
        catch (IOException ex) {
            this.logger.log(4, "setReadyToWrite exception", ex);
            if (ex instanceof EOFException) {
                this.destroy(Globals.getBrokerResources().getKString("B0061"));
            } else {
                this.destroy(ex.toString());
            }
            this.readyToWrite = false;
        }
    }

    @Override
    public synchronized void assigned(IMQConnection con, int events) throws IllegalAccessException {
    }

    @Override
    public synchronized void released(IMQConnection con, int events) {
    }

    @Override
    public synchronized void destroy(String reason) {
        this.valid = false;
        if (this.readthr != null && this.readkey != null) {
            try {
                this.readthr.removeConnection((IMQIPConnection)this.readkey.attachment(), reason);
            }
            catch (IOException ex) {
                this.logger.logStack(4, "B3100", "unable to remove WRITE data.", (Throwable)ex);
            }
        }
        this.readthr = null;
        this.readkey = null;
        if (this.writethr != null && this.writekey != null) {
            try {
                this.writethr.removeConnection((IMQIPConnection)this.writekey.attachment(), reason);
            }
            catch (IOException ex) {
                this.logger.logStack(4, "B3100", "unable to remove READ data.", (Throwable)ex);
            }
        }
        this.writethr = null;
        this.writekey = null;
    }

    @Override
    public void dumpState() {
        this.dumpState("");
    }

    public void dumpState(String prefix) {
        this.logger.log(8, prefix + "writethr: " + this.writethr);
        this.logger.log(8, prefix + "writekey: " + this.writekey);
        this.logger.log(8, prefix + "readthr:  " + this.readthr);
        this.logger.log(8, prefix + "readkey:  " + this.readkey);
        this.logger.log(8, prefix + "valid:    " + this.valid);
    }

    public Hashtable getDebugState() {
        Hashtable<String, Object> ht = new Hashtable<String, Object>();
        try {
            ht.put("valid:    ", String.valueOf(this.valid));
            ht.put("groupInfo:    ", this.toString());
            ht.put("targetRead: ", String.valueOf(this.targetRead));
            ht.put("targetWrite: ", String.valueOf(this.targetWrite));
            ht.put("writethr: ", String.valueOf(this.writethr));
            ht.put("readthr:  ", String.valueOf(this.readthr));
            if (this.targetRead != null) {
                ht.put("targetRead_state:  ", this.targetRead.getDebugState());
            }
            if (this.targetWrite != null) {
                ht.put("targetWrite_state:  ", this.targetWrite.getDebugState());
            }
            if (this.readthr != null) {
                ht.put("readthr_state:  ", this.readthr.getDebugState());
            }
            if (this.writethr != null) {
                ht.put("writethr_state:  ", this.writethr.getDebugState());
            }
            ht.put("readkey:  ", String.valueOf(this.readkey));
            ht.put("writekey: ", String.valueOf(this.writekey));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ht.put("EXCEPTION", ex.toString());
        }
        return ht;
    }

    String getOps(SelectionKey key) {
        if (key == null) {
            return "iOps[key is null]";
        }
        return "iOps[" + this.getKeyString(key.interestOps()) + "], rOps[" + this.getKeyString(key.readyOps()) + "]";
    }

    private String getKeyString(int events) {
        String str = "";
        if ((events & 4) != 0) {
            str = str + " WRITE ";
        }
        if ((events & 1) != 0) {
            str = str + " READ ";
        }
        return str;
    }
}

