/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.core;

import com.sun.messaging.jmq.io.InvalidPacketException;
import com.sun.messaging.jmq.io.InvalidSysMessageIDException;
import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.PacketType;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.api.BrokerStatus;
import com.sun.messaging.jmq.jmsserver.cluster.api.ClusterBroadcast;
import com.sun.messaging.jmq.jmsserver.cluster.api.ClusteredBroker;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.config.ConfigListener;
import com.sun.messaging.jmq.jmsserver.config.PropertyUpdateException;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.ConnToPartitionStrategy;
import com.sun.messaging.jmq.jmsserver.core.ConnToPartitionStrategyContext;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.ExpirationInfo;
import com.sun.messaging.jmq.jmsserver.core.MessageDeliveryTimeInfo;
import com.sun.messaging.jmq.jmsserver.core.MessageDeliveryTimeTimer;
import com.sun.messaging.jmq.jmsserver.core.PacketListDMPair;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.core.Producer;
import com.sun.messaging.jmq.jmsserver.core.ProducerUID;
import com.sun.messaging.jmq.jmsserver.core.Queue;
import com.sun.messaging.jmq.jmsserver.core.Subscription;
import com.sun.messaging.jmq.jmsserver.core.Topic;
import com.sun.messaging.jmq.jmsserver.data.TransactionAcknowledgement;
import com.sun.messaging.jmq.jmsserver.data.TransactionList;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.data.handlers.RefCompare;
import com.sun.messaging.jmq.jmsserver.management.agent.Agent;
import com.sun.messaging.jmq.jmsserver.persist.api.LoadException;
import com.sun.messaging.jmq.jmsserver.persist.api.NoPersistPartitionedStoreImpl;
import com.sun.messaging.jmq.jmsserver.persist.api.PartitionListener;
import com.sun.messaging.jmq.jmsserver.persist.api.PartitionedStore;
import com.sun.messaging.jmq.jmsserver.persist.api.TxnLoggingStore;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.service.Connection;
import com.sun.messaging.jmq.jmsserver.service.ConnectionManager;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQBasicConnection;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.ConflictException;
import com.sun.messaging.jmq.jmsserver.util.PartitionNotFoundException;
import com.sun.messaging.jmq.jmsserver.util.TransactionAckExistException;
import com.sun.messaging.jmq.jmsserver.util.lists.AddReason;
import com.sun.messaging.jmq.jmsserver.util.lists.RemoveReason;
import com.sun.messaging.jmq.util.DestLimitBehavior;
import com.sun.messaging.jmq.util.DestType;
import com.sun.messaging.jmq.util.GoodbyeReason;
import com.sun.messaging.jmq.util.SizeString;
import com.sun.messaging.jmq.util.SupportUtil;
import com.sun.messaging.jmq.util.UID;
import com.sun.messaging.jmq.util.lists.OutOfLimitsException;
import com.sun.messaging.jmq.util.lists.Reason;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.util.selector.SelectorFormatException;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimerTask;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public final class DestinationList
implements ConnToPartitionStrategyContext {
    static boolean DEBUG = false;
    static final boolean DEBUG_CLUSTER = Globals.getConfig().getBooleanProperty("imq.cluster.debug.ha") || Globals.getConfig().getBooleanProperty("imq.cluster.debug.txn") || Globals.getConfig().getBooleanProperty("imq.cluster.debug.msg");
    static final String DEBUG_LISTS_PROP = "imq.lists.debug";
    static boolean DEBUG_LISTS = Globals.getConfig().getBooleanProperty("imq.lists.debug");
    static final boolean NO_PRODUCER_FLOW = Globals.getConfig().getBooleanProperty("imq.noProducerFlow", false);
    static final int DEFAULT_PREFETCH = 1000;
    static final boolean PERSIST_SYNC = Globals.getConfig().getBooleanProperty("imq.persist.file.sync.enabled", false);
    public static final int DEFAULT_MAX_PRODUCERS = 100;
    public static final int UNLIMITED = -1;
    private static final int DEFAULT_DESTINATION_SIZE = 100000;
    private static final int ALL_DESTINATIONS_MASK = 0;
    private static final int TEMP_DESTINATIONS_MASK = 16;
    private static final String AUTO_QUEUE_STR = "imq.autocreate.queue";
    private static final String AUTO_TOPIC_STR = "imq.autocreate.topic";
    private static final String DST_REAP_STR = "imq.autocreate.reaptime";
    private static final String MSG_REAP_STR = "imq.message.expiration.interval";
    private static final String CHECK_MSGS_RATE_AT_DEST_CAPACITY_RATIO_PROP = "imq.cluster.prefetch.checkMsgRateAtCapacityRatio";
    static int CHECK_MSGS_RATE_AT_DEST_CAPACITY_RATIO = Globals.getConfig().getIntProperty("imq.cluster.prefetch.checkMsgRateAtCapacityRatio", 50);
    private static final String CHECK_MSGS_RATE_FOR_ALL_PROP = "imq.cluster.prefetch.checkMsgRateAll";
    static boolean CHECK_MSGS_RATE_FOR_ALL = Globals.getConfig().getBooleanProperty("imq.cluster.prefetch.checkMsgRateAll", false);
    private static final long DEFAULT_TIME = 120L;
    private static boolean ALLOW_QUEUE_AUTOCREATE = Globals.getConfig().getBooleanProperty("imq.autocreate.queue", true);
    private static boolean ALLOW_TOPIC_AUTOCREATE = Globals.getConfig().getBooleanProperty("imq.autocreate.topic", true);
    static long AUTOCREATE_EXPIRE = Globals.getConfig().getLongProperty("imq.autocreate.reaptime", 120L) * 1000L;
    static long MESSAGE_EXPIRE = Globals.getConfig().getLongProperty("imq.message.expiration.interval", 120L) * 1000L;
    private static List<PartitionListener> partitionListeners = new ArrayList<PartitionListener>();
    public static final int DEFAULT_MAX_PRODUCER_BATCH = 1000;
    public static final int MAX_PRODUCER_BATCH;
    private static final String AUTO_MAX_NUM_MSGS = "imq.autocreate.destination.maxNumMsgs";
    private static final String AUTO_MAX_TOTAL_BYTES = "imq.autocreate.destination.maxTotalMsgBytes";
    private static final String AUTO_MAX_BYTES_MSG = "imq.autocreate.destination.maxBytesPerMsg";
    public static final String AUTO_MAX_NUM_PRODUCERS = "imq.autocreate.destination.maxNumProducers";
    private static final String AUTO_LOCAL_ONLY = "imq.autocreate.destination.isLocalOnly";
    private static final String AUTO_LIMIT_BEHAVIOR = "imq.autocreate.destination.limitBehavior";
    static int defaultMaxMsgCnt;
    static int defaultProducerCnt;
    private static final long _defKByteDMQCapacity = 10240L;
    private static final long _defKByteCapacity = 0xA00000L;
    static SizeString defaultMaxMsgBytes;
    private static final long _defKBytePerMsg = 10240L;
    static SizeString defaultMaxBytesPerMsg;
    static boolean defaultIsLocal;
    static int defaultLimitBehavior;
    public static final String USE_DMQ_STR = "imq.autocreate.destination.useDMQ";
    private static final String TRUNCATE_BODY_STR = "imq.destination.DMQ.truncateBody";
    private static final String LOG_MSGS_STR = "imq.destination.logDeadMsgs";
    public static final boolean defaultUseDMQ;
    private static final boolean defaultTruncateBody;
    private static final boolean defaultVerbose;
    private static final String DMQ_NAME = "mq.sys.dmq";
    static boolean autocreateUseDMQ;
    private static boolean storeBodyWithDMQ;
    private static boolean verbose;
    private static final String SYSTEM_MAX_SIZE = "imq.system.max_size";
    private static final String SYSTEM_MAX_COUNT = "imq.system.max_count";
    public static final String MAX_MESSAGE_SIZE = "imq.message.max_size";
    public static final String MIN_CONN_STRATEGY = "MIN_CONN";
    public static final String RR_CONN_STRATEGY = "ROUND_ROBIN";
    public static final String CONN_STRATEGY_PROP = "imq.connection.loadBalanceToPartitionStrategy";
    public static final String CONN_STRATEGY_DEFAULT = "MIN_CONN";
    public static final String MIN_CONN_STRATEGY_CLASS = "com.sun.messaging.jmq.jmsserver.core.MinConnToPartitionStrategy";
    public static final String RR_CONN_STRATEGY_CLASS = "com.sun.messaging.jmq.jmsserver.core.RRConnToPartitionStrategy";
    private static ConnToPartitionStrategy partitionStrategy;
    private static SizeString individual_max_size;
    private static SizeString max_size;
    private static long message_max_count;
    private static Object totalcntLock;
    private static long totalbytes;
    private static int totalcnt;
    private static int totalcntNonPersist;
    private static boolean inited;
    private static boolean shutdown;
    static final Map<PartitionedStore, DestinationList> destinationListList;
    private static DestinationList DL;
    private static PartitionedStore ADMINP;
    private static PartitionedStore REMOTEP;
    private ArrayList<ConnectionUID> connections = new ArrayList();
    private Object destinationListLock = new Object();
    private boolean valid = true;
    private boolean destsLoaded = false;
    Queue deadMessageQueue = null;
    private final Map<SysMessageID, Set<PacketListDMPair>> packetlist = Collections.synchronizedMap(new HashMap());
    final Map destinationList = Collections.synchronizedMap(new HashMap());
    private Logger logger = Globals.getLogger();
    private BrokerResources br = Globals.getBrokerResources();
    private PartitionedStore pstore = null;
    private TransactionList translist = null;
    private static boolean partitionModeInited;
    private static boolean partitionMode;
    private static boolean partitionMigratable;
    private String logsuffix = "";
    private static final String PARTITION_LOCK_TIMEOUT_PROP = "imq.partition.lockTimeout";
    private static final long PARTITION_LOCK_TIMEOUT_DEFAULT = 300L;
    private static long partitionLockTimeout;
    private static ReentrantReadWriteLock partitionLock;
    private static Lock partitionShareLock;
    private static Lock partitionExclusiveLock;
    private static ExecutorService partitionMonitor;
    private Object subscriptionLock = new Object();
    private boolean duraSubscriptionInited = false;
    private boolean nonDuraSharedSubscriptionInited = false;
    private static ConfigListener cl;

    public DestinationList() {
    }

    DestinationList(PartitionedStore partition) {
        this.pstore = partition;
        if (partitionMode) {
            this.logsuffix = " [" + this.pstore + "]";
        }
    }

    public static PartitionedStore getAdminPartition() {
        return ADMINP;
    }

    public static PartitionedStore getRemotePartition() {
        return REMOTEP;
    }

    @Override
    public PartitionedStore getPartitionedStore() {
        return this.pstore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void translistPostProcess(PartitionedStore ps) {
        DestinationList dl = null;
        if (ps != null) {
            dl = destinationListList.get(ps);
            dl.getTransactionList().postProcess();
            return;
        }
        ArrayList<DestinationList> list = null;
        Map<PartitionedStore, DestinationList> map = destinationListList;
        synchronized (map) {
            list = new ArrayList<DestinationList>(destinationListList.values());
        }
        Iterator<DestinationList> itr = list.iterator();
        while (itr.hasNext()) {
            itr.next().getTransactionList().postProcess();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TransactionList[] getTransactionList(PartitionedStore ps) {
        DestinationList dl = null;
        if (ps != null) {
            dl = destinationListList.get(ps);
            if (dl == null) {
                return new TransactionList[]{null};
            }
            return new TransactionList[]{dl.getTransactionList()};
        }
        int i = 0;
        Map<PartitionedStore, DestinationList> map = destinationListList;
        synchronized (map) {
            int sz = destinationListList.size();
            TransactionList[] tls = new TransactionList[sz == 0 ? 1 : sz];
            tls[0] = null;
            Iterator<DestinationList> itr = destinationListList.values().iterator();
            while (itr.hasNext()) {
                tls[i++] = itr.next().getTransactionList();
            }
            return tls;
        }
    }

    TransactionList getTransactionList() {
        return this.translist;
    }

    public void setTransactionList(TransactionList tlist) {
        this.translist = tlist;
    }

    public static void storeBodyInDMQ(boolean store) {
        storeBodyWithDMQ = store;
    }

    public static boolean getStoreBodyInDMQ() {
        return storeBodyWithDMQ;
    }

    public static void setVerbose(boolean v) {
        verbose = v;
    }

    public static boolean getVerbose() {
        return verbose;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Queue[] getDMQ(PartitionedStore ps) {
        DestinationList dl = null;
        if (ps != null) {
            dl = destinationListList.get(ps);
            return new Queue[]{dl.getDMQ()};
        }
        int i = 0;
        Map<PartitionedStore, DestinationList> map = destinationListList;
        synchronized (map) {
            int sz = destinationListList.size();
            Queue[] qs = new Queue[sz == 0 ? 1 : sz];
            qs[0] = null;
            Iterator<DestinationList> itr = destinationListList.values().iterator();
            while (itr.hasNext()) {
                qs[i] = itr.next().getDMQ();
            }
            return qs;
        }
    }

    Queue getDMQ() {
        if (this.pstore == null) {
            throw new RuntimeException("IllegalStateException: DestinationList.getDMQ: no store partition set");
        }
        return this.deadMessageQueue;
    }

    private synchronized Queue createDMQ() throws BrokerException, IOException {
        if (this.pstore == null) {
            throw new RuntimeException("IllegalStateException: DestinaionList.createDMQ: no store partition set");
        }
        DestinationUID uid = DestinationUID.getUID(DMQ_NAME, true);
        Queue dmq = null;
        dmq = (Queue)this.destinationList.get(uid);
        try {
            if (dmq == null) {
                Globals.getLogger().log(8, "B1144");
                dmq = (Queue)this.createDestination(DMQ_NAME, 4097, true, false, null, false, false);
                dmq.maxProducerLimit = 0;
                dmq.scope = Globals.getHAEnabled() ? 1 : 0;
                dmq.msgSizeLimit = null;
                dmq.setLimitBehavior(1);
                dmq.setByteCapacity(new SizeString(10240L));
                dmq.setCapacity(1000);
                dmq.maxPrefetch = 1000;
                dmq.isDMQ = true;
                dmq.useDMQ = false;
                dmq.update();
            }
        }
        catch (BrokerException ex) {
            if (ex.getStatusCode() == 409) {
                Globals.getLogger().logStack(4, "Another broker may have created the DMQ, reloading", ex);
                dmq = (Queue)this.pstore.getDestination(uid);
                if (dmq == null) {
                    ex.overrideStatusCode(500);
                    throw ex;
                }
                dmq.setDestinationList(this);
            }
            throw ex;
        }
        dmq.load(true, null, null);
        return dmq;
    }

    public static boolean removeDeadMessage(PartitionedStore ps, SysMessageID sysid, String comment, Throwable exception, int deliverCnt, Reason r, String broker) throws IOException, BrokerException {
        PacketReference ref = DestinationList.get(ps, sysid);
        Destination d = ref.getDestination();
        return d.removeDeadMessage(ref, comment, exception, deliverCnt, r, broker);
    }

    public static void routeMoveAndForwardMessage(PacketReference oldRef, PacketReference newRef, Destination target) throws IOException, BrokerException {
        Set s;
        boolean route = target.queueMessage(newRef, false);
        if (route && (s = target.routeAndMoveMessage(oldRef, newRef)) != null) {
            target.forwardMessage(s, newRef);
        }
    }

    static int calcProducerBatchCnt(int destSize, int producers) {
        int val;
        if (destSize == -1) {
            return MAX_PRODUCER_BATCH;
        }
        int p = producers;
        if (p <= 0) {
            p = 100;
        }
        if ((val = destSize / p) <= 0) {
            val = 1;
        }
        if (val > MAX_PRODUCER_BATCH) {
            return MAX_PRODUCER_BATCH;
        }
        return val;
    }

    static long calcProducerBatchBytes(long destSize, int producers) {
        long val;
        if (destSize == -1L) {
            return -1L;
        }
        int p = producers;
        if (p <= 0) {
            p = 100;
        }
        if ((val = destSize / (long)p) <= 0L) {
            val = 1L;
        }
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetAllMetrics(PartitionedStore ps) {
        DestinationList dl2 = null;
        if (ps != null) {
            dl2 = destinationListList.get(ps);
            dl2.resetAllMetrics();
            return;
        }
        Map<PartitionedStore, DestinationList> map = destinationListList;
        synchronized (map) {
            for (DestinationList dl2 : destinationListList.values()) {
                dl2.resetAllMetrics();
            }
        }
    }

    private void resetAllMetrics() {
        Iterator itr = this.getAllDestinations(0);
        while (itr.hasNext()) {
            Destination d = (Destination)itr.next();
            d.resetMetrics();
        }
    }

    public String toString() {
        return partitionMode ? "[" + this.pstore + "]" : super.toString();
    }

    public String toLongString() {
        return "DestinationList[" + this.pstore + "]valid=" + this.valid + ",loaded=" + this.destsLoaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Hashtable getAllDebugState() {
        Hashtable<String, Object> ht = new Hashtable<String, Object>();
        ht.put("TABLE", "All Destinations");
        ht.put("maxMsgSize", individual_max_size == null ? "null" : individual_max_size.toString());
        ht.put("maxTotalSize", max_size == null ? "null" : max_size.toString());
        ht.put("maxCount", String.valueOf(message_max_count));
        ht.put("totalBytes", String.valueOf(totalbytes));
        ht.put("totalCnt", String.valueOf(totalcnt));
        ht.put("totalCntNonPersist", String.valueOf(totalcntNonPersist));
        ht.put("sync", String.valueOf(PERSIST_SYNC));
        ht.put("noProducerFlow", String.valueOf(NO_PRODUCER_FLOW));
        ht.put("autoCreateTopics", String.valueOf(ALLOW_TOPIC_AUTOCREATE));
        ht.put("autoCreateQueue", String.valueOf(ALLOW_QUEUE_AUTOCREATE));
        ht.put("messageExpiration", String.valueOf(MESSAGE_EXPIRE));
        ht.put("producerBatch", String.valueOf(MAX_PRODUCER_BATCH));
        ht.put("QueueSpecific", Queue.getAllDebugState());
        ArrayList<PartitionedStore> dls = null;
        Map<PartitionedStore, DestinationList> map = destinationListList;
        synchronized (map) {
            dls = new ArrayList<PartitionedStore>(destinationListList.keySet());
        }
        ht.put("partitionedStoreCnt", String.valueOf(dls.size()));
        Iterator<PartitionedStore> itr = dls.iterator();
        PartitionedStore ps = null;
        DestinationList dl = null;
        while (itr.hasNext()) {
            ps = itr.next();
            dl = destinationListList.get(ps);
            ht.put(ps.toString(), dl.getDebugState());
        }
        return ht;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getDebugState() {
        Hashtable<String, Object> ht = new Hashtable<String, Object>();
        ht.put("partitionedStore", this.pstore == null ? "null" : this.pstore.toString());
        ht.put("msgCnt", this.packetlist == null ? "null" : String.valueOf(this.packetlist.size()));
        Hashtable<String, Object> destInfo = new Hashtable<String, Object>();
        if (this.destinationList != null) {
            ArrayList dlist = null;
            Map map = this.destinationList;
            synchronized (map) {
                dlist = new ArrayList(this.destinationList.keySet());
            }
            ht.put("destinationCnt", String.valueOf(dlist.size()));
            for (DestinationUID duid : dlist) {
                Destination d = this.getDestination(duid);
                if (d == null) {
                    destInfo.put(duid.getLocalizedName(), "Unknown");
                    continue;
                }
                destInfo.put(duid.getLocalizedName(), d.getDebugState());
            }
        } else {
            ht.put("destinationCnt", "null");
        }
        ht.put("destinations", destInfo);
        return ht;
    }

    public static void remoteCheckMessageHomeChange(PacketReference ref, BrokerAddress broker) {
        BrokerAddress addr = ref.getBrokerAddress();
        if (addr != null && addr.equals(broker)) {
            return;
        }
        HashSet<ConnectionUID> destroyConns = new HashSet<ConnectionUID>();
        Map<ConsumerUID, ConnectionUID> cc = ref.getRemoteConsumerUIDs();
        Consumer consumer = null;
        ConsumerUID cuid = null;
        Iterator<Map.Entry<ConsumerUID, ConnectionUID>> citr = cc.entrySet().iterator();
        Map.Entry<ConsumerUID, ConnectionUID> me = null;
        while (citr.hasNext()) {
            me = citr.next();
            cuid = me.getKey();
            consumer = Consumer.getConsumer(cuid);
            if (consumer == null || !consumer.tobeRecreated()) continue;
            destroyConns.add(me.getValue());
        }
        DestinationList.destroyConnections(destroyConns, 9, GoodbyeReason.toString(9) + "[" + addr + ":" + broker + "]");
    }

    public static void remoteCheckTakeoverMsgs(Map<String, String> msgs, String brokerid, PartitionedStore ps) throws BrokerException {
        HashSet<ConnectionUID> destroyConns = new HashSet<ConnectionUID>();
        HashMap<String, String> badsysids = null;
        Iterator<Map.Entry<String, String>> itr = msgs.entrySet().iterator();
        Map.Entry<String, String> me = null;
        String sysidstr = null;
        String duidstr = null;
        SysMessageID sysid = null;
        DestinationUID duid = null;
        while (itr.hasNext()) {
            me = itr.next();
            sysidstr = me.getKey();
            duidstr = me.getValue();
            try {
                sysid = SysMessageID.get(sysidstr);
            }
            catch (InvalidSysMessageIDException e) {
                Globals.getLogger().logStack(32, e.getMessage(), e);
                if (!Globals.getStore().getStoreType().equals("jdbc")) {
                    throw e;
                }
                duid = new DestinationUID(duidstr);
                Globals.getLogger().log(16, Globals.getBrokerResources().getKString("B4458", sysidstr, duidstr));
                try {
                    Packet p = null;
                    try {
                        p = ps.getMessage(duid, sysidstr);
                    }
                    catch (BrokerException ee) {
                        Throwable cause = ee.getCause();
                        Object[] args = new String[]{sysidstr, "[?]", duidstr, cause.toString()};
                        String emsg = Globals.getBrokerResources().getKString("B4460", args);
                        Globals.getLogger().logStack(32, emsg, ee);
                        if (cause instanceof InvalidPacketException) {
                            DestinationList.handleInvalidPacket(sysidstr, duidstr, emsg, (InvalidPacketException)cause, ps);
                            itr.remove();
                            continue;
                        }
                        throw ee;
                    }
                    sysid = p.getSysMessageID();
                    String realsysidstr = sysid.getUniqueName();
                    Object[] args3 = new String[]{sysidstr, realsysidstr, duidstr};
                    Globals.getLogger().log(8, Globals.getBrokerResources().getKString("B4459", args3));
                    ps.repairCorruptedSysMessageID(sysid, sysidstr, duidstr, true);
                    if (badsysids == null) {
                        badsysids = new HashMap<String, String>();
                    }
                    badsysids.put(sysidstr, realsysidstr);
                }
                catch (BrokerException ee) {
                    Globals.getLogger().logStack(32, e.getMessage(), ee);
                    throw e;
                }
            }
            PacketReference ref = DestinationList.get(null, sysid);
            if (ref == null) continue;
            Iterator<ConnectionUID> cnitr = ref.getRemoteConsumerUIDs().values().iterator();
            while (cnitr.hasNext()) {
                destroyConns.add(cnitr.next());
            }
        }
        if (badsysids != null) {
            itr = badsysids.entrySet().iterator();
            String v = null;
            while (itr.hasNext()) {
                me = itr.next();
                v = msgs.remove(me.getKey());
                msgs.put(me.getValue(), v);
            }
        }
        DestinationList.destroyConnections(destroyConns, 7, GoodbyeReason.toString(7) + ":" + brokerid);
    }

    private static void handleInvalidPacket(String sysidstr, String duidstr, String comment, InvalidPacketException ipex, PartitionedStore ps) throws BrokerException {
        Properties props = new Properties();
        props.put("JMS_SUN_DMQ_UNDELIVERED_REASON", RemoveReason.ERROR.toString());
        props.put("JMS_SUN_DMQ_UNDELIVERED_TIMESTAMP", (Object)System.currentTimeMillis());
        props.put("JMS_SUN_DMQ_UNDELIVERED_COMMENT", comment);
        String cstr = SupportUtil.getStackTraceString(ipex);
        props.put("JMS_SUN_DMQ_UNDELIVERED_EXCEPTION", cstr);
        props.put("JMS_SUN_DMQ_PRODUCING_BROKER", Globals.getMyAddress().toString());
        props.put("JMS_SUN_DMQ_DEAD_BROKER", Globals.getMyAddress().toString());
        byte[] data = ipex.getBytes();
        Queue[] dmqs = DestinationList.getDMQ(ps);
        Queue dmq = dmqs[0];
        Packet pkt = new Packet();
        pkt.setPacketType(2);
        pkt.setProperties(props);
        pkt.setDestination(dmq.getDestinationName());
        pkt.setIsQueue(true);
        pkt.setPersistent(true);
        pkt.setIP(Globals.getBrokerInetAddress().getAddress());
        pkt.setPort(Globals.getPortMapper().getPort());
        pkt.updateSequenceNumber();
        pkt.updateTimestamp();
        pkt.generateSequenceNumber(false);
        pkt.generateTimestamp(false);
        pkt.setSendAcknowledge(false);
        pkt.setMessageBody(data);
        PacketReference ref = PacketReference.createReference(dmq.getPartitionedStore(), pkt, null);
        Object[] args1 = new String[]{sysidstr, duidstr, ref.getSysMessageID().toString() + "[" + PacketType.getString(2) + "]"};
        Globals.getLogger().log(8, Globals.getBrokerResources().getKString("B1506", args1));
        dmq.queueMessage(ref, false);
        Set s = dmq.routeNewMessage(ref);
        Object[] args2 = new String[]{sysidstr, duidstr, ref.getSysMessageID().toString() + "[" + PacketType.getString(2) + "]"};
        Globals.getLogger().log(8, Globals.getBrokerResources().getKString("B1507", args2));
        dmq.forwardMessage(s, ref);
        Globals.getLogger().log(8, Globals.getBrokerResources().getKString("B1508", sysidstr, duidstr));
        try {
            ps.removeMessage(new DestinationUID(duidstr), sysidstr, true);
        }
        catch (Exception e) {
            String emsg = Globals.getBrokerResources().getKString("B4016", sysidstr);
            Globals.getLogger().logStack(32, emsg, e);
            if (e instanceof BrokerException) {
                throw (BrokerException)e;
            }
            throw new BrokerException(emsg, e);
        }
    }

    private static void destroyConnections(Set destroyConns, int reason, String reasonstr) {
        ConnectionManager cm = Globals.getConnectionManager();
        Iterator cnitr = destroyConns.iterator();
        while (cnitr.hasNext()) {
            IMQBasicConnection conn = (IMQBasicConnection)cm.getConnection((ConnectionUID)cnitr.next());
            if (conn == null) continue;
            Globals.getLogger().log(8, "Destroying connection " + conn + " because " + reasonstr);
            if (DEBUG) {
                conn.dump();
            }
            conn.destroyConnection(true, reason, reasonstr);
            conn.waitForRelease(Globals.getConfig().getLongProperty("imq." + conn.getService().getName() + ".destroy_timeout", 30L) * 1000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void loadTakeoverMsgs(PartitionedStore storep, Map<String, String> msgs, List txns, Map txacks) throws BrokerException {
        Set l;
        DestinationUID dst;
        String emsg;
        DestinationList dl = destinationListList.get(storep);
        HashMap<DestinationUID, TreeSet<PacketReference>> m = new HashMap<DestinationUID, TreeSet<PacketReference>>();
        Logger logger = Globals.getLogger();
        HashMap<CallSite, TransactionUID> ackLookup = new HashMap<CallSite, TransactionUID>();
        if (txacks != null) {
            for (Map.Entry entry : txacks.entrySet()) {
                TransactionUID tuid = (TransactionUID)entry.getKey();
                List l2 = (List)entry.getValue();
                for (TransactionAcknowledgement ta : l2) {
                    String key = ta.getSysMessageID() + ":" + ta.getStoredConsumerUID();
                    ackLookup.put((CallSite)((Object)key), tuid);
                }
            }
        }
        HashMap<SysMessageID, TransactionUID> openMessages = new HashMap<SysMessageID, TransactionUID>();
        Iterator<Map.Entry<String, String>> itr = msgs.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry<String, String> me = itr.next();
            String msgID = me.getKey();
            String dst2 = me.getValue();
            DestinationUID dUID = new DestinationUID(dst2);
            Packet p = null;
            try {
                p = storep.getMessage(dUID, msgID);
            }
            catch (BrokerException ex) {
                Destination[] ds;
                Destination d;
                Throwable cause = ex.getCause();
                if (cause instanceof InvalidPacketException) {
                    Object[] args = new String[]{msgID, dst2, cause.toString()};
                    emsg = Globals.getBrokerResources().getKString("B4483", args);
                    logger.logStack(32, emsg, ex);
                    DestinationList.handleInvalidPacket(msgID, dst2, emsg, (InvalidPacketException)cause, storep);
                    itr.remove();
                    continue;
                }
                if (ex.getStatusCode() == 404 && (d = (ds = DestinationList.getDestination(storep, dUID))[0]) == null) {
                    Object[] args = new String[]{msgID, dst2, Globals.getBrokerResources().getString("B3013", dst2)};
                    logger.log(32, "B2089", args, (Throwable)ex);
                }
                throw ex;
            }
            dUID = DestinationUID.getUID(p.getDestination(), p.getIsQueue());
            PacketReference pr = PacketReference.createReference(storep, p, dUID, null);
            pr.setLoaded();
            logger.log(4, "Loading message " + pr.getSysMessageID() + " on " + pr.getDestinationUID());
            TransactionUID tid = pr.getTransactionID();
            if (tid != null && txns.contains(tid)) {
                TransactionState ts = dl.getTransactionList().retrieveState(pr.getTransactionID());
                if (ts != null && ts.getState() != 7 && ts.getState() != 6) {
                    logger.log(4, "Processing open transacted message " + pr.getSysMessageID() + " on " + tid + "[" + TransactionState.toString(ts.getState()) + "]");
                    openMessages.put(pr.getSysMessageID(), tid);
                } else if (ts != null && ts.getState() == 7) {
                    pr.destroy();
                    continue;
                }
            }
            dl.packetlistAdd(pr.getSysMessageID(), pr.getDestinationUID(), null);
            TreeSet<PacketReference> l3 = null;
            l3 = (TreeSet<PacketReference>)m.get(dUID);
            if (l3 == null) {
                l3 = new TreeSet<PacketReference>(new RefCompare());
                m.put(dUID, l3);
            }
            l3.add(pr);
        }
        HashMap<PacketReference, MessageDeliveryTimeInfo> deliveryDelays = new HashMap<PacketReference, MessageDeliveryTimeInfo>();
        for (Map.Entry entry : m.entrySet()) {
            Object destinationName;
            dst = (DestinationUID)entry.getKey();
            l = (Set)entry.getValue();
            Destination[] ds = DestinationList.getDestination(storep, dst);
            Destination d = ds[0];
            if (d == null) {
                destinationName = dst.getName();
                try {
                    ds = DestinationList.getDestination(storep, (String)destinationName, dst.isQueue() ? 1 : 2, true, true);
                    d = ds[0];
                }
                catch (IOException ex) {
                    throw new BrokerException(Globals.getBrokerResources().getKString("B4251", destinationName));
                }
            }
            destinationName = d;
            synchronized (destinationName) {
                if (d.isLoaded()) {
                    d.initialize();
                }
                d.load(l);
            }
            logger.log(8, "B1196", (Object)d.getName(), String.valueOf(l.size()));
            MessageDeliveryTimeTimer dt = d.deliveryTimeTimer;
            if (dt == null && !d.isDMQ()) {
                if (!d.isValid()) {
                    emsg = Globals.getBrokerResources().getKString("B2268", d.getDestinationUID());
                    logger.log(16, emsg);
                    continue;
                }
                emsg = Globals.getBrokerResources().getKString("B2269", d.getDestinationUID() + "[" + d.isValid() + "]");
                logger.log(16, emsg);
                continue;
            }
            Iterator litr = l.iterator();
            try {
                MessageDeliveryTimeInfo di = null;
                while (litr.hasNext()) {
                    PacketReference pr = (PacketReference)litr.next();
                    di = pr.getDeliveryTimeInfo();
                    if (di != null) {
                        dt.removeMessage(di);
                    }
                    try {
                        boolean el = d.destMessages.getEnforceLimits();
                        d.destMessages.enforceLimits(false);
                        if (DEBUG) {
                            logger.log(8, "Put message " + pr + "[" + di + "] to destination " + d);
                        }
                        pr.lock();
                        d.acquireQueueRemoteLock();
                        try {
                            d.putMessage(pr, AddReason.LOADED, true);
                        }
                        finally {
                            d.clearQueueRemoteLock();
                        }
                        d.destMessages.enforceLimits(el);
                    }
                    catch (OutOfLimitsException | IllegalStateException ex) {
                        Object[] args = new String[]{pr.getSysMessageID().toString(), pr.getDestinationUID().toString(), ex.getMessage()};
                        logger.logStack(16, "B2089", args, (Throwable)ex);
                    }
                    finally {
                        if (di == null || di.isDeliveryDue()) continue;
                        dt.addMessage(di);
                        deliveryDelays.put(pr, di);
                    }
                }
                d.sort(new RefCompare());
            }
            catch (Exception di) {}
        }
        for (Map.Entry entry : m.entrySet()) {
            dst = (DestinationUID)entry.getKey();
            l = (Set)entry.getValue();
            Destination d = dl.getDestination(dst);
            Iterator litr = l.iterator();
            try {
                while (litr.hasNext()) {
                    TransactionUID tuid;
                    PacketReference pr = (PacketReference)litr.next();
                    if (DEBUG) {
                        logger.log(8, "Process takeover message " + pr + "[" + pr.getDeliveryTimeInfo() + "] for destination " + d);
                    }
                    if ((tuid = (TransactionUID)openMessages.get(pr.getSysMessageID())) != null) {
                        dl.getTransactionList().addMessage(tuid, pr.getSysMessageID(), true);
                        pr.unlock();
                        continue;
                    }
                    ConsumerUID[] consumers = storep.getConsumerUIDs(dst, pr.getSysMessageID());
                    if (consumers == null) {
                        consumers = new ConsumerUID[]{};
                    }
                    if (consumers.length == 0 && storep.hasMessageBeenAcked(dst, pr.getSysMessageID())) {
                        logger.log(8, Globals.getBrokerResources().getString("B2196", pr.getSysMessageID()));
                        d.unputMessage(pr, RemoveReason.ACKNOWLEDGED);
                        pr.destroy();
                        pr.unlock();
                        continue;
                    }
                    if (consumers.length > 0) {
                        pr.setStoredWithInterest(true);
                    } else {
                        pr.setStoredWithInterest(false);
                    }
                    int[] states = null;
                    if (consumers.length == 0 && deliveryDelays.get(pr) == null) {
                        try {
                            consumers = d.routeLoadedTransactionMessage(pr);
                        }
                        catch (Exception ex) {
                            logger.logStack(16, Globals.getBrokerResources().getKString("B2281", pr.getSysMessageID(), ex.getMessage()), ex);
                        }
                        states = new int[consumers.length];
                        for (int i = 0; i < states.length; ++i) {
                            states[i] = 0;
                        }
                        try {
                            storep.storeInterestStates(d.getDestinationUID(), pr.getSysMessageID(), consumers, states, true, null);
                            pr.setStoredWithInterest(true);
                        }
                        catch (Exception ex) {
                            StringBuilder debuf = new StringBuilder();
                            for (int i = 0; i < consumers.length; ++i) {
                                if (i > 0) {
                                    debuf.append(", ");
                                }
                                debuf.append(consumers[i]);
                            }
                            logger.log(16, "B2197", pr.getSysMessageID(), debuf.toString(), ex);
                        }
                    } else if (consumers.length > 0) {
                        states = new int[consumers.length];
                        for (int i = 0; i < consumers.length; ++i) {
                            states[i] = storep.getInterestState(dst, pr.getSysMessageID(), consumers[i]);
                        }
                    }
                    pr.update(consumers, states, false);
                    ExpirationInfo ei = pr.getExpireInfo();
                    if (ei != null && d.expireReaper != null) {
                        d.expireReaper.addExpiringMessage(ei);
                    }
                    ArrayList<ConsumerUID> consumerList = new ArrayList<ConsumerUID>(Arrays.asList(consumers));
                    Iterator citr = consumerList.iterator();
                    while (citr.hasNext()) {
                        logger.log(4, " Message " + pr.getSysMessageID() + " has " + consumerList.size() + " consumers ");
                        ConsumerUID cuid = (ConsumerUID)citr.next();
                        String key = pr.getSysMessageID() + ":" + cuid;
                        TransactionList tl = dl.getTransactionList();
                        TransactionUID tid = (TransactionUID)ackLookup.get(key);
                        if (DEBUG) {
                            logger.log(8, "loadTakeoverMsgs: lookup " + key + " found tid=" + tid);
                        }
                        if (tid == null) continue;
                        boolean remote = false;
                        TransactionState ts = tl.retrieveState(tid);
                        if (ts == null) {
                            ts = tl.getRemoteTransactionState(tid);
                            remote = true;
                        }
                        if (DEBUG) {
                            logger.log(8, "tid=" + tid + " has state=" + TransactionState.toString(ts.getState()));
                        }
                        if (ts != null && ts.getState() != 7 && ts.getState() != 6) {
                            if (DEBUG) {
                                logger.log(8, "loadTakeoverMsgs: Open transaction ack [" + key + "]" + (remote ? "remote" : "") + ", TUID=" + tid);
                            }
                            if (!remote) {
                                try {
                                    tl.addAcknowledgement(tid, pr.getSysMessageID(), cuid, cuid, true, false);
                                }
                                catch (TransactionAckExistException e) {
                                    logger.log(8, Globals.getBrokerResources().getKString("B1330", "[" + pr.getSysMessageID() + "]" + cuid + ":" + cuid, tid + "[" + TransactionState.toString(ts.getState()) + "]"));
                                }
                                tl.addOrphanAck(tid, pr.getSysMessageID(), cuid);
                            }
                            citr.remove();
                            logger.log(8, "Processing open ack " + pr.getSysMessageID() + ":" + cuid + " on " + tid);
                            continue;
                        }
                        if (ts == null || ts.getState() != 6) continue;
                        logger.log(8, "Processing committed ack " + pr.getSysMessageID() + ":" + cuid + " on " + tid);
                        if (pr.acknowledged(cuid, cuid, false, true)) {
                            d.unputMessage(pr, RemoveReason.ACKNOWLEDGED);
                            pr.destroy();
                            continue;
                        }
                        citr.remove();
                    }
                    if (DEBUG) {
                        StringBuilder buf = new StringBuilder();
                        ConsumerUID cid = null;
                        for (int j = 0; j < consumerList.size(); ++j) {
                            cid = (ConsumerUID)consumerList.get(j);
                            buf.append(cid);
                            buf.append(' ');
                        }
                        if (deliveryDelays.get(pr) == null) {
                            logger.log(8, "non-transacted: Routing Message " + pr.getSysMessageID() + " to " + consumerList.size() + " consumers:" + buf.toString());
                        } else {
                            logger.log(8, "non-transacted: deliver time not arrived for message " + pr.getSysMessageID());
                        }
                    }
                    pr.unlock();
                    if (deliveryDelays.get(pr) == null) {
                        if (DEBUG) {
                            logger.log(8, "Route takeover message " + pr + "[" + pr.getDeliveryTimeInfo() + "] for destination " + d + " to consumers " + consumerList);
                        }
                        if (pr.getDeliveryTimeInfo() != null) {
                            d.forwardDeliveryDelayedMessage(new HashSet<ConsumerUID>(consumerList), pr);
                        } else {
                            d.routeLoadedMessage(pr, consumerList);
                        }
                    } else {
                        MessageDeliveryTimeInfo di = pr.getDeliveryTimeInfo();
                        di.setDeliveryReady();
                    }
                    if (d.destReaper == null) continue;
                    d.destReaper.cancel();
                    d.destReaper = null;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PacketListDMPair packetlistAdd(SysMessageID sysid, DestinationUID duid, PacketReference ref) {
        PacketListDMPair dmp = new PacketListDMPair(duid, ref);
        Map<SysMessageID, Set<PacketListDMPair>> map = this.packetlist;
        synchronized (map) {
            Set<PacketListDMPair> s = this.packetlist.get(sysid);
            if (s == null) {
                s = Collections.synchronizedSet(new LinkedHashSet());
                this.packetlist.put(sysid, s);
            }
            s.add(dmp);
        }
        return dmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DestinationUID getPacketListFirst(SysMessageID sysid) {
        Set<PacketListDMPair> s = null;
        Object object = this.packetlist;
        synchronized (object) {
            s = this.packetlist.get(sysid);
            if (s == null) {
                return null;
            }
        }
        object = s;
        synchronized (object) {
            Iterator<PacketListDMPair> itr = s.iterator();
            if (itr.hasNext()) {
                return itr.next().duid;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object removePacketList(SysMessageID sysid, DestinationUID duid, PacketReference ref) {
        Map<SysMessageID, Set<PacketListDMPair>> map = this.packetlist;
        synchronized (map) {
            Set<PacketListDMPair> s = this.packetlist.get(sysid);
            if (s == null) {
                return null;
            }
            PacketListDMPair dmp = new PacketListDMPair(duid, null);
            PacketListDMPair mydmp = null;
            if (s.contains(dmp)) {
                Iterator<PacketListDMPair> itr = s.iterator();
                while (itr.hasNext()) {
                    mydmp = itr.next();
                    if (mydmp.equals(dmp)) {
                        if (ref == null) {
                            itr.remove();
                            break;
                        }
                        if (mydmp.canRemove(ref, this)) {
                            itr.remove();
                            break;
                        }
                    }
                    mydmp = null;
                }
                if (s.isEmpty()) {
                    this.packetlist.remove(sysid);
                }
            }
            if (mydmp != null) {
                return mydmp.duid;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List[] findMatchingIDs(PartitionedStore ps, DestinationUID wildcarduid) throws PartitionNotFoundException {
        DestinationList dl2 = null;
        if (ps != null) {
            dl2 = destinationListList.get(ps);
            if (dl2 == null) {
                throw new PartitionNotFoundException(Globals.getBrokerResources().getKString("B4393", ps.getPartitionID()));
            }
            return new List[]{dl2.findMatchingIDs(wildcarduid)};
        }
        int i = 0;
        Map<PartitionedStore, DestinationList> map = destinationListList;
        synchronized (map) {
            int sz = destinationListList.size();
            List[] matchs = new List[sz == 0 ? 1 : sz];
            matchs[0] = null;
            for (DestinationList dl2 : destinationListList.values()) {
                matchs[i++] = dl2.findMatchingIDs(wildcarduid);
            }
            return matchs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<PartitionedStore, LinkedHashSet<Destination>> findMatchingDestinationMap(PartitionedStore ps, DestinationUID wildcarduid) {
        LinkedHashMap<PartitionedStore, LinkedHashSet<Destination>> map = new LinkedHashMap<PartitionedStore, LinkedHashSet<Destination>>();
        DestinationList dl = null;
        LinkedHashSet<Destination> dset = null;
        List<DestinationUID> duids = null;
        DestinationUID duid2 = null;
        Destination d = null;
        if (ps != null) {
            dl = destinationListList.get(ps);
            dset = new LinkedHashSet<Destination>();
            duids = dl.findMatchingIDs(wildcarduid);
            for (DestinationUID duid2 : duids) {
                d = dl.getDestination(duid2);
                if (d == null) continue;
                dset.add(d);
            }
            map.put(ps, dset);
            return map;
        }
        Map<PartitionedStore, DestinationList> map2 = destinationListList;
        synchronized (map2) {
            for (Map.Entry<PartitionedStore, DestinationList> pair : destinationListList.entrySet()) {
                dl = pair.getValue();
                dset = new LinkedHashSet();
                duids = dl.findMatchingIDs(wildcarduid);
                for (DestinationUID duid2 : duids) {
                    d = dl.getDestination(duid2);
                    dset.add(d);
                }
                map.put(pair.getKey(), dset);
            }
        }
        return map;
    }

    static List<DestinationUID> findMatchingIDsByDestinationList(DestinationList dl, DestinationUID wildcarduid) {
        return dl.findMatchingIDs(wildcarduid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<DestinationUID> findMatchingIDs(DestinationUID wildcarduid) {
        ArrayList<DestinationUID> l = new ArrayList<DestinationUID>();
        if (!wildcarduid.isWildcard()) {
            l.add(wildcarduid);
            return l;
        }
        Map map = this.destinationList;
        synchronized (map) {
            for (DestinationUID uid : this.destinationList.keySet()) {
                if (!DestinationUID.match(uid, wildcarduid)) continue;
                l.add(uid);
            }
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroyTransactionList(PartitionedStore ps) {
        if (ps != null) {
            DestinationList dl = null;
            dl = destinationListList.get(ps);
            if (dl != null) {
                dl.getTransactionList().destroy();
            }
            return;
        }
        Map<PartitionedStore, DestinationList> map = destinationListList;
        synchronized (map) {
            Iterator<DestinationList> itr = destinationListList.values().iterator();
            while (itr.hasNext()) {
                itr.next().getTransactionList().destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearDestinations(PartitionedStore ps) {
        if (ps != null) {
            DestinationList dl = null;
            dl = destinationListList.get(ps);
            if (dl != null) {
                dl.clearDestinations();
            }
            return;
        }
        Map<PartitionedStore, DestinationList> map = destinationListList;
        synchronized (map) {
            Iterator<DestinationList> itr = destinationListList.values().iterator();
            while (itr.hasNext()) {
                itr.next().clearDestinations();
            }
        }
        Queue.clear();
    }

    private void clearDestinations() {
        this.destsLoaded = false;
        this.destinationList.clear();
        this.packetlist.clear();
        inited = false;
        BrokerConfig cfg = Globals.getConfig();
        cfg.removeListener(SYSTEM_MAX_SIZE, cl);
        cfg.removeListener(SYSTEM_MAX_COUNT, cl);
        cfg.removeListener(MAX_MESSAGE_SIZE, cl);
        cfg.removeListener(AUTO_QUEUE_STR, cl);
        cfg.removeListener(AUTO_TOPIC_STR, cl);
        cfg.removeListener(DST_REAP_STR, cl);
        cfg.removeListener(MSG_REAP_STR, cl);
        cfg.removeListener(AUTO_MAX_NUM_MSGS, cl);
        cfg.removeListener(AUTO_MAX_TOTAL_BYTES, cl);
        cfg.removeListener(AUTO_MAX_BYTES_MSG, cl);
        cfg.removeListener(AUTO_MAX_NUM_PRODUCERS, cl);
        cfg.removeListener(AUTO_LOCAL_ONLY, cl);
        cfg.removeListener(AUTO_LIMIT_BEHAVIOR, cl);
        cfg.removeListener(USE_DMQ_STR, cl);
        cfg.removeListener(TRUNCATE_BODY_STR, cl);
        cfg.removeListener(LOG_MSGS_STR, cl);
        cl = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addDestination(PartitionedStore ps, Destination d, boolean throwRT) {
        if (ps != null) {
            destinationListList.get(ps).addDestination(d, throwRT);
            return;
        }
        DestinationList dl2 = null;
        Map<PartitionedStore, DestinationList> map = destinationListList;
        synchronized (map) {
            for (DestinationList dl2 : destinationListList.values()) {
                dl2.addDestination(d, throwRT);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDestination(Destination d, boolean throwRT) {
        Map map = this.destinationList;
        synchronized (map) {
            if (this.destinationList.get(d.getDestinationUID()) != null) {
                if (throwRT) {
                    throw new RuntimeException("Destination " + d + " is also being created by another broker");
                }
                return;
            }
            this.destinationList.put(d.getDestinationUID(), d);
            Agent agent = Globals.getAgent();
            if (agent != null) {
                agent.registerDestination(d);
                agent.notifyDestinationCreate(d);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean setDuraSubscriptionInited() {
        Object object = this.subscriptionLock;
        synchronized (object) {
            if (this.duraSubscriptionInited) {
                return false;
            }
            this.duraSubscriptionInited = true;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean setNonDuraSharedSubscriptionInited() {
        Object object = this.subscriptionLock;
        synchronized (object) {
            if (this.nonDuraSharedSubscriptionInited) {
                return false;
            }
            this.nonDuraSharedSubscriptionInited = true;
            return true;
        }
    }

    public LinkedHashMap processTransactions(Map inprocessAcks, Map openTrans, Map committingTrans) throws BrokerException {
        this.loadDestinations();
        Subscription.initDuraSubscriptions(this);
        LinkedHashMap prepared = new LinkedHashMap();
        Iterator itr = this.getAllDestinations(0);
        while (itr.hasNext()) {
            LinkedHashMap m;
            Destination d = (Destination)itr.next();
            boolean loaded = d.loaded;
            if (loaded) {
                d.unload(true);
            }
            if ((m = d.load(false, inprocessAcks, openTrans, committingTrans, null, false)) == null) continue;
            prepared.putAll(m);
        }
        return prepared;
    }

    public static void loadDestinations(PartitionedStore ps) throws BrokerException {
        if (ps == null) {
            throw new BrokerException("IllegalArgument: PartitionedStore null");
        }
        DestinationList dl = destinationListList.get(ps);
        dl.loadDestinations();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDestinations() throws BrokerException {
        Destination d;
        Object object = this.destinationListLock;
        synchronized (object) {
            if (this.destsLoaded) {
                return;
            }
            this.destsLoaded = true;
        }
        this.logger.log(8, this.br.getKString("B1434") + this.logsuffix);
        LoadException load_ex = this.pstore.getLoadDestinationException();
        if (load_ex != null) {
            LoadException processing = load_ex;
            while (processing != null) {
                String destid = (String)processing.getKey();
                d = (Destination)processing.getValue();
                if (destid == null && d == null) {
                    this.logger.log(16, "LoadDestinationException: Both key and value are corrupted");
                    continue;
                }
                if (destid == null) {
                    try {
                        this.pstore.storeDestination(d, PERSIST_SYNC);
                    }
                    catch (Exception ex) {
                        this.logger.log(16, "B2091", (Object)d.toString(), (Throwable)ex);
                        try {
                            this.pstore.removeDestination(d, true);
                        }
                        catch (Exception ex1) {
                            this.logger.logStack(4, "Unable to remove dest", ex1);
                        }
                    }
                } else {
                    DestinationUID duid = new DestinationUID(destid);
                    String name = duid.getName();
                    boolean isqueue = duid.isQueue();
                    int type = isqueue ? 1 : 2;
                    try {
                        d = this.createDestination(name, type);
                        d.store();
                        this.logger.log(16, "B2092", duid.getLocalizedName());
                    }
                    catch (Exception ex) {
                        this.logger.log(16, "B2093", (Object)duid, (Throwable)ex);
                        try {
                            d = duid.isQueue() ? new Queue(duid) : new Topic(duid);
                            this.pstore.removeDestination(d, true);
                        }
                        catch (Exception ex1) {
                            this.logger.logStack(4, "Unable to remove dest", ex1);
                        }
                    }
                }
                processing = processing.getNextException();
            }
        }
        try {
            Destination[] dests = this.pstore.getAllDestinations();
            this.logger.log(8, this.br.getKString("B1503", String.valueOf(dests.length)) + this.logsuffix);
            for (int i = 0; i < dests.length; ++i) {
                if (dests[i] == null) continue;
                if (DEBUG) {
                    this.logger.log(8, "Process stored destination " + dests[i].toString());
                }
                dests[i].setDestinationList(this);
                if (!(dests[i].isAdmin() || !dests[i].getIsDMQ() && dests[i].isInternal())) {
                    dests[i].initialize();
                }
                if (dests[i].isAutoCreated() && dests[i].size == 0 && dests[i].bytes == 0L) {
                    this.destinationList.remove(dests[i].getDestinationUID());
                    try {
                        Globals.getLogger().log(8, this.br.getKString("B1517", dests[i].getName()) + this.logsuffix);
                        dests[i].destroy(Globals.getBrokerResources().getString("B0069") + this.logsuffix);
                        continue;
                    }
                    catch (BrokerException ex) {
                        if (ex.getStatusCode() == 404) {
                            return;
                        }
                        throw ex;
                    }
                }
                this.addDestination(dests[i], false);
            }
            this.deadMessageQueue = this.createDMQ();
            Iterator itr = this.destinationList.values().iterator();
            while (itr.hasNext()) {
                d = (Destination)itr.next();
                try {
                    d.initMonitor();
                }
                catch (IOException ex) {
                    this.logger.logStack(8, "B1195", d.toString(), (Throwable)ex);
                    itr.remove();
                }
            }
        }
        catch (BrokerException ex) {
            this.logger.logStack(32, "B4031", ex);
            throw ex;
        }
        catch (IOException ex) {
            this.logger.logStack(32, "B4031", ex);
            throw new BrokerException("B4031", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Destination[] getLoadedDestination(PartitionedStore ps, DestinationUID uid) {
        DestinationList dl2 = null;
        if (ps != null) {
            dl2 = destinationListList.get(ps);
            Destination d = dl2.getLoadedDestination(uid);
            return new Destination[]{d};
        }
        int i = 0;
        Map<PartitionedStore, DestinationList> map = destinationListList;
        synchronized (map) {
            int sz = destinationListList.size();
            Destination[] dsts = new Destination[sz == 0 ? 1 : sz];
            dsts[0] = null;
            for (DestinationList dl2 : destinationListList.values()) {
                dsts[i++] = dl2.getLoadedDestination(uid);
            }
            return dsts;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Destination getLoadedDestination(DestinationUID uid) {
        Destination d = null;
        Map map = this.destinationList;
        synchronized (map) {
            d = (Destination)this.destinationList.get(uid);
        }
        if (d != null && !d.isDestInited()) {
            d.initialize();
        }
        return d;
    }

    static Destination getDestinationByDestinationList(DestinationList dl, DestinationUID uid) {
        return dl.getDestination(uid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Destination[] getDestination(PartitionedStore ps, DestinationUID uid) {
        Destination[] ret = null;
        DestinationList dl2 = null;
        if (ps != null) {
            dl2 = destinationListList.get(ps);
            if (dl2 == null) {
                ret = new Destination[]{null};
            } else {
                Destination d = dl2.getDestination(uid);
                ret = new Destination[]{d};
            }
        }
        int i = 0;
        Map<PartitionedStore, DestinationList> map = destinationListList;
        synchronized (map) {
            int sz = destinationListList.size();
            Destination[] dsts = new Destination[sz == 0 ? 1 : sz];
            dsts[0] = null;
            for (DestinationList dl2 : destinationListList.values()) {
                dsts[i++] = dl2.getDestination(uid);
            }
            if (ps == null) {
                return dsts;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<PartitionedStore, Destination> getDestinationMap(PartitionedStore ps, DestinationUID uid) {
        LinkedHashMap<PartitionedStore, Destination> map = new LinkedHashMap<PartitionedStore, Destination>();
        DestinationList dl = null;
        Destination d = null;
        if (ps != null) {
            dl = destinationListList.get(ps);
            d = dl.getDestination(uid);
            if (d != null) {
                map.put(ps, d);
            }
            return map;
        }
        Map<PartitionedStore, DestinationList> map2 = destinationListList;
        synchronized (map2) {
            for (Map.Entry<PartitionedStore, DestinationList> pair : destinationListList.entrySet()) {
                dl = pair.getValue();
                d = dl.getDestination(uid);
                if (d == null) continue;
                map.put(pair.getKey(), d);
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Destination getDestination(DestinationUID uid) {
        Destination d = null;
        Map map = this.destinationList;
        synchronized (map) {
            d = (Destination)this.destinationList.get(uid);
            if (d == null) {
                try {
                    d = this.pstore.getDestination(uid);
                    if (d != null) {
                        d.setDestinationList(this);
                        this.addDestination(d, false);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (d != null && !d.isDestInited()) {
            d.initialize();
        }
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Destination[] findDestination(PartitionedStore ps, DestinationUID uid) {
        DestinationList dl2 = null;
        if (ps != null) {
            dl2 = destinationListList.get(ps);
            return new Destination[]{dl2.findDestination(uid)};
        }
        int i = 0;
        Map<PartitionedStore, DestinationList> map = destinationListList;
        synchronized (map) {
            int sz = destinationListList.size();
            Destination[] dsts = new Destination[sz == 0 ? 1 : sz];
            dsts[0] = null;
            for (DestinationList dl2 : destinationListList.values()) {
                dsts[i++] = dl2.findDestination(uid);
            }
            return dsts;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Destination findDestination(DestinationUID uid) {
        Destination d = null;
        Map map = this.destinationList;
        synchronized (map) {
            d = (Destination)this.destinationList.get(uid);
        }
        return d;
    }

    public static Destination[] getDestination(PartitionedStore ps, String name, boolean isQueue) throws BrokerException, IOException {
        DestinationUID uid = new DestinationUID(name, isQueue);
        return DestinationList.getDestination(ps, uid);
    }

    public static Destination[] findDestination(PartitionedStore ps, String name, boolean isQueue) throws BrokerException, IOException {
        DestinationUID uid = new DestinationUID(name, isQueue);
        return DestinationList.findDestination(ps, uid);
    }

    public static Destination[] getLoadedDestination(PartitionedStore ps, String name, boolean isQueue) throws BrokerException, IOException {
        DestinationUID uid = new DestinationUID(name, isQueue);
        return DestinationList.getLoadedDestination(ps, uid);
    }

    static Destination getDestinationByDestinationList(DestinationList dl, String name, int type, boolean autocreate, boolean store) throws BrokerException, IOException {
        DestinationUID uid = new DestinationUID(name, DestType.isQueue(type));
        return dl.getDestination(uid, type, autocreate, store);
    }

    public static Destination[] getDestination(PartitionedStore ps, String name, int type, boolean autocreate, boolean store) throws BrokerException, IOException {
        DestinationUID uid = new DestinationUID(name, DestType.isQueue(type));
        return DestinationList.getDestination(ps, uid, type, autocreate, store);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Destination[] getDestination(PartitionedStore ps, DestinationUID uid, int type, boolean autocreate, boolean store) throws BrokerException, IOException {
        DestinationList dl2 = null;
        if (ps != null) {
            dl2 = destinationListList.get(ps);
            return new Destination[]{dl2.getDestination(uid, type, autocreate, store)};
        }
        int i = 0;
        Map<PartitionedStore, DestinationList> map = destinationListList;
        synchronized (map) {
            int sz = destinationListList.size();
            Destination[] dsts = new Destination[sz == 0 ? 1 : sz];
            dsts[0] = null;
            for (DestinationList dl2 : destinationListList.values()) {
                dsts[i++] = dl2.getDestination(uid, type, autocreate, store);
            }
            return dsts;
        }
    }

    private Destination getDestination(DestinationUID uid, int type, boolean autocreate, boolean store) throws BrokerException, IOException {
        Destination d = (Destination)this.destinationList.get(uid);
        if (autocreate && d == null) {
            try {
                d = this.createDestination(uid.getName(), type, store, autocreate, null, true, DestType.isLocal(type));
            }
            catch (ConflictException ex) {
                d = (Destination)this.destinationList.get(uid);
            }
        }
        if (d != null && !d.isDestInited()) {
            d.initialize();
        }
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Destination[] createDestination(PartitionedStore ps, String name, int type) throws BrokerException, IOException {
        Destination[] ret = null;
        DestinationList dl2 = null;
        if (ps != null) {
            dl2 = destinationListList.get(ps);
            Destination d = dl2.createDestination(name, type);
            ret = new Destination[]{d};
        }
        int i = 0;
        Map<PartitionedStore, DestinationList> map = destinationListList;
        synchronized (map) {
            int sz = destinationListList.size();
            Destination[] dsts = new Destination[sz == 0 ? 1 : sz];
            dsts[0] = null;
            for (DestinationList dl2 : destinationListList.values()) {
                dsts[i++] = dl2.createDestination(name, type);
            }
            if (ps == null) {
                return dsts;
            }
        }
        return ret;
    }

    private Destination createDestination(String name, int type) throws BrokerException, IOException {
        Destination d = this.createDestination(name, type, true, false, null, true, false);
        if (d != null && !d.isDestInited()) {
            d.initialize();
        }
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Destination[] createTempDestination(PartitionedStore ps, String name, int type, ConnectionUID uid, boolean store, long time) throws BrokerException, IOException {
        Destination[] ret = null;
        DestinationList dl2 = null;
        if (ps != null) {
            dl2 = destinationListList.get(ps);
            if (dl2 == null) {
                String emsg = "I18NNot found store partition:" + ps + " in " + destinationListList;
                Globals.getLogger().log(16, emsg);
                throw new BrokerException(emsg, 404);
            }
            Destination d = dl2.createTempDestination(name, type, uid, store, time);
            ret = new Destination[]{d};
        }
        int i = 0;
        Map<PartitionedStore, DestinationList> map = destinationListList;
        synchronized (map) {
            int sz = destinationListList.size();
            Destination[] dsts = new Destination[sz == 0 ? 1 : sz];
            dsts[0] = null;
            for (DestinationList dl2 : destinationListList.values()) {
                dsts[i++] = dl2.createTempDestination(name, type, uid, store, time);
            }
            if (ps == null) {
                return dsts;
            }
        }
        return ret;
    }

    private Destination createTempDestination(String name, int type, ConnectionUID uid, boolean store, long time) throws BrokerException, IOException {
        Destination d = null;
        try {
            d = this.createDestination(name, type, false, false, uid, true, DestType.isLocal(type));
            d.setReconnectInterval(time);
            d.overridePersistence(store);
            d.store();
        }
        catch (ConflictException ex) {
            DestinationUID duid = new DestinationUID(name, DestType.isQueue(type));
            d = this.getDestination(duid, type, false, false);
        }
        return d;
    }

    boolean isValid() {
        return this.valid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown() {
        shutdown = true;
        Map<PartitionedStore, DestinationList> map = destinationListList;
        synchronized (map) {
            Iterator<DestinationList> itr = destinationListList.values().iterator();
            while (itr.hasNext()) {
                itr.next().valid = false;
            }
        }
        try {
            partitionMonitor.shutdown();
            if (!partitionMonitor.awaitTermination(30L, TimeUnit.SECONDS)) {
                Globals.getLogger().log(8, "Force  partition monitor shutdown");
                partitionMonitor.shutdownNow();
                partitionMonitor.awaitTermination(10L, TimeUnit.SECONDS);
            }
        }
        catch (InterruptedException e) {
            partitionMonitor.shutdownNow();
        }
    }

    public static boolean isShutdown() {
        return shutdown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Destination[] createDestination(PartitionedStore ps, String name, int type, boolean store, boolean autocreated, Object from) throws BrokerException, IOException {
        ConnectionUID uid = null;
        boolean remote = false;
        if (from instanceof ConnectionUID) {
            uid = (ConnectionUID)from;
        }
        if (from instanceof BrokerAddress) {
            remote = ((BrokerAddress)from).equals(Globals.getMyAddress());
        }
        Destination[] ret = null;
        DestinationList dl2 = null;
        if (ps != null) {
            dl2 = destinationListList.get(ps);
            Destination d = dl2.createDestination(name, type, store, autocreated, uid, !remote, DestType.isLocal(type));
            ret = new Destination[]{d};
        }
        int i = 0;
        Map<PartitionedStore, DestinationList> map = destinationListList;
        synchronized (map) {
            int sz = destinationListList.size();
            Destination[] dsts = new Destination[sz == 0 ? 1 : sz];
            dsts[0] = null;
            for (DestinationList dl2 : destinationListList.values()) {
                dsts[i++] = dl2.createDestination(name, type, store, autocreated, uid, !remote, DestType.isLocal(type));
            }
            if (ps == null) {
                return dsts;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Destination createDestination(String name, int type, boolean store, boolean autocreated, ConnectionUID uid, boolean notify, boolean localOnly) throws BrokerException, IOException {
        DestinationUID wuid;
        DestinationUID duid = new DestinationUID(name, DestType.isQueue(type));
        if (!this.valid) {
            if (!DL.isPartitionMode()) {
                throw new BrokerException(Globals.getBrokerResources().getKString("B4140"), "B4140", null, 500);
            }
            throw new BrokerException(this.br.getKString("B1437", this.logsuffix));
        }
        if (this.destinationList.get(duid) != null) {
            throw new ConflictException(Globals.getBrokerResources().getKString("B4063", duid));
        }
        try {
            Destination d = this.pstore.getDestination(duid);
            if (d != null) {
                d.setDestinationList(this);
                this.addDestination(d, false);
                return d;
            }
        }
        catch (Exception d) {
            // empty catch block
        }
        ClusterBroadcast mbi = Globals.getClusterBroadcast();
        boolean clusterNotify = false;
        Destination d = null;
        try {
            d = DestType.isQueue(type) ? new Queue(name, type, store, uid, autocreated, this) : new Topic(name, type, store, uid, autocreated, this);
            d.setClusterNotifyFlag(notify);
            try {
                Map map = this.destinationList;
                synchronized (map) {
                    Destination newd = (Destination)this.destinationList.get(duid);
                    if (newd != null) {
                        String emsg = Globals.getBrokerResources().getKString("B4063", duid.getLongString());
                        throw new BrokerException(emsg, 409);
                    }
                    if (!autocreated) {
                        d.setIsLocal(localOnly);
                    }
                    if (store) {
                        d.store();
                    }
                    this.destinationList.put(duid, d);
                }
            }
            catch (BrokerException ex) {
                if (ex.getStatusCode() != 409) {
                    throw new BrokerException(ex.getMessage(), ex, 409);
                }
                throw ex;
            }
            boolean bl = clusterNotify = !d.isAutoCreated() && d.sendClusterUpdate() && notify;
            if (mbi != null && clusterNotify && !mbi.lockDestination(duid, uid)) {
                throw new ConflictException("Internal Exception: Destination " + duid + " is in the process of being created");
            }
            if (clusterNotify && mbi != null) {
                mbi.createDestination(d);
            }
        }
        finally {
            if (mbi != null && clusterNotify) {
                mbi.unlockDestination(duid, uid);
            }
        }
        Iterator itr = Consumer.getWildcardConsumers();
        while (itr.hasNext()) {
            ConsumerUID cuid = (ConsumerUID)itr.next();
            Consumer c = Consumer.getConsumer(cuid);
            if (c == null) {
                Globals.getLogger().log(8, "Consumer already destroyed");
                continue;
            }
            wuid = c.getDestinationUID();
            if (!DestinationUID.match(d.getDestinationUID(), wuid)) continue;
            try {
                if (c.getSubscription() != null) {
                    d.addConsumer(c.getSubscription(), false);
                    continue;
                }
                d.addConsumer(c, false);
            }
            catch (SelectorFormatException selectorFormatException) {}
        }
        itr = Producer.getWildcardProducers();
        while (itr.hasNext()) {
            ProducerUID puid = (ProducerUID)itr.next();
            Producer p = (Producer)Producer.getProducer(puid);
            wuid = p.getDestinationUID();
            if (!DestinationUID.match(d.getDestinationUID(), wuid)) continue;
            d.addProducer(p);
        }
        Agent agent = Globals.getAgent();
        if (agent != null) {
            agent.registerDestination(d);
            agent.notifyDestinationCreate(d);
        }
        return d;
    }

    public static Destination[] removeDestination(PartitionedStore ps, String name, boolean isQueue, String reason) throws IOException, BrokerException {
        DestinationUID duid = new DestinationUID(name, isQueue);
        return DestinationList.removeDestination(ps, duid, true, reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Destination[] removeDestination(PartitionedStore ps, DestinationUID uid, boolean notify, String reason) throws IOException, BrokerException {
        Destination[] ret = null;
        DestinationList dl2 = null;
        if (ps != null) {
            dl2 = destinationListList.get(ps);
            Destination d = dl2.removeDestination(uid, true, reason);
            ret = new Destination[]{d};
        }
        int i = 0;
        Map<PartitionedStore, DestinationList> map = destinationListList;
        synchronized (map) {
            int sz = destinationListList.size();
            Destination[] dsts = new Destination[sz == 0 ? 1 : sz];
            dsts[0] = null;
            for (DestinationList dl2 : destinationListList.values()) {
                dsts[i++] = dl2.removeDestination(uid, notify, reason);
            }
            if (ps == null) {
                return dsts;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Destination removeDestination(DestinationUID uid, boolean notify, String reason) throws IOException, BrokerException {
        boolean noerrnotfound;
        Destination d = null;
        boolean bl = noerrnotfound = Globals.getHAEnabled() && !notify;
        if (noerrnotfound) {
            d = this.findDestination(uid);
            if (d != null && !d.isTemporary()) {
                d = this.getDestination(uid);
            }
        } else {
            d = this.getDestination(uid);
        }
        if (d != null) {
            if (d.isDMQ) {
                throw new BrokerException(Globals.getBrokerResources().getKString("B4193"));
            }
            if (notify && d.sendClusterUpdate() && !d.isTemporary()) {
                Globals.getClusterBroadcast().recordRemoveDestination(d);
            }
            int level = DestType.isAdmin(d.getType()) ? 4 : 8;
            Globals.getLogger().log(level, "B1517", d.getName());
        }
        try {
            d = (Destination)this.destinationList.get(uid);
            DestinationUID.clearUID(uid);
            if (d != null) {
                Agent agent;
                if (d.producers.size() > 0) {
                    Object[] args = new String[]{d.getName(), String.valueOf(d.producers.size()), reason};
                    Globals.getLogger().log(16, "B2081", args);
                }
                if (d.consumers.size() > 0) {
                    int csize = d.consumers.size();
                    boolean destroyDurables = false;
                    HashSet cons = new HashSet(d.consumers.values());
                    for (Consumer c : cons) {
                        if (!(c instanceof Subscription) || !((Subscription)c).isDurable()) continue;
                        destroyDurables = true;
                        Subscription s = (Subscription)c;
                        if (s.isActive()) {
                            csize += s.getActiveSubscriberCnt();
                        }
                        Subscription.unsubscribeOnDestroy(s.getDurableName(), s.getClientID(), notify);
                        --csize;
                    }
                    if (destroyDurables) {
                        Globals.getLogger().log(8, "B1131", (Object)d.toString(), reason);
                    }
                    if (csize > 0) {
                        Object[] args = new String[]{d.getName(), String.valueOf(csize), reason};
                        Globals.getLogger().log(16, "B2082", args);
                    }
                }
                if (d.size() > 0) {
                    this.logger.log(16, this.br.getKString("B2181", String.valueOf(d.size()), d.toString()) + this.logsuffix);
                }
                d.destroy(reason, noerrnotfound);
                if (notify && d.sendClusterUpdate()) {
                    Globals.getClusterBroadcast().destroyDestination(d);
                }
                if ((agent = Globals.getAgent()) != null) {
                    agent.notifyDestinationDestroy(d);
                    agent.unregisterDestination(d);
                }
            }
        }
        finally {
            d = (Destination)this.destinationList.remove(uid);
        }
        return d;
    }

    public static boolean removeDestination(PartitionedStore ps, Destination dest, String reason) throws IOException, BrokerException {
        Destination[] dsts = DestinationList.removeDestination(ps, dest.getDestinationUID(), true, reason);
        return dsts != null && dsts.length == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterator getDestinations(Object id, int mask) {
        ArrayList<Destination> tq = new ArrayList<Destination>();
        Map map = this.destinationList;
        synchronized (map) {
            Collection values = this.destinationList.values();
            for (Destination dest : values) {
                if ((dest.getType() & mask) != mask || id != null && !id.equals(dest.getConnectionUID()) && (!(id instanceof BrokerAddress) || id != Globals.getMyAddress() || !dest.getClusterNotifyFlag() || !dest.sendClusterUpdate())) continue;
                tq.add(dest);
            }
        }
        return tq.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Iterator[] getAllDestinations(PartitionedStore ps) {
        if (ps != null) {
            DestinationList dl = destinationListList.get(ps);
            if (dl == null) {
                return new Iterator[]{null};
            }
            return new Iterator[]{dl.getAllDestinations(0)};
        }
        ArrayList<DestinationList> dls = null;
        Map<PartitionedStore, DestinationList> map = destinationListList;
        synchronized (map) {
            dls = new ArrayList<DestinationList>(destinationListList.values());
        }
        int sz = dls.size();
        Iterator[] itrs = new Iterator[sz == 0 ? 1 : sz];
        itrs[0] = null;
        int i = 0;
        Iterator<DestinationList> itr = dls.iterator();
        while (itr.hasNext()) {
            itrs[i++] = itr.next().getAllDestinations(0);
        }
        return itrs;
    }

    private Iterator getAllDestinations(int mask) {
        return this.getDestinations(null, mask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Iterator[] getTempDestinations(PartitionedStore ps, BrokerAddress address) {
        if (ps != null) {
            DestinationList dl = destinationListList.get(ps);
            return new Iterator[]{dl.getDestinations(address, 16)};
        }
        ArrayList<DestinationList> dls = null;
        Map<PartitionedStore, DestinationList> map = destinationListList;
        synchronized (map) {
            dls = new ArrayList<DestinationList>(destinationListList.values());
        }
        Iterator[] itrs = new Iterator[dls.size()];
        int i = 0;
        Iterator<DestinationList> itr = dls.iterator();
        while (itr.hasNext()) {
            itrs[i] = itr.next().getDestinations(address, 16);
        }
        return itrs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Iterator[] getStoredDestinations(PartitionedStore ps) {
        if (ps != null) {
            DestinationList dl = destinationListList.get(ps);
            Iterator itr = dl.getDestinations(null, 0);
            return new Iterator[]{itr};
        }
        ArrayList<DestinationList> dls = null;
        Map<PartitionedStore, DestinationList> itr = destinationListList;
        synchronized (itr) {
            dls = new ArrayList<DestinationList>(destinationListList.values());
        }
        Iterator[] itrs = new Iterator[dls.size()];
        int i = 0;
        Iterator<DestinationList> itr2 = dls.iterator();
        while (itr2.hasNext()) {
            itrs[i] = itr2.next().getDestinations(null, 0);
        }
        return itrs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doCheckpoint(PartitionedStore ps2, boolean sync) {
        if (ps2 != null) {
            if (ps2 instanceof TxnLoggingStore) {
                ((TxnLoggingStore)((Object)ps2)).doCheckpoint(sync);
            }
            return;
        }
        ArrayList<PartitionedStore> stores = null;
        Map<PartitionedStore, DestinationList> map = destinationListList;
        synchronized (map) {
            stores = new ArrayList<PartitionedStore>(destinationListList.keySet());
        }
        for (PartitionedStore ps2 : stores) {
            if (!(ps2 instanceof TxnLoggingStore)) continue;
            Globals.getLogger().log(8, Globals.getBrokerResources().getKString("B1324[" + ps2 + "]"));
            ((TxnLoggingStore)((Object)ps2)).doCheckpoint(sync);
        }
    }

    public static boolean isPartitionMode() {
        if (!partitionModeInited) {
            throw new IllegalStateException("DestinationList not initialized !");
        }
        return partitionMode;
    }

    public static boolean isPartitionMigratable() {
        if (!partitionModeInited) {
            throw new IllegalStateException("DestinationList not initialized !");
        }
        return partitionMigratable;
    }

    public static void init() throws BrokerException {
        if (inited) {
            if (shutdown) {
                throw new BrokerException(Globals.getBrokerResources().getKString("B4140"));
            }
            return;
        }
        shutdown = false;
        inited = true;
        if (DestinationList.canAutoCreate(true)) {
            Globals.getLogger().log(8, "B1013");
        }
        if (!DestinationList.canAutoCreate(false)) {
            Globals.getLogger().log(8, "B1014");
        }
        BrokerConfig cfg = Globals.getConfig();
        cfg.addListener(SYSTEM_MAX_SIZE, cl);
        cfg.addListener(SYSTEM_MAX_COUNT, cl);
        cfg.addListener(MAX_MESSAGE_SIZE, cl);
        cfg.addListener(AUTO_QUEUE_STR, cl);
        cfg.addListener(AUTO_TOPIC_STR, cl);
        cfg.addListener(DST_REAP_STR, cl);
        cfg.addListener(MSG_REAP_STR, cl);
        cfg.addListener(AUTO_MAX_NUM_MSGS, cl);
        cfg.addListener(AUTO_MAX_TOTAL_BYTES, cl);
        cfg.addListener(AUTO_MAX_BYTES_MSG, cl);
        cfg.addListener(AUTO_MAX_NUM_PRODUCERS, cl);
        cfg.addListener(AUTO_LOCAL_ONLY, cl);
        cfg.addListener(AUTO_LIMIT_BEHAVIOR, cl);
        cfg.addListener(USE_DMQ_STR, cl);
        cfg.addListener(TRUNCATE_BODY_STR, cl);
        cfg.addListener(LOG_MSGS_STR, cl);
        cfg.addListener(DEBUG_LISTS_PROP, cl);
        cfg.addListener(CHECK_MSGS_RATE_AT_DEST_CAPACITY_RATIO_PROP, cl);
        cfg.addListener(CHECK_MSGS_RATE_FOR_ALL_PROP, cl);
        DestinationList.setMaxSize(cfg.getSizeProperty(SYSTEM_MAX_SIZE));
        DestinationList.setMaxMessages(cfg.getIntProperty(SYSTEM_MAX_COUNT));
        DestinationList.setIndividualMessageMax(cfg.getSizeProperty(MAX_MESSAGE_SIZE));
        Queue.init();
        if (Globals.getStore().getPartitionModeEnabled()) {
            try {
                String typ = cfg.getProperty(CONN_STRATEGY_PROP, "MIN_CONN");
                String cl = null;
                if (typ.equalsIgnoreCase("MIN_CONN")) {
                    cl = MIN_CONN_STRATEGY_CLASS;
                } else if (typ.equalsIgnoreCase(RR_CONN_STRATEGY)) {
                    cl = RR_CONN_STRATEGY_CLASS;
                } else {
                    Globals.getLogger().log(16, "XXXIngore unknown " + typ + " for imq.connection.loadBalanceToPartitionStrategy");
                    cl = MIN_CONN_STRATEGY_CLASS;
                }
                partitionStrategy = Globals.isNucleusManagedBroker() ? (ConnToPartitionStrategy)Globals.getHabitat().getService(ConnToPartitionStrategy.class, cl, new Annotation[0]) : (ConnToPartitionStrategy)Class.forName(cl).newInstance();
            }
            catch (Exception e) {
                throw new BrokerException(e.getMessage(), e);
            }
        }
        DestinationList dl2 = null;
        List<PartitionedStore> partitions = Globals.getStore().getAllStorePartitions();
        if (Globals.getStore().getPartitionModeEnabled()) {
            partitionMode = true;
            if (Globals.getStore().isPartitionMigratable()) {
                partitionMigratable = true;
            }
        } else if (partitions.size() > 1) {
            BrokerException ex = new BrokerException(Globals.getBrokerResources().getKString("B3100", "Unexpected " + partitions.size() + "store partitions when partition mode disabled"));
            Globals.getLogger().logStack(32, ex.getMessage(), ex);
            throw ex;
        }
        partitionModeInited = true;
        PartitionedStore partition2 = null;
        for (PartitionedStore partition2 : partitions) {
            dl2 = new DestinationList(partition2);
            destinationListList.put(partition2, dl2);
        }
        TransactionList tl = null;
        for (DestinationList dl2 : destinationListList.values()) {
            tl = new TransactionList(dl2);
            dl2.setTransactionList(tl);
        }
        for (DestinationList dl2 : destinationListList.values()) {
            dl2.loadDestinations();
            DestinationList.addPartitionListener(dl2.getTransactionList());
            DestinationList.notifyPartitionAdded(dl2.getPartitionedStore(), dl2);
        }
    }

    public static void acquirePartitionLock(boolean share) throws BrokerException {
        if (!partitionMode) {
            return;
        }
        Lock lock = partitionShareLock;
        if (!share) {
            lock = partitionExclusiveLock;
        }
        try {
            if (lock.tryLock(partitionLockTimeout, TimeUnit.SECONDS)) {
                return;
            }
            throw new BrokerException("XXXAcquire partition lock timed out", 408);
        }
        catch (InterruptedException e) {
            throw new BrokerException("XXX Acquire partition lock interrupted", e);
        }
    }

    public static void releasePartitionLock(boolean share) {
        if (!partitionMode) {
            return;
        }
        if (share) {
            partitionShareLock.unlock();
        } else {
            partitionExclusiveLock.unlock();
        }
    }

    public static void registerPartitionLoadEvent(UID partitionID) {
        partitionMonitor.execute(new PartitionMonitorTask(0, partitionID, null));
    }

    public static void registerPartitionArrivedEvent(UID partitionID, String sourceBrokerID) {
        partitionMonitor.execute(new PartitionMonitorTask(1, partitionID, sourceBrokerID));
    }

    public static void registerPartitionArrivalNotificationEvent(UID partitionID, String targetBrokerID) {
        partitionMonitor.execute(new PartitionMonitorTask(2, partitionID, targetBrokerID));
    }

    public static void registerPartitionArrivalCheckEvent() {
        partitionMonitor.execute(new PartitionMonitorTask(3, null, null));
    }

    public static void storePartitionArrived(UID partitionID) throws BrokerException {
        List<PartitionedStore> pstores = Globals.getStore().partitionArrived(partitionID);
        if (partitionID != null) {
            DestinationList.addStorePartition(pstores.get(0), true);
            return;
        }
        if (pstores.size() > 0) {
            Globals.getLogger().log(8, "Found " + pstores.size() + " arrived store partitions to be loaded");
        }
        Iterator<PartitionedStore> itr = pstores.iterator();
        while (itr.hasNext()) {
            DestinationList.addStorePartition(itr.next(), false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addStorePartition(PartitionedStore ps, boolean errdup) throws BrokerException {
        DestinationList.acquirePartitionLock(false);
        try {
            Map<PartitionedStore, DestinationList> map = destinationListList;
            synchronized (map) {
                block9: {
                    if (destinationListList.get(ps) == null) break block9;
                    String emsg = "Partition " + ps + " has already been loaded";
                    if (errdup) {
                        throw new BrokerException(emsg);
                    }
                    Globals.getLogger().log(8, emsg);
                    return;
                }
                DestinationList dl = new DestinationList(ps);
                TransactionList tl = new TransactionList(dl);
                dl.setTransactionList(tl);
                dl.loadDestinations();
                Subscription.initDuraSubscriptions(dl);
                Subscription.initNonDuraSharedSubscriptions(dl);
                Consumer.attachConsumers(dl);
                destinationListList.put(ps, dl);
                tl.postProcess();
                DestinationList.addPartitionListener(tl);
                DestinationList.notifyPartitionAdded(ps, dl);
            }
        }
        finally {
            DestinationList.releasePartitionLock(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addPartitionListener(PartitionListener listener) {
        List<PartitionListener> list = partitionListeners;
        synchronized (list) {
            partitionListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removePartitionListener(PartitionListener listener) {
        List<PartitionListener> list = partitionListeners;
        synchronized (list) {
            partitionListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void notifyPartitionRemoved(PartitionedStore ps, DestinationList dl, String targetBroker) {
        List<PartitionListener> list = partitionListeners;
        synchronized (list) {
            Iterator<PartitionListener> itr = partitionListeners.iterator();
            while (itr.hasNext()) {
                itr.next().partitionRemoved(ps.getPartitionID(), dl, targetBroker);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void notifyPartitionAdded(PartitionedStore ps, DestinationList dl) {
        List<PartitionListener> list = partitionListeners;
        synchronized (list) {
            Iterator<PartitionListener> itr = partitionListeners.iterator();
            while (itr.hasNext()) {
                itr.next().partitionAdded(ps.getPartitionID(), dl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getNumPartitions() {
        Map<PartitionedStore, DestinationList> map = destinationListList;
        synchronized (map) {
            return destinationListList.keySet().size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DestinationList getDestinationList(UID partitionID) {
        if (partitionID == null) {
            return null;
        }
        Map<PartitionedStore, DestinationList> map = destinationListList;
        synchronized (map) {
            return destinationListList.get(new NoPersistPartitionedStoreImpl(partitionID));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void movePartition(UID partitionID, String brokerID) throws BrokerException {
        if (!DestinationList.isPartitionMigratable()) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B4395"), 412);
        }
        PartitionedStore pstore = null;
        Map<PartitionedStore, DestinationList> map = destinationListList;
        synchronized (map) {
            pstore = new NoPersistPartitionedStoreImpl(partitionID);
            DestinationList dl = destinationListList.get(pstore);
            if (dl == null) {
                throw new BrokerException(Globals.getBrokerResources().getKString("B4393", partitionID), 412);
            }
            if (dl.getPartitionedStore().isPrimaryPartition()) {
                throw new BrokerException(Globals.getBrokerResources().getKString("B4394", partitionID), 405);
            }
            dl.valid = false;
            DestinationList.notifyPartitionRemoved(pstore, dl, brokerID);
            pstore = dl.getPartitionedStore();
            dl.closeAttachedConnections(10, "XXXAdmin request to move partition: " + partitionID);
            destinationListList.remove(pstore);
            Consumer con = null;
            Iterator itr = Consumer.getAllConsumers(true);
            while (itr.hasNext()) {
                con = (Consumer)itr.next();
                con.setParentList(pstore, null);
            }
            Destination d = null;
            itr = dl.getDestinations(null, 0);
            while (itr.hasNext()) {
                d = (Destination)itr.next();
                d.unload(true, true);
            }
            pstore.close();
            Globals.getStore().partitionDeparture(partitionID, brokerID);
            dl.clearDestinations();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PartitionedStore assignStorePartition(int serviceType, ConnectionUID connid, UID storeSession) throws BrokerException {
        PartitionedStore pstore = null;
        DestinationList dl = null;
        if (partitionMode && serviceType == 1) {
            Map<PartitionedStore, DestinationList> map = destinationListList;
            synchronized (map) {
                if (destinationListList.size() == 0) {
                    throw new BrokerException("IllegalStateException: DestinationList not inited !");
                }
                dl = destinationListList.get(Globals.getStore().getPrimaryPartition());
                dl.attachConnection(connid);
                return dl.getPartitionedStore();
            }
        }
        if (storeSession != null && Globals.getStore().getPartitionModeEnabled()) {
            NoPersistPartitionedStoreImpl tmpps = new NoPersistPartitionedStoreImpl(storeSession);
            Map<PartitionedStore, DestinationList> map = destinationListList;
            synchronized (map) {
                dl = destinationListList.get(tmpps);
                if (dl == null) {
                    throw new BrokerException(Globals.getBrokerResources().getKString("B1436", storeSession, connid), 404);
                }
                dl.attachConnection(connid);
                pstore = dl.getPartitionedStore();
            }
            Globals.getLogger().log(8, Globals.getBrokerResources().getKString("B1438", pstore, connid));
            return pstore;
        }
        while (!shutdown) {
            ArrayList<ConnToPartitionStrategyContext> dls = null;
            Map<PartitionedStore, DestinationList> map = destinationListList;
            synchronized (map) {
                dls = new ArrayList<ConnToPartitionStrategyContext>(destinationListList.values());
            }
            if (dls.size() == 0) {
                throw new BrokerException("XXXIllegalState: DestinationList not inited !");
            }
            if (dls.size() == 1) {
                dl = dls.get(0);
                map = destinationListList;
                synchronized (map) {
                    dl.attachConnection(connid);
                }
                pstore = dl.getPartitionedStore();
                if (Globals.getStore().getPartitionModeEnabled()) {
                    Globals.getLogger().log(8, Globals.getBrokerResources().getKString("B1439", pstore, connid));
                }
                return pstore;
            }
            pstore = partitionStrategy != null ? partitionStrategy.chooseStorePartition(dls) : dls.get(0).getPartitionedStore();
            map = destinationListList;
            synchronized (map) {
                dl = destinationListList.get(pstore);
                if (dl == null) {
                    continue;
                }
                if (!dl.isValid()) {
                    continue;
                }
                dl.attachConnection(connid);
            }
            pstore = dl.getPartitionedStore();
            Globals.getLogger().log(8, Globals.getBrokerResources().getKString("B1439", pstore, connid));
            return pstore;
        }
        throw new BrokerException(Globals.getBrokerResources().getKString("B4140"), "B4140");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unassignStorePartition(ConnectionUID connid, PartitionedStore pstore) {
        if (pstore == null) {
            return;
        }
        Map<PartitionedStore, DestinationList> map = destinationListList;
        synchronized (map) {
            DestinationList dl = destinationListList.get(pstore);
            if (dl == null) {
                return;
            }
            dl.detachConnection(connid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void attachConnection(ConnectionUID connid) throws BrokerException {
        if (!this.valid) {
            throw new BrokerException(this.br.getKString("B1437", this.logsuffix));
        }
        ArrayList<ConnectionUID> arrayList = this.connections;
        synchronized (arrayList) {
            this.connections.add(connid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void detachConnection(ConnectionUID connid) {
        ArrayList<ConnectionUID> arrayList = this.connections;
        synchronized (arrayList) {
            this.connections.remove(connid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeAttachedConnections(int reason, String reasonStr) {
        ConnectionManager cmgr = Globals.getConnectionManager();
        ConnectionUID cuid = null;
        Connection con = null;
        ArrayList<ConnectionUID> arrayList = this.connections;
        synchronized (arrayList) {
            this.logger.log(8, "Sending good-bye to all assigned connections(" + this.connections.size() + ") for partition " + this);
            ConnectionUID[] conids = this.connections.toArray(new ConnectionUID[this.connections.size()]);
            for (int i = 0; i < conids.length; ++i) {
                cuid = conids[i];
                con = cmgr.getConnection(cuid);
                if (con == null) {
                    this.connections.remove(cuid);
                    continue;
                }
                con.closeConnection(true, reason, reasonStr);
                this.connections.remove(cuid);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getConnectionCount() {
        ArrayList<ConnectionUID> arrayList = this.connections;
        synchronized (arrayList) {
            return this.connections.size();
        }
    }

    @Override
    public long getPersistMessageCount() {
        return 0L;
    }

    public static void setIndividualMessageMax(SizeString size) {
        if (size == null) {
            size = new SizeString();
        }
        individual_max_size = size;
        long bytesize = size.getBytes();
        if (bytesize <= 0L) {
            bytesize = Long.MAX_VALUE;
        }
        Packet.setMaxPacketSize(bytesize);
        if (Globals.getMemManager() != null) {
            Globals.getMemManager().updateMaxMessageSize(bytesize);
        }
    }

    public static void setMaxMessages(long messages) {
        message_max_count = messages;
    }

    public static long getMaxMessages() {
        return message_max_count;
    }

    public static void setMaxSize(SizeString size) {
        if (size == null) {
            size = new SizeString();
        }
        max_size = size;
    }

    public static PacketReference get(PartitionedStore ps, SysMessageID id) {
        return DestinationList.get(ps, id, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PacketReference get(PartitionedStore ps, SysMessageID id, boolean wait) {
        DestinationList dl = null;
        if (ps != null) {
            dl = destinationListList.get(ps);
            if (dl == null) {
                Globals.getLogger().log(16, Globals.getBrokerResources().getKString("B4393", ps));
                return null;
            }
            return dl.get(id, wait);
        }
        PacketReference ref = null;
        Map<PartitionedStore, DestinationList> map = destinationListList;
        synchronized (map) {
            Destination d;
            DestinationUID uid;
            Iterator<DestinationList> itr = destinationListList.values().iterator();
            while (itr.hasNext() && ((uid = (dl = itr.next()).getPacketListFirst(id)) == null || (d = (Destination)dl.destinationList.get(uid)) == null || (ref = d.destMessages.get(id)) == null)) {
            }
        }
        if (ref == null) {
            return ref;
        }
        return ref.checkLock(wait);
    }

    PacketReference get(SysMessageID id, boolean wait) {
        DestinationUID uid = this.getPacketListFirst(id);
        if (uid == null) {
            return null;
        }
        Destination d = (Destination)this.destinationList.get(uid);
        if (d == null) {
            return null;
        }
        PacketReference ref = d.destMessages.get(id);
        if (ref == null) {
            return null;
        }
        return ref.checkLock(wait);
    }

    public static boolean isLocked(PartitionedStore ps, SysMessageID id) {
        if (ps != null) {
            return destinationListList.get(ps).isLocked(id);
        }
        PacketReference ref = DestinationList.get(null, id, false);
        if (ref == null) {
            return false;
        }
        return ref.checkLock(false) == null;
    }

    private boolean isLocked(SysMessageID id) {
        DestinationUID uid = this.getPacketListFirst(id);
        if (uid == null) {
            return false;
        }
        Destination d = (Destination)this.destinationList.get(uid);
        if (d == null) {
            return false;
        }
        PacketReference ref = d.destMessages.get(id);
        if (ref == null) {
            return false;
        }
        return ref.checkLock(false) == null;
    }

    static PacketListDMPair addNewMessage(PartitionedStore ps, boolean checkLimits, PacketReference ref) throws BrokerException {
        if (ps == null) {
            throw new BrokerException("IllegalArgument: addNewMessage(null, " + ref + ")");
        }
        DestinationList dl = destinationListList.get(ps);
        if (dl == null) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B4393", ps));
        }
        return dl.addNewMessage(checkLimits, ref);
    }

    PacketListDMPair addNewMessage(boolean checkLimits, PacketReference ref) throws BrokerException {
        if (checkLimits) {
            DestinationList.checkSystemLimit(ref);
        }
        PacketListDMPair dmp = this.packetlistAdd(ref.getSysMessageID(), ref.getDestinationUID(), ref);
        if (ref.isExpired()) {
            dmp.setReturn(false);
        } else {
            dmp.setReturn(true);
        }
        return dmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long checkSystemLimit(PacketReference ref) throws BrokerException {
        String limitstr;
        long room = -1L;
        long indsize = individual_max_size.getBytes();
        if (indsize > 0L && ref.byteSize() > indsize) {
            String limitstr2 = individual_max_size.toString();
            Object[] msgs = new String[]{String.valueOf(ref.byteSize()), ref.getSysMessageID().toString(), MAX_MESSAGE_SIZE, limitstr2};
            throw new BrokerException(Globals.getBrokerResources().getKString("B4026", msgs), "B4026", null, 423);
        }
        long newsize = 0L;
        int newcnt = 0;
        Object object = totalcntLock;
        synchronized (object) {
            newcnt = totalcnt + 1;
            newsize = totalbytes + ref.byteSize();
        }
        if (message_max_count > 0L && (long)newcnt > message_max_count) {
            limitstr = message_max_count <= 0L ? Globals.getBrokerResources().getString("B0012") : String.valueOf(message_max_count);
            throw new BrokerException(Globals.getBrokerResources().getKString("B4024", limitstr, ref.getSysMessageID()), "B4024", null, 414);
        }
        if (message_max_count > 0L && (room = message_max_count - (long)totalcnt) < 0L) {
            room = 0L;
        }
        if (max_size.getBytes() > 0L && newsize > max_size.getBytes()) {
            limitstr = max_size.getBytes() <= 0L ? Globals.getBrokerResources().getString("B0012") : max_size.toString();
            throw new BrokerException(Globals.getBrokerResources().getKString("B4025", limitstr, ref.getSysMessageID()), "B4025", null, 414);
        }
        if (max_size.getBytes() > 0L) {
            long cnt = (max_size.getBytes() - totalbytes) / ref.byteSize();
            if (cnt < 0L) {
                cnt = 0L;
            }
            if (cnt < room) {
                room = cnt;
            }
        }
        return room;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void adjustTotalBytes(long objsize) {
        Object object = totalcntLock;
        synchronized (object) {
            totalbytes += objsize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void adjustTotals(long dstsize, long objsize) {
        Object object = totalcntLock;
        synchronized (object) {
            totalcnt = (int)((long)totalcnt + dstsize);
            totalbytes += objsize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void incrementTotals(long objsize, boolean nonpersist) {
        Object object = totalcntLock;
        synchronized (object) {
            ++totalcnt;
            if (objsize > 0L) {
                totalbytes += objsize;
            }
            if (nonpersist) {
                ++totalcntNonPersist;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decrementTotals(long objsize, boolean nonpersist) {
        Object object = totalcntLock;
        synchronized (object) {
            --totalcnt;
            if (objsize > 0L) {
                totalbytes -= objsize;
            }
            if (nonpersist) {
                --totalcntNonPersist;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int totalCount() {
        Object object = totalcntLock;
        synchronized (object) {
            assert (totalcnt >= 0);
            return totalcnt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long totalBytes() {
        Object object = totalcntLock;
        synchronized (object) {
            assert (totalbytes >= 0L);
            return totalbytes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int totalCountNonPersist() {
        Object object = totalcntLock;
        synchronized (object) {
            assert (totalcntNonPersist >= 0);
            return totalcntNonPersist;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float totalCountPercent() {
        if (message_max_count <= 0L) {
            return 0.0f;
        }
        Object object = totalcntLock;
        synchronized (object) {
            return (float)totalcnt / (float)message_max_count * 100.0f;
        }
    }

    public static boolean canAutoCreate(boolean queue) {
        return queue ? ALLOW_QUEUE_AUTOCREATE : ALLOW_TOPIC_AUTOCREATE;
    }

    public static boolean canAutoCreate(boolean queue, int type) {
        if (DestType.isTemporary(type)) {
            return false;
        }
        return queue ? ALLOW_QUEUE_AUTOCREATE : ALLOW_TOPIC_AUTOCREATE;
    }

    static {
        if (Globals.getLogger().getLevel() <= 4) {
            DEBUG = true;
        }
        if (DEBUG) {
            Globals.getLogger().log(8, "Syncing message store: " + PERSIST_SYNC);
        }
        if (NO_PRODUCER_FLOW) {
            Globals.getLogger().log(8, "Producer flow control is turned off ");
        }
        MAX_PRODUCER_BATCH = Globals.getConfig().getIntProperty("imq.producer.maxBatch", 1000);
        defaultMaxMsgCnt = Globals.getConfig().getIntProperty(AUTO_MAX_NUM_MSGS, 100000);
        defaultProducerCnt = Globals.getConfig().getIntProperty(AUTO_MAX_NUM_PRODUCERS, 100);
        defaultMaxMsgBytes = Globals.getConfig().getSizeProperty(AUTO_MAX_TOTAL_BYTES, 0xA00000L);
        defaultMaxBytesPerMsg = Globals.getConfig().getSizeProperty(AUTO_MAX_BYTES_MSG, 10240L);
        defaultIsLocal = Globals.getConfig().getBooleanProperty(AUTO_LOCAL_ONLY, false);
        defaultLimitBehavior = DestLimitBehavior.getStateFromString(Globals.getConfig().getProperty(AUTO_LIMIT_BEHAVIOR, "REJECT_NEWEST"));
        defaultUseDMQ = Globals.getConfig().getBooleanProperty(USE_DMQ_STR, true);
        defaultTruncateBody = Globals.getConfig().getBooleanProperty(TRUNCATE_BODY_STR, false);
        defaultVerbose = Globals.getConfig().getBooleanProperty(LOG_MSGS_STR, false);
        autocreateUseDMQ = defaultUseDMQ;
        storeBodyWithDMQ = !defaultTruncateBody;
        verbose = defaultVerbose;
        partitionStrategy = null;
        individual_max_size = null;
        max_size = null;
        message_max_count = 0L;
        totalcntLock = new Object();
        totalbytes = 0L;
        totalcnt = 0;
        totalcntNonPersist = 0;
        inited = false;
        shutdown = false;
        destinationListList = Collections.synchronizedMap(new LinkedHashMap());
        DL = Globals.getDestinationList();
        ADMINP = new NoPersistPartitionedStoreImpl(PartitionedStore.ADMIN_UID);
        REMOTEP = new NoPersistPartitionedStoreImpl(PartitionedStore.REMOTE_UID);
        partitionModeInited = false;
        partitionMode = false;
        partitionMigratable = false;
        partitionLockTimeout = Globals.getConfig().getLongProperty(PARTITION_LOCK_TIMEOUT_PROP, 300L);
        partitionLock = new ReentrantReadWriteLock();
        partitionShareLock = partitionLock.readLock();
        partitionExclusiveLock = partitionLock.writeLock();
        partitionMonitor = Executors.newSingleThreadExecutor();
        cl = new ConfigListener(){

            @Override
            public void validate(String name, String value) throws PropertyUpdateException {
            }

            @Override
            public boolean update(String name, String value) {
                BrokerConfig cfg = Globals.getConfig();
                if (name.equals(DestinationList.SYSTEM_MAX_SIZE)) {
                    DestinationList.setMaxSize(cfg.getSizeProperty(DestinationList.SYSTEM_MAX_SIZE));
                } else if (name.equals(DestinationList.SYSTEM_MAX_COUNT)) {
                    DestinationList.setMaxMessages(cfg.getIntProperty(DestinationList.SYSTEM_MAX_COUNT));
                } else if (name.equals(DestinationList.MAX_MESSAGE_SIZE)) {
                    DestinationList.setIndividualMessageMax(cfg.getSizeProperty(DestinationList.MAX_MESSAGE_SIZE));
                } else if (name.equals(DestinationList.AUTO_QUEUE_STR)) {
                    ALLOW_QUEUE_AUTOCREATE = cfg.getBooleanProperty(DestinationList.AUTO_QUEUE_STR);
                } else if (name.equals(DestinationList.AUTO_TOPIC_STR)) {
                    ALLOW_TOPIC_AUTOCREATE = cfg.getBooleanProperty(DestinationList.AUTO_TOPIC_STR);
                } else if (name.equals(DestinationList.DST_REAP_STR)) {
                    AUTOCREATE_EXPIRE = cfg.getLongProperty(DestinationList.DST_REAP_STR) * 1000L;
                } else if (name.equals(DestinationList.MSG_REAP_STR)) {
                    MESSAGE_EXPIRE = cfg.getLongProperty(DestinationList.MSG_REAP_STR) * 1000L;
                } else if (name.equals(DestinationList.AUTO_MAX_NUM_MSGS)) {
                    defaultMaxMsgCnt = cfg.getIntProperty(DestinationList.AUTO_MAX_NUM_MSGS);
                } else if (name.equals(DestinationList.AUTO_MAX_TOTAL_BYTES)) {
                    defaultMaxMsgBytes = cfg.getSizeProperty(DestinationList.AUTO_MAX_TOTAL_BYTES);
                } else if (name.equals(DestinationList.AUTO_MAX_BYTES_MSG)) {
                    defaultMaxBytesPerMsg = cfg.getSizeProperty(DestinationList.AUTO_MAX_BYTES_MSG);
                } else if (name.equals(DestinationList.AUTO_MAX_NUM_PRODUCERS)) {
                    defaultProducerCnt = cfg.getIntProperty(DestinationList.AUTO_MAX_NUM_PRODUCERS);
                } else if (name.equals(DestinationList.AUTO_LOCAL_ONLY)) {
                    defaultIsLocal = cfg.getBooleanProperty(DestinationList.AUTO_LOCAL_ONLY);
                } else if (name.equals(DestinationList.AUTO_LIMIT_BEHAVIOR)) {
                    defaultLimitBehavior = DestLimitBehavior.getStateFromString(Globals.getConfig().getProperty(DestinationList.AUTO_LIMIT_BEHAVIOR));
                } else if (name.equals(DestinationList.USE_DMQ_STR)) {
                    autocreateUseDMQ = cfg.getBooleanProperty(DestinationList.USE_DMQ_STR);
                } else if (name.equals(DestinationList.TRUNCATE_BODY_STR)) {
                    storeBodyWithDMQ = !cfg.getBooleanProperty(DestinationList.TRUNCATE_BODY_STR);
                } else if (name.equals(DestinationList.LOG_MSGS_STR)) {
                    verbose = cfg.getBooleanProperty(DestinationList.LOG_MSGS_STR);
                } else if (name.equals(DestinationList.DEBUG_LISTS_PROP)) {
                    DEBUG_LISTS = Boolean.valueOf(value);
                } else if (name.equals(DestinationList.CHECK_MSGS_RATE_AT_DEST_CAPACITY_RATIO_PROP)) {
                    CHECK_MSGS_RATE_AT_DEST_CAPACITY_RATIO = cfg.getIntProperty(DestinationList.CHECK_MSGS_RATE_AT_DEST_CAPACITY_RATIO_PROP);
                } else if (name.equals(DestinationList.CHECK_MSGS_RATE_FOR_ALL_PROP)) {
                    CHECK_MSGS_RATE_FOR_ALL = cfg.getBooleanProperty(DestinationList.CHECK_MSGS_RATE_FOR_ALL_PROP);
                }
                return true;
            }
        };
    }

    private static class ResubmitPartitionMonitorTask
    extends TimerTask {
        private PartitionMonitorTask task = null;

        public ResubmitPartitionMonitorTask(PartitionMonitorTask task) {
            this.task = task;
        }

        @Override
        public void run() {
            block3: {
                if (shutdown) {
                    this.cancel();
                    return;
                }
                try {
                    partitionMonitor.execute(this.task);
                }
                catch (Exception e) {
                    if (shutdown) break block3;
                    Globals.getLogger().logStack(16, "Can't resubmit partition monitor task " + this.task, e);
                }
            }
        }
    }

    private static class PartitionMonitorTask
    implements Runnable {
        public static final int PARTITION_RELOAD = 0;
        public static final int PARTITION_ARRIVED = 1;
        public static final int PARTITION_ARRIVAL_NOTIFICATION = 2;
        public static final int PARTITION_ARRIVAL_CHECK = 3;
        private int type = 3;
        private UID partitionID = null;
        private String brokerID = null;

        public PartitionMonitorTask(int type, UID partitionID, String brokerID) {
            this.type = type;
            this.partitionID = partitionID;
            this.brokerID = brokerID;
        }

        @Override
        public void run() {
            if (shutdown) {
                return;
            }
            Globals.getLogger().log(8, Globals.getBrokerResources().getKString("B1442", this.toString()));
            switch (this.type) {
                case 0: 
                case 1: {
                    try {
                        DestinationList.storePartitionArrived(this.partitionID);
                    }
                    catch (BrokerException e) {
                        if (e.getStatusCode() == 412 || e.getStatusCode() == 405) {
                            Globals.getLogger().log(32, e.getMessage(), e);
                            return;
                        }
                        Globals.getLogger().logStack(16, e.getMessage(), e);
                        Globals.getLogger().log(8, "Resubmit partition monitor task " + this);
                        Globals.getTimer(false).schedule((TimerTask)new ResubmitPartitionMonitorTask(this), 30000L);
                    }
                    break;
                }
                case 2: {
                    Globals.getLogger().log(8, Globals.getBrokerResources().getKString("B1441", this.brokerID, this.partitionID));
                    try {
                        Globals.getClusterBroadcast().notifyPartitionArrival(this.partitionID, this.brokerID);
                    }
                    catch (Exception e) {
                        if (e instanceof BrokerException && ((BrokerException)e).getStatusCode() == 404) {
                            Globals.getLogger().log(8, e.getMessage());
                        } else {
                            Globals.getLogger().logStack(16, e.getMessage(), e);
                        }
                        ClusteredBroker cb = Globals.getClusterManager().getBroker(this.brokerID);
                        if (cb == null) {
                            Globals.getLogger().log(8, "Broker " + this.brokerID + " not found, cancel partition monitor event " + this);
                            return;
                        }
                        if (BrokerStatus.getBrokerLinkIsDown(cb.getStatus())) {
                            Globals.getLogger().log(8, "Broker " + this.brokerID + " link is down, cancel partition monitor event " + this);
                            return;
                        }
                        Globals.getLogger().log(8, "Resubmit partition monitor task " + this);
                        Globals.getTimer(false).schedule((TimerTask)new ResubmitPartitionMonitorTask(this), 30000L);
                    }
                    break;
                }
                case 3: {
                    try {
                        DestinationList.storePartitionArrived(null);
                    }
                    catch (BrokerException e) {
                        Globals.getLogger().log(16, this + ": " + e.getMessage());
                        if (e.getStatusCode() != 449) break;
                        Globals.getLogger().log(8, "Resubmit partition monitor task " + this);
                        Globals.getTimer(false).schedule((TimerTask)new ResubmitPartitionMonitorTask(this), 30000L);
                    }
                    break;
                }
            }
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            switch (this.type) {
                case 0: {
                    buf.append("PARTITION_RELOAD");
                    break;
                }
                case 1: {
                    buf.append("PARTITION_ARRIVED");
                    break;
                }
                case 2: {
                    buf.append("PARTITION_ARRIVAL_NOTIFICATION");
                    break;
                }
                case 3: {
                    buf.append("PARTITION_ARRIVAL_CHECK");
                    break;
                }
            }
            buf.append('[').append(this.partitionID == null ? "" : this.partitionID);
            buf.append(", ").append(this.brokerID == null ? "" : this.brokerID).append(']');
            return buf.toString();
        }
    }
}

