/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationList;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.multibroker.MessageBusCallback;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ClusterDestInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.GPacketHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.RaptorProtocol;
import com.sun.messaging.jmq.util.DestType;
import java.util.Hashtable;

public class DestinationUpdateHandler
extends GPacketHandler {
    private DestinationList DL = Globals.getDestinationList();

    public DestinationUpdateHandler(RaptorProtocol p) {
        super(p);
    }

    @Override
    public void handle(MessageBusCallback cb, BrokerAddress sender, GPacket pkt) {
        if (pkt.getType() == 13) {
            this.handleUpdateDestination(cb, sender, pkt);
        } else if (pkt.getType() == 15) {
            this.handleRemDestination(cb, sender, pkt);
        } else if (pkt.getType() == 14 || pkt.getType() == 16) {
            this.handleReply(sender, pkt);
        } else {
            this.logger.log(16, "DestinationUpdateHandler Internal error : Cannot handle this packet :" + pkt.toLongString());
        }
    }

    public void handleUpdateDestination(MessageBusCallback cb, BrokerAddress sender, GPacket pkt) {
        ClusterDestInfo cdi = ClusterDestInfo.newInstance(pkt);
        try {
            DestinationUID duid = cdi.getDestUID();
            Hashtable props = cdi.getDestProps();
            Destination[] ds = DestinationList.getDestination(null, duid);
            Destination d = ds[0];
            if (d == null) {
                ds = DestinationList.createDestination(null, cdi.getDestName(), cdi.getDestType(), !DestType.isTemporary(cdi.getDestType()), false, this.selfAddress);
                d = ds[0];
                d.setDestinationProperties(props);
                cb.notifyCreateDestination(d);
            } else {
                cb.notifyUpdateDestination(duid, props);
            }
            if (cdi.getShareccInfo() != null) {
                cb.setLastReceivedChangeRecord(sender, cdi.getShareccInfo());
            }
        }
        catch (Exception e) {
            this.logger.logStack(8, "Internal Exception, unable to process message " + pkt, e);
            return;
        }
    }

    public void handleRemDestination(MessageBusCallback cb, BrokerAddress sender, GPacket pkt) {
        try {
            ClusterDestInfo cdi = ClusterDestInfo.newInstance(pkt);
            DestinationUID duid = cdi.getDestUID();
            cb.notifyDestroyDestination(duid);
            if (cdi.getShareccInfo() != null) {
                cb.setLastReceivedChangeRecord(sender, cdi.getShareccInfo());
            }
        }
        catch (Exception e) {
            this.logger.logStack(8, "Internal Exception, unable to process message " + pkt, e);
            return;
        }
    }

    public void handleReply(BrokerAddress sender, GPacket pkt) {
    }
}

