/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.server;

import java.io.CharConversionException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.HttpHandlerRegistration;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.server.Response;
import org.glassfish.grizzly.http.server.jmxbase.JmxEventListener;
import org.glassfish.grizzly.http.server.jmxbase.Monitorable;
import org.glassfish.grizzly.http.server.util.DispatcherHelper;
import org.glassfish.grizzly.http.server.util.Mapper;
import org.glassfish.grizzly.http.server.util.MappingData;
import org.glassfish.grizzly.http.util.DataChunk;
import org.glassfish.grizzly.http.util.HttpStatus;
import org.glassfish.grizzly.http.util.RequestURIRef;
import org.glassfish.grizzly.localization.LogMessages;

public class HttpHandlerChain
extends HttpHandler
implements JmxEventListener {
    private static final Logger LOGGER = Grizzly.logger(HttpHandlerChain.class);
    private static final Map<HttpHandlerRegistration, PathUpdater> ROOT_URLS = new HashMap<HttpHandlerRegistration, PathUpdater>(3);
    private final FullUrlPathResolver fullUrlPathResolver = new FullUrlPathResolver(this);
    private final ConcurrentMap<String, HttpHandler> handlersByName = new ConcurrentHashMap<String, HttpHandler>();
    private final ReentrantReadWriteLock mapperUpdateLock = new ReentrantReadWriteLock();
    private final ConcurrentMap<HttpHandler, HttpHandlerRegistration[]> handlers = new ConcurrentHashMap<HttpHandler, HttpHandlerRegistration[]>();
    private final ConcurrentMap<HttpHandler, Object> monitors = new ConcurrentHashMap<HttpHandler, Object>();
    private int handlersCount;
    private volatile RootHttpHandler rootHttpHandler;
    private final Mapper mapper;
    private final DispatcherHelper dispatchHelper;
    private static final String LOCAL_HOST = "localhost";
    private boolean started;
    private final HttpServer httpServer;
    private boolean isRootConfigured = false;

    public HttpHandlerChain(HttpServer httpServer) {
        this.httpServer = httpServer;
        this.mapper = new Mapper();
        this.mapper.setDefaultHostName(LOCAL_HOST);
        this.dispatchHelper = new DispatchHelperImpl();
        this.setDecodeUrl(false);
    }

    @Override
    public void jmxEnabled() {
        this.mapperUpdateLock.readLock().lock();
        try {
            for (HttpHandler httpHandler : this.handlers.keySet()) {
                if (!(httpHandler instanceof Monitorable)) continue;
                this.registerJmxForHandler(httpHandler);
            }
        }
        finally {
            this.mapperUpdateLock.readLock().unlock();
        }
    }

    @Override
    public void jmxDisabled() {
        this.mapperUpdateLock.readLock().lock();
        try {
            for (HttpHandler httpHandler : this.handlers.keySet()) {
                if (!(httpHandler instanceof Monitorable)) continue;
                this.deregisterJmxForHandler(httpHandler);
            }
        }
        finally {
            this.mapperUpdateLock.readLock().unlock();
        }
    }

    @Override
    boolean doHandle(Request request, Response response) throws Exception {
        block7: {
            response.setErrorPageGenerator(this.getErrorPageGenerator(request));
            try {
                RootHttpHandler rootHttpHandlerLocal = this.rootHttpHandler;
                if (rootHttpHandlerLocal != null) {
                    HttpHandler rh = rootHttpHandlerLocal.httpHandler;
                    rootHttpHandlerLocal.pathUpdater.update(this, rh, request);
                    return rh.doHandle(request, response);
                }
                RequestURIRef uriRef = request.getRequest().getRequestURIRef();
                uriRef.setDefaultURIEncoding(this.getRequestURIEncoding());
                DataChunk decodedURI = uriRef.getDecodedRequestURIBC(this.isAllowEncodedSlash());
                MappingData mappingData = request.obtainMappingData();
                this.mapper.mapUriWithSemicolon(request.getRequest(), decodedURI, mappingData, 0);
                if (mappingData.context != null && mappingData.context instanceof HttpHandler) {
                    HttpHandler httpHandler = mappingData.wrapper != null ? (HttpHandler)mappingData.wrapper : (HttpHandler)mappingData.context;
                    HttpHandlerChain.updatePaths(request, mappingData);
                    return httpHandler.doHandle(request, response);
                }
                response.sendError(404);
            }
            catch (Exception t) {
                try {
                    response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR_500);
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.log(Level.FINE, "Internal server error", t);
                    }
                }
                catch (Exception ex2) {
                    if (!LOGGER.isLoggable(Level.WARNING)) break block7;
                    LOGGER.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_HTTP_SERVER_HTTPHANDLERCHAIN_ERRORPAGE(), ex2);
                }
            }
        }
        return true;
    }

    @Override
    public void service(Request request, Response response) throws Exception {
        throw new IllegalStateException("Method doesn't have to be called");
    }

    public void addHandler(HttpHandler httpHandler, String[] mappings) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHandler(HttpHandler httpHandler, HttpHandlerRegistration[] mappings) {
        this.mapperUpdateLock.writeLock().lock();
        try {
            if (mappings.length == 0) {
                this.addHandler(httpHandler, new String[]{""});
            } else {
                String name;
                if (this.started) {
                    httpHandler.start();
                    if (httpHandler instanceof Monitorable) {
                        this.registerJmxForHandler(httpHandler);
                    }
                }
                if (this.handlers.put(httpHandler, mappings) == null) {
                    ++this.handlersCount;
                }
                if ((name = httpHandler.getName()) != null) {
                    this.handlersByName.put(name, httpHandler);
                }
                httpHandler.setDispatcherHelper(this.dispatchHelper);
                for (HttpHandlerRegistration reg : mappings) {
                    String ctx = reg.getContextPath();
                    String wrapper = reg.getUrlPattern();
                    if (ctx.length() != 0) {
                        this.mapper.addContext(LOCAL_HOST, ctx, httpHandler, new String[]{"index.html", "index.htm"}, null);
                    } else if (!this.isRootConfigured && wrapper.startsWith("*.")) {
                        this.isRootConfigured = true;
                        HttpHandler a = new HttpHandler(){

                            @Override
                            public void service(Request request, Response response) throws IOException {
                                response.sendError(404);
                            }
                        };
                        this.mapper.addContext(LOCAL_HOST, ctx, a, new String[]{"index.html", "index.htm"}, null);
                    } else {
                        this.mapper.addContext(LOCAL_HOST, ctx, httpHandler, new String[]{"index.html", "index.htm"}, null);
                    }
                    this.mapper.addWrapper(LOCAL_HOST, ctx, wrapper, httpHandler);
                }
                this.rootHttpHandler = this.handlersCount == 1 && mappings.length == 1 && ROOT_URLS.containsKey(mappings[0]) ? new RootHttpHandler(httpHandler, ROOT_URLS.get(mappings[0])) : null;
            }
        }
        finally {
            this.mapperUpdateLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeHttpHandler(HttpHandler httpHandler) {
        if (httpHandler == null) {
            throw new IllegalStateException();
        }
        this.mapperUpdateLock.writeLock().lock();
        try {
            HttpHandlerRegistration[] mappings;
            String name = httpHandler.getName();
            if (name != null) {
                this.handlersByName.remove(name);
            }
            if ((mappings = (HttpHandlerRegistration[])this.handlers.remove(httpHandler)) != null) {
                Map.Entry entry;
                HttpHandlerRegistration[] lastHttpHandlerMappings;
                for (HttpHandlerRegistration mapping : mappings) {
                    String contextPath = mapping.getContextPath();
                    this.mapper.removeWrapper(LOCAL_HOST, contextPath, mapping.getUrlPattern());
                    if (this.mapper.getWrapperNames(LOCAL_HOST, name).length != 0) continue;
                    this.mapper.removeContext(LOCAL_HOST, contextPath);
                }
                this.deregisterJmxForHandler(httpHandler);
                httpHandler.destroy();
                --this.handlersCount;
                this.rootHttpHandler = this.handlersCount == 1 ? ((lastHttpHandlerMappings = (HttpHandlerRegistration[])(entry = this.handlers.entrySet().iterator().next()).getValue()).length == 1 && ROOT_URLS.containsKey(lastHttpHandlerMappings[0]) ? new RootHttpHandler(httpHandler, ROOT_URLS.get(lastHttpHandlerMappings[0])) : null) : null;
            }
            boolean bl = mappings != null;
            return bl;
        }
        finally {
            this.mapperUpdateLock.writeLock().unlock();
        }
    }

    public void removeAllHttpHandlers() {
        this.mapperUpdateLock.writeLock().lock();
        try {
            for (HttpHandler handler : this.handlers.keySet()) {
                this.removeHttpHandler(handler);
            }
        }
        finally {
            this.mapperUpdateLock.writeLock().unlock();
        }
    }

    @Override
    public synchronized void start() {
        this.mapperUpdateLock.readLock().lock();
        try {
            for (HttpHandler httpHandler : this.handlers.keySet()) {
                httpHandler.start();
            }
        }
        finally {
            this.mapperUpdateLock.readLock().unlock();
        }
        this.started = true;
    }

    @Override
    public synchronized void destroy() {
        this.mapperUpdateLock.writeLock().lock();
        try {
            for (HttpHandler httpHandler : this.handlers.keySet()) {
                httpHandler.destroy();
            }
        }
        finally {
            this.mapperUpdateLock.writeLock().unlock();
        }
        this.started = false;
    }

    private void registerJmxForHandler(HttpHandler httpHandler) {
        Monitorable monitorable = (Monitorable)((Object)httpHandler);
        Object jmx = monitorable.createManagementObject();
        if (this.monitors.putIfAbsent(httpHandler, jmx) == null) {
            this.httpServer.jmxManager.register(this.httpServer.managementObject, jmx);
        }
    }

    private void deregisterJmxForHandler(HttpHandler httpHandler) {
        Object jmx = this.monitors.remove(httpHandler);
        if (jmx != null) {
            this.httpServer.jmxManager.deregister(jmx);
        }
    }

    static {
        ROOT_URLS.put(HttpHandlerRegistration.fromString(""), new EmptyPathUpdater());
        ROOT_URLS.put(HttpHandlerRegistration.fromString("/"), new SlashPathUpdater());
        ROOT_URLS.put(HttpHandlerRegistration.fromString("/*"), new SlashStarPathUpdater());
    }

    private static class FullUrlPathResolver
    implements Request.PathResolver {
        private final HttpHandler httpHandler;

        public FullUrlPathResolver(HttpHandler httpHandler) {
            this.httpHandler = httpHandler;
        }

        @Override
        public String resolve(Request request) {
            try {
                RequestURIRef uriRef = request.getRequest().getRequestURIRef();
                uriRef.setDefaultURIEncoding(this.httpHandler.getRequestURIEncoding());
                DataChunk decodedURI = uriRef.getDecodedRequestURIBC(this.httpHandler.isAllowEncodedSlash());
                int pos = decodedURI.indexOf(';', 0);
                return pos < 0 ? decodedURI.toString() : decodedURI.toString(0, pos);
            }
            catch (CharConversionException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private static class EmptyPathUpdater
    implements PathUpdater {
        private EmptyPathUpdater() {
        }

        @Override
        public void update(HttpHandlerChain handlerChain, HttpHandler httpHandler, Request request) {
            request.setContextPath("");
            request.setPathInfo((String)null);
            request.setHttpHandlerPath((String)null);
        }
    }

    private static class SlashStarPathUpdater
    implements PathUpdater {
        private SlashStarPathUpdater() {
        }

        @Override
        public void update(HttpHandlerChain handlerChain, HttpHandler httpHandler, Request request) {
            request.setContextPath("");
            request.setPathInfo(handlerChain.fullUrlPathResolver);
            request.setHttpHandlerPath("");
        }
    }

    private static class SlashPathUpdater
    implements PathUpdater {
        private SlashPathUpdater() {
        }

        @Override
        public void update(HttpHandlerChain handlerChain, HttpHandler httpHandler, Request request) {
            request.setContextPath("");
            request.setPathInfo((String)null);
            request.setHttpHandlerPath(handlerChain.fullUrlPathResolver);
        }
    }

    private static interface PathUpdater {
        public void update(HttpHandlerChain var1, HttpHandler var2, Request var3);
    }

    private static final class RootHttpHandler {
        private final HttpHandler httpHandler;
        private final PathUpdater pathUpdater;

        public RootHttpHandler(HttpHandler httpHandler, PathUpdater pathUpdater) {
            this.httpHandler = httpHandler;
            this.pathUpdater = pathUpdater;
        }
    }

    private final class DispatchHelperImpl
    implements DispatcherHelper {
        private DispatchHelperImpl() {
        }

        @Override
        public void mapPath(HttpRequestPacket requestPacket, DataChunk path, MappingData mappingData) throws Exception {
            HttpHandlerChain.this.mapper.map(requestPacket, path, mappingData);
        }

        @Override
        public void mapName(DataChunk name, MappingData mappingData) {
            String nameStr = name.toString();
            HttpHandler handler = (HttpHandler)HttpHandlerChain.this.handlersByName.get(nameStr);
            if (handler != null) {
                mappingData.wrapper = handler;
                mappingData.servletName = nameStr;
            }
        }
    }
}

