/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.spi;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import org.glassfish.tyrus.spi.ServerContainer;

public abstract class ServerContainerFactory {
    private static final String CONTAINTER_CLASS = "org.glassfish.tyrus.container.grizzly.server.GrizzlyServerContainer";

    public static ServerContainer createServerContainer() {
        return ServerContainerFactory.createServerContainer(Collections.<String, Object>emptyMap());
    }

    public static ServerContainer createServerContainer(Map<String, Object> properties) {
        ServerContainerFactory factory = null;
        Iterator<ServerContainerFactory> it = ServiceLoader.load(ServerContainerFactory.class).iterator();
        if (it.hasNext()) {
            factory = it.next();
        }
        if (factory == null) {
            try {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                Class<?> factoryClass = classLoader == null ? Class.forName(CONTAINTER_CLASS) : classLoader.loadClass(CONTAINTER_CLASS);
                factory = (ServerContainerFactory)factoryClass.newInstance();
            }
            catch (ClassNotFoundException ce) {
                throw new RuntimeException(ce);
            }
            catch (InstantiationException ie) {
                throw new RuntimeException(ie);
            }
            catch (IllegalAccessException ie) {
                throw new RuntimeException(ie);
            }
        }
        return factory.createContainer(properties);
    }

    public abstract ServerContainer createContainer(Map<String, Object> var1);
}

