/*
 * Decompiled with CFR 0.152.
 */
package org.gnowsis.util;

import apple.laf.AquaSystemIcon;
import com.apple.cocoa.foundation.NSAppleEventDescriptor;
import com.apple.cocoa.foundation.NSAppleScript;
import com.apple.cocoa.foundation.NSArray;
import com.apple.cocoa.foundation.NSMutableDictionary;
import com.apple.eawt.Application;
import com.apple.eawt.ApplicationAdapter;
import com.apple.eawt.ApplicationEvent;
import com.apple.eawt.ApplicationListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.JMenu;

public class AppleUtils {
    private static final String[] bundleextension = new String[]{".app", ".bundle", ".framework", ".kext", ".mpkg", "mdimporter", ".nib", ".pbproj", ".pkg", ".plugin", ".prefPane", ".rtfd", ".saver", ".slideSaver", ".wdgt", ".webarchive", ".xcode", ".xcodeproj", ".key", ".pages"};
    private Method pref;
    private Method about;
    private Object prefo;
    private Object abouto;
    private Application a;
    private Method quit;
    private Object quito;
    private App app;

    public static boolean isBundle(File f) throws IOException {
        if (f.isDirectory()) {
            String filename = f.getName();
            for (String e : bundleextension) {
                if (!filename.endsWith(e)) continue;
                return true;
            }
        }
        return false;
    }

    private static void addURL(URL u) throws IOException {
        URLClassLoader sysloader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        Class<URLClassLoader> sysclass = URLClassLoader.class;
        try {
            Method method = sysclass.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            method.invoke((Object)sysloader, u);
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new IOException("Error, could not add URL to system classloader");
        }
    }

    public AppleUtils() {
        try {
            AppleUtils.addURL(new File("/System/Library/Java/").toURL());
        }
        catch (Exception e) {
            System.err.println("Could not add cocoa libraries to classpath.");
            e.printStackTrace();
        }
        this.app = new App();
        this.a = Application.getApplication();
        this.a.addAboutMenuItem();
        this.a.addPreferencesMenuItem();
        this.a.setEnabledAboutMenu(false);
        this.a.setEnabledPreferencesMenu(false);
        this.a.addApplicationListener((ApplicationListener)this.app);
    }

    public void registerPreferences(Method preferences, Object object) {
        this.pref = preferences;
        this.prefo = object;
        this.a.setEnabledPreferencesMenu(true);
    }

    public void registerAbout(Method about, Object object) {
        this.abouto = object;
        this.about = about;
        this.a.setEnabledAboutMenu(true);
    }

    public void registerQuit(Method quit, Object object) {
        this.quit = quit;
        this.quito = object;
    }

    public void addDockMenu(JMenu menu) {
        AquaSystemIcon a = new AquaSystemIcon("kake");
    }

    public static ClassLoader getAppleClassLoader() throws MalformedURLException {
        return new URLClassLoader(new URL[]{new File("/System/Library/Java").toURL()});
    }

    public String applescript(String script) throws AppleScriptException {
        NSAppleScript nsa = new NSAppleScript(script);
        NSMutableDictionary errors = new NSMutableDictionary();
        NSAppleEventDescriptor res = nsa.execute(errors);
        if (errors.allKeys().count() > 0) {
            Hashtable<String, String> err = new Hashtable<String, String>();
            NSArray a = errors.allKeys();
            for (int i = 0; i < a.count(); ++i) {
                Object k = a.objectAtIndex(i);
                err.put(k.toString(), errors.objectForKey(k).toString());
            }
            throw new AppleScriptException("Error while executing applescript.", err);
        }
        return res.stringValue();
    }

    public static void main(String[] args) throws Exception {
        AppleUtils a = new AppleUtils();
        System.err.println(AppleUtils.isBundle(new File("/Users/grimnes")));
        System.err.println(AppleUtils.isBundle(new File("/Applications/Net/Firefox.app")));
        System.err.println(AppleUtils.isBundle(new File("/Users/grimnes/Documents/presentations/TRB - Nepomuk.key")));
        System.err.println(AppleUtils.isBundle(new File("/Users/grimnes/foaf-pimo.xml")));
    }

    public static String readWholeFileAsUTF8(String filename) throws IOException {
        return AppleUtils.readWholeFileAsEncoding(filename, "utf-8");
    }

    public static String readWholeFileAsEncoding(String filename, String encoding) throws IOException {
        int l;
        FileInputStream in = new FileInputStream(filename);
        BufferedReader r = new BufferedReader(AppleUtils.asEncoding(in, encoding), 1024);
        StringWriter sw = new StringWriter(1024);
        char[] buff = new char[1024];
        while (((Reader)r).ready() && (l = r.read(buff)) > 0) {
            sw.write(buff, 0, l);
        }
        ((Reader)r).close();
        sw.close();
        return sw.toString();
    }

    private static Reader asEncoding(InputStream in, String encoding) {
        Charset charset = Charset.forName(encoding);
        return new InputStreamReader(in, charset.newDecoder());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class AppleScriptException
    extends Exception {
        private static final long serialVersionUID = -5426568970373973484L;
        private Map<String, String> error;
        private String msg;

        public AppleScriptException(String string, Map<String, String> err) {
            super(string);
            this.msg = string;
            this.error = err;
        }

        public AppleScriptException(String string) {
            this.msg = string;
            this.error = new Hashtable<String, String>();
        }

        @Override
        public String toString() {
            return this.msg + ": " + this.error.toString();
        }
    }

    private class App
    extends ApplicationAdapter {
        private App() {
        }

        public void handleQuit(ApplicationEvent event) {
            if (AppleUtils.this.quit != null) {
                event.setHandled(false);
                try {
                    AppleUtils.this.quit.invoke(AppleUtils.this.quito, new Object[0]);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        public void handleAbout(ApplicationEvent event) {
            if (AppleUtils.this.about != null) {
                try {
                    event.setHandled(true);
                    AppleUtils.this.about.invoke(AppleUtils.this.abouto, new Object[0]);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        public void handlePreferences(ApplicationEvent event) {
            if (AppleUtils.this.pref != null) {
                try {
                    event.setHandled(true);
                    AppleUtils.this.pref.invoke(AppleUtils.this.prefo, new Object[0]);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

