/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.objects;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.utilities.TriState;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;

@GeneratedBy(value=JSDynamicObject.class)
public final class JSDynamicObjectGen {
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    private JSDynamicObjectGen() {
    }

    static {
        LibraryExport.register(JSDynamicObject.class, (LibraryExport[])new LibraryExport[]{new InteropLibraryExports()});
    }

    @GeneratedBy(value=JSDynamicObject.class)
    public static class InteropLibraryExports
    extends LibraryExport<InteropLibrary> {
        private InteropLibraryExports() {
            super(InteropLibrary.class, JSDynamicObject.class, false, false, 0);
        }

        protected InteropLibrary createUncached(Object receiver) {
            assert (receiver instanceof JSDynamicObject);
            Uncached uncached = new Uncached(receiver);
            return uncached;
        }

        protected InteropLibrary createCached(Object receiver) {
            assert (receiver instanceof JSDynamicObject);
            return new Cached(receiver);
        }

        @GeneratedBy(value=JSDynamicObject.class)
        public static class Uncached
        extends InteropLibrary {
            private final Class<? extends JSDynamicObject> receiverClass_;

            protected Uncached(Object receiver) {
                this.receiverClass_ = ((Object)((Object)((JSDynamicObject)((Object)receiver)))).getClass();
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (receiver.getClass() != this.receiverClass_ || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return CompilerDirectives.isExact((Object)receiver, this.receiverClass_);
            }

            public final boolean isAdoptable() {
                return false;
            }

            public final NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @CompilerDirectives.TruffleBoundary
            public TriState isIdenticalOrUndefined(Object arg0Value_, Object arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                JSDynamicObject arg0Value = (JSDynamicObject)((Object)arg0Value_);
                if (arg1Value instanceof JSDynamicObject) {
                    JSDynamicObject arg1Value_ = (JSDynamicObject)((Object)arg1Value);
                    return JSDynamicObject.IsIdenticalOrUndefined.doHostObject(arg0Value, arg1Value_);
                }
                return JSDynamicObject.IsIdenticalOrUndefined.doOther(arg0Value, arg1Value);
            }

            @CompilerDirectives.TruffleBoundary
            public int identityHashCode(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((JSDynamicObject)((Object)receiver)).identityHashCode();
            }
        }

        @GeneratedBy(value=JSDynamicObject.class)
        public static class Cached
        extends InteropLibrary {
            private final Class<? extends JSDynamicObject> receiverClass_;
            @CompilerDirectives.CompilationFinal
            private int state_0_;

            protected Cached(Object receiver) {
                JSDynamicObject castReceiver = (JSDynamicObject)((Object)receiver);
                this.receiverClass_ = ((Object)((Object)castReceiver)).getClass();
            }

            public boolean accepts(Object receiver) {
                assert (receiver.getClass() != this.receiverClass_ || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return CompilerDirectives.isExact((Object)receiver, this.receiverClass_);
            }

            private boolean fallbackGuard_(int state_0, JSDynamicObject arg0Value, Object arg1Value) {
                return (state_0 & 1) != 0 || !(arg1Value instanceof JSDynamicObject);
            }

            protected TriState isIdenticalOrUndefined(Object arg0Value_, Object arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                JSDynamicObject arg0Value = (JSDynamicObject)((Object)CompilerDirectives.castExact((Object)arg0Value_, this.receiverClass_));
                int state_0 = this.state_0_;
                if (state_0 != 0) {
                    if ((state_0 & 1) != 0 && arg1Value instanceof JSDynamicObject) {
                        JSDynamicObject arg1Value_ = (JSDynamicObject)((Object)arg1Value);
                        return JSDynamicObject.IsIdenticalOrUndefined.doHostObject(arg0Value, arg1Value_);
                    }
                    if ((state_0 & 2) != 0 && this.fallbackGuard_(state_0, arg0Value, arg1Value)) {
                        return JSDynamicObject.IsIdenticalOrUndefined.doOther(arg0Value, arg1Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value);
            }

            private TriState executeAndSpecialize(JSDynamicObject arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if (arg1Value instanceof JSDynamicObject) {
                    JSDynamicObject arg1Value_ = (JSDynamicObject)((Object)arg1Value);
                    this.state_0_ = state_0 |= 1;
                    return JSDynamicObject.IsIdenticalOrUndefined.doHostObject(arg0Value, arg1Value_);
                }
                this.state_0_ = state_0 |= 2;
                return JSDynamicObject.IsIdenticalOrUndefined.doOther(arg0Value, arg1Value);
            }

            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                }
                if ((state_0 & state_0 - 1) == 0) {
                    return NodeCost.MONOMORPHIC;
                }
                return NodeCost.POLYMORPHIC;
            }

            public int identityHashCode(Object receiver) throws UnsupportedMessageException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (this.assertAdopted());
                return ((JSDynamicObject)((Object)CompilerDirectives.castExact((Object)receiver, this.receiverClass_))).identityHashCode();
            }
        }
    }
}

