/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.js.builtins.IteratorFunctionBuiltinsFactory;
import com.oracle.truffle.js.builtins.IteratorPrototypeBuiltins;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.nodes.access.GetIteratorFlattenableNode;
import com.oracle.truffle.js.nodes.access.GetIteratorFromMethodNode;
import com.oracle.truffle.js.nodes.access.GetMethodNode;
import com.oracle.truffle.js.nodes.access.IsObjectNode;
import com.oracle.truffle.js.nodes.access.IteratorCompleteNode;
import com.oracle.truffle.js.nodes.access.IteratorNextNode;
import com.oracle.truffle.js.nodes.access.IteratorValueNode;
import com.oracle.truffle.js.nodes.binary.InstanceofNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSIterator;
import com.oracle.truffle.js.runtime.builtins.JSIteratorHelperObject;
import com.oracle.truffle.js.runtime.builtins.JSWrapForValidIterator;
import com.oracle.truffle.js.runtime.objects.IteratorRecord;
import com.oracle.truffle.js.runtime.objects.Undefined;

public final class IteratorFunctionBuiltins
extends JSBuiltinsContainer.SwitchEnum<IteratorFunction> {
    public static final JSBuiltinsContainer BUILTINS = new IteratorFunctionBuiltins();

    IteratorFunctionBuiltins() {
        super(JSIterator.CLASS_NAME, IteratorFunction.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, IteratorFunction builtinEnum) {
        switch (builtinEnum.ordinal()) {
            case 0: {
                return IteratorFunctionBuiltinsFactory.JSIteratorFromNodeGen.create(context, builtin, IteratorFunctionBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case 1: {
                return IteratorFunctionBuiltinsFactory.IteratorConcatNodeGen.create(context, builtin, IteratorFunctionBuiltins.args().varArgs().createArgumentNodes(context));
            }
        }
        return null;
    }

    public static enum IteratorFunction implements BuiltinEnum<IteratorFunction>
    {
        from(1),
        concat(0);

        private final int length;

        private IteratorFunction(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public int getECMAScriptVersion() {
            if (this == concat) {
                return 16;
            }
            return BuiltinEnum.super.getECMAScriptVersion();
        }
    }

    public static abstract class JSIteratorFromNode
    extends JSBuiltinNode {
        @Node.Child
        private GetIteratorFlattenableNode getIteratorFlattenableNode;
        @Node.Child
        private InstanceofNode.OrdinaryHasInstanceNode ordinaryHasInstanceNode;

        protected JSIteratorFromNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.getIteratorFlattenableNode = GetIteratorFlattenableNode.create(false, false, context);
            this.ordinaryHasInstanceNode = InstanceofNode.OrdinaryHasInstanceNode.create(context);
        }

        @Specialization
        protected Object iteratorFrom(Object arg) {
            IteratorRecord iteratorRecord = this.getIteratorFlattenableNode.execute(arg);
            JSRealm realm = this.getRealm();
            boolean hasInstance = this.ordinaryHasInstanceNode.executeBoolean(iteratorRecord.getIterator(), (Object)realm.getIteratorConstructor());
            if (hasInstance) {
                return iteratorRecord.getIterator();
            }
            return JSWrapForValidIterator.create(this.getContext(), realm, iteratorRecord);
        }
    }

    @ImportStatic(value={Symbol.class})
    public static abstract class IteratorConcatNode
    extends IteratorPrototypeBuiltins.IteratorFromGeneratorNode<ConcatArgs> {
        protected IteratorConcatNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin, JSContext.BuiltinFunctionKey.IteratorConcat, c -> IteratorConcatNode.createIteratorFromGeneratorFunctionImpl(c, IteratorConcatNextNode.create(c)));
        }

        @Specialization
        protected final Object iteratorConcat(Object[] items, @Cached IsObjectNode isObjectNode, @Cached(parameters={"getContext()", "SYMBOL_ITERATOR"}) GetMethodNode getIteratorMethodNode, @Cached InlinedBranchProfile errorBranch) {
            Iterable[] iterables = new Iterable[items.length];
            for (int i = 0; i < items.length; ++i) {
                Object item = items[i];
                if (!isObjectNode.executeBoolean(item)) {
                    errorBranch.enter((Node)this);
                    throw Errors.createTypeErrorNotAnObject(item);
                }
                Object method = getIteratorMethodNode.executeWithTarget(item);
                if (method == Undefined.instance) {
                    errorBranch.enter((Node)this);
                    throw Errors.createTypeErrorNotIterable(item, this);
                }
                iterables[i] = new Iterable(method, item);
            }
            return this.createIteratorHelperObject(new ConcatArgs(iterables));
        }
    }

    protected static abstract class IteratorConcatNextNode
    extends IteratorPrototypeBuiltins.IteratorFromGeneratorNode.IteratorFromGeneratorImplNode<ConcatArgs> {
        protected IteratorConcatNextNode(JSContext context) {
            super(context);
        }

        @Specialization
        protected final Object next(VirtualFrame frame, JSIteratorHelperObject thisObj, @Cached GetIteratorFromMethodNode getIteratorFromMethodNode, @Cached IteratorNextNode iteratorNextNode, @Cached IteratorCompleteNode iteratorCompleteNode, @Cached IteratorValueNode iteratorValueNode) {
            ConcatArgs args = (ConcatArgs)this.getArgs(thisObj);
            Iterable[] iterables = args.iterables;
            int iterableIndex = args.iterableIndex;
            while (iterableIndex < iterables.length) {
                IteratorRecord iterator = args.innerIterator;
                if (!args.innerAlive) {
                    Iterable iterable = iterables[iterableIndex];
                    args.innerIterator = iterator = getIteratorFromMethodNode.execute(this, iterable.iterable, iterable.openMethod);
                    args.innerAlive = true;
                }
                assert (args.innerAlive && iterator != null);
                Object result = iteratorNextNode.execute(iterator);
                boolean done = iteratorCompleteNode.execute(result);
                if (done) {
                    iteratorValueNode.execute(result);
                    args.innerAlive = false;
                    args.innerIterator = null;
                    args.iterableIndex = ++iterableIndex;
                    continue;
                }
                return IteratorConcatNextNode.generatorYield(thisObj, result);
            }
            return this.createResultDone(frame, thisObj);
        }

        @Override
        public IteratorPrototypeBuiltins.IteratorFromGeneratorNode.IteratorFromGeneratorImplNode<ConcatArgs> copyUninitialized() {
            return IteratorConcatNextNode.create(this.context);
        }

        static IteratorConcatNextNode create(JSContext context) {
            return IteratorFunctionBuiltinsFactory.IteratorConcatNextNodeGen.create(context);
        }
    }

    static final class ConcatArgs
    extends IteratorPrototypeBuiltins.IteratorArgs {
        private final Iterable[] iterables;
        private int iterableIndex;
        boolean innerAlive;
        IteratorRecord innerIterator;

        ConcatArgs(Iterable[] iterables) {
            super(null);
            this.iterables = iterables;
        }
    }

    private record Iterable(Object openMethod, Object iterable) {
    }
}

