/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins.intl;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.intl.CollatorPrototypeBuiltinsFactory;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.access.PropertySetNode;
import com.oracle.truffle.js.nodes.cast.JSToStringNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JavaScriptRootNode;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSFunctionData;
import com.oracle.truffle.js.runtime.builtins.JSFunctionObject;
import com.oracle.truffle.js.runtime.builtins.intl.JSCollator;
import com.oracle.truffle.js.runtime.builtins.intl.JSCollatorObject;
import com.oracle.truffle.js.runtime.objects.Undefined;

public final class CollatorPrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<CollatorPrototype> {
    public static final JSBuiltinsContainer BUILTINS = new CollatorPrototypeBuiltins();

    protected CollatorPrototypeBuiltins() {
        super(JSCollator.PROTOTYPE_NAME, CollatorPrototype.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, CollatorPrototype builtinEnum) {
        switch (builtinEnum.ordinal()) {
            case 0: {
                return CollatorPrototypeBuiltinsFactory.JSCollatorResolvedOptionsNodeGen.create(context, builtin, CollatorPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 1: {
                return CollatorPrototypeBuiltinsFactory.JSCollatorGetCompareNodeGen.create(context, builtin, CollatorPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
        }
        return null;
    }

    public static enum CollatorPrototype implements BuiltinEnum<CollatorPrototype>
    {
        resolvedOptions(0),
        compare(0);

        private final int length;

        private CollatorPrototype(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public boolean isGetter() {
            return this == compare;
        }
    }

    public static abstract class JSCollatorResolvedOptionsNode
    extends JSBuiltinNode {
        public JSCollatorResolvedOptionsNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        public Object doResolvedOptions(JSCollatorObject collator) {
            return JSCollator.resolvedOptions(this.getContext(), this.getRealm(), collator);
        }

        @Fallback
        public Object doIncompatibleReceiver(Object bummer) {
            throw Errors.createTypeErrorTypeXExpected(JSCollator.CLASS_NAME);
        }
    }

    public static abstract class JSCollatorGetCompareNode
    extends JSBuiltinNode {
        static final HiddenKey BOUND_OBJECT_KEY = new HiddenKey(Strings.toJavaString(JSCollator.CLASS_NAME));
        @Node.Child
        private PropertySetNode setBoundObjectNode;

        public JSCollatorGetCompareNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.setBoundObjectNode = PropertySetNode.createSetHidden(BOUND_OBJECT_KEY, context);
        }

        @Specialization
        public Object doCollator(JSCollatorObject collatorObj, @Cached InlinedBranchProfile errorBranch) {
            JSCollator.InternalState state = JSCollator.getInternalState(collatorObj);
            if (state == null || !state.isInitializedCollator()) {
                errorBranch.enter((Node)this);
                throw Errors.createTypeErrorMethodCalledOnNonObjectOrWrongType("compare");
            }
            if (state.getBoundCompareFunction() == null) {
                JSFunctionData compareFunctionData = this.getContext().getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.CollatorCompare, c -> JSCollatorGetCompareNode.createCompareFunctionData(c));
                JSFunctionObject compareFn = JSFunction.create(this.getRealm(), compareFunctionData);
                this.setBoundObjectNode.setValue((Object)compareFn, (Object)collatorObj);
                state.setBoundCompareFunction(compareFn);
            }
            return state.getBoundCompareFunction();
        }

        @Fallback
        public Object doIncompatibleReceiver(Object bummer) {
            throw Errors.createTypeErrorTypeXExpected(JSCollator.CLASS_NAME);
        }

        private static JSFunctionData createCompareFunctionData(final JSContext context) {
            return JSFunctionData.createCallOnly(context, (CallTarget)new JavaScriptRootNode(context.getLanguage(), null, null){
                @Node.Child
                private PropertyGetNode getBoundObjectNode;
                @Node.Child
                private JSToStringNode toString1Node;
                @Node.Child
                private JSToStringNode toString2Node;
                {
                    super(lang, sourceSection, frameDescriptor);
                    this.getBoundObjectNode = PropertyGetNode.createGetHidden(BOUND_OBJECT_KEY, context);
                    this.toString1Node = JSToStringNode.create();
                    this.toString2Node = JSToStringNode.create();
                }

                public Object execute(VirtualFrame frame) {
                    Object[] arguments = frame.getArguments();
                    JSCollatorObject thisObj = (JSCollatorObject)((Object)this.getBoundObjectNode.getValue(JSArguments.getFunctionObject(arguments)));
                    int argumentCount = JSArguments.getUserArgumentCount(arguments);
                    String one = Strings.toJavaString(argumentCount > 0 ? this.toString1Node.executeString(JSArguments.getUserArgument(arguments, 0)) : Undefined.NAME);
                    String two = Strings.toJavaString(argumentCount > 1 ? this.toString2Node.executeString(JSArguments.getUserArgument(arguments, 1)) : Undefined.NAME);
                    return JSCollator.compare(thisObj, one, two);
                }
            }.getCallTarget(), 2, Strings.EMPTY_STRING);
        }
    }
}

