/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.cast;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.cast.JSToPrimitiveNode;
import com.oracle.truffle.js.nodes.cast.JSToPropertyKeyNodeGen;
import com.oracle.truffle.js.nodes.cast.JSToStringNode;
import com.oracle.truffle.js.nodes.unary.JSUnaryNode;
import com.oracle.truffle.js.runtime.Symbol;
import java.util.Set;

public abstract class JSToPropertyKeyNode
extends JavaScriptBaseNode {
    @NeverDefault
    public static JSToPropertyKeyNode create() {
        return JSToPropertyKeyNodeGen.create();
    }

    public abstract Object execute(Object var1);

    @Specialization
    protected TruffleString doTString(TruffleString value) {
        return value;
    }

    @Specialization
    protected Symbol doSymbol(Symbol value) {
        return value;
    }

    @Specialization(guards={"!isSymbol(value)"})
    protected Object doOther(Object value, @Cached(value="createHintString()") JSToPrimitiveNode toPrimitiveNode, @Cached JSToStringNode toStringNode, @Cached InlinedConditionProfile isSymbol) {
        Object key = toPrimitiveNode.execute(value);
        if (isSymbol.profile((Node)this, key instanceof Symbol)) {
            return key;
        }
        return toStringNode.executeString(key);
    }

    public static abstract class JSToPropertyKeyWrapperNode
    extends JSUnaryNode {
        protected JSToPropertyKeyWrapperNode(JavaScriptNode operand) {
            super(operand);
        }

        public static JavaScriptNode create(JavaScriptNode key) {
            if (key.isResultAlwaysOfType(TruffleString.class) || key.isResultAlwaysOfType(Symbol.class)) {
                return key;
            }
            return JSToPropertyKeyNodeGen.JSToPropertyKeyWrapperNodeGen.create(key);
        }

        @Specialization
        protected static Object doDefault(Object value, @Cached JSToPropertyKeyNode toPropertyKeyNode) {
            return toPropertyKeyNode.execute(value);
        }

        @Override
        protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
            return JSToPropertyKeyNodeGen.JSToPropertyKeyWrapperNodeGen.create(JSToPropertyKeyWrapperNode.cloneUninitialized(this.getOperand(), materializedTags));
        }
    }
}

