/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.lang.JavaScriptLanguage;
import com.oracle.truffle.js.nodes.access.ReadElementNode;
import com.oracle.truffle.js.nodes.access.WriteElementNode;
import com.oracle.truffle.js.nodes.interop.ExportValueNode;
import com.oracle.truffle.js.nodes.interop.ImportValueNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.ToDisplayStringFormat;
import com.oracle.truffle.js.runtime.array.TypedArray;
import com.oracle.truffle.js.runtime.builtins.JSArrayBufferObject;
import com.oracle.truffle.js.runtime.builtins.JSArrayBufferView;
import com.oracle.truffle.js.runtime.builtins.JSArrayBufferViewBase;
import com.oracle.truffle.js.runtime.builtins.JSNonProxy;
import com.oracle.truffle.js.runtime.builtins.JSSharedArrayBuffer;
import com.oracle.truffle.js.runtime.interop.InteropArray;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.Undefined;

@ExportLibrary(value=InteropLibrary.class)
public final class JSTypedArrayObject
extends JSArrayBufferViewBase {
    final TypedArray arrayType;

    protected JSTypedArrayObject(Shape shape, JSDynamicObject proto, TypedArray arrayType, JSArrayBufferObject arrayBuffer, int length, int offset) {
        super(shape, proto, arrayBuffer, length, offset);
        this.arrayType = arrayType;
    }

    @NeverDefault
    public TypedArray getArrayType() {
        return this.arrayType;
    }

    public int getLengthFixed() {
        assert (!this.hasAutoLength());
        return this.length;
    }

    public int getLength() {
        return this.hasAutoLength() ? this.arrayBuffer.getByteLength() - this.offset >> this.arrayType.bytesPerElementShift() : this.length;
    }

    public int getByteLength() {
        return this.hasAutoLength() ? this.arrayBuffer.getByteLength() - this.offset : this.length << this.arrayType.bytesPerElementShift();
    }

    public static JSTypedArrayObject create(Shape shape, JSDynamicObject proto, TypedArray arrayType, JSArrayBufferObject arrayBuffer, int length, int offset) {
        return new JSTypedArrayObject(shape, proto, arrayType, arrayBuffer, length, offset);
    }

    @Override
    public TruffleString getClassName() {
        return JSArrayBufferView.typedArrayGetName(this);
    }

    @ExportMessage
    public Object getMembers(boolean includeInternal, @CachedLibrary(value="this") InteropLibrary self) {
        assert (JSObject.getJSClass(this) == JSArrayBufferView.INSTANCE);
        boolean includeArrayIndices = JSTypedArrayObject.language(self).getJSContext().getLanguageOptions().arrayElementsAmongMembers();
        if (includeArrayIndices) {
            return InteropArray.create(JSObject.enumerableOwnNames(this));
        }
        return InteropArray.create(JSTypedArrayObject.filterEnumerableNames(this, JSNonProxy.ordinaryOwnPropertyKeys(this), JSArrayBufferView.INSTANCE));
    }

    @ExportMessage
    public boolean hasArrayElements() {
        return true;
    }

    @ExportMessage
    public long getArraySize() {
        return this.getLength();
    }

    @ExportMessage
    public Object readArrayElement(long index, @CachedLibrary(value="this") InteropLibrary self, @Cached(value="create(language(self).getJSContext())", uncached="getUncachedRead()") ReadElementNode readNode, @Cached ExportValueNode exportNode) throws InvalidArrayIndexException, UnsupportedMessageException {
        JSTypedArrayObject target = this;
        if (index < 0L || index >= self.getArraySize((Object)this)) {
            throw InvalidArrayIndexException.create((long)index);
        }
        Object result = readNode == null ? JSArrayBufferView.INSTANCE.getOwnHelper((JSDynamicObject)target, (Object)target, index, (Node)self) : readNode.executeWithTargetAndIndexOrDefault((Object)target, index, (Object)Undefined.instance);
        return exportNode.execute(result);
    }

    @ExportMessage.Repeat(value={@ExportMessage(name="isArrayElementReadable"), @ExportMessage(name="isArrayElementModifiable")})
    public boolean isArrayElementReadable(long index, @CachedLibrary(value="this") InteropLibrary thisLibrary) {
        try {
            return index >= 0L && index < thisLibrary.getArraySize((Object)this);
        }
        catch (UnsupportedMessageException e) {
            throw Errors.shouldNotReachHere(e);
        }
    }

    @ExportMessage
    public void writeArrayElement(long index, Object value, @Cached ImportValueNode castValueNode, @Cached(value="createCachedInterop()", uncached="getUncachedWrite()") WriteElementNode writeNode, @CachedLibrary(value="this") InteropLibrary self) throws InvalidArrayIndexException, UnsupportedMessageException {
        JSTypedArrayObject target = this;
        if (index < 0L || index >= self.getArraySize((Object)this)) {
            throw InvalidArrayIndexException.create((long)index);
        }
        Object importedValue = castValueNode.executeWithTarget(value);
        if (writeNode == null) {
            JSArrayBufferView.INSTANCE.set((JSDynamicObject)target, index, importedValue, (Object)target, true, (Node)self);
        } else {
            writeNode.executeWithTargetAndIndexAndValue((Object)target, index, importedValue);
        }
    }

    @ExportMessage
    public boolean isArrayElementInsertable(long index) {
        return false;
    }

    @Override
    public boolean testIntegrityLevel(boolean frozen) {
        if (frozen && this.getArraySize() > 0L) {
            return false;
        }
        return JSNonProxy.testIntegrityLevelFast(this, frozen);
    }

    @Override
    public boolean setIntegrityLevel(boolean freeze, boolean doThrow) {
        this.preventExtensions(doThrow);
        if (freeze && this.getArraySize() > 0L) {
            throw Errors.createTypeErrorCannotRedefineTypedArrayElement();
        }
        JSNonProxy.setIntegrityLevelFast(this, freeze);
        return true;
    }

    public boolean isFixedLength() {
        return !this.hasAutoLength() && (this.getArrayBuffer().isFixedLength() || JSSharedArrayBuffer.isJSSharedArrayBuffer((Object)this.getArrayBuffer()));
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean preventExtensions(boolean doThrow) {
        if (!this.isFixedLength()) {
            if (doThrow) {
                throw Errors.createTypeError("Cannot prevent extensions of variable-length typed array");
            }
            return false;
        }
        return super.preventExtensions(doThrow);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public TruffleString toDisplayStringImpl(boolean allowSideEffects, ToDisplayStringFormat format, int depth) {
        if (JavaScriptLanguage.get(null).getJSContext().isOptionNashornCompatibilityMode()) {
            return this.defaultToString();
        }
        return JSRuntime.objectToDisplayString(this, allowSideEffects, format, depth, JSArrayBufferView.typedArrayGetName(this));
    }
}

