/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.util;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.js.runtime.JSContextOptions;
import com.oracle.truffle.js.runtime.JSRealm;
import java.util.Objects;
import java.util.function.Function;
import org.graalvm.options.OptionKey;

public final class StableContextOptionValue<T> {
    @CompilerDirectives.CompilationFinal
    private Assumption stableAssumption = ASSUMPTION_UNINITIALIZED;
    @CompilerDirectives.CompilationFinal
    private T stableValue;
    private final Function<JSContextOptions, T> getter;
    private final OptionKey<T> optionKey;
    private final String optionName;
    private static final Assumption ASSUMPTION_UNINITIALIZED = Assumption.NEVER_VALID;

    public StableContextOptionValue(Function<JSContextOptions, T> getter, OptionKey<T> optionKey, String optionName) {
        this.stableValue = optionKey.getDefaultValue();
        this.getter = getter;
        this.optionKey = optionKey;
        this.optionName = optionName;
    }

    public T get() {
        assert (this.isInitialized()) : "Stable context option " + this.optionName + " accessed before initialization.";
        if (this.stableAssumption.isValid()) {
            assert (Objects.equals(this.stableValue, this.getFromContext()));
            return this.stableValue;
        }
        return this.getFromContext();
    }

    public T getFromContext() {
        return this.getter.apply(JSRealm.get(null).getContextOptions());
    }

    private boolean isInitialized() {
        return this.stableAssumption != ASSUMPTION_UNINITIALIZED;
    }

    public void update(JSContextOptions contextOptions, UpdateKind kind) {
        T newValue = this.getter.apply(contextOptions);
        switch (kind.ordinal()) {
            case 0: {
                this.setInitialValue(newValue);
                break;
            }
            case 1: {
                this.updateValue(newValue);
                break;
            }
            case 2: {
                this.patchValue(newValue);
            }
        }
    }

    private synchronized void setInitialValue(T initialValue) {
        CompilerAsserts.neverPartOfCompilation();
        assert (!this.isInitialized());
        assert (Objects.equals(this.stableValue, this.optionKey.getDefaultValue()));
        this.stableValue = initialValue;
        this.stableAssumption = this.makeAssumption();
    }

    private synchronized void updateValue(T newValue) {
        CompilerAsserts.neverPartOfCompilation();
        assert (this.isInitialized());
        T oldValue = this.stableValue;
        if (!Objects.equals(oldValue, newValue)) {
            this.invalidateAssumption(newValue, oldValue);
        }
    }

    private synchronized void patchValue(T newValue) {
        CompilerAsserts.neverPartOfCompilation();
        if (!this.isInitialized()) {
            this.setInitialValue(newValue);
        } else {
            this.updateValue(newValue);
        }
    }

    private Assumption makeAssumption() {
        return Assumption.create((String)this.optionName);
    }

    private void invalidateAssumption(T newValue, T oldValue) {
        Assumption oldAssumption = this.stableAssumption;
        if (oldAssumption.isValid()) {
            oldAssumption.invalidate(String.format("Option %s was changed from %s to %s.", this.optionName, oldValue, newValue));
        }
    }

    public int hashCode() {
        return this.optionKey.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof StableContextOptionValue)) return false;
        StableContextOptionValue other = (StableContextOptionValue)obj;
        if (other.optionKey != this.optionKey) return false;
        return true;
    }

    public static enum UpdateKind {
        INITIALIZE,
        UPDATE,
        PATCH;

    }
}

