/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.meta.AnalysisType;
import java.util.HashMap;
import java.util.Map;
import jdk.vm.ci.meta.JavaConstant;

public abstract class HeapScanningPolicy {
    public abstract boolean trackConstant(BigBang var1, JavaConstant var2);

    public abstract boolean scanConstant(BigBang var1, JavaConstant var2);

    public static HeapScanningPolicy scanAll() {
        return new ScanAllPolicy();
    }

    public static HeapScanningPolicy skipTypes(AnalysisType ... skipTypes) {
        return new SkipTypesPolicy(skipTypes);
    }

    static class SkipTypesPolicy
    extends HeapScanningPolicy {
        final Map<AnalysisType, SkipData> skipTypes = new HashMap<AnalysisType, SkipData>();

        SkipTypesPolicy(AnalysisType ... types) {
            for (AnalysisType type : types) {
                this.skipTypes.put(type, new SkipData());
            }
        }

        @Override
        public boolean trackConstant(BigBang bb, JavaConstant constant) {
            AnalysisType type = bb.getMetaAccess().lookupJavaType(constant);
            SkipData data = this.skipTypes.get(type);
            if (data != null) {
                if (data.seenForTracking) {
                    return false;
                }
                data.seenForTracking = true;
                return true;
            }
            return true;
        }

        @Override
        public boolean scanConstant(BigBang bb, JavaConstant constant) {
            AnalysisType type = bb.getMetaAccess().lookupJavaType(constant);
            SkipData data = this.skipTypes.get(type);
            if (data != null) {
                if (data.seenForScanning) {
                    return false;
                }
                data.seenForScanning = true;
                return true;
            }
            return true;
        }

        static class SkipData {
            volatile boolean seenForTracking;
            volatile boolean seenForScanning;

            SkipData() {
            }
        }
    }

    static class ScanAllPolicy
    extends HeapScanningPolicy {
        ScanAllPolicy() {
        }

        @Override
        public boolean trackConstant(BigBang bb, JavaConstant constant) {
            return true;
        }

        @Override
        public boolean scanConstant(BigBang bb, JavaConstant constant) {
            return true;
        }
    }
}

