/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow;

import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.typestate.TypeState;
import com.oracle.graal.pointsto.util.AnalysisError;
import jdk.vm.ci.code.BytecodePosition;
import org.graalvm.compiler.nodes.ValueNode;

public abstract class SourceTypeFlowBase
extends TypeFlow<BytecodePosition> {
    protected final TypeState sourceState;

    public SourceTypeFlowBase(ValueNode node, TypeState state) {
        this(node, state.exactType(), state);
    }

    public SourceTypeFlowBase(ValueNode node, AnalysisType declaredType, TypeState state) {
        super(node.getNodeSourcePosition(), declaredType);
        this.sourceState = state;
    }

    public SourceTypeFlowBase(PointsToAnalysis bb, SourceTypeFlowBase original, MethodFlowsGraph methodFlows) {
        this(bb, original, methodFlows, original.sourceState);
    }

    public SourceTypeFlowBase(PointsToAnalysis bb, SourceTypeFlowBase original, MethodFlowsGraph methodFlows, TypeState state) {
        super(original, methodFlows);
        this.sourceState = state;
    }

    @Override
    public void initClone(PointsToAnalysis bb) {
        if (this.sourceState.isNull() || this.sourceState.isEmpty() || bb.getAllInstantiatedTypeFlow().getState().containsType(this.sourceState.exactType())) {
            this.addState(bb, this.sourceState);
        } else {
            this.addState(bb, this.sourceState.canBeNull() ? TypeState.forNull() : TypeState.forEmpty());
            bb.getAllInstantiatedTypeFlow().addObserver(bb, this);
        }
    }

    @Override
    public void onObservedUpdate(PointsToAnalysis bb) {
        if (bb.getAllInstantiatedTypeFlow().getState().containsType(this.sourceState.exactType())) {
            bb.getAllInstantiatedTypeFlow().removeObserver(this);
            this.addState(bb, this.sourceState);
        }
    }

    @Override
    public void onObservedSaturated(PointsToAnalysis bb, TypeFlow<?> observed) {
        AnalysisError.shouldNotReachHere("NewInstanceTypeFlow cannot saturate.");
    }

    @Override
    protected void onInputSaturated(PointsToAnalysis bb, TypeFlow<?> input) {
        AnalysisError.shouldNotReachHere("NewInstanceTypeFlow cannot saturate.");
    }

    @Override
    protected void onSaturated(PointsToAnalysis bb) {
        AnalysisError.shouldNotReachHere("NewInstanceTypeFlow cannot saturate.");
    }

    @Override
    public boolean canSaturate() {
        return false;
    }

    @Override
    public boolean addState(PointsToAnalysis bb, TypeState add) {
        assert (this.isClone());
        return super.addState(bb, add);
    }
}

