/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow;

import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.api.PointstoOptions;
import com.oracle.graal.pointsto.flow.AbstractVirtualInvokeTypeFlow;
import com.oracle.graal.pointsto.flow.ActualReturnTypeFlow;
import com.oracle.graal.pointsto.flow.FormalParamTypeFlow;
import com.oracle.graal.pointsto.flow.FormalReceiverTypeFlow;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.flow.context.object.AnalysisObject;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.InvokeInfo;
import com.oracle.graal.pointsto.meta.PointsToAnalysisMethod;
import com.oracle.graal.pointsto.typestate.SingleTypeState;
import com.oracle.graal.pointsto.typestate.TypeState;
import java.util.Collection;
import jdk.vm.ci.code.BytecodePosition;

public abstract class InvokeTypeFlow
extends TypeFlow<BytecodePosition>
implements InvokeInfo {
    protected final TypeFlow<?>[] actualParameters;
    protected ActualReturnTypeFlow actualReturn;
    protected final InvokeTypeFlow originalInvoke;
    protected final AnalysisType receiverType;
    protected final PointsToAnalysisMethod targetMethod;
    protected boolean isContextInsensitive;

    protected InvokeTypeFlow(BytecodePosition invokeLocation, AnalysisType receiverType, PointsToAnalysisMethod targetMethod, TypeFlow<?>[] actualParameters, ActualReturnTypeFlow actualReturn) {
        super(invokeLocation, null);
        this.originalInvoke = null;
        this.receiverType = receiverType;
        this.targetMethod = targetMethod;
        this.actualParameters = actualParameters;
        this.actualReturn = actualReturn;
        this.getTargetMethod().registerAsInvoked(this);
    }

    protected InvokeTypeFlow(PointsToAnalysis bb, MethodFlowsGraph methodFlows, InvokeTypeFlow original) {
        super(original, methodFlows);
        this.originalInvoke = original;
        this.receiverType = original.receiverType;
        this.targetMethod = original.targetMethod;
        this.actualReturn = original.getActualReturn() != null ? (ActualReturnTypeFlow)methodFlows.lookupCloneOf(bb, original.getActualReturn()) : null;
        this.actualParameters = new TypeFlow[original.actualParameters.length];
        for (int i = 0; i < original.actualParameters.length; ++i) {
            if (original.getActualParameter(i) == null) continue;
            this.actualParameters[i] = methodFlows.lookupCloneOf(bb, original.getActualParameter(i));
        }
    }

    public void markAsContextInsensitive() {
        this.isContextInsensitive = true;
    }

    @Override
    public boolean isContextInsensitive() {
        return this.isContextInsensitive;
    }

    public AnalysisType getReceiverType() {
        return this.receiverType;
    }

    @Override
    public PointsToAnalysisMethod getTargetMethod() {
        return this.targetMethod;
    }

    public int actualParametersCount() {
        return this.actualParameters.length;
    }

    public TypeFlow<?>[] getActualParameters() {
        return this.actualParameters;
    }

    public TypeFlow<?> getReceiver() {
        return this.actualParameters[0];
    }

    public InvokeTypeFlow getOriginalInvoke() {
        return this.originalInvoke;
    }

    @Override
    public void setObserved(TypeFlow<?> newReceiver) {
        this.actualParameters[0] = newReceiver;
    }

    public TypeFlow<?> getActualParameter(int index) {
        return this.actualParameters[index];
    }

    public TypeFlow<?> getActualReturn() {
        return this.actualReturn;
    }

    public void setActualReturn(PointsToAnalysis bb, boolean isStatic, ActualReturnTypeFlow actualReturn) {
        this.actualReturn = actualReturn;
        bb.analysisPolicy().linkActualReturn(bb, isStatic, this);
    }

    public TypeFlow<?> getResult() {
        return this.actualReturn;
    }

    protected TypeState filterReceiverState(PointsToAnalysis bb, TypeState invokeState) {
        if (bb.analysisPolicy().relaxTypeFlowConstraints()) {
            return TypeState.forIntersection(bb, invokeState, this.receiverType.getAssignableTypes(true));
        }
        return invokeState;
    }

    protected void updateReceiver(PointsToAnalysis bb, MethodFlowsGraph calleeFlows, AnalysisObject receiverObject) {
        SingleTypeState receiverTypeState = TypeState.forExactType(bb, receiverObject, false);
        this.updateReceiver(bb, calleeFlows, receiverTypeState);
    }

    protected void updateReceiver(PointsToAnalysis bb, MethodFlowsGraph calleeFlows, TypeState receiverTypeState) {
        FormalReceiverTypeFlow formalReceiverFlow = calleeFlows.getFormalReceiver();
        if (formalReceiverFlow != null) {
            formalReceiverFlow.addReceiverState(bb, receiverTypeState);
        }
        if (((Boolean)PointstoOptions.DivertParameterReturningMethod.getValue(bb.getOptions())).booleanValue()) {
            int paramIndex = calleeFlows.getMethod().getTypeFlow().getReturnedParameterIndex();
            if (this.actualReturn != null && paramIndex == 0) {
                this.actualReturn.addState(bb, receiverTypeState);
            }
        }
    }

    protected void linkCallee(PointsToAnalysis bb, boolean isStatic, MethodFlowsGraph calleeFlows) {
        for (int i = 0; i < this.actualParameters.length; ++i) {
            TypeFlow<BytecodePosition> actualParam = this.actualParameters[i];
            FormalParamTypeFlow formalParam = calleeFlows.getParameter(i);
            if (actualParam == null || formalParam == null) continue;
            actualParam.addUse(bb, formalParam);
        }
        this.linkReturn(bb, isStatic, calleeFlows);
        bb.analysisPolicy().registerAsImplementationInvoked(this, calleeFlows);
    }

    public void linkReturn(PointsToAnalysis bb, boolean isStatic, MethodFlowsGraph calleeFlows) {
        if (this.actualReturn != null) {
            if (((Boolean)PointstoOptions.DivertParameterReturningMethod.getValue(bb.getOptions())).booleanValue()) {
                int paramNodeIndex = calleeFlows.getMethod().getTypeFlow().getReturnedParameterIndex();
                if (paramNodeIndex != -1) {
                    if (isStatic || paramNodeIndex != 0) {
                        TypeFlow<BytecodePosition> actualParam = this.actualParameters[paramNodeIndex];
                        actualParam.addUse(bb, this.actualReturn);
                    }
                } else if (calleeFlows.getReturnFlow() != null) {
                    calleeFlows.getReturnFlow().addUse(bb, this.actualReturn);
                }
            } else if (calleeFlows.getReturnFlow() != null) {
                calleeFlows.getReturnFlow().addUse(bb, this.actualReturn);
            }
        }
    }

    public static boolean isContextInsensitiveVirtualInvoke(InvokeTypeFlow invoke) {
        return invoke instanceof AbstractVirtualInvokeTypeFlow && invoke.isContextInsensitive();
    }

    @Override
    public abstract Collection<AnalysisMethod> getCallees();

    @Override
    public BytecodePosition getPosition() {
        return (BytecodePosition)this.getSource();
    }

    @Override
    public boolean canBeStaticallyBound() {
        boolean triviallyStaticallyBound = this.targetMethod.canBeStaticallyBound();
        if (triviallyStaticallyBound) {
            assert (this.getCallees().size() <= 1) : "Statically bound result mismatch between analysis and host VM.";
            return true;
        }
        return this.getCallees().size() == 1;
    }

    public abstract Collection<MethodFlowsGraph> getCalleesFlows(PointsToAnalysis var1);
}

