/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow.context.bytecode;

import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.AbstractVirtualInvokeTypeFlow;
import com.oracle.graal.pointsto.flow.ActualReturnTypeFlow;
import com.oracle.graal.pointsto.flow.CallSiteSensitiveMethodTypeFlow;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.MethodFlowsGraphClone;
import com.oracle.graal.pointsto.flow.MethodTypeFlow;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.flow.context.AnalysisContext;
import com.oracle.graal.pointsto.flow.context.bytecode.BytecodeAnalysisContext;
import com.oracle.graal.pointsto.flow.context.bytecode.BytecodeSensitiveAnalysisPolicy;
import com.oracle.graal.pointsto.flow.context.bytecode.TypesObjectsIterator;
import com.oracle.graal.pointsto.flow.context.object.AnalysisObject;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.PointsToAnalysisMethod;
import com.oracle.graal.pointsto.typestate.TypeState;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import jdk.vm.ci.code.BytecodePosition;

final class BytecodeSensitiveVirtualInvokeTypeFlow
extends AbstractVirtualInvokeTypeFlow {
    private final ConcurrentMap<MethodFlowsGraph, Object> calleesFlows = new ConcurrentHashMap<MethodFlowsGraph, Object>(4, 0.75f, 1);
    private final AnalysisContext callerContext;

    BytecodeSensitiveVirtualInvokeTypeFlow(BytecodePosition invokeLocation, AnalysisType receiverType, PointsToAnalysisMethod targetMethod, TypeFlow<?>[] actualParameters, ActualReturnTypeFlow actualReturn) {
        super(invokeLocation, receiverType, targetMethod, actualParameters, actualReturn);
        this.callerContext = null;
    }

    private BytecodeSensitiveVirtualInvokeTypeFlow(PointsToAnalysis bb, MethodFlowsGraph methodFlows, BytecodeSensitiveVirtualInvokeTypeFlow original) {
        super(bb, methodFlows, original);
        this.callerContext = ((MethodFlowsGraphClone)methodFlows).context();
    }

    @Override
    public TypeFlow<BytecodePosition> copy(PointsToAnalysis bb, MethodFlowsGraph methodFlows) {
        return new BytecodeSensitiveVirtualInvokeTypeFlow(bb, methodFlows, this);
    }

    @Override
    public void onObservedUpdate(PointsToAnalysis bb) {
        assert (this.isClone() || this.isContextInsensitive());
        TypeState receiverState = this.getReceiver().getState();
        if ((receiverState = this.filterReceiverState(bb, receiverState)).isEmpty() || receiverState.isNull()) {
            return;
        }
        TypesObjectsIterator toi = new TypesObjectsIterator(receiverState);
        while (toi.hasNextType()) {
            AnalysisType type = toi.nextType();
            AnalysisMethod method = type.resolveConcreteMethod(this.getTargetMethod());
            if (method == null || Modifier.isAbstract(method.getModifiers())) {
                while (toi.hasNextObject(type)) {
                    toi.nextObject(type);
                }
                continue;
            }
            assert (!Modifier.isAbstract(method.getModifiers()));
            CallSiteSensitiveMethodTypeFlow callee = (CallSiteSensitiveMethodTypeFlow)PointsToAnalysis.assertPointsToAnalysisMethod(method).getTypeFlow();
            while (toi.hasNextObject(type)) {
                AnalysisObject actualReceiverObject = toi.nextObject(type);
                BytecodeAnalysisContext calleeContext = BytecodeSensitiveAnalysisPolicy.contextPolicy(bb).calleeContext(bb, actualReceiverObject, (BytecodeAnalysisContext)this.callerContext, (MethodTypeFlow)callee);
                MethodFlowsGraph calleeFlows = callee.addContext(bb, calleeContext, this);
                if (this.calleesFlows.put(calleeFlows, Boolean.TRUE) == null) {
                    this.addCallee(calleeFlows.getMethod());
                    this.linkCallee(bb, false, calleeFlows);
                }
                this.updateReceiver(bb, calleeFlows, actualReceiverObject);
            }
        }
    }

    @Override
    public void onObservedSaturated(PointsToAnalysis bb, TypeFlow<?> observed) {
        this.replaceObservedWith(bb, this.receiverType);
    }

    @Override
    public Collection<MethodFlowsGraph> getCalleesFlows(PointsToAnalysis bb) {
        return new ArrayList<MethodFlowsGraph>(this.calleesFlows.keySet());
    }
}

