/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow.context.bytecode;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.context.object.AnalysisObject;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.typestate.PointsToStats;
import com.oracle.graal.pointsto.typestate.SingleTypeState;
import com.oracle.graal.pointsto.typestate.TypeState;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

public class ContextSensitiveSingleTypeState
extends SingleTypeState {
    protected final AnalysisObject[] objects;

    public ContextSensitiveSingleTypeState(PointsToAnalysis bb, boolean canBeNull, int properties, AnalysisType type, ArrayList<AnalysisObject> objects) {
        this(bb, canBeNull, properties, type, objects.toArray(AnalysisObject.EMPTY_ARRAY));
        assert (objects.size() > 0) : "Single type state with no objects.";
    }

    public ContextSensitiveSingleTypeState(PointsToAnalysis bb, boolean canBeNull, int properties, AnalysisType type, AnalysisObject ... objects) {
        super(bb, canBeNull, properties, type);
        this.objects = objects;
        assert (!bb.extendedAsserts() || this.checkObjects(bb));
        PointsToStats.registerTypeState(bb, this);
    }

    protected ContextSensitiveSingleTypeState(PointsToAnalysis bb, boolean canBeNull, ContextSensitiveSingleTypeState other) {
        super(bb, canBeNull, other);
        this.objects = other.objects;
        PointsToStats.registerTypeState(bb, this);
    }

    protected boolean checkObjects(BigBang bb) {
        assert (bb.extendedAsserts());
        for (int idx = 0; idx < this.objects.length - 1; ++idx) {
            AnalysisObject o0 = this.objects[idx];
            AnalysisObject o1 = this.objects[idx + 1];
            assert (o0 != null && o1 != null) : "Object state must contain non null elements.";
            assert (o0.type().equals(o1.type())) : "Single type state objects must have the same type.";
            assert (o0.getId() < o1.getId()) : "Analysis objects must be sorted by ID.";
        }
        return true;
    }

    @Override
    public final int objectsCount() {
        return this.objects.length;
    }

    @Override
    public Iterator<AnalysisObject> objectsIterator(BigBang bb) {
        return Arrays.asList(this.objects).iterator();
    }

    @Override
    protected Iterator<AnalysisObject> objectsIterator(final AnalysisType t) {
        return new Iterator<AnalysisObject>(){
            private final boolean typesEqual;
            private int idx;
            {
                this.typesEqual = ContextSensitiveSingleTypeState.this.type.equals(t);
                this.idx = 0;
            }

            @Override
            public boolean hasNext() {
                return this.typesEqual && this.idx < ContextSensitiveSingleTypeState.this.objects.length;
            }

            @Override
            public AnalysisObject next() {
                return ContextSensitiveSingleTypeState.this.objects[this.idx++];
            }
        };
    }

    @Override
    public TypeState forCanBeNull(PointsToAnalysis bb, boolean stateCanBeNull) {
        if (stateCanBeNull == this.canBeNull()) {
            return this;
        }
        return new ContextSensitiveSingleTypeState(bb, stateCanBeNull, this);
    }

    @Override
    public void noteMerge(PointsToAnalysis bb) {
        assert (bb.analysisPolicy().isMergingEnabled());
        if (!this.merged) {
            for (AnalysisObject obj : this.objects) {
                obj.noteMerge(bb);
            }
            this.merged = true;
        }
    }

    @Override
    public boolean isMerged() {
        return this.merged;
    }

    @Override
    public boolean isAllocation() {
        return this.objects[0].isAllocationContextSensitiveObject();
    }

    @Override
    public boolean isConstant() {
        return this.objects[0].isConstantContextSensitiveObject();
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.objects);
        result = 31 * result + (this.canBeNull ? 1 : 0);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContextSensitiveSingleTypeState that = (ContextSensitiveSingleTypeState)o;
        return this.canBeNull == that.canBeNull && this.exactType().equals(that.exactType()) && Arrays.equals(this.objects, that.objects);
    }

    @Override
    public String toString() {
        return "1TypeMObject<" + (this.canBeNull ? "null," : "") + Arrays.toString(this.objects) + ">";
    }
}

