/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.typestate;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.context.object.AnalysisObject;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.typestate.EmptyTypeState;
import com.oracle.graal.pointsto.typestate.MultiTypeState;
import com.oracle.graal.pointsto.typestate.NullTypeState;
import com.oracle.graal.pointsto.typestate.SingleTypeState;
import java.lang.reflect.Modifier;
import java.util.BitSet;
import java.util.Iterator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import jdk.vm.ci.meta.JavaConstant;

public abstract class TypeState {
    private int id = -1;
    protected final int properties;

    public TypeState(int properties) {
        this.properties = properties;
    }

    public int getProperties() {
        return this.properties;
    }

    public abstract boolean hasExactTypes(BitSet var1);

    public abstract int typesCount();

    public abstract AnalysisType exactType();

    protected abstract Iterator<AnalysisType> typesIterator(BigBang var1);

    public Iterable<AnalysisType> types(BigBang bb) {
        return () -> this.typesIterator(bb);
    }

    public Stream<AnalysisType> typesStream(BigBang bb) {
        return StreamSupport.stream(this.types(bb).spliterator(), false);
    }

    public abstract boolean containsType(AnalysisType var1);

    public abstract int objectsCount();

    protected abstract Iterator<AnalysisObject> objectsIterator(BigBang var1);

    public final Iterable<AnalysisObject> objects(BigBang bb) {
        return () -> this.objectsIterator(bb);
    }

    protected abstract Iterator<AnalysisObject> objectsIterator(AnalysisType var1);

    public Iterable<AnalysisObject> objects(AnalysisType type) {
        return () -> this.objectsIterator(type);
    }

    public boolean isAllocation() {
        return false;
    }

    public boolean isConstant() {
        return false;
    }

    public boolean isEmpty() {
        return this == EmptyTypeState.SINGLETON;
    }

    public boolean isNull() {
        return this == NullTypeState.SINGLETON;
    }

    public abstract boolean canBeNull();

    public void noteMerge(PointsToAnalysis bb) {
    }

    public boolean isMerged() {
        return false;
    }

    public boolean verifyDeclaredType(BigBang bb, AnalysisType declaredType) {
        if (declaredType != null) {
            for (AnalysisType e : this.types(bb)) {
                if (declaredType.isAssignableFrom(e)) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public abstract boolean equals(Object var1);

    public int getId(PointsToAnalysis bb) {
        assert (bb.reportAnalysisStatistics()) : "TypeState id should only be used for statistics.";
        return this.id;
    }

    public void setId(PointsToAnalysis bb, int id) {
        assert (bb.reportAnalysisStatistics()) : "TypeState id should only be used for statistics.";
        this.id = id;
    }

    public static TypeState forEmpty() {
        return EmptyTypeState.SINGLETON;
    }

    public static TypeState forNull() {
        return NullTypeState.SINGLETON;
    }

    public static TypeState forNonNullObject(PointsToAnalysis bb, AnalysisObject object) {
        return bb.analysisPolicy().singleTypeState(bb, false, bb.analysisPolicy().makeProperties(bb, object), object.type(), object);
    }

    public static TypeState forConstant(PointsToAnalysis bb, JavaConstant constant, AnalysisType exactType) {
        assert (!constant.isNull());
        assert (exactType.isArray() || exactType.isInstanceClass() && !Modifier.isAbstract(exactType.getModifiers())) : exactType;
        AnalysisObject constantObject = bb.analysisPolicy().createConstantObject(bb, constant, exactType);
        return TypeState.forNonNullObject(bb, constantObject);
    }

    public static SingleTypeState forExactType(PointsToAnalysis bb, AnalysisType exactType, boolean canBeNull) {
        return TypeState.forExactType(bb, exactType.getContextInsensitiveAnalysisObject(), canBeNull);
    }

    public static SingleTypeState forExactType(PointsToAnalysis bb, AnalysisObject object, boolean canBeNull) {
        assert (object.type().isArray() || object.type().isInstanceClass() && !Modifier.isAbstract(object.type().getModifiers())) : object.type();
        return bb.analysisPolicy().singleTypeState(bb, canBeNull, bb.analysisPolicy().makeProperties(bb, object), object.type(), object);
    }

    public static TypeState forType(PointsToAnalysis bb, AnalysisType type, boolean canBeNull) {
        return TypeState.forType(bb, type.getContextInsensitiveAnalysisObject(), canBeNull);
    }

    public static TypeState forType(PointsToAnalysis bb, AnalysisObject object, boolean canBeNull) {
        return bb.analysisPolicy().singleTypeState(bb, canBeNull, bb.analysisPolicy().makeProperties(bb, object), object.type(), object);
    }

    public final TypeState forNonNull(PointsToAnalysis bb) {
        return this.forCanBeNull(bb, false);
    }

    public abstract TypeState forCanBeNull(PointsToAnalysis var1, boolean var2);

    public static TypeState forUnion(PointsToAnalysis bb, TypeState s1, TypeState s2) {
        if (s1.isEmpty()) {
            return s2;
        }
        if (s1.isNull()) {
            return s2.forCanBeNull(bb, true);
        }
        if (s2.isEmpty()) {
            return s1;
        }
        if (s2.isNull()) {
            return s1.forCanBeNull(bb, true);
        }
        if (s1 instanceof SingleTypeState && s2 instanceof SingleTypeState) {
            return bb.analysisPolicy().doUnion(bb, (SingleTypeState)s1, (SingleTypeState)s2);
        }
        if (s1 instanceof SingleTypeState && s2 instanceof MultiTypeState) {
            return bb.analysisPolicy().doUnion(bb, (MultiTypeState)s2, (SingleTypeState)s1);
        }
        if (s1 instanceof MultiTypeState && s2 instanceof SingleTypeState) {
            return bb.analysisPolicy().doUnion(bb, (MultiTypeState)s1, (SingleTypeState)s2);
        }
        assert (s1 instanceof MultiTypeState && s2 instanceof MultiTypeState);
        if (s1.objectsCount() >= s2.objectsCount()) {
            return bb.analysisPolicy().doUnion(bb, (MultiTypeState)s1, (MultiTypeState)s2);
        }
        return bb.analysisPolicy().doUnion(bb, (MultiTypeState)s2, (MultiTypeState)s1);
    }

    public static TypeState forIntersection(PointsToAnalysis bb, TypeState s1, TypeState s2) {
        assert (!bb.extendedAsserts() || TypeState.checkTypes(bb, s1));
        if (s1.isEmpty()) {
            return s1;
        }
        if (s1.isNull()) {
            return s1.forCanBeNull(bb, s2.canBeNull());
        }
        if (s2.isEmpty()) {
            return s2;
        }
        if (s2.isNull()) {
            return s2.forCanBeNull(bb, s1.canBeNull());
        }
        if (s1 instanceof SingleTypeState && s2 instanceof SingleTypeState) {
            return bb.analysisPolicy().doIntersection(bb, (SingleTypeState)s1, (SingleTypeState)s2);
        }
        if (s1 instanceof SingleTypeState && s2 instanceof MultiTypeState) {
            return bb.analysisPolicy().doIntersection(bb, (SingleTypeState)s1, (MultiTypeState)s2);
        }
        if (s1 instanceof MultiTypeState && s2 instanceof SingleTypeState) {
            return bb.analysisPolicy().doIntersection(bb, (MultiTypeState)s1, (SingleTypeState)s2);
        }
        assert (s1 instanceof MultiTypeState && s2 instanceof MultiTypeState);
        return bb.analysisPolicy().doIntersection(bb, (MultiTypeState)s1, (MultiTypeState)s2);
    }

    public static TypeState forSubtraction(PointsToAnalysis bb, TypeState s1, TypeState s2) {
        assert (!bb.extendedAsserts() || TypeState.checkTypes(bb, s1));
        if (s1.isEmpty()) {
            return s1;
        }
        if (s1.isNull()) {
            return s1.forCanBeNull(bb, !s2.canBeNull());
        }
        if (s2.isEmpty()) {
            return s1;
        }
        if (s2.isNull()) {
            return s1.forCanBeNull(bb, false);
        }
        if (s1 instanceof SingleTypeState && s2 instanceof SingleTypeState) {
            return bb.analysisPolicy().doSubtraction(bb, (SingleTypeState)s1, (SingleTypeState)s2);
        }
        if (s1 instanceof SingleTypeState && s2 instanceof MultiTypeState) {
            return bb.analysisPolicy().doSubtraction(bb, (SingleTypeState)s1, (MultiTypeState)s2);
        }
        if (s1 instanceof MultiTypeState && s2 instanceof SingleTypeState) {
            return bb.analysisPolicy().doSubtraction(bb, (MultiTypeState)s1, (SingleTypeState)s2);
        }
        assert (s1 instanceof MultiTypeState && s2 instanceof MultiTypeState);
        return bb.analysisPolicy().doSubtraction(bb, (MultiTypeState)s1, (MultiTypeState)s2);
    }

    private static boolean checkTypes(BigBang bb, TypeState state) {
        for (AnalysisType type : state.types(bb)) {
            if (type.isInstantiated()) continue;
            System.out.println("Processing a type not yet marked as instantiated: " + type.getName());
            return false;
        }
        return true;
    }
}

