/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.util;

public class BitArrayUtils {
    public static final int EMPTY_BIT_ARRAY = 0;

    public static int or(int first, int second) {
        return first | second;
    }

    public static int and(int first, int second) {
        return first & second;
    }

    public static int set(int array, int bit) {
        assert (0 <= bit && bit < 64);
        return array | 1 << bit;
    }

    public static int unSet(int array, int bit) {
        assert (0 <= bit && bit < 64);
        return array & ~(1 << bit);
    }

    public static boolean isSet(int array, int bit) {
        assert (0 <= bit && bit < 64);
        return (array & 1 << bit) == 1;
    }
}

