/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.util;

import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.runtime.JVMCI;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.api.runtime.GraalJVMCICompiler;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.runtime.RuntimeProvider;

public final class GraalAccess {
    private GraalAccess() {
    }

    public static TargetDescription getOriginalTarget() {
        return GraalAccess.getGraalCapability(RuntimeProvider.class).getHostBackend().getTarget();
    }

    public static Providers getOriginalProviders() {
        return GraalAccess.getGraalCapability(RuntimeProvider.class).getHostBackend().getProviders();
    }

    public static SnippetReflectionProvider getOriginalSnippetReflection() {
        return GraalAccess.getGraalCapability(SnippetReflectionProvider.class);
    }

    public static <T> T getGraalCapability(Class<T> clazz) {
        GraalJVMCICompiler compiler = (GraalJVMCICompiler)JVMCI.getRuntime().getCompiler();
        return (T)compiler.getGraalRuntime().getCapability(clazz);
    }
}

