/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.graal.snippets;

import com.oracle.svm.core.MonitorSupport;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.graal.GraalFeature;
import com.oracle.svm.core.graal.meta.RuntimeConfiguration;
import com.oracle.svm.core.graal.meta.SubstrateForeignCallLinkage;
import com.oracle.svm.core.graal.nodes.KillMemoryNode;
import com.oracle.svm.core.graal.nodes.UnreachableNode;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.graal.snippets.SubstrateTemplates;
import com.oracle.svm.core.snippets.SnippetRuntime;
import java.util.Map;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import org.graalvm.compiler.api.replacements.Snippet;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.debug.DebugHandlersFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.DeoptimizeNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.extended.ForeignCallNode;
import org.graalvm.compiler.nodes.java.MonitorEnterNode;
import org.graalvm.compiler.nodes.java.MonitorExitNode;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.compiler.replacements.SnippetTemplate;
import org.graalvm.compiler.replacements.Snippets;
import org.graalvm.word.LocationIdentity;

public final class MonitorSnippets
extends SubstrateTemplates
implements Snippets {
    @Snippet
    protected static void monitorEnterSnippet(Object obj) {
        KillMemoryNode.killMemory(LocationIdentity.any());
        MonitorSnippets.nullCheck(obj);
        if (!SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            return;
        }
        ForeignCalls.callMonitorEnter(ForeignCalls.MONITOR_SNIPPETS_SLOW_PATH_MONITOR_ENTER, obj);
    }

    @Snippet
    protected static void monitorExitSnippet(Object obj) {
        KillMemoryNode.killMemory(LocationIdentity.any());
        MonitorSnippets.nullCheck(obj);
        if (!SubstrateOptions.MultiThreaded.getValue().booleanValue()) {
            return;
        }
        ForeignCalls.callMonitorExit(ForeignCalls.MONITOR_SNIPPETS_SLOW_PATH_MONITOR_EXIT, obj);
    }

    private static void nullCheck(Object obj) {
        if (obj == null) {
            DeoptimizeNode.deopt((DeoptimizationAction)DeoptimizationAction.None, (DeoptimizationReason)DeoptimizationReason.NullCheckException);
            throw UnreachableNode.unreachable();
        }
    }

    public static void registerLowerings(OptionValues options, Iterable<DebugHandlersFactory> factories, Providers providers, SnippetReflectionProvider snippetReflection, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings) {
        new MonitorSnippets(options, factories, providers, snippetReflection, lowerings);
    }

    private MonitorSnippets(OptionValues options, Iterable<DebugHandlersFactory> factories, Providers providers, SnippetReflectionProvider snippetReflection, Map<Class<? extends Node>, NodeLoweringProvider<?>> lowerings) {
        super(options, factories, providers, snippetReflection);
        lowerings.put(MonitorEnterNode.class, new MonitorEnterLowering());
        lowerings.put(MonitorExitNode.class, new MonitorExitLowering());
    }

    static class ForeignCalls {
        static final SnippetRuntime.SubstrateForeignCallDescriptor MONITOR_SNIPPETS_SLOW_PATH_MONITOR_ENTER = SnippetRuntime.findForeignCall(MonitorSupport.class, "monitorEnter", false, new LocationIdentity[0]);
        static final SnippetRuntime.SubstrateForeignCallDescriptor MONITOR_SNIPPETS_SLOW_PATH_MONITOR_EXIT = SnippetRuntime.findForeignCall(MonitorSupport.class, "monitorExit", false, new LocationIdentity[0]);
        private static final SnippetRuntime.SubstrateForeignCallDescriptor[] FOREIGN_CALLS = new SnippetRuntime.SubstrateForeignCallDescriptor[]{MONITOR_SNIPPETS_SLOW_PATH_MONITOR_ENTER, MONITOR_SNIPPETS_SLOW_PATH_MONITOR_EXIT};

        ForeignCalls() {
        }

        @Node.NodeIntrinsic(value=ForeignCallNode.class)
        static native void callMonitorEnter(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Object var1);

        @Node.NodeIntrinsic(value=ForeignCallNode.class)
        static native void callMonitorExit(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Object var1);
    }

    @AutomaticFeature
    static class MonitorFeature
    implements GraalFeature {
        MonitorFeature() {
        }

        @Override
        public void registerForeignCalls(RuntimeConfiguration runtimeConfig, Providers providers, SnippetReflectionProvider snippetReflection, Map<SnippetRuntime.SubstrateForeignCallDescriptor, SubstrateForeignCallLinkage> foreignCalls, boolean hosted) {
            for (SnippetRuntime.SubstrateForeignCallDescriptor descriptor : ForeignCalls.FOREIGN_CALLS) {
                foreignCalls.put(descriptor, new SubstrateForeignCallLinkage(providers, descriptor));
            }
        }
    }

    protected class MonitorExitLowering
    implements NodeLoweringProvider<MonitorExitNode> {
        private final SnippetTemplate.SnippetInfo monitorExit;

        protected MonitorExitLowering() {
            this.monitorExit = MonitorSnippets.this.snippet(MonitorSnippets.class, "monitorExitSnippet", new LocationIdentity[0]);
        }

        @Override
        public void lower(MonitorExitNode node, LoweringTool tool) {
            if (tool.getLoweringStage() == LoweringTool.StandardLoweringStage.HIGH_TIER) {
                return;
            }
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(this.monitorExit, node.graph().getGuardsStage(), tool.getLoweringStage());
            args.add("obj", (Object)node.object());
            MonitorSnippets.this.template((ValueNode)node, args).instantiate(MonitorSnippets.this.providers.getMetaAccess(), (FixedNode)node, SnippetTemplate.DEFAULT_REPLACER, args);
        }
    }

    protected class MonitorEnterLowering
    implements NodeLoweringProvider<MonitorEnterNode> {
        private final SnippetTemplate.SnippetInfo monitorEnter;

        protected MonitorEnterLowering() {
            this.monitorEnter = MonitorSnippets.this.snippet(MonitorSnippets.class, "monitorEnterSnippet", new LocationIdentity[0]);
        }

        @Override
        public void lower(MonitorEnterNode node, LoweringTool tool) {
            if (tool.getLoweringStage() == LoweringTool.StandardLoweringStage.HIGH_TIER) {
                return;
            }
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(this.monitorEnter, node.graph().getGuardsStage(), tool.getLoweringStage());
            args.add("obj", (Object)node.object());
            MonitorSnippets.this.template((ValueNode)node, args).instantiate(MonitorSnippets.this.providers.getMetaAccess(), (FixedNode)node, SnippetTemplate.DEFAULT_REPLACER, args);
        }
    }
}

