/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.headers.Errno;
import com.oracle.svm.core.jdk.SubstrateOperatingSystemMXBean;
import com.oracle.svm.core.posix.PosixUtils;
import com.oracle.svm.core.posix.headers.Resource;
import com.oracle.svm.core.posix.headers.Stat;
import com.oracle.svm.core.posix.headers.Times;
import com.oracle.svm.core.posix.headers.Unistd;
import com.sun.management.UnixOperatingSystemMXBean;
import java.util.concurrent.TimeUnit;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.impl.InternalPlatform;

@Platforms(value={InternalPlatform.LINUX_JNI_AND_SUBSTITUTIONS.class, InternalPlatform.DARWIN_JNI_AND_SUBSTITUTIONS.class})
class PosixSubstrateOperatingSystemMXBean
extends SubstrateOperatingSystemMXBean
implements UnixOperatingSystemMXBean {
    PosixSubstrateOperatingSystemMXBean() {
    }

    @Override
    public long getProcessCpuTime() {
        long clkTck = Unistd.sysconf(Unistd._SC_CLK_TCK());
        if (clkTck == -1L) {
            return -1L;
        }
        long nsPerTick = TimeUnit.SECONDS.toNanos(1L) / clkTck;
        Times.tms time = (Times.tms)StackValue.get(Times.tms.class);
        Times.times(time);
        return (time.tms_utime() + time.tms_stime()) * nsPerTick;
    }

    @Override
    public long getMaxFileDescriptorCount() {
        Resource.rlimit rlp = (Resource.rlimit)StackValue.get(Resource.rlimit.class);
        if (Resource.getrlimit(Resource.RLIMIT_NOFILE(), rlp) < 0) {
            PosixSubstrateOperatingSystemMXBean.throwUnchecked(PosixUtils.newIOExceptionWithLastError("getrlimit failed"));
        }
        return rlp.rlim_cur().rawValue();
    }

    @Override
    public long getOpenFileDescriptorCount() {
        int maxFileDescriptor = Unistd.getdtablesize();
        long count = 0L;
        for (int i = 0; i <= maxFileDescriptor; ++i) {
            Stat.stat stat2 = (Stat.stat)StackValue.get(Stat.stat.class);
            if (Stat.fstat(i, stat2) != 0 && Errno.errno() == Errno.EBADF()) continue;
            ++count;
        }
        return count;
    }

    private static <T extends Throwable> void throwUnchecked(Throwable exception) throws T {
        throw exception;
    }
}

