/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.code;

import com.oracle.svm.core.c.NonmovableArray;
import com.oracle.svm.core.c.NonmovableArrays;
import com.oracle.svm.core.util.NonmovableByteArrayReader;
import com.oracle.svm.core.util.VMError;
import org.graalvm.compiler.core.common.util.AbstractTypeReader;

public final class ReusableTypeReader
extends AbstractTypeReader {
    private NonmovableArray<Byte> data;
    private long byteIndex = -1L;

    public ReusableTypeReader() {
    }

    public ReusableTypeReader(NonmovableArray<Byte> data, long byteIndex) {
        this.data = data;
        this.byteIndex = byteIndex;
    }

    public ReusableTypeReader reset() {
        this.data = NonmovableArrays.nullArray();
        this.byteIndex = -1L;
        return this;
    }

    public boolean isValid() {
        return this.data != null && this.byteIndex >= 0L;
    }

    public long getByteIndex() {
        return this.byteIndex;
    }

    public void setByteIndex(long byteIndex) {
        this.byteIndex = byteIndex;
    }

    public NonmovableArray<Byte> getData() {
        return this.data;
    }

    public void setData(NonmovableArray<Byte> data) {
        this.data = data;
    }

    public int getS1() {
        throw VMError.unimplemented();
    }

    public int getU1() {
        int result = NonmovableByteArrayReader.getU1(this.data, this.byteIndex);
        ++this.byteIndex;
        return result;
    }

    public int getS2() {
        throw VMError.unimplemented();
    }

    public int getU2() {
        throw VMError.unimplemented();
    }

    public int getS4() {
        throw VMError.unimplemented();
    }

    public long getU4() {
        throw VMError.unimplemented();
    }

    public long getS8() {
        throw VMError.unimplemented();
    }
}

