/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.svm.core.FallbackExecutor;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.NativeImageOptions;
import com.oracle.svm.hosted.NativeImageSystemClassLoader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.module.ModuleDescriptor;
import java.lang.module.ModuleFinder;
import java.lang.module.ModuleReference;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import jdk.vm.ci.code.BytecodePosition;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
public class FallbackFeature
implements InternalFeature {
    private static final String ABORT_MSG_PREFIX = "Aborting stand-alone image build";
    private final List<ReflectionInvocationCheck> reflectionInvocationChecks = new ArrayList<ReflectionInvocationCheck>();
    private final List<String> reflectionCalls = new ArrayList<String>();
    private final List<String> resourceCalls = new ArrayList<String>();
    private final List<String> jniCalls = new ArrayList<String>();
    private final List<String> proxyCalls = new ArrayList<String>();
    private final List<String> serializationCalls = new ArrayList<String>();
    private final Set<ModuleDescriptor> systemModuleDescriptors = ModuleFinder.ofSystem().findAll().stream().map(ModuleReference::descriptor).collect(Collectors.toSet());
    private final Set<AutoProxyInvoke> autoProxyInvokes = new HashSet<AutoProxyInvoke>();
    public FallbackImageRequest reflectionFallback = null;
    public FallbackImageRequest resourceFallback = null;
    public FallbackImageRequest jniFallback = null;
    public FallbackImageRequest proxyFallback = null;
    public FallbackImageRequest serializationFallback = null;

    public void addAutoProxyInvoke(ResolvedJavaMethod method, int bci) {
        this.autoProxyInvokes.add(new AutoProxyInvoke(method, bci));
    }

    private boolean containsAutoProxyInvoke(ResolvedJavaMethod method, int bci) {
        return this.autoProxyInvokes.contains(new AutoProxyInvoke(method, bci));
    }

    private void addCheck(Method reflectionMethod, InvokeChecker checker) {
        this.reflectionInvocationChecks.add(new ReflectionInvocationCheck(reflectionMethod, checker));
    }

    public FallbackFeature() {
        try {
            this.addCheck(Class.class.getMethod("forName", String.class), this::collectReflectionInvokes);
            this.addCheck(Class.class.getMethod("forName", String.class, Boolean.TYPE, ClassLoader.class), this::collectReflectionInvokes);
            this.addCheck(Class.class.getMethod("newInstance", new Class[0]), this::collectReflectionInvokes);
            this.addCheck(Class.class.getMethod("getMethod", String.class, Class[].class), this::collectReflectionInvokes);
            this.addCheck(Class.class.getMethod("getDeclaredMethod", String.class, Class[].class), this::collectReflectionInvokes);
            this.addCheck(Class.class.getMethod("getMethods", new Class[0]), this::collectReflectionInvokes);
            this.addCheck(Class.class.getMethod("getDeclaredMethods", new Class[0]), this::collectReflectionInvokes);
            this.addCheck(Class.class.getMethod("getEnclosingMethod", new Class[0]), this::collectReflectionInvokes);
            this.addCheck(Class.class.getMethod("getConstructor", Class[].class), this::collectReflectionInvokes);
            this.addCheck(Class.class.getMethod("getDeclaredConstructor", Class[].class), this::collectReflectionInvokes);
            this.addCheck(Class.class.getMethod("getConstructors", new Class[0]), this::collectReflectionInvokes);
            this.addCheck(Class.class.getMethod("getDeclaredConstructors", new Class[0]), this::collectReflectionInvokes);
            this.addCheck(Class.class.getMethod("getEnclosingConstructor", new Class[0]), this::collectReflectionInvokes);
            this.addCheck(Class.class.getMethod("getField", String.class), this::collectReflectionInvokes);
            this.addCheck(Class.class.getMethod("getFields", new Class[0]), this::collectReflectionInvokes);
            this.addCheck(Class.class.getMethod("getDeclaredFields", new Class[0]), this::collectReflectionInvokes);
            this.addCheck(ClassLoader.class.getMethod("loadClass", String.class), this::collectReflectionInvokes);
            this.addCheck(ClassLoader.class.getMethod("getResource", String.class), this::collectResourceInvokes);
            this.addCheck(ClassLoader.class.getMethod("getSystemResource", String.class), this::collectResourceInvokes);
            this.addCheck(ClassLoader.class.getMethod("getResources", String.class), this::collectResourceInvokes);
            this.addCheck(ClassLoader.class.getMethod("getSystemResources", String.class), this::collectResourceInvokes);
            this.addCheck(Proxy.class.getMethod("getProxyClass", ClassLoader.class, Class[].class), this::collectProxyInvokes);
            this.addCheck(Proxy.class.getMethod("newProxyInstance", ClassLoader.class, Class[].class, InvocationHandler.class), this::collectProxyInvokes);
            this.addCheck(System.class.getMethod("loadLibrary", String.class), this::collectJNIInvokes);
            this.addCheck(ObjectInputStream.class.getMethod("readObject", new Class[0]), this::collectDeserializationInvokes);
            this.addCheck(ObjectInputStream.class.getMethod("readUnshared", new Class[0]), this::collectDeserializationInvokes);
            this.addCheck(ObjectOutputStream.class.getMethod("writeObject", Object.class), this::collectSerializationInvokes);
            this.addCheck(ObjectOutputStream.class.getMethod("writeUnshared", Object.class), this::collectSerializationInvokes);
        }
        catch (NoSuchMethodException e) {
            throw VMError.shouldNotReachHere("Registering ReflectionInvocationChecks failed", e);
        }
    }

    private void collectReflectionInvokes(ReflectionInvocationCheck check, BytecodePosition invokeLocation) {
        this.reflectionCalls.add("Reflection method " + check.locationString(invokeLocation));
    }

    private void collectResourceInvokes(ReflectionInvocationCheck check, BytecodePosition invokeLocation) {
        this.resourceCalls.add("Resource access method " + check.locationString(invokeLocation));
    }

    private void collectJNIInvokes(ReflectionInvocationCheck check, BytecodePosition invokeLocation) {
        this.jniCalls.add("System method " + check.locationString(invokeLocation));
    }

    private void collectProxyInvokes(ReflectionInvocationCheck check, BytecodePosition invokeLocation) {
        if (!this.containsAutoProxyInvoke(invokeLocation.getMethod(), invokeLocation.getBCI())) {
            this.proxyCalls.add("Dynamic proxy method " + check.locationString(invokeLocation));
        }
    }

    private void collectDeserializationInvokes(ReflectionInvocationCheck check, BytecodePosition invokeLocation) {
        this.serializationCalls.add("Deserialization method " + check.locationString(invokeLocation));
    }

    private void collectSerializationInvokes(ReflectionInvocationCheck check, BytecodePosition invokeLocation) {
        this.serializationCalls.add("Serialization method " + check.locationString(invokeLocation));
    }

    static FallbackImageRequest reportFallback(String message) {
        return FallbackFeature.reportFallback(message, null);
    }

    static FallbackImageRequest reportFallback(String message, Throwable cause) {
        FallbackImageRequest request;
        if (cause instanceof UserError.UserException) {
            ArrayList<String> messages = new ArrayList<String>();
            if (message != null) {
                messages.add(message);
            }
            ((UserError.UserException)cause).getMessages().forEach(messages::add);
            request = new FallbackImageRequest(messages);
            request.initCause(cause.getCause());
        } else {
            String fallbackMessage = message == null && cause != null ? cause.getMessage() : message;
            request = new FallbackImageRequest(fallbackMessage);
            request.initCause(cause);
        }
        throw request;
    }

    public static UserError.UserException reportAsFallback(RuntimeException original) {
        if (SubstrateOptions.FallbackThreshold.getValue() == 0) {
            throw UserError.abort(original, "%s", original.getMessage());
        }
        throw FallbackFeature.reportFallback("Aborting stand-alone image build. " + original.getMessage(), original);
    }

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return FallbackExecutor.Options.FallbackExecutorMainClass.getValue() == null;
    }

    public void afterRegistration(Feature.AfterRegistrationAccess a) {
        if (SubstrateOptions.FallbackThreshold.getValue() == 10) {
            FallbackFeature.reportFallback("Aborting stand-alone image build due to native-image option --force-fallback");
        }
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess a) {
        FeatureImpl.BeforeAnalysisAccessImpl access = (FeatureImpl.BeforeAnalysisAccessImpl)a;
        AnalysisMetaAccess metaAccess = access.getBigBang().getMetaAccess();
        for (ReflectionInvocationCheck check : this.reflectionInvocationChecks) {
            check.trackMethod(metaAccess);
        }
    }

    public void afterAnalysis(Feature.AfterAnalysisAccess a) {
        if (SubstrateOptions.FallbackThreshold.getValue() == 0 || NativeImageOptions.ReportUnsupportedElementsAtRuntime.getValue().booleanValue() || SubstrateOptions.SharedLibrary.getValue().booleanValue()) {
            return;
        }
        FeatureImpl.AfterAnalysisAccessImpl access = (FeatureImpl.AfterAnalysisAccessImpl)a;
        if (access.getBigBang().getUnsupportedFeatures().exist()) {
            FallbackFeature.reportFallback("Aborting stand-alone image build due to unsupported features");
        }
        for (ReflectionInvocationCheck check : this.reflectionInvocationChecks) {
            for (BytecodePosition invokeLocation : check.trackedReflectionMethod.getInvokeLocations()) {
                check.apply(invokeLocation);
            }
        }
        if (!this.reflectionCalls.isEmpty()) {
            this.reflectionCalls.add("Aborting stand-alone image build due to reflection use without configuration.");
            this.reflectionFallback = new FallbackImageRequest(this.reflectionCalls);
        }
        if (!this.resourceCalls.isEmpty()) {
            this.resourceCalls.add("Aborting stand-alone image build due to accessing resources without configuration.");
            this.resourceFallback = new FallbackImageRequest(this.resourceCalls);
        }
        if (!this.jniCalls.isEmpty()) {
            this.jniCalls.add("Aborting stand-alone image build due to loading native libraries without configuration.");
            this.jniFallback = new FallbackImageRequest(this.jniCalls);
        }
        if (!this.proxyCalls.isEmpty()) {
            this.proxyCalls.add("Aborting stand-alone image build due to dynamic proxy use without configuration.");
            this.proxyFallback = new FallbackImageRequest(this.proxyCalls);
        }
        if (!this.serializationCalls.isEmpty()) {
            this.serializationCalls.add("Aborting stand-alone image build due to serialization use without configuration.");
            this.serializationFallback = new FallbackImageRequest(this.serializationCalls);
        }
    }

    public static final class FallbackImageRequest
    extends UserError.UserException {
        private FallbackImageRequest(String message) {
            super(message);
        }

        private FallbackImageRequest(Iterable<String> messages) {
            super(messages);
        }
    }

    private class ReflectionInvocationCheck {
        private final Method reflectionMethod;
        private final InvokeChecker checker;
        private AnalysisMethod trackedReflectionMethod;

        ReflectionInvocationCheck(Method reflectionMethod, InvokeChecker checker) {
            this.reflectionMethod = reflectionMethod;
            this.checker = checker;
            this.trackedReflectionMethod = null;
        }

        void trackMethod(AnalysisMetaAccess metaAccess) {
            this.trackedReflectionMethod = metaAccess.lookupJavaMethod((Executable)this.reflectionMethod);
            this.trackedReflectionMethod.startTrackInvocations();
        }

        void apply(BytecodePosition invokeLocation) {
            Class javaClass = ((AnalysisMethod)invokeLocation.getMethod()).getDeclaringClass().getJavaClass();
            if (FallbackFeature.this.systemModuleDescriptors.contains(javaClass.getModule().getDescriptor())) {
                return;
            }
            ClassLoader classLoader = javaClass.getClassLoader();
            if (!NativeImageSystemClassLoader.singleton().isNativeImageClassLoader(classLoader)) {
                return;
            }
            this.checker.check(this, invokeLocation);
        }

        String locationString(BytecodePosition invokeLocation) {
            ResolvedJavaMethod caller = invokeLocation.getMethod();
            String callerLocation = caller.asStackTraceElement(invokeLocation.getBCI()).toString();
            return this.trackedReflectionMethod.format("%H.%n") + " invoked at " + callerLocation;
        }
    }

    private static interface InvokeChecker {
        public void check(ReflectionInvocationCheck var1, BytecodePosition var2);
    }

    private static class AutoProxyInvoke {
        private final ResolvedJavaMethod method;
        private final int bci;

        AutoProxyInvoke(ResolvedJavaMethod method, int bci) {
            this.method = method;
            this.bci = bci;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AutoProxyInvoke that = (AutoProxyInvoke)o;
            return this.bci == that.bci && Objects.equals(this.method, that.method);
        }

        public int hashCode() {
            return Objects.hash(this.method, this.bci);
        }
    }
}

