/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.options;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import org.graalvm.options.OptionMap;

public final class OptionType<T> {
    private static final Consumer<?> EMPTY_VALIDATOR = new Consumer<Object>(){

        @Override
        public void accept(Object t) {
        }
    };
    private final String name;
    private final Converter<T> converter;
    private final Consumer<T> validator;
    private final boolean isOptionMap;
    private static final Map<Class<?>, OptionType<?>> DEFAULTTYPES = new HashMap();

    public OptionType(String name, final Function<String, T> stringConverter, Consumer<T> validator) {
        this(name, new Converter<T>(){

            @Override
            public T convert(T previousValue, String key, String value) {
                return stringConverter.apply(value);
            }
        }, validator, false);
    }

    private OptionType(String name, Converter<T> converter, Consumer<T> validator, boolean isOptionMap) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(converter);
        Objects.requireNonNull(validator);
        this.name = name;
        this.converter = converter;
        this.validator = validator;
        this.isOptionMap = isOptionMap;
    }

    public OptionType(String name, Function<String, T> stringConverter) {
        this(name, stringConverter, EMPTY_VALIDATOR);
    }

    @Deprecated
    public OptionType(String name, T defaultValue, Function<String, T> stringConverter, Consumer<T> validator) {
        this(name, stringConverter, validator);
    }

    @Deprecated
    public OptionType(String name, T defaultValue, Function<String, T> stringConverter) {
        this(name, stringConverter);
    }

    @Deprecated
    public T getDefaultValue() {
        return null;
    }

    public String getName() {
        return this.name;
    }

    public T convert(String value) {
        T v = this.converter.convert(null, null, value);
        this.validate(v);
        return v;
    }

    public T convert(Object previousValue, String nameSuffix, String value) {
        Object v = this.converter.convert(previousValue, nameSuffix, value);
        this.validate(v);
        return (T)v;
    }

    public void validate(T value) {
        this.validator.accept(value);
    }

    public String toString() {
        return "OptionType[name=" + this.name + "]";
    }

    public static <T> OptionType<T> defaultType(T value) {
        return OptionType.defaultType(value.getClass());
    }

    static <V> OptionType<OptionMap<V>> mapOf(Class<V> valueClass) {
        final OptionType<V> valueType = OptionType.defaultType(valueClass);
        if (valueType == null) {
            return null;
        }
        return new OptionType<OptionMap<V>>("OptionMap", new Converter<OptionMap<V>>(){

            @Override
            public OptionMap<V> convert(OptionMap<V> previousValue, String key, String value) {
                OptionMap map = previousValue;
                if (map == null || map.entrySet().isEmpty()) {
                    map = new OptionMap(new HashMap());
                }
                map.backingMap.put(key, valueType.convert(map.get(key), key, value));
                return map;
            }
        }, EMPTY_VALIDATOR, true);
    }

    public static <T> OptionType<T> defaultType(Class<T> clazz) {
        OptionType<?> type = DEFAULTTYPES.get(clazz);
        if (type != null) {
            return type;
        }
        if (Enum.class.isAssignableFrom(clazz)) {
            return OptionType.defaultEnumType(clazz);
        }
        return null;
    }

    private static <T> OptionType<T> defaultEnumType(final Class<T> clazz) {
        return new OptionType<T>(clazz.getSimpleName(), new Function<String, T>(){

            @Override
            public T apply(String t) {
                Class enumType = clazz;
                try {
                    if (t != null) {
                        return Enum.valueOf(enumType, t);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                StringBuilder b = new StringBuilder();
                String sep = "";
                for (Enum constant : (Enum[])enumType.getEnumConstants()) {
                    b.append(sep);
                    b.append('\'');
                    b.append(constant.name());
                    b.append('\'');
                    sep = ", ";
                }
                throw new IllegalArgumentException("Invalid option value '" + t + "'. Valid options values are: " + b.toString());
            }
        });
    }

    boolean isOptionMap() {
        return this.isOptionMap;
    }

    static {
        DEFAULTTYPES.put(Boolean.class, new OptionType<Boolean>("Boolean", new Function<String, Boolean>(){

            @Override
            public Boolean apply(String t) {
                if ("true".equals(t)) {
                    return Boolean.TRUE;
                }
                if ("false".equals(t)) {
                    return Boolean.FALSE;
                }
                throw new IllegalArgumentException(String.format("Invalid boolean option value '%s'. The value of the option must be '%s' or '%s'.", t, "true", "false"));
            }
        }));
        DEFAULTTYPES.put(Byte.class, new OptionType<Byte>("Byte", new Function<String, Byte>(){

            @Override
            public Byte apply(String t) {
                try {
                    return Byte.parseByte(t);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException(e.getMessage(), e);
                }
            }
        }));
        DEFAULTTYPES.put(Integer.class, new OptionType<Integer>("Integer", new Function<String, Integer>(){

            @Override
            public Integer apply(String t) {
                try {
                    return Integer.parseInt(t);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException(e.getMessage(), e);
                }
            }
        }));
        DEFAULTTYPES.put(Long.class, new OptionType<Long>("Long", new Function<String, Long>(){

            @Override
            public Long apply(String t) {
                try {
                    return Long.parseLong(t);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException(e.getMessage(), e);
                }
            }
        }));
        DEFAULTTYPES.put(Float.class, new OptionType<Float>("Float", new Function<String, Float>(){

            @Override
            public Float apply(String t) {
                try {
                    return Float.valueOf(Float.parseFloat(t));
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException(e.getMessage(), e);
                }
            }
        }));
        DEFAULTTYPES.put(Double.class, new OptionType<Double>("Double", new Function<String, Double>(){

            @Override
            public Double apply(String t) {
                try {
                    return Double.parseDouble(t);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException(e.getMessage(), e);
                }
            }
        }));
        DEFAULTTYPES.put(String.class, new OptionType<String>("String", new Function<String, String>(){

            @Override
            public String apply(String t) {
                return t;
            }
        }));
    }

    @FunctionalInterface
    private static interface Converter<T> {
        public T convert(T var1, String var2, String var3);
    }
}

