/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.staticobject;

final class StaticPropertyKind
extends Enum<StaticPropertyKind> {
    public static final /* enum */ StaticPropertyKind Long = new StaticPropertyKind();
    public static final /* enum */ StaticPropertyKind Double = new StaticPropertyKind();
    public static final /* enum */ StaticPropertyKind Int = new StaticPropertyKind();
    public static final /* enum */ StaticPropertyKind Float = new StaticPropertyKind();
    public static final /* enum */ StaticPropertyKind Short = new StaticPropertyKind();
    public static final /* enum */ StaticPropertyKind Char = new StaticPropertyKind();
    public static final /* enum */ StaticPropertyKind Byte = new StaticPropertyKind();
    public static final /* enum */ StaticPropertyKind Boolean = new StaticPropertyKind();
    public static final /* enum */ StaticPropertyKind Object = new StaticPropertyKind();
    static final int N_PRIMITIVES = 8;
    static final byte BYTE_ARRAY = 9;
    static final byte OBJECT_ARRAY = 10;
    private static final /* synthetic */ StaticPropertyKind[] $VALUES;

    public static StaticPropertyKind[] values() {
        return (StaticPropertyKind[])$VALUES.clone();
    }

    public static StaticPropertyKind valueOf(String name) {
        return Enum.valueOf(StaticPropertyKind.class, name);
    }

    static String getDescriptor(int i) {
        if (i == Long.ordinal()) {
            return "J";
        }
        if (i == Double.ordinal()) {
            return "D";
        }
        if (i == Int.ordinal()) {
            return "I";
        }
        if (i == Float.ordinal()) {
            return "F";
        }
        if (i == Short.ordinal()) {
            return "S";
        }
        if (i == Char.ordinal()) {
            return "C";
        }
        if (i == Byte.ordinal()) {
            return "B";
        }
        if (i == Boolean.ordinal()) {
            return "Z";
        }
        if (i == Object.ordinal()) {
            return "Ljava/lang/Object;";
        }
        if (i == 9) {
            return "[B";
        }
        if (i == 10) {
            return "[Ljava/lang/Object;";
        }
        throw new IllegalArgumentException("Invalid StaticPropertyKind: " + i);
    }

    static int getByteCount(int b) {
        if (b == Boolean.ordinal()) {
            return 1;
        }
        return StaticPropertyKind.getBitCount(b) >> 3;
    }

    private static int getBitCount(int b) {
        if (b == Boolean.ordinal()) {
            return 1;
        }
        if (b == Byte.ordinal()) {
            return 8;
        }
        if (b == Char.ordinal() || b == Short.ordinal()) {
            return 16;
        }
        if (b == Float.ordinal() || b == Int.ordinal()) {
            return 32;
        }
        if (b == Double.ordinal() || b == Long.ordinal()) {
            return 64;
        }
        throw new IllegalArgumentException("Invalid StaticPropertyKind: " + b);
    }

    static StaticPropertyKind valueOf(Class<?> type) {
        if (type == java.lang.Long.TYPE) {
            return Long;
        }
        if (type == java.lang.Double.TYPE) {
            return Double;
        }
        if (type == Integer.TYPE) {
            return Int;
        }
        if (type == java.lang.Float.TYPE) {
            return Float;
        }
        if (type == java.lang.Short.TYPE) {
            return Short;
        }
        if (type == Character.TYPE) {
            return Char;
        }
        if (type == java.lang.Byte.TYPE) {
            return Byte;
        }
        if (type == java.lang.Boolean.TYPE) {
            return Boolean;
        }
        if (type == Object.class) {
            return Object;
        }
        throw new IllegalArgumentException("Invalid Static Property type: " + type.getName());
    }

    static StaticPropertyKind valueOf(byte b) {
        return StaticPropertyKind.values()[b];
    }

    byte toByte() {
        assert (StaticPropertyKind.values().length < 127);
        return (byte)this.ordinal();
    }

    static {
        $VALUES = new StaticPropertyKind[]{Long, Double, Int, Float, Short, Char, Byte, Boolean, Object};
    }
}

