/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.impl.DefaultTruffleRuntime;
import com.oracle.truffle.api.impl.DispatchOutputStream;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.polyglot.DefaultPolyglotHostService;
import com.oracle.truffle.polyglot.EngineAccessor;
import com.oracle.truffle.polyglot.FileSystems;
import com.oracle.truffle.polyglot.InternalResourceCache;
import com.oracle.truffle.polyglot.InternalResourceRoots;
import com.oracle.truffle.polyglot.LanguageCache;
import com.oracle.truffle.polyglot.ModuleUtils;
import com.oracle.truffle.polyglot.OptionValuesImpl;
import com.oracle.truffle.polyglot.PolyglotContextDispatch;
import com.oracle.truffle.polyglot.PolyglotContextImpl;
import com.oracle.truffle.polyglot.PolyglotEngineDispatch;
import com.oracle.truffle.polyglot.PolyglotEngineException;
import com.oracle.truffle.polyglot.PolyglotEngineImpl;
import com.oracle.truffle.polyglot.PolyglotEngineOptions;
import com.oracle.truffle.polyglot.PolyglotExceptionDispatch;
import com.oracle.truffle.polyglot.PolyglotExceptionImpl;
import com.oracle.truffle.polyglot.PolyglotExecutionEventDispatch;
import com.oracle.truffle.polyglot.PolyglotExecutionListenerDispatch;
import com.oracle.truffle.polyglot.PolyglotFastThreadLocals;
import com.oracle.truffle.polyglot.PolyglotHostAccess;
import com.oracle.truffle.polyglot.PolyglotInstrumentDispatch;
import com.oracle.truffle.polyglot.PolyglotLanguageContext;
import com.oracle.truffle.polyglot.PolyglotLanguageDispatch;
import com.oracle.truffle.polyglot.PolyglotLimits;
import com.oracle.truffle.polyglot.PolyglotLoggers;
import com.oracle.truffle.polyglot.PolyglotSharingLayer;
import com.oracle.truffle.polyglot.PolyglotSourceDispatch;
import com.oracle.truffle.polyglot.PolyglotSourceSectionDispatch;
import com.oracle.truffle.polyglot.PolyglotValueDispatch;
import com.oracle.truffle.polyglot.PolyglotWrapper;
import com.oracle.truffle.polyglot.PreInitContextHostLanguage;
import com.oracle.truffle.polyglot.ProcessHandlers;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Level;
import org.graalvm.options.OptionDescriptors;
import org.graalvm.polyglot.Engine;
import org.graalvm.polyglot.HostAccess;
import org.graalvm.polyglot.PolyglotException;
import org.graalvm.polyglot.SandboxPolicy;
import org.graalvm.polyglot.impl.AbstractPolyglotImpl;
import org.graalvm.polyglot.impl.ModuleToUnnamedBridge;
import org.graalvm.polyglot.io.ByteSequence;
import org.graalvm.polyglot.io.MessageTransport;
import org.graalvm.polyglot.io.ProcessHandler;

public final class PolyglotImpl
extends AbstractPolyglotImpl {
    static final Object SECRET = new Object();
    static final Object[] EMPTY_ARGS = new Object[0];
    static final String TRUFFLE_VERSION;
    private final PolyglotSourceDispatch sourceDispatch = new PolyglotSourceDispatch(this);
    private final PolyglotSourceSectionDispatch sourceSectionDispatch = new PolyglotSourceSectionDispatch(this);
    private final PolyglotExecutionListenerDispatch executionListenerDispatch = new PolyglotExecutionListenerDispatch(this);
    private final PolyglotExecutionEventDispatch executionEventDispatch = new PolyglotExecutionEventDispatch(this);
    final PolyglotEngineDispatch engineDispatch = new PolyglotEngineDispatch(this);
    final PolyglotContextDispatch contextDispatch = new PolyglotContextDispatch(this);
    private final PolyglotExceptionDispatch exceptionDispatch = new PolyglotExceptionDispatch(this);
    final PolyglotInstrumentDispatch instrumentDispatch = new PolyglotInstrumentDispatch(this);
    final PolyglotLanguageDispatch languageDispatch = new PolyglotLanguageDispatch(this);
    private final AtomicReference<PolyglotEngineImpl> preInitializedEngineRef = new AtomicReference();
    private final Map<Class<?>, PolyglotValueDispatch> primitiveValues = new HashMap();
    Object hostNull;
    private PolyglotValueDispatch disconnectedHostValue;
    private PolyglotValueDispatch disconnectedBigIntegerHostValue;
    private volatile Object defaultFileSystemContext;
    private static volatile AbstractPolyglotImpl isolatePolyglot;

    public int getPriority() {
        return 0;
    }

    private static AbstractPolyglotImpl findImpl() {
        try {
            Method f = Engine.class.getDeclaredMethod("getImpl", new Class[0]);
            f.setAccessible(true);
            return (AbstractPolyglotImpl)f.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new InternalError(e);
        }
    }

    static PolyglotImpl findInstance() {
        AbstractPolyglotImpl polyglot;
        for (polyglot = PolyglotImpl.findImpl(); polyglot != null && !(polyglot instanceof PolyglotImpl); polyglot = polyglot.getNext()) {
        }
        if (polyglot == null) {
            throw new AssertionError((Object)String.format("%s not found or installed but required.", PolyglotImpl.class.getSimpleName()));
        }
        return (PolyglotImpl)polyglot;
    }

    static AbstractPolyglotImpl findIsolatePolyglot() {
        return isolatePolyglot;
    }

    static void setIsolatePolyglot(AbstractPolyglotImpl instance) {
        assert (instance != null);
        assert (isolatePolyglot == null);
        isolatePolyglot = instance;
    }

    PolyglotEngineImpl getPreinitializedEngine() {
        return this.preInitializedEngineRef.get();
    }

    public void initialize() {
        super.initialize();
        this.hostNull = this.getAPIAccess().newValue((AbstractPolyglotImpl.AbstractValueDispatch)PolyglotValueDispatch.createHostNull(this), null, EngineAccessor.HOST.getHostNull());
        this.disconnectedHostValue = new PolyglotValueDispatch.HostValue(this);
        this.disconnectedBigIntegerHostValue = new PolyglotValueDispatch.BigIntegerHostValue(this);
        PolyglotValueDispatch.createDefaultValues(this, null, this.primitiveValues);
    }

    public Object initializeModuleToUnnamedAccess(MethodHandles.Lookup unnamedLookup, Object unnamedAccess, Object unnamedAPIAccess, Object unnamedIOAccess, Object unnamedManagementAccess) {
        ModuleToUnnamedBridge bridge = ModuleToUnnamedBridge.create((MethodHandles.Lookup)unnamedLookup, (Object)unnamedAccess, (Object)unnamedAPIAccess, (Object)unnamedIOAccess, (Object)unnamedManagementAccess);
        for (AbstractPolyglotImpl impl = this.getRootImpl(); impl != null; impl = impl.getNextOrNull()) {
            PolyglotImpl.initializeModuleToUnnamedBridge(impl, bridge);
        }
        return bridge.getModuleAccess();
    }

    private static void initializeModuleToUnnamedBridge(AbstractPolyglotImpl impl, ModuleToUnnamedBridge bridge) {
        impl.setConstructors(Objects.requireNonNull(bridge.getAPIAccess()));
        impl.setIO(Objects.requireNonNull(bridge.getIOAccess()));
        impl.setMonitoring(Objects.requireNonNull(bridge.getManagementAccess()));
        impl.initialize();
    }

    public Object buildLimits(long statementLimit, Predicate<Object> statementLimitSourceFilter, Consumer<Object> onLimit) {
        try {
            return new PolyglotLimits(statementLimit, statementLimitSourceFilter, onLimit);
        }
        catch (Throwable t) {
            throw PolyglotImpl.guestToHostException(this, t);
        }
    }

    AbstractPolyglotImpl.AbstractSourceDispatch getSourceDispatch() {
        return this.sourceDispatch;
    }

    AbstractPolyglotImpl.AbstractSourceSectionDispatch getSourceSectionDispatch() {
        return this.sourceSectionDispatch;
    }

    AbstractPolyglotImpl.AbstractExecutionListenerDispatch getExecutionListenerDispatch() {
        return this.executionListenerDispatch;
    }

    AbstractPolyglotImpl.AbstractExecutionEventDispatch getExecutionEventDispatch() {
        return this.executionEventDispatch;
    }

    public Object getCurrentContext() {
        try {
            PolyglotContextImpl context = PolyglotFastThreadLocals.getContext(null);
            if (context == null) {
                throw PolyglotEngineException.illegalState("No current context is available. Make sure the Java method is invoked by a Graal guest language or a context is entered using Context.enter().");
            }
            Object api = context.api;
            if (api == null) {
                context.api = api = this.getAPIAccess().newContext((AbstractPolyglotImpl.AbstractContextDispatch)this.contextDispatch, (Object)context, context.engine.api);
            }
            return api;
        }
        catch (Throwable t) {
            throw PolyglotImpl.guestToHostException(this, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object buildEngine(String[] permittedLanguages, SandboxPolicy sandboxPolicy, OutputStream out, OutputStream err, InputStream in, Map<String, String> options, boolean allowExperimentalOptions, boolean boundEngine, MessageTransport messageInterceptor, Object logHandler, Object hostLanguage, boolean hostLanguageOnly, boolean registerInActiveEngines, Object polyglotHostService) {
        PolyglotEngineImpl impl = null;
        try {
            AbstractPolyglotImpl.LogHandler useHandler;
            OptionValuesImpl engineOptions;
            PolyglotLoggers.EngineLoggerProvider loggerProvider;
            PolyglotEngineImpl.LogConfig logConfig;
            DispatchOutputStream dispatchErr;
            DispatchOutputStream dispatchOut;
            InputStream resolvedIn;
            block13: {
                this.validateSandbox(sandboxPolicy);
                InternalResourceRoots.ensureInitialized();
                if (TruffleOptions.AOT) {
                    EngineAccessor.ACCESSOR.initializeNativeImageTruffleLocator();
                }
                OutputStream resolvedOut = out == null ? System.out : out;
                OutputStream resolvedErr = err == null ? System.err : err;
                resolvedIn = in == null ? System.in : in;
                dispatchOut = EngineAccessor.INSTRUMENT.createDispatchOutput(resolvedOut);
                dispatchErr = EngineAccessor.INSTRUMENT.createDispatchOutput(resolvedErr);
                logConfig = new PolyglotEngineImpl.LogConfig();
                loggerProvider = null;
                engineOptions = null;
                useHandler = null;
                try {
                    engineOptions = PolyglotImpl.createEngineOptions(this, options, logConfig, sandboxPolicy, allowExperimentalOptions);
                    useHandler = logHandler != null ? (AbstractPolyglotImpl.LogHandler)logHandler : PolyglotEngineImpl.createLogHandler(logConfig, dispatchErr, sandboxPolicy);
                    loggerProvider = new PolyglotLoggers.EngineLoggerProvider(useHandler, logConfig.logLevels);
                    if (useHandler != null) break block13;
                    AbstractPolyglotImpl.LogHandler logHandler2 = useHandler = logHandler != null ? (AbstractPolyglotImpl.LogHandler)logHandler : PolyglotEngineImpl.createLogHandler(logConfig, dispatchErr, sandboxPolicy);
                }
                catch (Throwable throwable) {
                    if (useHandler == null) {
                        AbstractPolyglotImpl.LogHandler logHandler3 = useHandler = logHandler != null ? (AbstractPolyglotImpl.LogHandler)logHandler : PolyglotEngineImpl.createLogHandler(logConfig, dispatchErr, sandboxPolicy);
                    }
                    if (loggerProvider == null) {
                        loggerProvider = new PolyglotLoggers.EngineLoggerProvider(useHandler, logConfig.logLevels);
                    }
                    PolyglotImpl.logTruffleRuntimeWarning(options, engineOptions, loggerProvider);
                    throw throwable;
                }
            }
            if (loggerProvider == null) {
                loggerProvider = new PolyglotLoggers.EngineLoggerProvider(useHandler, logConfig.logLevels);
            }
            PolyglotImpl.logTruffleRuntimeWarning(options, engineOptions, loggerProvider);
            Object usePolyglotHostService = polyglotHostService != null ? (AbstractPolyglotImpl.AbstractPolyglotHostService)polyglotHostService : new DefaultPolyglotHostService(this);
            impl = (PolyglotEngineImpl)EngineAccessor.RUNTIME.tryLoadCachedEngine(engineOptions, loggerProvider);
            if (impl == null && boundEngine && !hostLanguageOnly && !EngineAccessor.RUNTIME.isStoreEnabled(engineOptions)) {
                impl = this.preInitializedEngineRef.getAndSet(null);
            }
            if (impl != null) {
                assert (hostLanguage.getClass() == impl.getHostLanguageSPI().getClass() || PreInitContextHostLanguage.isInstance(impl.hostLanguage));
                impl.patch(sandboxPolicy, dispatchOut, dispatchErr, resolvedIn, engineOptions, logConfig, loggerProvider, options, allowExperimentalOptions, boundEngine, useHandler, (TruffleLanguage)hostLanguage, (AbstractPolyglotImpl.AbstractPolyglotHostService)usePolyglotHostService);
            }
            if (impl == null) {
                impl = new PolyglotEngineImpl(this, sandboxPolicy, permittedLanguages, dispatchOut, dispatchErr, resolvedIn, engineOptions, logConfig.logLevels, loggerProvider, options, allowExperimentalOptions, boundEngine, false, messageInterceptor, useHandler, (TruffleLanguage)hostLanguage, hostLanguageOnly, (AbstractPolyglotImpl.AbstractPolyglotHostService)usePolyglotHostService);
            }
            return this.getAPIAccess().newEngine((AbstractPolyglotImpl.AbstractEngineDispatch)this.engineDispatch, (Object)impl, registerInActiveEngines);
        }
        catch (Throwable t) {
            if (impl == null) {
                throw PolyglotImpl.guestToHostException(this, t);
            }
            throw PolyglotImpl.guestToHostException(impl, t);
        }
    }

    private static void logTruffleRuntimeWarning(Map<String, String> options, OptionValuesImpl engineOptions, PolyglotLoggers.EngineLoggerProvider loggerProvider) {
        boolean warnInterpreterOnly = engineOptions == null ? !"false".equals(options.get("engine.WarnInterpreterOnly")) : engineOptions.get(PolyglotEngineOptions.WarnInterpreterOnly);
        if (warnInterpreterOnly && Truffle.getRuntime().getClass() == DefaultTruffleRuntime.class) {
            DefaultTruffleRuntime runtime = (DefaultTruffleRuntime)Truffle.getRuntime();
            String reason = runtime.getFallbackReason();
            if (reason == null) {
                reason = "Unknown cause.";
            }
            loggerProvider.apply("engine").log(Level.WARNING, String.format("The polyglot engine uses a fallback runtime that does not support runtime compilation to native code.\nExecution without runtime compilation will negatively impact the guest application performance.\nThe following cause was found: %s\nFor more information see: https://www.graalvm.org/latest/reference-manual/embed-languages/#runtime-optimization-support.\nTo disable this warning use the '--engine.WarnInterpreterOnly=false' option or the '-Dpolyglot.engine.WarnInterpreterOnly=false' system property.", reason));
        }
    }

    private void validateSandbox(SandboxPolicy sandboxPolicy) {
        if (this == this.getRootImpl() && sandboxPolicy.isStricterThan(SandboxPolicy.CONSTRAINED)) {
            throw PolyglotEngineException.illegalArgument(String.format("The Builder.sandbox(SandboxPolicy) is set to %s, but the GraalVM community edition supports only sandbox policy TRUSTED or CONSTRAINED.In order to resolve this switch to a less strict sandbox policy using Builder.sandbox(SandboxPolicy).", sandboxPolicy));
        }
    }

    protected OptionDescriptors createEngineOptionDescriptors() {
        return PolyglotEngineImpl.createEngineOptionDescriptors();
    }

    static OptionValuesImpl createEngineOptions(PolyglotImpl polyglot, Map<String, String> options, PolyglotEngineImpl.LogConfig logOptions, SandboxPolicy sandboxPolicy, boolean allowExperimentalOptions) {
        OptionDescriptors engineOptionDescriptors = polyglot.createAllEngineOptionDescriptors();
        HashMap<String, String> engineOptions = new HashMap<String, String>();
        PolyglotEngineImpl.parseEngineOptions(options, engineOptions, logOptions);
        OptionValuesImpl values = new OptionValuesImpl(engineOptionDescriptors, sandboxPolicy, true, true);
        values.putAll(null, engineOptions, allowExperimentalOptions);
        return values;
    }

    public void preInitializeEngine() {
        PolyglotEngineImpl engine = this.createDefaultEngine(new PreInitContextHostLanguage());
        this.getAPIAccess().newEngine((AbstractPolyglotImpl.AbstractEngineDispatch)this.engineDispatch, (Object)engine, false);
        try {
            engine.preInitialize();
        }
        finally {
            LanguageCache.resetNativeImageCacheLanguageHomes();
            engine.logLevels.clear();
            engine.logHandler.close();
            engine.logHandler = null;
        }
        this.preInitializedEngineRef.set(engine);
    }

    PolyglotEngineImpl createDefaultEngine(TruffleLanguage<Object> hostLanguage) {
        InternalResourceRoots.ensureInitialized();
        Map options = this.getAPIAccess().readOptionsFromSystemProperties();
        PolyglotEngineImpl.LogConfig logConfig = new PolyglotEngineImpl.LogConfig();
        SandboxPolicy sandboxPolicy = SandboxPolicy.TRUSTED;
        OptionValuesImpl engineOptions = PolyglotImpl.createEngineOptions(this, options, logConfig, sandboxPolicy, true);
        DispatchOutputStream out = EngineAccessor.INSTRUMENT.createDispatchOutput(System.out);
        DispatchOutputStream err = EngineAccessor.INSTRUMENT.createDispatchOutput(System.err);
        AbstractPolyglotImpl.LogHandler logHandler = PolyglotEngineImpl.createLogHandler(logConfig, err, sandboxPolicy);
        PolyglotLoggers.EngineLoggerProvider loggerProvider = new PolyglotLoggers.EngineLoggerProvider(logHandler, logConfig.logLevels);
        PolyglotEngineImpl engine = new PolyglotEngineImpl(this, sandboxPolicy, new String[0], out, err, System.in, engineOptions, logConfig.logLevels, loggerProvider, options, true, true, true, null, logHandler, hostLanguage, false, new DefaultPolyglotHostService(this));
        this.getAPIAccess().newEngine((AbstractPolyglotImpl.AbstractEngineDispatch)this.engineDispatch, (Object)engine, false);
        return engine;
    }

    public TruffleLanguage<Object> createHostLanguage(Object access) {
        return EngineAccessor.HOST.createDefaultHostLanguage(this, (AbstractPolyglotImpl.AbstractHostAccess)access);
    }

    public void resetPreInitializedEngine() {
        this.preInitializedEngineRef.set(null);
    }

    public Class<?> loadLanguageClass(String className) {
        for (EngineAccessor.AbstractClassLoaderSupplier supplier : EngineAccessor.locatorOrDefaultLoaders()) {
            ClassLoader loader = (ClassLoader)supplier.get();
            if (loader == null) continue;
            try {
                Class<?> clazz = loader.loadClass(className);
                if (!supplier.accepts(clazz)) continue;
                Module clazzModule = clazz.getModule();
                ModuleUtils.exportTransitivelyTo(clazzModule);
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        return null;
    }

    public <S, T> Object newTargetTypeMapping(Class<S> sourceType, Class<T> targetType, Predicate<S> acceptsValue, Function<S, T> convertValue, HostAccess.TargetMappingPrecedence precedence) {
        return EngineAccessor.HOST.newTargetTypeMapping(sourceType, targetType, acceptsValue, convertValue, precedence);
    }

    Object asValue(PolyglotContextImpl currentContext, Object hostValue) {
        if (currentContext != null) {
            return currentContext.asValue(hostValue);
        }
        assert (!this.getAPIAccess().isValue(hostValue));
        Object guestValue = null;
        if (hostValue == null) {
            return this.hostNull;
        }
        if (PolyglotImpl.isGuestPrimitive(hostValue)) {
            return this.getAPIAccess().newValue((AbstractPolyglotImpl.AbstractValueDispatch)this.primitiveValues.get(hostValue.getClass()), null, hostValue);
        }
        if (PolyglotWrapper.isInstance(hostValue)) {
            PolyglotWrapper hostWrapper = PolyglotWrapper.asInstance(hostValue);
            PolyglotLanguageContext languageContext = hostWrapper.getLanguageContext();
            assert (languageContext != null) : "HostWrappers must be guaranteed to have non-null language context.";
            guestValue = hostWrapper.getGuestObject();
            return languageContext.asValue(guestValue);
        }
        guestValue = hostValue instanceof TruffleObject ? hostValue : (this.getAPIAccess().isProxy(hostValue) ? EngineAccessor.HOST.toDisconnectedHostProxy(hostValue) : EngineAccessor.HOST.toDisconnectedHostObject(hostValue));
        return this.getAPIAccess().newValue((AbstractPolyglotImpl.AbstractValueDispatch)(hostValue instanceof BigInteger ? this.disconnectedBigIntegerHostValue : this.disconnectedHostValue), null, guestValue);
    }

    @CompilerDirectives.TruffleBoundary
    public Object asValue(Object hostValue) {
        try {
            PolyglotContextImpl currentContext = PolyglotFastThreadLocals.getContext(null);
            return this.asValue(currentContext, hostValue);
        }
        catch (Throwable t) {
            throw PolyglotImpl.guestToHostException(this, t);
        }
    }

    public org.graalvm.polyglot.io.FileSystem newDefaultFileSystem(String hostTmpDir) {
        return FileSystems.newDefaultFileSystem(hostTmpDir);
    }

    public org.graalvm.polyglot.io.FileSystem allowInternalResourceAccess(org.graalvm.polyglot.io.FileSystem fileSystem) {
        return FileSystems.allowInternalResourceAccess(fileSystem);
    }

    public org.graalvm.polyglot.io.FileSystem newReadOnlyFileSystem(org.graalvm.polyglot.io.FileSystem fileSystem) {
        return FileSystems.newReadOnlyFileSystem(fileSystem);
    }

    public org.graalvm.polyglot.io.FileSystem newNIOFileSystem(FileSystem fileSystem) {
        return FileSystems.newNIOFileSystem(fileSystem);
    }

    public ByteSequence asByteSequence(Object object) {
        return (ByteSequence)object;
    }

    public ProcessHandler newDefaultProcessHandler() {
        if (PolyglotEngineImpl.ALLOW_CREATE_PROCESS) {
            return ProcessHandlers.newDefaultProcessHandler();
        }
        return null;
    }

    public Object newIOAccess(String name, boolean allowHostFileAccess, boolean allowHostSocketAccess, org.graalvm.polyglot.io.FileSystem customFileSystem) {
        return this.getIO().createIOAccess(name, allowHostFileAccess, allowHostSocketAccess, customFileSystem);
    }

    public boolean isDefaultProcessHandler(ProcessHandler processHandler) {
        return ProcessHandlers.isDefault(processHandler);
    }

    public boolean isInternalFileSystem(org.graalvm.polyglot.io.FileSystem fileSystem) {
        return FileSystems.isInternal(this.getRootImpl(), fileSystem);
    }

    public AbstractPolyglotImpl.ThreadScope createThreadScope() {
        return null;
    }

    public boolean isInCurrentEngineHostCallback(Object engine) {
        RootNode topMostGuestToHostRootNode = Truffle.getRuntime().iterateFrames(f -> {
            RootNode root = ((RootCallTarget)f.getCallTarget()).getRootNode();
            if (EngineAccessor.HOST.isGuestToHostRootNode(root)) {
                return root;
            }
            return null;
        });
        if (topMostGuestToHostRootNode == null) {
            return false;
        }
        PolyglotSharingLayer sharing = (PolyglotSharingLayer)EngineAccessor.NODES.getSharingLayer(topMostGuestToHostRootNode);
        PolyglotEngineImpl rootEngine = sharing.engine;
        return rootEngine == engine;
    }

    public AbstractPolyglotImpl.LogHandler newLogHandler(Object logHandlerOrStream) {
        return PolyglotLoggers.asLogHandler(logHandlerOrStream);
    }

    public OptionDescriptors createUnionOptionDescriptors(OptionDescriptors ... optionDescriptors) {
        return EngineAccessor.LANGUAGE.createOptionDescriptorsUnion(optionDescriptors);
    }

    public org.graalvm.polyglot.io.FileSystem newFileSystem(org.graalvm.polyglot.io.FileSystem fs) {
        return fs;
    }

    public AbstractPolyglotImpl.AbstractHostAccess createHostAccess() {
        return new PolyglotHostAccess(this);
    }

    public boolean isHostFileSystem(org.graalvm.polyglot.io.FileSystem fileSystem) {
        return FileSystems.isHostFileSystem(fileSystem);
    }

    public boolean copyResources(Path targetFolder, String ... components) throws IOException {
        return InternalResourceCache.copyResourcesForNativeImage(targetFolder, components);
    }

    public String getTruffleVersion() {
        return TRUFFLE_VERSION;
    }

    public String findLanguage(File file) throws IOException {
        Objects.requireNonNull(file);
        String mimeType = this.findMimeType(file);
        if (mimeType != null) {
            return this.findLanguage(mimeType);
        }
        return null;
    }

    public String findLanguage(URL url) throws IOException {
        String mimeType = this.findMimeType(url);
        if (mimeType != null) {
            return this.findLanguage(mimeType);
        }
        return null;
    }

    public String findMimeType(File file) throws IOException {
        TruffleFile truffleFile;
        Objects.requireNonNull(file);
        try {
            truffleFile = EngineAccessor.LANGUAGE.getTruffleFile(file.toPath().toString(), this.getDefaultFileSystemContext());
        }
        catch (IllegalArgumentException | UnsupportedOperationException e) {
            throw new AssertionError("Inconsistent path", e);
        }
        return truffleFile.detectMimeType();
    }

    public String findMimeType(URL url) throws IOException {
        Objects.requireNonNull(url);
        return EngineAccessor.SOURCE.findMimeType(url, this.getDefaultFileSystemContext());
    }

    public String findLanguage(String mimeType) {
        Objects.requireNonNull(mimeType);
        LanguageCache cache = LanguageCache.languageMimes().get(mimeType);
        if (cache != null) {
            return cache.getId();
        }
        return null;
    }

    public Object buildSource(String language, Object origin, URI uri, String name, String mimeType, Object content, boolean interactive, boolean internal, boolean cached, Charset encoding, URL url, String path) throws IOException {
        Source.SourceBuilder builder;
        assert (language != null);
        AbstractPolyglotImpl.APIAccess apiAccess = this.getAPIAccess();
        if (origin instanceof File) {
            builder = EngineAccessor.SOURCE.newBuilder(language, (File)origin);
        } else if (origin instanceof CharSequence) {
            builder = Source.newBuilder(language, (CharSequence)origin, name);
        } else if (apiAccess.isByteSequence(origin)) {
            builder = Source.newBuilder(language, apiAccess.asByteSequence(origin), name);
        } else if (origin instanceof Reader) {
            builder = Source.newBuilder(language, (Reader)origin, name);
        } else if (origin instanceof URL) {
            builder = Source.newBuilder(language, (URL)origin);
        } else if (origin == Source.CONTENT_NONE) {
            builder = Source.newBuilder(language, "", name).content(Source.CONTENT_NONE);
        } else {
            throw CompilerDirectives.shouldNotReachHere();
        }
        if (origin instanceof File || origin instanceof URL) {
            EngineAccessor.SOURCE.setFileSystemContext(builder, this.getDefaultFileSystemContext());
        }
        EngineAccessor.SOURCE.setEmbedderSource(builder, true);
        if (url != null) {
            EngineAccessor.SOURCE.setURL(builder, url);
        }
        if (path != null) {
            EngineAccessor.SOURCE.setPath(builder, path);
        }
        if (content instanceof CharSequence) {
            builder.content((CharSequence)content);
        } else if (apiAccess.isByteSequence(content)) {
            builder.content(apiAccess.asByteSequence(content));
        }
        builder.uri(uri);
        builder.name(name);
        builder.internal(internal);
        builder.interactive(interactive);
        builder.mimeType(mimeType);
        builder.cached(cached);
        builder.encoding(encoding);
        try {
            return PolyglotImpl.getOrCreatePolyglotSource(this, builder.build());
        }
        catch (IOException | RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw CompilerDirectives.shouldNotReachHere(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getDefaultFileSystemContext() {
        Object res = this.defaultFileSystemContext;
        if (res == null) {
            PolyglotImpl polyglotImpl = this;
            synchronized (polyglotImpl) {
                res = this.defaultFileSystemContext;
                if (res == null) {
                    EmbedderFileSystemContext context = new EmbedderFileSystemContext(this);
                    this.defaultFileSystemContext = res = EngineAccessor.LANGUAGE.createFileSystemContext(context, context.fileSystem);
                }
            }
        }
        return res;
    }

    static Object getOrCreatePolyglotSource(PolyglotImpl polyglot, Source source) {
        return EngineAccessor.SOURCE.getOrCreatePolyglotSource(source, t -> polyglot.getAPIAccess().newSource(polyglot.getSourceDispatch(), t));
    }

    static Object getPolyglotSourceSection(PolyglotImpl polyglot, SourceSection sourceSection) {
        if (sourceSection == null) {
            return null;
        }
        Object polyglotSource = PolyglotImpl.getOrCreatePolyglotSource(polyglot, sourceSection.getSource());
        return polyglot.getAPIAccess().newSourceSection(polyglotSource, (AbstractPolyglotImpl.AbstractSourceSectionDispatch)polyglot.sourceSectionDispatch, (Object)sourceSection);
    }

    @CompilerDirectives.TruffleBoundary
    static <T extends Throwable> RuntimeException engineToLanguageException(Throwable t) throws T {
        assert (!(t instanceof PolyglotException)) : "polyglot exceptions must not be thrown to the guest language";
        PolyglotEngineException.rethrow(t);
        throw t;
    }

    @CompilerDirectives.TruffleBoundary
    static <T extends Throwable> RuntimeException engineToInstrumentException(Throwable t) throws T {
        assert (!(t instanceof PolyglotException)) : "polyglot exceptions must not be thrown to the guest instrument";
        PolyglotEngineException.rethrow(t);
        throw t;
    }

    @CompilerDirectives.TruffleBoundary
    static <T extends Throwable> RuntimeException guestToHostException(PolyglotLanguageContext languageContext, T e, boolean entered) {
        PolyglotExceptionImpl exceptionImpl;
        assert (languageContext == null || !languageContext.getAPIAccess().isPolyglotException(e)) : "polyglot exceptions must not be thrown to the host: " + String.valueOf(e);
        PolyglotEngineException.rethrow(e);
        if (languageContext == null) {
            throw new AssertionError((Object)e);
        }
        PolyglotContextImpl context = languageContext.context;
        PolyglotExceptionImpl suppressedImpl = null;
        PolyglotContextImpl.State localContextState = context.state;
        PolyglotImpl polyglot = context.engine.impl;
        if (localContextState.isInvalidOrClosed()) {
            exceptionImpl = new PolyglotExceptionImpl(polyglot, context.engine, localContextState, context.invalidResourceLimit, context.exitCode, languageContext, e, false, false);
        } else {
            try {
                exceptionImpl = new PolyglotExceptionImpl(languageContext.getImpl(), languageContext.context.engine, localContextState, false, 0, languageContext, e, true, entered);
            }
            catch (Throwable t) {
                exceptionImpl = new PolyglotExceptionImpl(context.engine, localContextState, false, 0, e);
                suppressedImpl = new PolyglotExceptionImpl(context.engine, localContextState, false, 0, t);
            }
        }
        AbstractPolyglotImpl.APIAccess access = polyglot.getAPIAccess();
        RuntimeException polyglotException = access.newLanguageException(exceptionImpl.getMessage(), (AbstractPolyglotImpl.AbstractExceptionDispatch)polyglot.exceptionDispatch, (Object)exceptionImpl);
        if (suppressedImpl != null) {
            polyglotException.addSuppressed(access.newLanguageException(exceptionImpl.getMessage(), (AbstractPolyglotImpl.AbstractExceptionDispatch)polyglot.exceptionDispatch, (Object)suppressedImpl));
        }
        return polyglotException;
    }

    static <T extends Throwable> RuntimeException guestToHostException(PolyglotEngineImpl engine, T e) {
        assert (!engine.getAPIAccess().isPolyglotException(e)) : "polyglot exceptions must not be thrown to the host: " + String.valueOf(e);
        PolyglotEngineException.rethrow(e);
        AbstractPolyglotImpl.APIAccess access = engine.getAPIAccess();
        PolyglotExceptionImpl exceptionImpl = new PolyglotExceptionImpl(engine, null, false, 0, e);
        return access.newLanguageException(exceptionImpl.getMessage(), (AbstractPolyglotImpl.AbstractExceptionDispatch)engine.impl.exceptionDispatch, (Object)exceptionImpl);
    }

    @CompilerDirectives.TruffleBoundary
    static <T extends Throwable> RuntimeException guestToHostException(PolyglotImpl polyglot, T e) {
        assert (!polyglot.getAPIAccess().isPolyglotException(e)) : "polyglot exceptions must not be thrown to the host: " + String.valueOf(e);
        PolyglotEngineException.rethrow(e);
        AbstractPolyglotImpl.APIAccess access = polyglot.getAPIAccess();
        PolyglotExceptionImpl exceptionImpl = new PolyglotExceptionImpl(polyglot, e);
        return access.newLanguageException(exceptionImpl.getMessage(), (AbstractPolyglotImpl.AbstractExceptionDispatch)polyglot.exceptionDispatch, (Object)exceptionImpl);
    }

    static RuntimeException hostToGuestException(PolyglotEngineImpl engine, Throwable t) {
        return engine.polyglotHostService.hostToGuestException(engine.host, t);
    }

    static IllegalArgumentException sandboxPolicyException(SandboxPolicy sandboxPolicy, String reason, String fix) {
        Objects.requireNonNull(sandboxPolicy);
        Objects.requireNonNull(reason);
        Objects.requireNonNull(fix);
        String spawnIsolateHelp = sandboxPolicy.isStricterOrEqual(SandboxPolicy.ISOLATED) ? " If you switch to a less strict sandbox policy you can still spawn an isolate with an isolated heap using Builder.option(\"engine.SpawnIsolate\",\"true\")." : "";
        String message = String.format("The validation for the given sandbox policy %s failed. %s In order to resolve this %s or switch to a less strict sandbox policy using Builder.sandbox(SandboxPolicy).%s", sandboxPolicy, reason, fix, spawnIsolateHelp);
        return new IllegalArgumentException(message);
    }

    static boolean isGuestPrimitive(Object receiver) {
        return receiver instanceof Integer || receiver instanceof Double || receiver instanceof Long || receiver instanceof Float || receiver instanceof Boolean || receiver instanceof Character || receiver instanceof Byte || receiver instanceof Short || receiver instanceof String || receiver instanceof TruffleString;
    }

    static {
        InputStream in = PolyglotImpl.class.getResourceAsStream("/META-INF/graalvm/org.graalvm.truffle/version");
        if (in == null) {
            throw new InternalError("Truffle API must have a version file.");
        }
        try (BufferedReader r = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
            TRUFFLE_VERSION = r.readLine();
        }
        catch (IOException ioe) {
            throw new InternalError(ioe);
        }
    }

    static final class EmbedderFileSystemContext {
        private final PolyglotImpl impl;
        final org.graalvm.polyglot.io.FileSystem fileSystem;
        final Map<String, LanguageCache> cachedLanguages = LanguageCache.languages();
        final Supplier<Map<String, Collection<? extends TruffleFile.FileTypeDetector>>> fileTypeDetectors = FileSystems.newFileTypeDetectorsSupplier(this.cachedLanguages.values());

        EmbedderFileSystemContext(PolyglotImpl impl) {
            this.impl = Objects.requireNonNull(impl);
            this.fileSystem = FileSystems.newDefaultFileSystem(null);
        }

        PolyglotImpl getImpl() {
            return this.impl;
        }
    }

    static interface VMObject {
        public PolyglotEngineImpl getEngine();

        public PolyglotImpl getImpl();

        public AbstractPolyglotImpl.APIAccess getAPIAccess();
    }
}

