/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.object;

import com.oracle.truffle.object.ImmutableMap;
import com.oracle.truffle.object.TrieNode;
import com.oracle.truffle.object.WeakKey;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;

final class UnorderedTrieMap<K, V>
implements ImmutableMap<K, V> {
    private static final UnorderedTrieMap<?, ?> EMPTY = new UnorderedTrieMap(0, TrieNode.empty());
    private static final boolean VERIFY = false;
    private final int size;
    private final TrieNode<K, V, Map.Entry<K, V>> root;

    static int hash(Object key) {
        return key.hashCode();
    }

    private UnorderedTrieMap(int size, TrieNode<K, V, Map.Entry<K, V>> root) {
        this.size = size;
        this.root = root;
        assert (this.verify());
    }

    public static <K, V> UnorderedTrieMap<K, V> empty() {
        return EMPTY;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getEntry(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        for (Map.Entry<K, V> entry : this.entrySet()) {
            if (!Objects.equals(value, entry.getValue())) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        Map.Entry<Object, V> entry = this.getEntry(key);
        return entry == null ? null : (V)entry.getValue();
    }

    Map.Entry<K, V> getEntry(K key) {
        WeakKey wk;
        K k;
        Map.Entry<K, V> entry = this.root.find(key, UnorderedTrieMap.hash(key));
        assert (entry == null || entry.getKey().equals(key) || (k = entry.getKey()) instanceof WeakKey && (wk = (WeakKey)k).refersTo(null)) : Arrays.asList(entry, key);
        return entry;
    }

    @Override
    public UnorderedTrieMap<K, V> copyAndPut(K key, V value) {
        return this.copyAndPutImpl(key, value, Map::entry, false);
    }

    UnorderedTrieMap<K, V> copyAndPut(K key, V value, BiFunction<K, V, Map.Entry<K, V>> entryFactory) {
        return this.copyAndPutImpl(key, value, entryFactory, false);
    }

    UnorderedTrieMap<K, V> copyAndPutIfAbsent(K key, V value, BiFunction<K, V, Map.Entry<K, V>> entryFactory) {
        return this.copyAndPutImpl(key, value, entryFactory, true);
    }

    private UnorderedTrieMap<K, V> copyAndPutImpl(K key, V value, BiFunction<K, V, Map.Entry<K, V>> entryFactory, boolean ifAbsent) {
        Map.Entry<K, V> newEntry;
        int newSize;
        int hash = UnorderedTrieMap.hash(key);
        Map.Entry<K, V> existing = this.root.find(key, hash);
        TrieNode<K, V, Map.Entry<K, V>> newRoot = this.root;
        if (existing == null) {
            newSize = this.size + 1;
            newEntry = this.newEntry(key, value, entryFactory);
        } else {
            V existingValue = existing.getValue();
            if (existingValue != null && (ifAbsent || existingValue.equals(value))) {
                return this;
            }
            newSize = this.size;
            newEntry = this.newEntry(key, value, entryFactory);
            assert (!newEntry.equals(existing)) : Arrays.asList(newEntry, existing);
        }
        newRoot = newRoot.put(key, hash, newEntry);
        return new UnorderedTrieMap<K, V>(newSize, newRoot);
    }

    private Map.Entry<K, V> newEntry(K key, V newValue, BiFunction<K, V, Map.Entry<K, V>> entryFactory) {
        return entryFactory.apply(key, newValue);
    }

    @Override
    public UnorderedTrieMap<K, V> copyAndRemove(K key) {
        int hash = UnorderedTrieMap.hash(key);
        Map.Entry<K, V> existing = this.root.find(key, hash);
        if (existing == null) {
            return this;
        }
        if (this.size == 1) {
            return UnorderedTrieMap.empty();
        }
        TrieNode<K, V, Map.Entry<K, V>> newRoot = this.root;
        newRoot = newRoot.remove(key, hash);
        return new UnorderedTrieMap<K, V>(this.size - 1, newRoot);
    }

    UnorderedTrieMap<K, V> copyAndRemoveEntry(Map.Entry<K, V> entry) {
        int hash;
        K key = entry.getKey();
        Map.Entry<K, V> existing = this.root.find(key, hash = UnorderedTrieMap.hash(key));
        if (existing != entry) {
            return this;
        }
        if (this.size == 1) {
            return UnorderedTrieMap.empty();
        }
        TrieNode<K, V, Map.Entry<K, V>> newRoot = this.root;
        newRoot = newRoot.remove(key, hash);
        return new UnorderedTrieMap<K, V>(this.size - 1, newRoot);
    }

    @Override
    public void forEach(final BiConsumer<? super K, ? super V> action) {
        this.forEachEntry(new Consumer<Map.Entry<K, V>>(){
            final /* synthetic */ UnorderedTrieMap this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void accept(Map.Entry<K, V> e) {
                action.accept(e.getKey(), e.getValue());
            }
        });
    }

    void forEachEntry(Consumer<? super Map.Entry<K, V>> consumer) {
        this.root.forEachEntry(consumer);
    }

    Iterator<Map.Entry<K, V>> entryIterator() {
        return this.root.entryIterator();
    }

    Iterator<K> keyIterator() {
        return new Iterator<K>(){
            private final Iterator<Map.Entry<K, V>> entryIterator;
            {
                this.entryIterator = UnorderedTrieMap.this.entryIterator();
            }

            @Override
            public boolean hasNext() {
                return this.entryIterator.hasNext();
            }

            @Override
            public K next() {
                return this.entryIterator.next().getKey();
            }
        };
    }

    Iterator<V> valueIterator() {
        return new Iterator<V>(){
            private final Iterator<Map.Entry<K, V>> entryIterator;
            {
                this.entryIterator = UnorderedTrieMap.this.entryIterator();
            }

            @Override
            public boolean hasNext() {
                return this.entryIterator.hasNext();
            }

            @Override
            public V next() {
                return this.entryIterator.next().getValue();
            }
        };
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return UnorderedTrieMap.this.entryIterator();
            }

            @Override
            public int size() {
                return UnorderedTrieMap.this.size();
            }
        };
    }

    @Override
    public Set<K> keySet() {
        return new AbstractSet<K>(){

            @Override
            public Iterator<K> iterator() {
                return UnorderedTrieMap.this.keyIterator();
            }

            @Override
            public int size() {
                return UnorderedTrieMap.this.size();
            }
        };
    }

    @Override
    public Collection<V> values() {
        return new AbstractSet<V>(){

            @Override
            public Iterator<V> iterator() {
                return UnorderedTrieMap.this.valueIterator();
            }

            @Override
            public int size() {
                return UnorderedTrieMap.this.size();
            }
        };
    }

    public String toString() {
        return this.entrySet().toString();
    }

    private boolean verify() {
        assert (this.size >= 0);
        assert (this.root != null);
        return true;
    }
}

