/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.object;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.CoreLocations;
import com.oracle.truffle.api.object.DefaultStrategy;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.FieldInfo;
import com.oracle.truffle.api.object.LayoutImpl;
import com.oracle.truffle.api.object.LayoutStrategy;
import com.oracle.truffle.api.object.ObjectStorageOptions;
import com.oracle.truffle.api.object.ShapeBasic;
import com.oracle.truffle.api.object.ShapeImpl;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.graalvm.nativeimage.ImageInfo;

class DefaultLayout
extends LayoutImpl {
    private final CoreLocations.ObjectLocation[] objectFields;
    private final CoreLocations.LongLocation[] primitiveFields;
    static final CoreLocations.ObjectLocation[] NO_OBJECT_FIELDS = new CoreLocations.ObjectLocation[0];
    static final CoreLocations.LongLocation[] NO_LONG_FIELDS = new CoreLocations.LongLocation[0];

    DefaultLayout(Class<? extends DynamicObject> dynamicObjectClass, MethodHandles.Lookup layoutLookup, LayoutStrategy strategy, int implicitCastFlags) {
        super(dynamicObjectClass, strategy, implicitCastFlags);
        if (DynamicObject.class == dynamicObjectClass) {
            this.objectFields = NO_OBJECT_FIELDS;
            this.primitiveFields = NO_LONG_FIELDS;
        } else if (DynamicObject.class.isAssignableFrom(dynamicObjectClass)) {
            LayoutInfo layoutInfo = LayoutInfo.getOrCreateLayoutInfo(dynamicObjectClass, layoutLookup);
            this.objectFields = layoutInfo.objectFields;
            this.primitiveFields = layoutInfo.primitiveFields;
        } else {
            throw new IllegalArgumentException(dynamicObjectClass.getName());
        }
    }

    static LayoutImpl createCoreLayout(Class<? extends DynamicObject> type, MethodHandles.Lookup layoutLookup, int implicitCastFlags) {
        return DefaultLayout.getOrCreateLayout(type, layoutLookup, implicitCastFlags);
    }

    private static DefaultLayout getOrCreateLayout(Class<? extends DynamicObject> type, MethodHandles.Lookup layoutLookup, int implicitCastFlags) {
        Objects.requireNonNull(type, "DynamicObject layout class");
        LayoutImpl.Key key = new LayoutImpl.Key(type, implicitCastFlags, DefaultStrategy.SINGLETON);
        DefaultLayout layout = (DefaultLayout)LAYOUT_MAP.get(key);
        if (layout != null) {
            return layout;
        }
        DefaultLayout newLayout = new DefaultLayout(type, layoutLookup, DefaultStrategy.SINGLETON, implicitCastFlags);
        layout = LAYOUT_MAP.putIfAbsent(key, newLayout);
        return layout == null ? newLayout : layout;
    }

    static void registerLayoutClass(Class<? extends DynamicObject> type, MethodHandles.Lookup layoutLookup) {
        DefaultLayout.createCoreLayout(type, layoutLookup, 0);
    }

    static UnsupportedOperationException unsupported() {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new UnsupportedOperationException("not supported by this object layout");
    }

    @Override
    protected ShapeImpl newShape(Object objectType, Object sharedData, int flags, Assumption singleContextAssumption) {
        return new ShapeBasic(this, sharedData, objectType, flags, singleContextAssumption);
    }

    @Override
    protected boolean hasObjectExtensionArray() {
        return true;
    }

    @Override
    protected boolean hasPrimitiveExtensionArray() {
        return true;
    }

    @Override
    protected int getObjectFieldCount() {
        return this.objectFields.length;
    }

    @Override
    protected int getPrimitiveFieldCount() {
        return this.primitiveFields.length;
    }

    protected CoreLocations.ObjectLocation getObjectFieldLocation(int index) {
        return this.objectFields[index];
    }

    protected CoreLocations.LongLocation getPrimitiveFieldLocation(int index) {
        return this.primitiveFields[index];
    }

    protected int getLongFieldSize() {
        return 1;
    }

    @Override
    public ShapeImpl.BaseAllocator createAllocator() {
        DefaultLayout layout = this;
        return this.getStrategy().createAllocator(layout);
    }

    private static final class LayoutInfo {
        final CoreLocations.ObjectLocation[] objectFields;
        final CoreLocations.LongLocation[] primitiveFields;

        static LayoutInfo getOrCreateLayoutInfo(Class<? extends DynamicObject> dynamicObjectClass, MethodHandles.Lookup layoutLookup) {
            LayoutInfo layoutInfo = (LayoutInfo)LayoutImpl.LAYOUT_INFO_MAP.get(dynamicObjectClass);
            if (layoutInfo != null) {
                return layoutInfo;
            }
            if (ImageInfo.inImageRuntimeCode()) {
                throw new IllegalStateException("Layout not initialized ahead-of-time: " + String.valueOf(dynamicObjectClass));
            }
            return LayoutInfo.createLayoutInfo(dynamicObjectClass, layoutLookup);
        }

        private static LayoutInfo createLayoutInfo(Class<? extends DynamicObject> dynamicObjectClass, MethodHandles.Lookup layoutLookup) {
            Class<DynamicObject> subclass = dynamicObjectClass.asSubclass(DynamicObject.class);
            ArrayList<CoreLocations.ObjectLocation> objectFieldList = new ArrayList<CoreLocations.ObjectLocation>();
            ArrayList<CoreLocations.LongLocation> longFieldList = new ArrayList<CoreLocations.LongLocation>();
            Class<? extends DynamicObject> superclass = LayoutInfo.collectFields(subclass, layoutLookup, objectFieldList, longFieldList);
            if (objectFieldList.size() + longFieldList.size() > 1000) {
                throw new IllegalArgumentException("Too many @DynamicField annotated fields.");
            }
            LayoutInfo newLayoutInfo = superclass != subclass ? LayoutInfo.getOrCreateLayoutInfo(superclass, layoutLookup) : new LayoutInfo(objectFieldList, longFieldList);
            LayoutInfo layoutInfo = (LayoutInfo)LayoutImpl.LAYOUT_INFO_MAP.putIfAbsent(dynamicObjectClass, newLayoutInfo);
            return layoutInfo == null ? newLayoutInfo : layoutInfo;
        }

        private LayoutInfo(List<CoreLocations.ObjectLocation> objectFieldList, List<CoreLocations.LongLocation> longFieldList) {
            this.objectFields = objectFieldList.toArray(NO_OBJECT_FIELDS);
            this.primitiveFields = longFieldList.toArray(NO_LONG_FIELDS);
        }

        private static Class<? extends DynamicObject> collectFields(Class<? extends DynamicObject> clazz, MethodHandles.Lookup layoutLookup, List<CoreLocations.ObjectLocation> objectFieldList, List<CoreLocations.LongLocation> primitiveFieldList) {
            if (clazz == DynamicObject.class) {
                return clazz;
            }
            Class<? extends DynamicObject> layoutClass = LayoutInfo.collectFields(clazz.getSuperclass().asSubclass(DynamicObject.class), layoutLookup, objectFieldList, primitiveFieldList);
            Class<? extends Annotation> dynamicFieldAnnotation = DynamicObject.getDynamicFieldAnnotation();
            boolean hasDynamicFields = false;
            for (Field field : clazz.getDeclaredFields()) {
                if (Modifier.isStatic(field.getModifiers()) || field.isSynthetic()) {
                    assert (!field.isAnnotationPresent(dynamicFieldAnnotation));
                    continue;
                }
                if (field.getAnnotation(dynamicFieldAnnotation) == null) continue;
                LayoutInfo.checkDynamicFieldType(field);
                assert (field.getDeclaringClass() == clazz);
                VarHandle varHandle = null;
                if (layoutLookup != null) {
                    try {
                        MethodHandles.Lookup privateLookup = MethodHandles.privateLookupIn(clazz, layoutLookup);
                        varHandle = privateLookup.findVarHandle(clazz, field.getName(), field.getType());
                    }
                    catch (IllegalAccessException | NoSuchFieldException e) {
                        throw CompilerDirectives.shouldNotReachHere(e);
                    }
                } else if (ObjectStorageOptions.UseVarHandle) continue;
                hasDynamicFields = true;
                if (field.getType() == Object.class) {
                    objectFieldList.add(new CoreLocations.SimpleObjectFieldLocation(objectFieldList.size(), FieldInfo.fromField(field, varHandle)));
                    continue;
                }
                if (field.getType() != Long.TYPE) continue;
                primitiveFieldList.add(new CoreLocations.SimpleLongFieldLocation(primitiveFieldList.size(), FieldInfo.fromField(field, varHandle)));
            }
            if (hasDynamicFields) {
                layoutClass = clazz;
            }
            return layoutClass;
        }

        private static void checkDynamicFieldType(Field field) {
            if (field.getType() != Object.class && field.getType() != Integer.TYPE && field.getType() != Long.TYPE) {
                throw new IllegalArgumentException("@DynamicField annotated field type must be either Object or int or long: " + String.valueOf(field));
            }
            if (Modifier.isFinal(field.getModifiers())) {
                throw new IllegalArgumentException("@DynamicField annotated field must not be final: " + String.valueOf(field));
            }
        }

        public String toString() {
            return "LayoutInfo [objectFields=" + Arrays.toString(this.objectFields) + ", primitiveFields=" + Arrays.toString(this.primitiveFields) + "]";
        }
    }
}

