/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.strings;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.DSLSupport;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.InlineSupport;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TStringGuards;
import com.oracle.truffle.api.strings.TStringOpsNodes;
import com.oracle.truffle.api.strings.TruffleString;
import java.lang.invoke.MethodHandles;

@GeneratedBy(value=TStringOpsNodes.class)
final class TStringOpsNodesFactory {
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private static final TruffleString.CompactionLevel[] COMPACTION_LEVEL_VALUES = (TruffleString.CompactionLevel[])DSLSupport.lookupEnumConstants(TruffleString.CompactionLevel.class);

    TStringOpsNodesFactory() {
    }

    private static TruffleString.CompactionLevel decodeCompactionLevel(int state) {
        if (state >= 0) {
            return COMPACTION_LEVEL_VALUES[state];
        }
        return null;
    }

    private static int encodeCompactionLevel(TruffleString.CompactionLevel e) {
        if (e != null) {
            return e.ordinal();
        }
        return -1;
    }

    @GeneratedBy(value=TStringOpsNodes.CalculateHashCodeNode.class)
    static final class CalculateHashCodeNodeGen {
        private static final Uncached UNCACHED = new Uncached();

        CalculateHashCodeNodeGen() {
        }

        @CompilerDirectives.TruffleBoundary
        private static UnsupportedSpecializationException newUnsupportedSpecializationException4LLLJ(Node thisNode_, Object arg0Value, Object arg1Value, Object arg2Value, long arg3Value) {
            return new UnsupportedSpecializationException(thisNode_, null, arg0Value, arg1Value, arg2Value, arg3Value);
        }

        @NeverDefault
        public static TStringOpsNodes.CalculateHashCodeNode getUncached() {
            return UNCACHED;
        }

        @NeverDefault
        public static TStringOpsNodes.CalculateHashCodeNode inline(@InlineSupport.RequiredField(bits=12, value=InlineSupport.StateField.class) InlineSupport.InlineTarget target) {
            return new Inlined(target);
        }

        @GeneratedBy(value=TStringOpsNodes.CalculateHashCodeNode.class)
        @DenyReplace
        private static final class Uncached
        extends TStringOpsNodes.CalculateHashCodeNode
        implements UnadoptableNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            int execute(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value) {
                return TStringOpsNodes.CalculateHashCodeNode.cached(arg0Value, arg1Value, arg2Value, arg3Value, TruffleString.CompactionLevel.fromStride(arg1Value.stride()), TruffleString.CompactionLevel.fromStride(arg1Value.stride()));
            }
        }

        @GeneratedBy(value=TStringOpsNodes.CalculateHashCodeNode.class)
        @DenyReplace
        private static final class Inlined
        extends TStringOpsNodes.CalculateHashCodeNode
        implements UnadoptableNode {
            private final InlineSupport.StateField state_0_;

            private Inlined(InlineSupport.InlineTarget target) {
                assert (target.getTargetClass().isAssignableFrom(TStringOpsNodes.CalculateHashCodeNode.class));
                this.state_0_ = target.getState(0, 12);
            }

            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((state_0 & 0x111) != 0) {
                    TruffleString.CompactionLevel compaction__;
                    if ((state_0 & 1) != 0 && (state_0 & 0xE) >>> 1 != 0 && (compaction__ = TruffleString.CompactionLevel.fromStride(arg1Value.stride())) == TStringOpsNodesFactory.decodeCompactionLevel(((state_0 & 0xE) >>> 1) - 2)) {
                        return TStringOpsNodes.CalculateHashCodeNode.cached(arg0Value, arg1Value, arg2Value, arg3Value, compaction__, TStringOpsNodesFactory.decodeCompactionLevel(((state_0 & 0xE) >>> 1) - 2));
                    }
                    if ((state_0 & 0x10) != 0 && (state_0 & 0xE0) >>> 5 != 0 && (compaction__ = TruffleString.CompactionLevel.fromStride(arg1Value.stride())) == TStringOpsNodesFactory.decodeCompactionLevel(((state_0 & 0xE0) >>> 5) - 2)) {
                        return TStringOpsNodes.CalculateHashCodeNode.cached(arg0Value, arg1Value, arg2Value, arg3Value, compaction__, TStringOpsNodesFactory.decodeCompactionLevel(((state_0 & 0xE0) >>> 5) - 2));
                    }
                    if ((state_0 & 0x100) != 0 && (state_0 & 0xE00) >>> 9 != 0 && (compaction__ = TruffleString.CompactionLevel.fromStride(arg1Value.stride())) == TStringOpsNodesFactory.decodeCompactionLevel(((state_0 & 0xE00) >>> 9) - 2)) {
                        return TStringOpsNodes.CalculateHashCodeNode.cached(arg0Value, arg1Value, arg2Value, arg3Value, compaction__, TStringOpsNodesFactory.decodeCompactionLevel(((state_0 & 0xE00) >>> 9) - 2));
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value);
            }

            private int executeAndSpecialize(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value) {
                int state_0 = this.state_0_.get(arg0Value);
                TruffleString.CompactionLevel compaction__ = null;
                boolean Cached0_duplicateFound_ = false;
                if ((state_0 & 1) != 0 && (state_0 & 0xE) >>> 1 != 0 && (compaction__ = TruffleString.CompactionLevel.fromStride(arg1Value.stride())) == TStringOpsNodesFactory.decodeCompactionLevel(((state_0 & 0xE) >>> 1) - 2)) {
                    Cached0_duplicateFound_ = true;
                }
                if (!Cached0_duplicateFound_ && (state_0 & 1) == 0) {
                    compaction__ = TruffleString.CompactionLevel.fromStride(arg1Value.stride());
                    state_0 |= TStringOpsNodesFactory.encodeCompactionLevel(compaction__) + 2 << 1;
                    this.state_0_.set(arg0Value, state_0 |= 1);
                    Cached0_duplicateFound_ = true;
                }
                if (Cached0_duplicateFound_) {
                    return TStringOpsNodes.CalculateHashCodeNode.cached(arg0Value, arg1Value, arg2Value, arg3Value, compaction__, TStringOpsNodesFactory.decodeCompactionLevel(((state_0 & 0xE) >>> 1) - 2));
                }
                compaction__ = null;
                boolean Cached1_duplicateFound_ = false;
                if ((state_0 & 0x10) != 0 && (state_0 & 0xE0) >>> 5 != 0 && (compaction__ = TruffleString.CompactionLevel.fromStride(arg1Value.stride())) == TStringOpsNodesFactory.decodeCompactionLevel(((state_0 & 0xE0) >>> 5) - 2)) {
                    Cached1_duplicateFound_ = true;
                }
                if (!Cached1_duplicateFound_ && (state_0 & 0x10) == 0) {
                    compaction__ = TruffleString.CompactionLevel.fromStride(arg1Value.stride());
                    state_0 |= TStringOpsNodesFactory.encodeCompactionLevel(compaction__) + 2 << 5;
                    this.state_0_.set(arg0Value, state_0 |= 0x10);
                    Cached1_duplicateFound_ = true;
                }
                if (Cached1_duplicateFound_) {
                    return TStringOpsNodes.CalculateHashCodeNode.cached(arg0Value, arg1Value, arg2Value, arg3Value, compaction__, TStringOpsNodesFactory.decodeCompactionLevel(((state_0 & 0xE0) >>> 5) - 2));
                }
                compaction__ = null;
                boolean Cached2_duplicateFound_ = false;
                if ((state_0 & 0x100) != 0 && (state_0 & 0xE00) >>> 9 != 0 && (compaction__ = TruffleString.CompactionLevel.fromStride(arg1Value.stride())) == TStringOpsNodesFactory.decodeCompactionLevel(((state_0 & 0xE00) >>> 9) - 2)) {
                    Cached2_duplicateFound_ = true;
                }
                if (!Cached2_duplicateFound_ && (state_0 & 0x100) == 0) {
                    compaction__ = TruffleString.CompactionLevel.fromStride(arg1Value.stride());
                    state_0 |= TStringOpsNodesFactory.encodeCompactionLevel(compaction__) + 2 << 9;
                    this.state_0_.set(arg0Value, state_0 |= 0x100);
                    Cached2_duplicateFound_ = true;
                }
                if (Cached2_duplicateFound_) {
                    return TStringOpsNodes.CalculateHashCodeNode.cached(arg0Value, arg1Value, arg2Value, arg3Value, compaction__, TStringOpsNodesFactory.decodeCompactionLevel(((state_0 & 0xE00) >>> 9) - 2));
                }
                throw CalculateHashCodeNodeGen.newUnsupportedSpecializationException4LLLJ(this, arg0Value, arg1Value, arg2Value, arg3Value);
            }
        }
    }

    @GeneratedBy(value=TStringOpsNodes.RawLastIndexOfStringNode.class)
    static final class RawLastIndexOfStringNodeGen {
        private static final InlineSupport.StateField CACHED_LEN1_RAW_LAST_INDEX_OF_STRING_NODE_CACHED_LEN1_STATE_0_UPDATER = InlineSupport.StateField.create(CachedLen1Data.lookup_(), "cachedLen1_state_0_");
        private static final InlinedConditionProfile INLINED_ONE_LENGTH_ = InlinedConditionProfile.inline(InlineSupport.InlineTarget.create(InlinedConditionProfile.class, CACHED_LEN1_RAW_LAST_INDEX_OF_STRING_NODE_CACHED_LEN1_STATE_0_UPDATER.subUpdater(6, 2)));
        private static final Uncached UNCACHED = new Uncached();

        RawLastIndexOfStringNodeGen() {
        }

        @CompilerDirectives.TruffleBoundary
        private static UnsupportedSpecializationException newUnsupportedSpecializationException10LLLJLLJIIL(Node thisNode_, Object arg0Value, Object arg1Value, Object arg2Value, long arg3Value, Object arg4Value, Object arg5Value, long arg6Value, int arg7Value, int arg8Value, Object arg9Value) {
            return new UnsupportedSpecializationException(thisNode_, null, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value);
        }

        @NeverDefault
        public static TStringOpsNodes.RawLastIndexOfStringNode getUncached() {
            return UNCACHED;
        }

        @NeverDefault
        public static TStringOpsNodes.RawLastIndexOfStringNode inline(@InlineSupport.RequiredFields(value={@InlineSupport.RequiredField(bits=1, value=InlineSupport.StateField.class), @InlineSupport.RequiredField(type=Node.class, value=InlineSupport.ReferenceField.class)}) InlineSupport.InlineTarget target) {
            return new Inlined(target);
        }

        @GeneratedBy(value=TStringOpsNodes.RawLastIndexOfStringNode.class)
        @DenyReplace
        private static final class Uncached
        extends TStringOpsNodes.RawLastIndexOfStringNode
        implements UnadoptableNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            int execute(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, AbstractTruffleString arg4Value, byte[] arg5Value, long arg6Value, int arg7Value, int arg8Value, byte[] arg9Value) {
                return TStringOpsNodes.RawLastIndexOfStringNode.cachedLen1(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, TruffleString.CompactionLevel.fromStride(arg1Value.stride()), TruffleString.CompactionLevel.fromStride(arg1Value.stride()), TruffleString.CompactionLevel.fromStride(arg4Value.stride()), TruffleString.CompactionLevel.fromStride(arg4Value.stride()), InlinedConditionProfile.getUncached());
            }
        }

        @GeneratedBy(value=TStringOpsNodes.RawLastIndexOfStringNode.class)
        @DenyReplace
        private static final class Inlined
        extends TStringOpsNodes.RawLastIndexOfStringNode
        implements UnadoptableNode {
            private final InlineSupport.StateField state_0_;
            private final InlineSupport.ReferenceField<CachedLen1Data> cachedLen1_cache;

            private Inlined(InlineSupport.InlineTarget target) {
                assert (target.getTargetClass().isAssignableFrom(TStringOpsNodes.RawLastIndexOfStringNode.class));
                this.state_0_ = target.getState(0, 1);
                this.cachedLen1_cache = target.getReference(1, CachedLen1Data.class);
            }

            @Override
            @ExplodeLoop
            int execute(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, AbstractTruffleString arg4Value, byte[] arg5Value, long arg6Value, int arg7Value, int arg8Value, byte[] arg9Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if (state_0 != 0) {
                    CachedLen1Data s0_ = this.cachedLen1_cache.get(arg0Value);
                    while (s0_ != null) {
                        TruffleString.CompactionLevel compactionB__;
                        TruffleString.CompactionLevel compactionA__ = TruffleString.CompactionLevel.fromStride(arg1Value.stride());
                        if (compactionA__ == TStringOpsNodesFactory.decodeCompactionLevel(((s0_.cachedLen1_state_0_ & 7) >>> 0) - 2) && (compactionB__ = TruffleString.CompactionLevel.fromStride(arg4Value.stride())) == TStringOpsNodesFactory.decodeCompactionLevel(((s0_.cachedLen1_state_0_ & 0x38) >>> 3) - 2)) {
                            return TStringOpsNodes.RawLastIndexOfStringNode.cachedLen1(s0_, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, compactionA__, TStringOpsNodesFactory.decodeCompactionLevel(((s0_.cachedLen1_state_0_ & 7) >>> 0) - 2), compactionB__, TStringOpsNodesFactory.decodeCompactionLevel(((s0_.cachedLen1_state_0_ & 0x38) >>> 3) - 2), INLINED_ONE_LENGTH_);
                        }
                        s0_ = s0_.next_;
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value);
            }

            private int executeAndSpecialize(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, AbstractTruffleString arg4Value, byte[] arg5Value, long arg6Value, int arg7Value, int arg8Value, byte[] arg9Value) {
                CachedLen1Data s0_;
                TruffleString.CompactionLevel compactionA__;
                TruffleString.CompactionLevel compactionB__;
                block3: {
                    CachedLen1Data s0_original;
                    int state_0 = this.state_0_.get(arg0Value);
                    compactionB__ = null;
                    compactionA__ = null;
                    do {
                        int count0_ = 0;
                        s0_original = s0_ = this.cachedLen1_cache.getVolatile(arg0Value);
                        while (s0_ != null && ((compactionA__ = TruffleString.CompactionLevel.fromStride(arg1Value.stride())) != TStringOpsNodesFactory.decodeCompactionLevel(((s0_.cachedLen1_state_0_ & 7) >>> 0) - 2) || (compactionB__ = TruffleString.CompactionLevel.fromStride(arg4Value.stride())) != TStringOpsNodesFactory.decodeCompactionLevel(((s0_.cachedLen1_state_0_ & 0x38) >>> 3) - 2))) {
                            ++count0_;
                            s0_ = s0_.next_;
                        }
                        if (s0_ != null || count0_ >= 9) break block3;
                        s0_ = arg0Value.insert(new CachedLen1Data(s0_original));
                        compactionA__ = TruffleString.CompactionLevel.fromStride(arg1Value.stride());
                        s0_.cachedLen1_state_0_ |= TStringOpsNodesFactory.encodeCompactionLevel(compactionA__) + 2 << 0;
                        compactionB__ = TruffleString.CompactionLevel.fromStride(arg4Value.stride());
                        s0_.cachedLen1_state_0_ |= TStringOpsNodesFactory.encodeCompactionLevel(compactionB__) + 2 << 3;
                    } while (!this.cachedLen1_cache.compareAndSet(arg0Value, s0_original, s0_));
                    this.state_0_.set(arg0Value, state_0 |= 1);
                }
                if (s0_ != null) {
                    return TStringOpsNodes.RawLastIndexOfStringNode.cachedLen1(s0_, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, compactionA__, TStringOpsNodesFactory.decodeCompactionLevel(((s0_.cachedLen1_state_0_ & 7) >>> 0) - 2), compactionB__, TStringOpsNodesFactory.decodeCompactionLevel(((s0_.cachedLen1_state_0_ & 0x38) >>> 3) - 2), INLINED_ONE_LENGTH_);
                }
                throw RawLastIndexOfStringNodeGen.newUnsupportedSpecializationException10LLLJLLJIIL(this, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value);
            }
        }

        @GeneratedBy(value=TStringOpsNodes.RawLastIndexOfStringNode.class)
        @DenyReplace
        private static final class CachedLen1Data
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @Node.Child
            CachedLen1Data next_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int cachedLen1_state_0_;

            CachedLen1Data(CachedLen1Data next_) {
                this.next_ = next_;
            }

            private static MethodHandles.Lookup lookup_() {
                return MethodHandles.lookup();
            }
        }
    }

    @GeneratedBy(value=TStringOpsNodes.RawIndexOfStringNode.class)
    static final class RawIndexOfStringNodeGen {
        private static final InlineSupport.StateField CACHED_RAW_INDEX_OF_STRING_NODE_CACHED_STATE_0_UPDATER = InlineSupport.StateField.create(CachedData.lookup_(), "cached_state_0_");
        private static final InlinedConditionProfile INLINED_ONE_LENGTH_ = InlinedConditionProfile.inline(InlineSupport.InlineTarget.create(InlinedConditionProfile.class, CACHED_RAW_INDEX_OF_STRING_NODE_CACHED_STATE_0_UPDATER.subUpdater(6, 2)));
        private static final Uncached UNCACHED = new Uncached();

        RawIndexOfStringNodeGen() {
        }

        @CompilerDirectives.TruffleBoundary
        private static UnsupportedSpecializationException newUnsupportedSpecializationException10LLLJLLJIIL(Node thisNode_, Object arg0Value, Object arg1Value, Object arg2Value, long arg3Value, Object arg4Value, Object arg5Value, long arg6Value, int arg7Value, int arg8Value, Object arg9Value) {
            return new UnsupportedSpecializationException(thisNode_, null, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value);
        }

        @NeverDefault
        public static TStringOpsNodes.RawIndexOfStringNode getUncached() {
            return UNCACHED;
        }

        @NeverDefault
        public static TStringOpsNodes.RawIndexOfStringNode inline(@InlineSupport.RequiredFields(value={@InlineSupport.RequiredField(bits=1, value=InlineSupport.StateField.class), @InlineSupport.RequiredField(type=Node.class, value=InlineSupport.ReferenceField.class)}) InlineSupport.InlineTarget target) {
            return new Inlined(target);
        }

        @GeneratedBy(value=TStringOpsNodes.RawIndexOfStringNode.class)
        @DenyReplace
        private static final class Uncached
        extends TStringOpsNodes.RawIndexOfStringNode
        implements UnadoptableNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            int execute(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, AbstractTruffleString arg4Value, byte[] arg5Value, long arg6Value, int arg7Value, int arg8Value, byte[] arg9Value) {
                return TStringOpsNodes.RawIndexOfStringNode.doCached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, TruffleString.CompactionLevel.fromStride(arg1Value.stride()), TruffleString.CompactionLevel.fromStride(arg1Value.stride()), TruffleString.CompactionLevel.fromStride(arg4Value.stride()), TruffleString.CompactionLevel.fromStride(arg4Value.stride()), InlinedConditionProfile.getUncached());
            }
        }

        @GeneratedBy(value=TStringOpsNodes.RawIndexOfStringNode.class)
        @DenyReplace
        private static final class Inlined
        extends TStringOpsNodes.RawIndexOfStringNode
        implements UnadoptableNode {
            private final InlineSupport.StateField state_0_;
            private final InlineSupport.ReferenceField<CachedData> cached_cache;

            private Inlined(InlineSupport.InlineTarget target) {
                assert (target.getTargetClass().isAssignableFrom(TStringOpsNodes.RawIndexOfStringNode.class));
                this.state_0_ = target.getState(0, 1);
                this.cached_cache = target.getReference(1, CachedData.class);
            }

            @Override
            @ExplodeLoop
            int execute(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, AbstractTruffleString arg4Value, byte[] arg5Value, long arg6Value, int arg7Value, int arg8Value, byte[] arg9Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if (state_0 != 0) {
                    CachedData s0_ = this.cached_cache.get(arg0Value);
                    while (s0_ != null) {
                        TruffleString.CompactionLevel compactionB__;
                        TruffleString.CompactionLevel compactionA__ = TruffleString.CompactionLevel.fromStride(arg1Value.stride());
                        if (compactionA__ == TStringOpsNodesFactory.decodeCompactionLevel(((s0_.cached_state_0_ & 7) >>> 0) - 2) && (compactionB__ = TruffleString.CompactionLevel.fromStride(arg4Value.stride())) == TStringOpsNodesFactory.decodeCompactionLevel(((s0_.cached_state_0_ & 0x38) >>> 3) - 2)) {
                            return TStringOpsNodes.RawIndexOfStringNode.doCached(s0_, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, compactionA__, TStringOpsNodesFactory.decodeCompactionLevel(((s0_.cached_state_0_ & 7) >>> 0) - 2), compactionB__, TStringOpsNodesFactory.decodeCompactionLevel(((s0_.cached_state_0_ & 0x38) >>> 3) - 2), INLINED_ONE_LENGTH_);
                        }
                        s0_ = s0_.next_;
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value);
            }

            private int executeAndSpecialize(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, AbstractTruffleString arg4Value, byte[] arg5Value, long arg6Value, int arg7Value, int arg8Value, byte[] arg9Value) {
                CachedData s0_;
                TruffleString.CompactionLevel compactionA__;
                TruffleString.CompactionLevel compactionB__;
                block3: {
                    CachedData s0_original;
                    int state_0 = this.state_0_.get(arg0Value);
                    compactionB__ = null;
                    compactionA__ = null;
                    do {
                        int count0_ = 0;
                        s0_original = s0_ = this.cached_cache.getVolatile(arg0Value);
                        while (s0_ != null && ((compactionA__ = TruffleString.CompactionLevel.fromStride(arg1Value.stride())) != TStringOpsNodesFactory.decodeCompactionLevel(((s0_.cached_state_0_ & 7) >>> 0) - 2) || (compactionB__ = TruffleString.CompactionLevel.fromStride(arg4Value.stride())) != TStringOpsNodesFactory.decodeCompactionLevel(((s0_.cached_state_0_ & 0x38) >>> 3) - 2))) {
                            ++count0_;
                            s0_ = s0_.next_;
                        }
                        if (s0_ != null || count0_ >= 9) break block3;
                        s0_ = arg0Value.insert(new CachedData(s0_original));
                        compactionA__ = TruffleString.CompactionLevel.fromStride(arg1Value.stride());
                        s0_.cached_state_0_ |= TStringOpsNodesFactory.encodeCompactionLevel(compactionA__) + 2 << 0;
                        compactionB__ = TruffleString.CompactionLevel.fromStride(arg4Value.stride());
                        s0_.cached_state_0_ |= TStringOpsNodesFactory.encodeCompactionLevel(compactionB__) + 2 << 3;
                    } while (!this.cached_cache.compareAndSet(arg0Value, s0_original, s0_));
                    this.state_0_.set(arg0Value, state_0 |= 1);
                }
                if (s0_ != null) {
                    return TStringOpsNodes.RawIndexOfStringNode.doCached(s0_, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, compactionA__, TStringOpsNodesFactory.decodeCompactionLevel(((s0_.cached_state_0_ & 7) >>> 0) - 2), compactionB__, TStringOpsNodesFactory.decodeCompactionLevel(((s0_.cached_state_0_ & 0x38) >>> 3) - 2), INLINED_ONE_LENGTH_);
                }
                throw RawIndexOfStringNodeGen.newUnsupportedSpecializationException10LLLJLLJIIL(this, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value);
            }
        }

        @GeneratedBy(value=TStringOpsNodes.RawIndexOfStringNode.class)
        @DenyReplace
        private static final class CachedData
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @Node.Child
            CachedData next_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int cached_state_0_;

            CachedData(CachedData next_) {
                this.next_ = next_;
            }

            private static MethodHandles.Lookup lookup_() {
                return MethodHandles.lookup();
            }
        }
    }

    @GeneratedBy(value=TStringOpsNodes.RawLastIndexOfCodePointNode.class)
    static final class RawLastIndexOfCodePointNodeGen {
        private static final Uncached UNCACHED = new Uncached();

        RawLastIndexOfCodePointNodeGen() {
        }

        @CompilerDirectives.TruffleBoundary
        private static UnsupportedSpecializationException newUnsupportedSpecializationException7LLLJIII(Node thisNode_, Object arg0Value, Object arg1Value, Object arg2Value, long arg3Value, int arg4Value, int arg5Value, int arg6Value) {
            return new UnsupportedSpecializationException(thisNode_, null, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
        }

        @NeverDefault
        public static TStringOpsNodes.RawLastIndexOfCodePointNode getUncached() {
            return UNCACHED;
        }

        @NeverDefault
        public static TStringOpsNodes.RawLastIndexOfCodePointNode inline(@InlineSupport.RequiredField(bits=12, value=InlineSupport.StateField.class) InlineSupport.InlineTarget target) {
            return new Inlined(target);
        }

        @GeneratedBy(value=TStringOpsNodes.RawLastIndexOfCodePointNode.class)
        @DenyReplace
        private static final class Uncached
        extends TStringOpsNodes.RawLastIndexOfCodePointNode
        implements UnadoptableNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            int execute(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, int arg4Value, int arg5Value, int arg6Value) {
                return TStringOpsNodes.RawLastIndexOfCodePointNode.cached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, TruffleString.CompactionLevel.fromStride(arg1Value.stride()), TruffleString.CompactionLevel.fromStride(arg1Value.stride()));
            }
        }

        @GeneratedBy(value=TStringOpsNodes.RawLastIndexOfCodePointNode.class)
        @DenyReplace
        private static final class Inlined
        extends TStringOpsNodes.RawLastIndexOfCodePointNode
        implements UnadoptableNode {
            private final InlineSupport.StateField state_0_;

            private Inlined(InlineSupport.InlineTarget target) {
                assert (target.getTargetClass().isAssignableFrom(TStringOpsNodes.RawLastIndexOfCodePointNode.class));
                this.state_0_ = target.getState(0, 12);
            }

            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, int arg4Value, int arg5Value, int arg6Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((state_0 & 0x111) != 0) {
                    TruffleString.CompactionLevel compaction__;
                    if ((state_0 & 1) != 0 && (state_0 & 0xE) >>> 1 != 0 && (compaction__ = TruffleString.CompactionLevel.fromStride(arg1Value.stride())) == TStringOpsNodesFactory.decodeCompactionLevel(((state_0 & 0xE) >>> 1) - 2)) {
                        return TStringOpsNodes.RawLastIndexOfCodePointNode.cached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, compaction__, TStringOpsNodesFactory.decodeCompactionLevel(((state_0 & 0xE) >>> 1) - 2));
                    }
                    if ((state_0 & 0x10) != 0 && (state_0 & 0xE0) >>> 5 != 0 && (compaction__ = TruffleString.CompactionLevel.fromStride(arg1Value.stride())) == TStringOpsNodesFactory.decodeCompactionLevel(((state_0 & 0xE0) >>> 5) - 2)) {
                        return TStringOpsNodes.RawLastIndexOfCodePointNode.cached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, compaction__, TStringOpsNodesFactory.decodeCompactionLevel(((state_0 & 0xE0) >>> 5) - 2));
                    }
                    if ((state_0 & 0x100) != 0 && (state_0 & 0xE00) >>> 9 != 0 && (compaction__ = TruffleString.CompactionLevel.fromStride(arg1Value.stride())) == TStringOpsNodesFactory.decodeCompactionLevel(((state_0 & 0xE00) >>> 9) - 2)) {
                        return TStringOpsNodes.RawLastIndexOfCodePointNode.cached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, compaction__, TStringOpsNodesFactory.decodeCompactionLevel(((state_0 & 0xE00) >>> 9) - 2));
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
            }

            private int executeAndSpecialize(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, int arg4Value, int arg5Value, int arg6Value) {
                int state_0 = this.state_0_.get(arg0Value);
                TruffleString.CompactionLevel compaction__ = null;
                boolean Cached0_duplicateFound_ = false;
                if ((state_0 & 1) != 0 && (state_0 & 0xE) >>> 1 != 0 && (compaction__ = TruffleString.CompactionLevel.fromStride(arg1Value.stride())) == TStringOpsNodesFactory.decodeCompactionLevel(((state_0 & 0xE) >>> 1) - 2)) {
                    Cached0_duplicateFound_ = true;
                }
                if (!Cached0_duplicateFound_ && (state_0 & 1) == 0) {
                    compaction__ = TruffleString.CompactionLevel.fromStride(arg1Value.stride());
                    state_0 |= TStringOpsNodesFactory.encodeCompactionLevel(compaction__) + 2 << 1;
                    this.state_0_.set(arg0Value, state_0 |= 1);
                    Cached0_duplicateFound_ = true;
                }
                if (Cached0_duplicateFound_) {
                    return TStringOpsNodes.RawLastIndexOfCodePointNode.cached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, compaction__, TStringOpsNodesFactory.decodeCompactionLevel(((state_0 & 0xE) >>> 1) - 2));
                }
                compaction__ = null;
                boolean Cached1_duplicateFound_ = false;
                if ((state_0 & 0x10) != 0 && (state_0 & 0xE0) >>> 5 != 0 && (compaction__ = TruffleString.CompactionLevel.fromStride(arg1Value.stride())) == TStringOpsNodesFactory.decodeCompactionLevel(((state_0 & 0xE0) >>> 5) - 2)) {
                    Cached1_duplicateFound_ = true;
                }
                if (!Cached1_duplicateFound_ && (state_0 & 0x10) == 0) {
                    compaction__ = TruffleString.CompactionLevel.fromStride(arg1Value.stride());
                    state_0 |= TStringOpsNodesFactory.encodeCompactionLevel(compaction__) + 2 << 5;
                    this.state_0_.set(arg0Value, state_0 |= 0x10);
                    Cached1_duplicateFound_ = true;
                }
                if (Cached1_duplicateFound_) {
                    return TStringOpsNodes.RawLastIndexOfCodePointNode.cached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, compaction__, TStringOpsNodesFactory.decodeCompactionLevel(((state_0 & 0xE0) >>> 5) - 2));
                }
                compaction__ = null;
                boolean Cached2_duplicateFound_ = false;
                if ((state_0 & 0x100) != 0 && (state_0 & 0xE00) >>> 9 != 0 && (compaction__ = TruffleString.CompactionLevel.fromStride(arg1Value.stride())) == TStringOpsNodesFactory.decodeCompactionLevel(((state_0 & 0xE00) >>> 9) - 2)) {
                    Cached2_duplicateFound_ = true;
                }
                if (!Cached2_duplicateFound_ && (state_0 & 0x100) == 0) {
                    compaction__ = TruffleString.CompactionLevel.fromStride(arg1Value.stride());
                    state_0 |= TStringOpsNodesFactory.encodeCompactionLevel(compaction__) + 2 << 9;
                    this.state_0_.set(arg0Value, state_0 |= 0x100);
                    Cached2_duplicateFound_ = true;
                }
                if (Cached2_duplicateFound_) {
                    return TStringOpsNodes.RawLastIndexOfCodePointNode.cached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, compaction__, TStringOpsNodesFactory.decodeCompactionLevel(((state_0 & 0xE00) >>> 9) - 2));
                }
                throw RawLastIndexOfCodePointNodeGen.newUnsupportedSpecializationException7LLLJIII(this, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
            }
        }
    }

    @GeneratedBy(value=TStringOpsNodes.RawIndexOfCodePointNode.class)
    static final class RawIndexOfCodePointNodeGen {
        private static final Uncached UNCACHED = new Uncached();

        RawIndexOfCodePointNodeGen() {
        }

        @CompilerDirectives.TruffleBoundary
        private static UnsupportedSpecializationException newUnsupportedSpecializationException7LLLJIII(Node thisNode_, Object arg0Value, Object arg1Value, Object arg2Value, long arg3Value, int arg4Value, int arg5Value, int arg6Value) {
            return new UnsupportedSpecializationException(thisNode_, null, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
        }

        @NeverDefault
        public static TStringOpsNodes.RawIndexOfCodePointNode getUncached() {
            return UNCACHED;
        }

        @NeverDefault
        public static TStringOpsNodes.RawIndexOfCodePointNode inline(@InlineSupport.RequiredField(bits=12, value=InlineSupport.StateField.class) InlineSupport.InlineTarget target) {
            return new Inlined(target);
        }

        @GeneratedBy(value=TStringOpsNodes.RawIndexOfCodePointNode.class)
        @DenyReplace
        private static final class Uncached
        extends TStringOpsNodes.RawIndexOfCodePointNode
        implements UnadoptableNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            int execute(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, int arg4Value, int arg5Value, int arg6Value) {
                return TStringOpsNodes.RawIndexOfCodePointNode.cached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, TruffleString.CompactionLevel.fromStride(arg1Value.stride()), TruffleString.CompactionLevel.fromStride(arg1Value.stride()));
            }
        }

        @GeneratedBy(value=TStringOpsNodes.RawIndexOfCodePointNode.class)
        @DenyReplace
        private static final class Inlined
        extends TStringOpsNodes.RawIndexOfCodePointNode
        implements UnadoptableNode {
            private final InlineSupport.StateField state_0_;

            private Inlined(InlineSupport.InlineTarget target) {
                assert (target.getTargetClass().isAssignableFrom(TStringOpsNodes.RawIndexOfCodePointNode.class));
                this.state_0_ = target.getState(0, 12);
            }

            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, int arg4Value, int arg5Value, int arg6Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if ((state_0 & 0x111) != 0) {
                    TruffleString.CompactionLevel compaction__;
                    if ((state_0 & 1) != 0 && (state_0 & 0xE) >>> 1 != 0 && (compaction__ = TruffleString.CompactionLevel.fromStride(arg1Value.stride())) == TStringOpsNodesFactory.decodeCompactionLevel(((state_0 & 0xE) >>> 1) - 2)) {
                        return TStringOpsNodes.RawIndexOfCodePointNode.cached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, compaction__, TStringOpsNodesFactory.decodeCompactionLevel(((state_0 & 0xE) >>> 1) - 2));
                    }
                    if ((state_0 & 0x10) != 0 && (state_0 & 0xE0) >>> 5 != 0 && (compaction__ = TruffleString.CompactionLevel.fromStride(arg1Value.stride())) == TStringOpsNodesFactory.decodeCompactionLevel(((state_0 & 0xE0) >>> 5) - 2)) {
                        return TStringOpsNodes.RawIndexOfCodePointNode.cached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, compaction__, TStringOpsNodesFactory.decodeCompactionLevel(((state_0 & 0xE0) >>> 5) - 2));
                    }
                    if ((state_0 & 0x100) != 0 && (state_0 & 0xE00) >>> 9 != 0 && (compaction__ = TruffleString.CompactionLevel.fromStride(arg1Value.stride())) == TStringOpsNodesFactory.decodeCompactionLevel(((state_0 & 0xE00) >>> 9) - 2)) {
                        return TStringOpsNodes.RawIndexOfCodePointNode.cached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, compaction__, TStringOpsNodesFactory.decodeCompactionLevel(((state_0 & 0xE00) >>> 9) - 2));
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
            }

            private int executeAndSpecialize(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, int arg4Value, int arg5Value, int arg6Value) {
                int state_0 = this.state_0_.get(arg0Value);
                TruffleString.CompactionLevel compaction__ = null;
                boolean Cached0_duplicateFound_ = false;
                if ((state_0 & 1) != 0 && (state_0 & 0xE) >>> 1 != 0 && (compaction__ = TruffleString.CompactionLevel.fromStride(arg1Value.stride())) == TStringOpsNodesFactory.decodeCompactionLevel(((state_0 & 0xE) >>> 1) - 2)) {
                    Cached0_duplicateFound_ = true;
                }
                if (!Cached0_duplicateFound_ && (state_0 & 1) == 0) {
                    compaction__ = TruffleString.CompactionLevel.fromStride(arg1Value.stride());
                    state_0 |= TStringOpsNodesFactory.encodeCompactionLevel(compaction__) + 2 << 1;
                    this.state_0_.set(arg0Value, state_0 |= 1);
                    Cached0_duplicateFound_ = true;
                }
                if (Cached0_duplicateFound_) {
                    return TStringOpsNodes.RawIndexOfCodePointNode.cached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, compaction__, TStringOpsNodesFactory.decodeCompactionLevel(((state_0 & 0xE) >>> 1) - 2));
                }
                compaction__ = null;
                boolean Cached1_duplicateFound_ = false;
                if ((state_0 & 0x10) != 0 && (state_0 & 0xE0) >>> 5 != 0 && (compaction__ = TruffleString.CompactionLevel.fromStride(arg1Value.stride())) == TStringOpsNodesFactory.decodeCompactionLevel(((state_0 & 0xE0) >>> 5) - 2)) {
                    Cached1_duplicateFound_ = true;
                }
                if (!Cached1_duplicateFound_ && (state_0 & 0x10) == 0) {
                    compaction__ = TruffleString.CompactionLevel.fromStride(arg1Value.stride());
                    state_0 |= TStringOpsNodesFactory.encodeCompactionLevel(compaction__) + 2 << 5;
                    this.state_0_.set(arg0Value, state_0 |= 0x10);
                    Cached1_duplicateFound_ = true;
                }
                if (Cached1_duplicateFound_) {
                    return TStringOpsNodes.RawIndexOfCodePointNode.cached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, compaction__, TStringOpsNodesFactory.decodeCompactionLevel(((state_0 & 0xE0) >>> 5) - 2));
                }
                compaction__ = null;
                boolean Cached2_duplicateFound_ = false;
                if ((state_0 & 0x100) != 0 && (state_0 & 0xE00) >>> 9 != 0 && (compaction__ = TruffleString.CompactionLevel.fromStride(arg1Value.stride())) == TStringOpsNodesFactory.decodeCompactionLevel(((state_0 & 0xE00) >>> 9) - 2)) {
                    Cached2_duplicateFound_ = true;
                }
                if (!Cached2_duplicateFound_ && (state_0 & 0x100) == 0) {
                    compaction__ = TruffleString.CompactionLevel.fromStride(arg1Value.stride());
                    state_0 |= TStringOpsNodesFactory.encodeCompactionLevel(compaction__) + 2 << 9;
                    this.state_0_.set(arg0Value, state_0 |= 0x100);
                    Cached2_duplicateFound_ = true;
                }
                if (Cached2_duplicateFound_) {
                    return TStringOpsNodes.RawIndexOfCodePointNode.cached(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, compaction__, TStringOpsNodesFactory.decodeCompactionLevel(((state_0 & 0xE00) >>> 9) - 2));
                }
                throw RawIndexOfCodePointNodeGen.newUnsupportedSpecializationException7LLLJIII(this, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
            }
        }
    }

    @GeneratedBy(value=TStringOpsNodes.IndexOfAnyIntNode.class)
    static final class IndexOfAnyIntNodeGen {
        private static final Uncached UNCACHED = new Uncached();

        IndexOfAnyIntNodeGen() {
        }

        @CompilerDirectives.TruffleBoundary
        private static UnsupportedSpecializationException newUnsupportedSpecializationException7LLLJIIL(Node thisNode_, Object arg0Value, Object arg1Value, Object arg2Value, long arg3Value, int arg4Value, int arg5Value, Object arg6Value) {
            return new UnsupportedSpecializationException(thisNode_, null, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
        }

        @NeverDefault
        public static TStringOpsNodes.IndexOfAnyIntNode getUncached() {
            return UNCACHED;
        }

        @NeverDefault
        public static TStringOpsNodes.IndexOfAnyIntNode inline(@InlineSupport.RequiredField(bits=5, value=InlineSupport.StateField.class) InlineSupport.InlineTarget target) {
            return new Inlined(target);
        }

        @GeneratedBy(value=TStringOpsNodes.IndexOfAnyIntNode.class)
        @DenyReplace
        private static final class Uncached
        extends TStringOpsNodes.IndexOfAnyIntNode
        implements UnadoptableNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            int execute(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, int arg4Value, int arg5Value, int[] arg6Value) {
                if (TStringGuards.isStride0(arg1Value) && arg6Value.length == 1) {
                    return this.stride0(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                if (TStringGuards.isStride0(arg1Value) && arg6Value.length > 1) {
                    return this.stride0MultiValue(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                if (TStringGuards.isStride1(arg1Value) && arg6Value.length == 1) {
                    return this.stride1(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                if (TStringGuards.isStride1(arg1Value) && arg6Value.length > 1) {
                    return this.stride1MultiValue(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                if (TStringGuards.isStride2(arg1Value)) {
                    return this.stride2(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                throw IndexOfAnyIntNodeGen.newUnsupportedSpecializationException7LLLJIIL(this, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
            }
        }

        @GeneratedBy(value=TStringOpsNodes.IndexOfAnyIntNode.class)
        @DenyReplace
        private static final class Inlined
        extends TStringOpsNodes.IndexOfAnyIntNode
        implements UnadoptableNode {
            private final InlineSupport.StateField state_0_;

            private Inlined(InlineSupport.InlineTarget target) {
                assert (target.getTargetClass().isAssignableFrom(TStringOpsNodes.IndexOfAnyIntNode.class));
                this.state_0_ = target.getState(0, 5);
            }

            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, int arg4Value, int arg5Value, int[] arg6Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if (state_0 != 0) {
                    if ((state_0 & 1) != 0 && TStringGuards.isStride0(arg1Value) && arg6Value.length == 1) {
                        return this.stride0(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                    }
                    if ((state_0 & 2) != 0 && TStringGuards.isStride0(arg1Value) && arg6Value.length > 1) {
                        return this.stride0MultiValue(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                    }
                    if ((state_0 & 4) != 0 && TStringGuards.isStride1(arg1Value) && arg6Value.length == 1) {
                        return this.stride1(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                    }
                    if ((state_0 & 8) != 0 && TStringGuards.isStride1(arg1Value) && arg6Value.length > 1) {
                        return this.stride1MultiValue(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                    }
                    if ((state_0 & 0x10) != 0 && TStringGuards.isStride2(arg1Value)) {
                        return this.stride2(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
            }

            private int executeAndSpecialize(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, int arg4Value, int arg5Value, int[] arg6Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if (TStringGuards.isStride0(arg1Value) && arg6Value.length == 1) {
                    this.state_0_.set(arg0Value, state_0 |= 1);
                    return this.stride0(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                if (TStringGuards.isStride0(arg1Value) && arg6Value.length > 1) {
                    this.state_0_.set(arg0Value, state_0 |= 2);
                    return this.stride0MultiValue(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                if (TStringGuards.isStride1(arg1Value) && arg6Value.length == 1) {
                    this.state_0_.set(arg0Value, state_0 |= 4);
                    return this.stride1(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                if (TStringGuards.isStride1(arg1Value) && arg6Value.length > 1) {
                    this.state_0_.set(arg0Value, state_0 |= 8);
                    return this.stride1MultiValue(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                if (TStringGuards.isStride2(arg1Value)) {
                    this.state_0_.set(arg0Value, state_0 |= 0x10);
                    return this.stride2(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                throw IndexOfAnyIntNodeGen.newUnsupportedSpecializationException7LLLJIIL(this, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
            }
        }
    }

    @GeneratedBy(value=TStringOpsNodes.IndexOfAnyCharUTF16Node.class)
    static final class IndexOfAnyCharUTF16NodeGen {
        private static final Uncached UNCACHED = new Uncached();

        IndexOfAnyCharUTF16NodeGen() {
        }

        @CompilerDirectives.TruffleBoundary
        private static UnsupportedSpecializationException newUnsupportedSpecializationException7LLLJIIL(Node thisNode_, Object arg0Value, Object arg1Value, Object arg2Value, long arg3Value, int arg4Value, int arg5Value, Object arg6Value) {
            return new UnsupportedSpecializationException(thisNode_, null, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
        }

        @NeverDefault
        public static TStringOpsNodes.IndexOfAnyCharUTF16Node getUncached() {
            return UNCACHED;
        }

        @NeverDefault
        public static TStringOpsNodes.IndexOfAnyCharUTF16Node inline(@InlineSupport.RequiredField(bits=3, value=InlineSupport.StateField.class) InlineSupport.InlineTarget target) {
            return new Inlined(target);
        }

        @GeneratedBy(value=TStringOpsNodes.IndexOfAnyCharUTF16Node.class)
        @DenyReplace
        private static final class Uncached
        extends TStringOpsNodes.IndexOfAnyCharUTF16Node
        implements UnadoptableNode {
            private Uncached() {
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            int execute(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, int arg4Value, int arg5Value, char[] arg6Value) {
                if (TStringGuards.isStride0(arg1Value) && arg6Value.length == 1) {
                    return this.stride0(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                if (TStringGuards.isStride0(arg1Value) && arg6Value.length > 1) {
                    return this.stride0MultiValue(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                if (TStringGuards.isStride1(arg1Value)) {
                    return this.stride1(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                throw IndexOfAnyCharUTF16NodeGen.newUnsupportedSpecializationException7LLLJIIL(this, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
            }
        }

        @GeneratedBy(value=TStringOpsNodes.IndexOfAnyCharUTF16Node.class)
        @DenyReplace
        private static final class Inlined
        extends TStringOpsNodes.IndexOfAnyCharUTF16Node
        implements UnadoptableNode {
            private final InlineSupport.StateField state_0_;

            private Inlined(InlineSupport.InlineTarget target) {
                assert (target.getTargetClass().isAssignableFrom(TStringOpsNodes.IndexOfAnyCharUTF16Node.class));
                this.state_0_ = target.getState(0, 3);
            }

            @Override
            int execute(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, int arg4Value, int arg5Value, char[] arg6Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if (state_0 != 0) {
                    if ((state_0 & 1) != 0 && TStringGuards.isStride0(arg1Value) && arg6Value.length == 1) {
                        return this.stride0(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                    }
                    if ((state_0 & 2) != 0 && TStringGuards.isStride0(arg1Value) && arg6Value.length > 1) {
                        return this.stride0MultiValue(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                    }
                    if ((state_0 & 4) != 0 && TStringGuards.isStride1(arg1Value)) {
                        return this.stride1(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
            }

            private int executeAndSpecialize(Node arg0Value, AbstractTruffleString arg1Value, byte[] arg2Value, long arg3Value, int arg4Value, int arg5Value, char[] arg6Value) {
                int state_0 = this.state_0_.get(arg0Value);
                if (TStringGuards.isStride0(arg1Value) && arg6Value.length == 1) {
                    this.state_0_.set(arg0Value, state_0 |= 1);
                    return this.stride0(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                if (TStringGuards.isStride0(arg1Value) && arg6Value.length > 1) {
                    this.state_0_.set(arg0Value, state_0 |= 2);
                    return this.stride0MultiValue(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                if (TStringGuards.isStride1(arg1Value)) {
                    this.state_0_.set(arg0Value, state_0 |= 4);
                    return this.stride1(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
                }
                throw IndexOfAnyCharUTF16NodeGen.newUnsupportedSpecializationException7LLLJIIL(this, arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value);
            }
        }
    }
}

