/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.orm.hibernate.cfg;

import java.util.HashSet;
import java.util.Set;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.commons.GrailsClass;
import org.codehaus.groovy.grails.commons.GrailsDomainClass;
import org.codehaus.groovy.grails.orm.hibernate.cfg.GrailsDomainBinder;
import org.codehaus.groovy.grails.orm.hibernate.cfg.GrailsDomainConfiguration;
import org.codehaus.groovy.grails.orm.hibernate.cfg.Mapping;
import org.hibernate.MappingException;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.Mappings;

public class DefaultGrailsDomainConfiguration
extends Configuration
implements GrailsDomainConfiguration {
    private static final long serialVersionUID = -7115087342689305517L;
    private GrailsApplication grailsApplication;
    private Set<GrailsDomainClass> domainClasses = new HashSet<GrailsDomainClass>();
    private boolean configLocked;

    public GrailsDomainConfiguration addDomainClass(GrailsDomainClass domainClass) {
        if (domainClass.getMappingStrategy().equalsIgnoreCase("GORM")) {
            this.domainClasses.add(domainClass);
        }
        return this;
    }

    public void setGrailsApplication(GrailsApplication application) {
        this.grailsApplication = application;
        if (this.grailsApplication != null) {
            GrailsClass[] existingDomainClasses;
            for (GrailsClass existingDomainClass : existingDomainClasses = this.grailsApplication.getArtefacts("Domain")) {
                this.addDomainClass((GrailsDomainClass)existingDomainClass);
            }
        }
    }

    protected void secondPassCompile() throws MappingException {
        if (this.configLocked) {
            return;
        }
        if (this.grailsApplication != null) {
            Thread.currentThread().setContextClassLoader((ClassLoader)this.grailsApplication.getClassLoader());
        }
        for (GrailsDomainClass domainClass : this.domainClasses) {
            GrailsDomainBinder.evaluateMapping(domainClass);
        }
        for (GrailsDomainClass domainClass : this.domainClasses) {
            Mappings mappings = super.createMappings();
            Mapping m = GrailsDomainBinder.getMapping(domainClass);
            mappings.setAutoImport(m == null || m.getAutoImport());
            GrailsDomainBinder.bindClass(domainClass, mappings);
        }
        super.secondPassCompile();
        this.configLocked = true;
    }
}

