/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.orm.hibernate.cfg;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.commons.AnnotationDomainClassArtefactHandler;
import org.codehaus.groovy.grails.commons.ArtefactHandler;
import org.codehaus.groovy.grails.commons.GrailsApplication;
import org.codehaus.groovy.grails.commons.GrailsClass;
import org.codehaus.groovy.grails.commons.GrailsDomainClass;
import org.codehaus.groovy.grails.orm.hibernate.cfg.GrailsDomainBinder;
import org.codehaus.groovy.grails.orm.hibernate.cfg.GrailsDomainConfiguration;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.AnnotationConfiguration;

public class GrailsAnnotationConfiguration
extends AnnotationConfiguration
implements GrailsDomainConfiguration {
    private static final Log LOG = LogFactory.getLog(GrailsAnnotationConfiguration.class);
    private static final long serialVersionUID = -7115087342689305517L;
    private GrailsApplication grailsApplication;
    private Set<GrailsDomainClass> domainClasses = new HashSet<GrailsDomainClass>();
    private boolean configLocked;

    public GrailsDomainConfiguration addDomainClass(GrailsDomainClass domainClass) {
        if (!AnnotationDomainClassArtefactHandler.isJPADomainClass((Class)domainClass.getClazz())) {
            this.domainClasses.add(domainClass);
        }
        return this;
    }

    public void setGrailsApplication(GrailsApplication application) {
        application.registerArtefactHandler((ArtefactHandler)new AnnotationDomainClassArtefactHandler());
        this.grailsApplication = application;
        if (this.grailsApplication != null) {
            GrailsClass[] existingDomainClasses = this.grailsApplication.getArtefacts("Domain");
            for (int i = 0; i < existingDomainClasses.length; ++i) {
                this.addDomainClass((GrailsDomainClass)existingDomainClasses[i]);
            }
        }
    }

    public SessionFactory buildSessionFactory() throws HibernateException {
        if (this.grailsApplication != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"[GrailsAnnotationConfiguration] Setting context class loader to Grails GroovyClassLoader");
            }
            Thread.currentThread().setContextClassLoader((ClassLoader)this.grailsApplication.getClassLoader());
        }
        SessionFactory sessionFactory = super.buildSessionFactory();
        return sessionFactory;
    }

    protected void secondPassCompile() throws MappingException {
        if (this.configLocked) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("[GrailsAnnotationConfiguration] [" + this.domainClasses.size() + "] Grails domain classes to bind to persistence runtime"));
        }
        for (GrailsDomainClass domainClass : this.domainClasses) {
            GrailsDomainBinder.evaluateMapping(domainClass);
        }
        for (GrailsDomainClass domainClass : this.domainClasses) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("[GrailsAnnotationConfiguration] Binding persistent class [" + domainClass.getFullName() + "]"));
            }
            GrailsDomainBinder.bindClass(domainClass, super.createMappings());
        }
        super.secondPassCompile();
        this.configLocked = true;
    }
}

