/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.orm.hibernate.metaclass;

import grails.util.GrailsNameUtils;
import groovy.lang.GString;
import groovy.lang.MissingMethodException;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.codehaus.groovy.grails.commons.GrailsClassUtils;
import org.codehaus.groovy.grails.orm.hibernate.cfg.GrailsHibernateUtil;
import org.codehaus.groovy.grails.orm.hibernate.exceptions.GrailsQueryException;
import org.codehaus.groovy.grails.orm.hibernate.metaclass.AbstractStaticPersistentMethod;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Example;
import org.springframework.orm.hibernate3.HibernateCallback;

public class FindAllPersistentMethod
extends AbstractStaticPersistentMethod {
    public FindAllPersistentMethod(SessionFactory sessionFactory, ClassLoader classLoader) {
        super(sessionFactory, classLoader, Pattern.compile("^findAll$"));
    }

    protected Object doInvokeInternal(final Class clazz, String methodName, final Object[] arguments) {
        Object arg;
        if (arguments.length == 0) {
            return this.getHibernateTemplate().loadAll(clazz);
        }
        Object object = arg = arguments[0] instanceof GString ? arguments[0].toString() : arguments[0];
        if (arg instanceof String) {
            final String query = ((String)arg).trim();
            String shortName = GrailsNameUtils.getShortName((Class)clazz);
            if (!query.matches("(?i)from(?-i)\\s+[" + clazz.getName() + "|" + shortName + "].*")) {
                throw new GrailsQueryException("Invalid query [" + query + "] for domain class [" + clazz + "]");
            }
            return super.getHibernateTemplate().executeFind(new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException, SQLException {
                    Query q = session.createQuery(query);
                    Object[] queryArgs = null;
                    Map queryNamedArgs = null;
                    int max = this.retrieveMaxValue(arguments);
                    int offset = this.retrieveOffsetValue(arguments);
                    if (arguments.length > 1) {
                        if (arguments[1] instanceof Collection) {
                            queryArgs = GrailsClassUtils.collectionToObjectArray((Collection)((Collection)arguments[1]));
                        } else if (arguments[1].getClass().isArray()) {
                            queryArgs = (Object[])arguments[1];
                        } else if (arguments[1] instanceof Map) {
                            queryNamedArgs = (Map)arguments[1];
                        }
                    }
                    if (queryArgs != null) {
                        for (int i = 0; i < queryArgs.length; ++i) {
                            if (queryArgs[i] instanceof GString) {
                                q.setParameter(i, (Object)queryArgs[i].toString());
                                continue;
                            }
                            q.setParameter(i, queryArgs[i]);
                        }
                    }
                    if (queryNamedArgs != null) {
                        for (Map.Entry entry : queryNamedArgs.entrySet()) {
                            if (!(entry.getKey() instanceof String)) {
                                throw new GrailsQueryException("Named parameter's name must be String: " + queryNamedArgs.toString());
                            }
                            String stringKey = (String)entry.getKey();
                            if ("max".equals(stringKey) || "offset".equals(stringKey)) continue;
                            Object value = entry.getValue();
                            if (value == null) {
                                q.setParameter(stringKey, null);
                                continue;
                            }
                            if (value instanceof GString) {
                                q.setParameter(stringKey, (Object)value.toString());
                                continue;
                            }
                            if (List.class.isAssignableFrom(value.getClass())) {
                                q.setParameterList(stringKey, (Collection)((List)value));
                                continue;
                            }
                            if (value.getClass().isArray()) {
                                q.setParameterList(stringKey, (Object[])value);
                                continue;
                            }
                            q.setParameter(stringKey, value);
                        }
                    }
                    if (max > 0) {
                        q.setMaxResults(max);
                    }
                    if (offset > 0) {
                        q.setFirstResult(offset);
                    }
                    return q.list();
                }

                private int retrieveMaxValue(Object[] arguments2) {
                    int result = -1;
                    if (arguments2.length > 1) {
                        result = this.retrieveInt(arguments2[1], "max");
                        if (arguments2.length > 2 && result == -1) {
                            result = this.retrieveInt(arguments2[2], "max");
                        }
                    }
                    return result;
                }

                private int retrieveOffsetValue(Object[] arguments2) {
                    int result = -1;
                    if (arguments2.length > 1) {
                        if (this.isMapWithValue(arguments2[1], "offset")) {
                            result = ((Number)((Map)arguments2[1]).get("offset")).intValue();
                        }
                        if (arguments2.length > 2 && result == -1) {
                            if (this.isMapWithValue(arguments2[2], "offset")) {
                                result = ((Number)((Map)arguments2[2]).get("offset")).intValue();
                            } else if (this.isIntegerOrLong(arguments2[1]) && this.isIntegerOrLong(arguments2[2])) {
                                result = ((Number)arguments2[2]).intValue();
                            }
                        }
                        if (arguments2.length > 3 && result == -1 && this.isIntegerOrLong(arguments2[3])) {
                            result = ((Number)arguments2[3]).intValue();
                        }
                    }
                    return result;
                }

                private int retrieveInt(Object param, String key) {
                    if (this.isMapWithValue(param, key)) {
                        return ((Number)((Map)param).get(key)).intValue();
                    }
                    if (this.isIntegerOrLong(param)) {
                        return ((Number)param).intValue();
                    }
                    return -1;
                }

                private boolean isIntegerOrLong(Object param) {
                    return param instanceof Integer || param instanceof Long;
                }

                private boolean isMapWithValue(Object param, String key) {
                    return param instanceof Map && ((Map)param).containsKey(key);
                }
            });
        }
        if (clazz.isAssignableFrom(arg.getClass())) {
            return super.getHibernateTemplate().executeFind(new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException, SQLException {
                    Example example = Example.create((Object)arg).ignoreCase();
                    Criteria crit = session.createCriteria(clazz);
                    crit.add((Criterion)example);
                    Map argsMap = arguments.length > 1 && arguments[1] instanceof Map ? (Map)arguments[1] : Collections.EMPTY_MAP;
                    GrailsHibernateUtil.populateArgumentsForCriteria(clazz, crit, argsMap);
                    return crit.list();
                }
            });
        }
        if (arguments[0] instanceof Map) {
            return super.getHibernateTemplate().executeFind(new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException, SQLException {
                    Criteria crit = session.createCriteria(clazz);
                    GrailsHibernateUtil.populateArgumentsForCriteria(clazz, crit, (Map)arguments[0]);
                    return crit.list();
                }
            });
        }
        throw new MissingMethodException(methodName, clazz, arguments);
    }
}

