/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.orm.hibernate.support;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.support.PersistenceContextInterceptor;
import org.hibernate.FlushMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.orm.hibernate3.SessionFactoryUtils;
import org.springframework.orm.hibernate3.SessionHolder;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class HibernatePersistenceContextInterceptor
implements PersistenceContextInterceptor {
    private static final Log LOG = LogFactory.getLog(HibernatePersistenceContextInterceptor.class);
    private SessionFactory sessionFactory;
    private boolean participate;

    public void destroy() {
        if (!this.participate) {
            SessionHolder holder = (SessionHolder)TransactionSynchronizationManager.unbindResource((Object)this.sessionFactory);
            LOG.debug((Object)"Closing single Hibernate session in GrailsDispatcherServlet");
            try {
                Session session = holder.getSession();
                SessionFactoryUtils.releaseSession((Session)session, (SessionFactory)this.sessionFactory);
            }
            catch (RuntimeException ex) {
                LOG.error((Object)"Unexpected exception on closing Hibernate Session", (Throwable)ex);
            }
        }
    }

    public void flush() {
        Session session = SessionFactoryUtils.getSession((SessionFactory)this.sessionFactory, (boolean)true);
        session.flush();
    }

    public void clear() {
        Session session = SessionFactoryUtils.getSession((SessionFactory)this.sessionFactory, (boolean)true);
        session.clear();
    }

    public void init() {
        if (TransactionSynchronizationManager.hasResource((Object)this.sessionFactory)) {
            this.participate = true;
        } else {
            LOG.debug((Object)"Opening single Hibernate session in HibernatePersistenceContextInterceptor");
            Session session = SessionFactoryUtils.getSession((SessionFactory)this.sessionFactory, (boolean)true);
            session.setFlushMode(FlushMode.AUTO);
            TransactionSynchronizationManager.bindResource((Object)this.sessionFactory, (Object)new SessionHolder(session));
        }
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }
}

