/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.graph.implementations;

import java.io.IOException;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import org.graphstream.graph.Edge;
import org.graphstream.graph.EdgeFactory;
import org.graphstream.graph.EdgeRejectedException;
import org.graphstream.graph.ElementNotFoundException;
import org.graphstream.graph.Graph;
import org.graphstream.graph.IdAlreadyInUseException;
import org.graphstream.graph.Node;
import org.graphstream.graph.NodeFactory;
import org.graphstream.graph.implementations.AbstractEdge;
import org.graphstream.graph.implementations.AbstractElement;
import org.graphstream.graph.implementations.AbstractNode;
import org.graphstream.stream.AttributeSink;
import org.graphstream.stream.ElementSink;
import org.graphstream.stream.GraphParseException;
import org.graphstream.stream.Pipe;
import org.graphstream.stream.Replayable;
import org.graphstream.stream.Sink;
import org.graphstream.stream.SourceBase;
import org.graphstream.stream.file.FileSink;
import org.graphstream.stream.file.FileSinkFactory;
import org.graphstream.stream.file.FileSource;
import org.graphstream.stream.file.FileSourceFactory;
import org.graphstream.stream.sync.SinkTime;
import org.graphstream.ui.layout.Layout;
import org.graphstream.ui.layout.Layouts;
import org.graphstream.ui.swingViewer.GraphRenderer;
import org.graphstream.ui.swingViewer.Viewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGraph
extends AbstractElement
implements Graph,
Replayable {
    private boolean strictChecking;
    private boolean autoCreate;
    GraphListeners listeners;
    private NodeFactory<? extends AbstractNode> nodeFactory;
    private EdgeFactory<? extends AbstractEdge> edgeFactory;
    private double step = 0.0;
    private boolean nullAttributesAreErrors;
    private long replayId = 0L;

    public AbstractGraph(String id) {
        this(id, true, false);
    }

    public AbstractGraph(String id, boolean strictChecking, boolean autoCreate) {
        super(id);
        this.strictChecking = strictChecking;
        this.autoCreate = autoCreate;
        this.listeners = new GraphListeners();
    }

    @Override
    protected void attributeChanged(String sourceId, long timeId, String attribute, AbstractElement.AttributeChangeEvent event, Object oldValue, Object newValue) {
        this.listeners.sendAttributeChangedEvent(sourceId, timeId, this.id, SourceBase.ElementType.GRAPH, attribute, event, oldValue, newValue);
    }

    @Override
    protected String myGraphId() {
        return this.getId();
    }

    @Override
    protected long newEvent() {
        return this.listeners.newEvent();
    }

    @Override
    public boolean nullAttributesAreErrors() {
        return this.nullAttributesAreErrors;
    }

    @Override
    public abstract <T extends Node> T getNode(String var1);

    @Override
    public abstract <T extends Node> T getNode(int var1);

    @Override
    public abstract <T extends Edge> T getEdge(String var1);

    @Override
    public abstract <T extends Edge> T getEdge(int var1);

    @Override
    public abstract int getNodeCount();

    @Override
    public abstract int getEdgeCount();

    @Override
    public abstract <T extends Node> Iterator<T> getNodeIterator();

    @Override
    public abstract <T extends Edge> Iterator<T> getEdgeIterator();

    @Override
    public <T extends Node> Iterable<? extends T> getEachNode() {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return AbstractGraph.this.getNodeIterator();
            }
        };
    }

    @Override
    public <T extends Edge> Iterable<? extends T> getEachEdge() {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return AbstractGraph.this.getEdgeIterator();
            }
        };
    }

    @Override
    public <T extends Node> Collection<T> getNodeSet() {
        return new AbstractCollection<T>(){

            @Override
            public Iterator<T> iterator() {
                return AbstractGraph.this.getNodeIterator();
            }

            @Override
            public int size() {
                return AbstractGraph.this.getNodeCount();
            }
        };
    }

    @Override
    public <T extends Edge> Collection<T> getEdgeSet() {
        return new AbstractCollection<T>(){

            @Override
            public Iterator<T> iterator() {
                return AbstractGraph.this.getEdgeIterator();
            }

            @Override
            public int size() {
                return AbstractGraph.this.getEdgeCount();
            }
        };
    }

    @Override
    public Iterator<Node> iterator() {
        return this.getNodeIterator();
    }

    @Override
    public NodeFactory<? extends Node> nodeFactory() {
        return this.nodeFactory;
    }

    @Override
    public EdgeFactory<? extends Edge> edgeFactory() {
        return this.edgeFactory;
    }

    @Override
    public void setNodeFactory(NodeFactory<? extends Node> nf) {
        this.nodeFactory = nf;
    }

    @Override
    public void setEdgeFactory(EdgeFactory<? extends Edge> ef) {
        this.edgeFactory = ef;
    }

    @Override
    public boolean isStrict() {
        return this.strictChecking;
    }

    @Override
    public boolean isAutoCreationEnabled() {
        return this.autoCreate;
    }

    @Override
    public double getStep() {
        return this.step;
    }

    @Override
    public void setNullAttributesAreErrors(boolean on) {
        this.nullAttributesAreErrors = on;
    }

    @Override
    public void setStrict(boolean on) {
        this.strictChecking = on;
    }

    @Override
    public void setAutoCreate(boolean on) {
        this.autoCreate = on;
    }

    @Override
    public void stepBegins(double time) {
        this.stepBegins_(this.getId(), -1L, time);
    }

    @Override
    public void clear() {
        this.clear_(this.getId(), -1L);
    }

    @Override
    public <T extends Node> T addNode(String id) {
        return this.addNode_(this.getId(), -1L, id);
    }

    @Override
    public <T extends Edge> T addEdge(String id, String node1, String node2) {
        return this.addEdge(id, node1, node2, false);
    }

    @Override
    public <T extends Edge> T addEdge(String id, String from, String to, boolean directed) {
        return this.addEdge_(this.getId(), -1L, id, (AbstractNode)this.getNode(from), from, (AbstractNode)this.getNode(to), to, directed);
    }

    @Override
    public <T extends Edge> T addEdge(String id, int index1, int index2) {
        return this.addEdge(id, index1, index2, false);
    }

    @Override
    public <T extends Edge> T addEdge(String id, int fromIndex, int toIndex, boolean directed) {
        return this.addEdge(id, (Node)this.getNode(fromIndex), (Node)this.getNode(toIndex), directed);
    }

    @Override
    public <T extends Edge> T addEdge(String id, Node node1, Node node2) {
        return this.addEdge(id, node1, node2, false);
    }

    @Override
    public <T extends Edge> T addEdge(String id, Node from, Node to, boolean directed) {
        return this.addEdge_(this.getId(), -1L, id, (AbstractNode)from, from.getId(), (AbstractNode)to, to.getId(), directed);
    }

    @Override
    public <T extends Node> T removeNode(String id) {
        return this.removeNode_(this.getId(), -1L, (AbstractNode)this.getNode(id), id, true);
    }

    @Override
    public <T extends Node> T removeNode(int index) {
        T node = this.getNode(index);
        return this.removeNode((Node)node);
    }

    @Override
    public <T extends Node> T removeNode(Node node) {
        return this.removeNode_(this.getId(), -1L, (AbstractNode)node, node == null ? null : node.getId(), true);
    }

    @Override
    public <T extends Edge> T removeEdge(String id) {
        return this.removeEdge_(this.getId(), -1L, (AbstractEdge)this.getEdge(id), id, true, true, true);
    }

    @Override
    public <T extends Edge> T removeEdge(int index) {
        T edge = this.getEdge(index);
        return this.removeEdge((Edge)edge);
    }

    @Override
    public <T extends Edge> T removeEdge(Edge edge) {
        return this.removeEdge_(this.getId(), -1L, (AbstractEdge)edge, edge == null ? null : edge.getId(), true, true, true);
    }

    @Override
    public <T extends Edge> T removeEdge(String from, String to) {
        T fromNode = this.getNode(from);
        T toNode = this.getNode(to);
        if (fromNode == null || toNode == null) {
            if (this.strictChecking) {
                throw new ElementNotFoundException("Cannot remove the edge. The node \"%s\" does not exist", fromNode == null ? from : to);
            }
            return null;
        }
        return this.removeEdge((Node)fromNode, (Node)toNode);
    }

    @Override
    public <T extends Edge> T removeEdge(int fromIndex, int toIndex) {
        T fromNode = this.getNode(fromIndex);
        T toNode = this.getNode(toIndex);
        return this.removeEdge((Node)fromNode, (Node)toNode);
    }

    @Override
    public <T extends Edge> T removeEdge(Node node1, Node node2) {
        AbstractEdge edge = (AbstractEdge)node1.getEdgeToward(node2);
        if (edge == null) {
            if (this.strictChecking) {
                throw new ElementNotFoundException("There is no edge from \"%s\" to \"%s\". Cannot remove it.", node1.getId(), node2.getId());
            }
            return null;
        }
        return this.removeEdge_(this.id, -1L, edge, edge.getId(), true, true, true);
    }

    @Override
    public Iterable<AttributeSink> attributeSinks() {
        return this.listeners.attributeSinks();
    }

    @Override
    public Iterable<ElementSink> elementSinks() {
        return this.listeners.elementSinks();
    }

    @Override
    public void addAttributeSink(AttributeSink sink) {
        this.listeners.addAttributeSink(sink);
    }

    @Override
    public void addElementSink(ElementSink sink) {
        this.listeners.addElementSink(sink);
    }

    @Override
    public void addSink(Sink sink) {
        this.listeners.addSink(sink);
    }

    @Override
    public void clearAttributeSinks() {
        this.listeners.clearAttributeSinks();
    }

    @Override
    public void clearElementSinks() {
        this.listeners.clearElementSinks();
    }

    @Override
    public void clearSinks() {
        this.listeners.clearSinks();
    }

    @Override
    public void removeAttributeSink(AttributeSink sink) {
        this.listeners.removeAttributeSink(sink);
    }

    @Override
    public void removeElementSink(ElementSink sink) {
        this.listeners.removeElementSink(sink);
    }

    @Override
    public void removeSink(Sink sink) {
        this.listeners.removeSink(sink);
    }

    @Override
    public void edgeAttributeAdded(String sourceId, long timeId, String edgeId, String attribute, Object value) {
        this.listeners.edgeAttributeAdded(sourceId, timeId, edgeId, attribute, value);
    }

    @Override
    public void edgeAttributeChanged(String sourceId, long timeId, String edgeId, String attribute, Object oldValue, Object newValue) {
        this.listeners.edgeAttributeChanged(sourceId, timeId, edgeId, attribute, oldValue, newValue);
    }

    @Override
    public void edgeAttributeRemoved(String sourceId, long timeId, String edgeId, String attribute) {
        this.listeners.edgeAttributeRemoved(sourceId, timeId, edgeId, attribute);
    }

    @Override
    public void graphAttributeAdded(String sourceId, long timeId, String attribute, Object value) {
        this.listeners.graphAttributeAdded(sourceId, timeId, attribute, value);
    }

    @Override
    public void graphAttributeChanged(String sourceId, long timeId, String attribute, Object oldValue, Object newValue) {
        this.listeners.graphAttributeChanged(sourceId, timeId, attribute, oldValue, newValue);
    }

    @Override
    public void graphAttributeRemoved(String sourceId, long timeId, String attribute) {
        this.listeners.graphAttributeRemoved(sourceId, timeId, attribute);
    }

    @Override
    public void nodeAttributeAdded(String sourceId, long timeId, String nodeId, String attribute, Object value) {
        this.listeners.nodeAttributeAdded(sourceId, timeId, nodeId, attribute, value);
    }

    @Override
    public void nodeAttributeChanged(String sourceId, long timeId, String nodeId, String attribute, Object oldValue, Object newValue) {
        this.listeners.nodeAttributeChanged(sourceId, timeId, nodeId, attribute, oldValue, newValue);
    }

    @Override
    public void nodeAttributeRemoved(String sourceId, long timeId, String nodeId, String attribute) {
        this.listeners.nodeAttributeRemoved(sourceId, timeId, nodeId, attribute);
    }

    @Override
    public void edgeAdded(String sourceId, long timeId, String edgeId, String fromNodeId, String toNodeId, boolean directed) {
        this.listeners.edgeAdded(sourceId, timeId, edgeId, fromNodeId, toNodeId, directed);
    }

    @Override
    public void edgeRemoved(String sourceId, long timeId, String edgeId) {
        this.listeners.edgeRemoved(sourceId, timeId, edgeId);
    }

    @Override
    public void graphCleared(String sourceId, long timeId) {
        this.listeners.graphCleared(sourceId, timeId);
    }

    @Override
    public void nodeAdded(String sourceId, long timeId, String nodeId) {
        this.listeners.nodeAdded(sourceId, timeId, nodeId);
    }

    @Override
    public void nodeRemoved(String sourceId, long timeId, String nodeId) {
        this.listeners.nodeRemoved(sourceId, timeId, nodeId);
    }

    @Override
    public void stepBegins(String sourceId, long timeId, double step) {
        this.listeners.stepBegins(sourceId, timeId, step);
    }

    @Override
    public Viewer display() {
        return this.display(true);
    }

    @Override
    public Viewer display(boolean autoLayout) {
        Viewer viewer = new Viewer(this, Viewer.ThreadingModel.GRAPH_IN_ANOTHER_THREAD);
        GraphRenderer renderer = Viewer.newGraphRenderer();
        viewer.addView(Viewer.DEFAULT_VIEW_ID, renderer);
        if (autoLayout) {
            Layout layout = Layouts.newLayoutAlgorithm();
            viewer.enableAutoLayout(layout);
        }
        return viewer;
    }

    @Override
    public void read(FileSource input, String filename) throws IOException, GraphParseException {
        input.readAll(filename);
    }

    @Override
    public void read(String filename) throws IOException, GraphParseException, ElementNotFoundException {
        FileSource input = FileSourceFactory.sourceFor(filename);
        if (input == null) {
            throw new IOException("No source reader for " + filename);
        }
        input.addSink(this);
        this.read(input, filename);
        input.removeSink(this);
    }

    @Override
    public void write(FileSink output, String filename) throws IOException {
        output.writeAll((Graph)this, filename);
    }

    @Override
    public void write(String filename) throws IOException {
        FileSink output = FileSinkFactory.sinkFor(filename);
        if (output == null) {
            throw new IOException("No sink writer for " + filename);
        }
        this.write(output, filename);
    }

    @Override
    public Replayable.Controller getReplayController() {
        return new GraphReplayController();
    }

    protected abstract void addNodeCallback(AbstractNode var1);

    protected abstract void addEdgeCallback(AbstractEdge var1);

    protected abstract void removeNodeCallback(AbstractNode var1);

    protected abstract void removeEdgeCallback(AbstractEdge var1);

    protected abstract void clearCallback();

    protected <T extends Node> T addNode_(String sourceId, long timeId, String nodeId) {
        AbstractNode node = (AbstractNode)this.getNode(nodeId);
        if (node != null) {
            if (this.strictChecking) {
                throw new IdAlreadyInUseException("id \"" + nodeId + "\" already in use. Cannot create a node.");
            }
            return (T)node;
        }
        node = this.nodeFactory.newInstance(nodeId, this);
        this.addNodeCallback(node);
        if (timeId == -1L) {
            timeId = this.newEvent();
        }
        this.listeners.sendNodeAdded(sourceId, timeId, nodeId);
        return (T)node;
    }

    protected <T extends Edge> T addEdge_(String sourceId, long timeId, String edgeId, AbstractNode src, String srcId, AbstractNode dst, String dstId, boolean directed) {
        AbstractEdge edge = (AbstractEdge)this.getEdge(edgeId);
        if (edge != null) {
            if (this.strictChecking) {
                throw new IdAlreadyInUseException("id \"" + edgeId + "\" already in use. Cannot create an edge.");
            }
            if (edge.getSourceNode() == src && edge.getTargetNode() == dst || !directed && edge.getTargetNode() == src && edge.getSourceNode() == dst) {
                return (T)edge;
            }
            return null;
        }
        if (src == null || dst == null) {
            if (this.strictChecking) {
                throw new ElementNotFoundException(String.format("Cannot create edge %s[%s-%s%s]. Node '%s' does not exist.", edgeId, srcId, directed ? ">" : "-", dstId, src == null ? srcId : dstId), new Object[0]);
            }
            if (!this.autoCreate) {
                return null;
            }
            if (src == null) {
                src = (AbstractNode)this.addNode(srcId);
            }
            if (dst == null) {
                dst = (AbstractNode)this.addNode(dstId);
            }
        }
        if (!src.addEdgeCallback(edge = this.edgeFactory.newInstance(edgeId, src, dst, directed))) {
            if (this.strictChecking) {
                throw new EdgeRejectedException("Edge " + edge + " was rejected by node " + src);
            }
            return null;
        }
        if (src != dst && !dst.addEdgeCallback(edge)) {
            src.removeEdgeCallback(edge);
            if (this.strictChecking) {
                throw new EdgeRejectedException("Edge " + edge + " was rejected by node " + dst);
            }
            return null;
        }
        this.addEdgeCallback(edge);
        if (timeId == -1L) {
            timeId = this.newEvent();
        }
        this.listeners.sendEdgeAdded(sourceId, timeId, edgeId, srcId, dstId, directed);
        return (T)edge;
    }

    protected <T extends Node> T removeNode_(String sourceId, long timeId, AbstractNode node, String nodeId, boolean graphCallback) {
        if (node == null) {
            if (this.strictChecking) {
                throw new ElementNotFoundException("Node \"" + nodeId + "\" not found. Cannot remove it.", new Object[0]);
            }
            return null;
        }
        this.removeAllEdges(node);
        if (timeId == -1L) {
            timeId = this.newEvent();
        }
        this.listeners.sendNodeRemoved(sourceId, timeId, nodeId);
        if (graphCallback) {
            this.removeNodeCallback(node);
        }
        return (T)node;
    }

    protected <T extends Edge> T removeEdge_(String sourceId, long timeId, AbstractEdge edge, String edgeId, boolean graphCallback, boolean srcCallback, boolean dstCallback) {
        if (edge == null) {
            if (this.strictChecking) {
                throw new ElementNotFoundException("Edge \"" + edgeId + "\" not found. Cannot remove it.", new Object[0]);
            }
            return null;
        }
        AbstractNode src = (AbstractNode)edge.getSourceNode();
        AbstractNode dst = (AbstractNode)edge.getTargetNode();
        if (timeId == -1L) {
            timeId = this.newEvent();
        }
        this.listeners.sendEdgeRemoved(sourceId, timeId, edgeId);
        if (srcCallback) {
            src.removeEdgeCallback(edge);
        }
        if (src != dst && dstCallback) {
            dst.removeEdgeCallback(edge);
        }
        if (graphCallback) {
            this.removeEdgeCallback(edge);
        }
        return (T)edge;
    }

    protected void clear_(String sourceId, long timeId) {
        Iterator it = this.getNodeIterator();
        while (it.hasNext()) {
            ((AbstractNode)it.next()).clearCallback();
        }
        this.clearCallback();
        this.clearAttributes();
        if (timeId == -1L) {
            timeId = this.newEvent();
        }
        this.listeners.sendGraphCleared(sourceId, timeId);
    }

    protected void stepBegins_(String sourceId, long timeId, double step) {
        this.step = step;
        if (timeId == -1L) {
            timeId = this.newEvent();
        }
        this.listeners.sendStepBegins(sourceId, timeId, step);
    }

    private void removeAllEdges(AbstractNode node) {
        Iterator edgeIt = node.getEdgeIterator();
        boolean supportsRemove = true;
        if (!edgeIt.hasNext()) {
            return;
        }
        try {
            edgeIt.next();
            edgeIt.remove();
        }
        catch (UnsupportedOperationException e) {
            supportsRemove = false;
        }
        if (supportsRemove) {
            while (edgeIt.hasNext()) {
                edgeIt.next();
                edgeIt.remove();
            }
        } else {
            while (node.getDegree() > 0) {
                this.removeEdge((Edge)node.getEdge(0));
            }
        }
    }

    protected void removeNode(AbstractNode node, boolean graphCallback) {
        this.removeNode_(this.id, -1L, node, node.getId(), graphCallback);
    }

    protected void removeEdge(AbstractEdge edge, boolean graphCallback, boolean sourceCallback, boolean targetCallback) {
        this.removeEdge_(this.id, -1L, edge, edge.getId(), graphCallback, sourceCallback, targetCallback);
    }

    class GraphListeners
    extends SourceBase
    implements Pipe {
        SinkTime sinkTime;

        public GraphListeners() {
            super(AbstractGraph.this.getId());
            this.sinkTime = new SinkTime();
            this.sourceTime.setSinkTime(this.sinkTime);
        }

        public long newEvent() {
            return this.sourceTime.newEvent();
        }

        public void edgeAttributeAdded(String sourceId, long timeId, String edgeId, String attribute, Object value) {
            AbstractEdge edge;
            if (this.sinkTime.isNewEvent(sourceId, timeId) && (edge = (AbstractEdge)AbstractGraph.this.getEdge(edgeId)) != null) {
                edge.addAttribute_(sourceId, timeId, attribute, value);
            }
        }

        public void edgeAttributeChanged(String sourceId, long timeId, String edgeId, String attribute, Object oldValue, Object newValue) {
            AbstractEdge edge;
            if (this.sinkTime.isNewEvent(sourceId, timeId) && (edge = (AbstractEdge)AbstractGraph.this.getEdge(edgeId)) != null) {
                edge.changeAttribute_(sourceId, timeId, attribute, newValue);
            }
        }

        public void edgeAttributeRemoved(String sourceId, long timeId, String edgeId, String attribute) {
            AbstractEdge edge;
            if (this.sinkTime.isNewEvent(sourceId, timeId) && (edge = (AbstractEdge)AbstractGraph.this.getEdge(edgeId)) != null) {
                edge.removeAttribute_(sourceId, timeId, attribute);
            }
        }

        public void graphAttributeAdded(String sourceId, long timeId, String attribute, Object value) {
            if (this.sinkTime.isNewEvent(sourceId, timeId)) {
                AbstractGraph.this.addAttribute_(sourceId, timeId, attribute, value);
            }
        }

        public void graphAttributeChanged(String sourceId, long timeId, String attribute, Object oldValue, Object newValue) {
            if (this.sinkTime.isNewEvent(sourceId, timeId)) {
                AbstractGraph.this.changeAttribute_(sourceId, timeId, attribute, newValue);
            }
        }

        public void graphAttributeRemoved(String sourceId, long timeId, String attribute) {
            if (this.sinkTime.isNewEvent(sourceId, timeId)) {
                AbstractGraph.this.removeAttribute_(sourceId, timeId, attribute);
            }
        }

        public void nodeAttributeAdded(String sourceId, long timeId, String nodeId, String attribute, Object value) {
            AbstractNode node;
            if (this.sinkTime.isNewEvent(sourceId, timeId) && (node = (AbstractNode)AbstractGraph.this.getNode(nodeId)) != null) {
                node.addAttribute_(sourceId, timeId, attribute, value);
            }
        }

        public void nodeAttributeChanged(String sourceId, long timeId, String nodeId, String attribute, Object oldValue, Object newValue) {
            AbstractNode node;
            if (this.sinkTime.isNewEvent(sourceId, timeId) && (node = (AbstractNode)AbstractGraph.this.getNode(nodeId)) != null) {
                node.changeAttribute_(sourceId, timeId, attribute, newValue);
            }
        }

        public void nodeAttributeRemoved(String sourceId, long timeId, String nodeId, String attribute) {
            AbstractNode node;
            if (this.sinkTime.isNewEvent(sourceId, timeId) && (node = (AbstractNode)AbstractGraph.this.getNode(nodeId)) != null) {
                node.removeAttribute_(sourceId, timeId, attribute);
            }
        }

        public void edgeAdded(String sourceId, long timeId, String edgeId, String fromNodeId, String toNodeId, boolean directed) {
            if (this.sinkTime.isNewEvent(sourceId, timeId)) {
                AbstractNode from = (AbstractNode)AbstractGraph.this.getNode(fromNodeId);
                AbstractNode to = (AbstractNode)AbstractGraph.this.getNode(toNodeId);
                AbstractGraph.this.addEdge_(sourceId, timeId, edgeId, from, fromNodeId, to, toNodeId, directed);
            }
        }

        public void edgeRemoved(String sourceId, long timeId, String edgeId) {
            if (this.sinkTime.isNewEvent(sourceId, timeId)) {
                AbstractEdge edge = (AbstractEdge)AbstractGraph.this.getEdge(edgeId);
                AbstractGraph.this.removeEdge_(sourceId, timeId, edge, edgeId, true, true, true);
            }
        }

        public void graphCleared(String sourceId, long timeId) {
            if (this.sinkTime.isNewEvent(sourceId, timeId)) {
                AbstractGraph.this.clear_(sourceId, timeId);
            }
        }

        public void nodeAdded(String sourceId, long timeId, String nodeId) {
            if (this.sinkTime.isNewEvent(sourceId, timeId)) {
                AbstractGraph.this.addNode_(sourceId, timeId, nodeId);
            }
        }

        public void nodeRemoved(String sourceId, long timeId, String nodeId) {
            if (this.sinkTime.isNewEvent(sourceId, timeId)) {
                AbstractNode node = (AbstractNode)AbstractGraph.this.getNode(nodeId);
                AbstractGraph.this.removeNode_(sourceId, timeId, node, nodeId, true);
            }
        }

        public void stepBegins(String sourceId, long timeId, double step) {
            if (this.sinkTime.isNewEvent(sourceId, timeId)) {
                AbstractGraph.this.stepBegins_(sourceId, timeId, step);
            }
        }
    }

    class GraphReplayController
    extends SourceBase
    implements Replayable.Controller {
        GraphReplayController() {
            super(AbstractGraph.this.id + "replay");
        }

        public void replay() {
            String sourceId = String.format("%s-replay-%x", AbstractGraph.this.id, AbstractGraph.this.replayId++);
            this.replay(sourceId);
        }

        public void replay(String sourceId) {
            int i;
            for (String key : AbstractGraph.this.getAttributeKeySet()) {
                this.sendGraphAttributeAdded(sourceId, key, AbstractGraph.this.getAttribute(key));
            }
            for (i = 0; i < AbstractGraph.this.getNodeCount(); ++i) {
                Object node = AbstractGraph.this.getNode(i);
                String nodeId = node.getId();
                this.sendNodeAdded(sourceId, nodeId);
                if (node.getAttributeCount() <= 0) continue;
                for (String key : node.getAttributeKeySet()) {
                    this.sendNodeAttributeAdded(sourceId, nodeId, key, node.getAttribute(key));
                }
            }
            for (i = 0; i < AbstractGraph.this.getEdgeCount(); ++i) {
                Object edge = AbstractGraph.this.getEdge(i);
                String edgeId = edge.getId();
                this.sendEdgeAdded(sourceId, edgeId, edge.getNode0().getId(), edge.getNode1().getId(), edge.isDirected());
                if (edge.getAttributeCount() <= 0) continue;
                for (String key : edge.getAttributeKeySet()) {
                    this.sendEdgeAttributeAdded(sourceId, edgeId, key, edge.getAttribute(key));
                }
            }
        }
    }
}

