/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.stream.file.pajek;

import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EdgeMatrix {
    protected boolean[][] mat;
    protected int curLine = 0;

    public EdgeMatrix(int size) {
        this.mat = new boolean[size][size];
    }

    public int size() {
        return this.mat.length;
    }

    public boolean hasEdge(int line, int col) {
        return this.mat[line][col];
    }

    public void set(int line, int col, boolean value) {
        this.mat[line][col] = value;
    }

    public void addLine(ArrayList<String> line) {
        if (this.curLine < this.mat.length) {
            if (line.size() == this.mat.length) {
                for (int i = 0; i < this.mat.length; ++i) {
                    this.mat[this.curLine][i] = line.get(i).equals("1");
                }
                ++this.curLine;
            } else if (line.size() == this.mat.length * this.mat.length) {
                int n = this.mat.length * this.mat.length;
                this.curLine = -1;
                for (int i = 0; i < n; ++i) {
                    if (i % this.mat.length == 0) {
                        ++this.curLine;
                    }
                    this.mat[this.curLine][i - this.curLine * this.mat.length] = line.get(i).equals("1");
                }
            }
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        for (int line = 0; line < this.mat.length; ++line) {
            for (int col = 0; col < this.mat.length; ++col) {
                buffer.append(String.format("%s ", this.mat[line][col] ? "1" : "0"));
            }
            buffer.append(String.format("%n", new Object[0]));
        }
        return buffer.toString();
    }
}

