/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.stream.netstream.packing;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.graphstream.stream.netstream.packing.Base64;
import org.graphstream.stream.netstream.packing.Base64Packer;
import org.graphstream.stream.netstream.packing.NetStreamUnpacker;

public class Base64Unpacker
extends NetStreamUnpacker {
    public ByteBuffer unpackMessage(ByteBuffer buffer, int startIndex, int endIndex) {
        try {
            byte[] raw = Base64.decode(buffer.array(), startIndex, endIndex - startIndex, 0);
            return ByteBuffer.wrap(raw);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public int unpackMessageSize(ByteBuffer buffer) {
        try {
            byte[] raw = Base64.decode(buffer.array(), buffer.position(), 8, 0);
            return ByteBuffer.wrap(raw).getInt();
        }
        catch (IOException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public static void main(String[] args) {
        Base64Packer packer = new Base64Packer();
        Base64Unpacker b = new Base64Unpacker();
        ByteBuffer source = ByteBuffer.allocate(9);
        source.putInt(-1).putFloat(0.1f);
        source.put((byte)101);
        source.rewind();
        ByteBuffer bb = b.unpackMessage(packer.packMessage(source));
        bb.rewind();
        System.out.println(bb.getInt());
        System.out.println(bb.getFloat());
        System.out.println((char)bb.get());
    }

    public int sizeOfInt() {
        return 8;
    }
}

