/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.stream.thread;

import org.graphstream.graph.Edge;
import org.graphstream.graph.Graph;
import org.graphstream.graph.Node;
import org.graphstream.stream.AttributeSink;
import org.graphstream.stream.ProxyPipe;
import org.graphstream.stream.Sink;
import org.graphstream.stream.Source;
import org.graphstream.stream.SourceBase;
import org.miv.mbox.CannotPostException;
import org.miv.mbox.MBox;
import org.miv.mbox.MBoxListener;
import org.miv.mbox.MBoxStandalone;

@Deprecated
public class ThreadProxyPipeOld
extends SourceBase
implements ProxyPipe,
MBoxListener {
    protected String id;
    protected String from;
    protected MBox events;
    protected Source input;
    protected boolean unregisterWhenPossible = false;

    public ThreadProxyPipeOld() {
        this((Source)null);
    }

    public ThreadProxyPipeOld(Source input) {
        this(input, (MBox)new MBoxStandalone());
    }

    public ThreadProxyPipeOld(Source input, MBox sharedMBox) {
        this.events = sharedMBox;
        this.from = "<in>";
        this.input = input;
        if (input != null) {
            input.addSink(this);
        }
        ((MBoxStandalone)this.events).addListener((MBoxListener)this);
    }

    public ThreadProxyPipeOld(Graph inputGraph) {
        this(inputGraph, true);
    }

    public ThreadProxyPipeOld(Graph inputGraph, boolean replayGraph) {
        this(inputGraph, null, replayGraph);
    }

    public ThreadProxyPipeOld(Graph inputGraph, Sink firstListener, boolean replayGraph) {
        this(inputGraph, firstListener, replayGraph, (MBox)new MBoxStandalone());
    }

    public ThreadProxyPipeOld(Graph inputGraph, Sink firstListener, boolean replayGraph, MBox sharedMBox) {
        this.events = sharedMBox;
        this.from = inputGraph.getId();
        this.input = inputGraph;
        if (firstListener != null) {
            this.addSink(firstListener);
        }
        if (replayGraph) {
            this.replayGraph(inputGraph);
        }
        this.input.addSink(this);
        ((MBoxStandalone)this.events).addListener((MBoxListener)this);
    }

    public String toString() {
        String dest = "nil";
        if (this.attrSinks.size() > 0) {
            dest = ((AttributeSink)this.attrSinks.get(0)).toString();
        }
        return String.format("thread-proxy(from %s to %s)", this.from, dest);
    }

    public void unregisterFromSource() {
        this.unregisterWhenPossible = true;
    }

    public void pump() {
        ((MBoxStandalone)this.events).processMessages();
    }

    protected void replayGraph(Graph graph) {
        try {
            String graphId = "@replay";
            if (graph.getAttributeKeySet() != null) {
                for (String key : graph.getAttributeKeySet()) {
                    this.events.post(this.from, new Object[]{GraphEvents.ADD_GRAPH_ATTR, graphId, this.sourceTime.newEvent(), key, graph.getAttribute(key)});
                }
            }
            Thread.yield();
            for (Node node : graph) {
                this.events.post(this.from, new Object[]{GraphEvents.ADD_NODE, graphId, this.sourceTime.newEvent(), node.getId()});
                if (node.getAttributeKeySet() != null) {
                    for (String key : node.getAttributeKeySet()) {
                        this.events.post(this.from, new Object[]{GraphEvents.ADD_NODE_ATTR, graphId, this.sourceTime.newEvent(), node.getId(), key, node.getAttribute(key)});
                    }
                }
                Thread.yield();
            }
            for (Edge edge : graph.getEachEdge()) {
                this.events.post(this.from, new Object[]{GraphEvents.ADD_EDGE, graphId, this.sourceTime.newEvent(), edge.getId(), edge.getSourceNode().getId(), edge.getTargetNode().getId(), edge.isDirected()});
                if (edge.getAttributeKeySet() != null) {
                    for (String key : edge.getAttributeKeySet()) {
                        this.events.post(this.from, new Object[]{GraphEvents.ADD_EDGE_ATTR, graphId, this.sourceTime.newEvent(), edge.getId(), key, edge.getAttribute(key)});
                    }
                }
                Thread.yield();
            }
        }
        catch (CannotPostException e) {
            System.err.printf("GraphRendererRunner: cannot post message to listeners: %s%n", e.getMessage());
        }
    }

    protected boolean maybeUnregister() {
        if (this.unregisterWhenPossible) {
            if (this.input != null) {
                this.input.removeSink(this);
            }
            return true;
        }
        return false;
    }

    public void edgeAttributeAdded(String graphId, long timeId, String edgeId, String attribute, Object value) {
        if (this.maybeUnregister()) {
            return;
        }
        try {
            this.events.post(this.from, new Object[]{GraphEvents.ADD_EDGE_ATTR, graphId, timeId, edgeId, attribute, value});
        }
        catch (CannotPostException e) {
            e.printStackTrace();
        }
    }

    public void edgeAttributeChanged(String graphId, long timeId, String edgeId, String attribute, Object oldValue, Object newValue) {
        if (this.maybeUnregister()) {
            return;
        }
        try {
            this.events.post(this.from, new Object[]{GraphEvents.CHG_EDGE_ATTR, graphId, timeId, edgeId, attribute, oldValue, newValue});
        }
        catch (CannotPostException e) {
            e.printStackTrace();
        }
    }

    public void edgeAttributeRemoved(String graphId, long timeId, String edgeId, String attribute) {
        if (this.maybeUnregister()) {
            return;
        }
        try {
            this.events.post(this.from, new Object[]{GraphEvents.DEL_EDGE_ATTR, graphId, timeId, edgeId, attribute});
        }
        catch (CannotPostException e) {
            e.printStackTrace();
        }
    }

    public void graphAttributeAdded(String graphId, long timeId, String attribute, Object value) {
        if (this.maybeUnregister()) {
            return;
        }
        try {
            this.events.post(this.from, new Object[]{GraphEvents.ADD_GRAPH_ATTR, graphId, timeId, attribute, value});
        }
        catch (CannotPostException e) {
            e.printStackTrace();
        }
    }

    public void graphAttributeChanged(String graphId, long timeId, String attribute, Object oldValue, Object newValue) {
        if (this.maybeUnregister()) {
            return;
        }
        try {
            this.events.post(this.from, new Object[]{GraphEvents.CHG_GRAPH_ATTR, graphId, timeId, attribute, oldValue, newValue});
        }
        catch (CannotPostException e) {
            e.printStackTrace();
        }
    }

    public void graphAttributeRemoved(String graphId, long timeId, String attribute) {
        if (this.maybeUnregister()) {
            return;
        }
        try {
            this.events.post(this.from, new Object[]{GraphEvents.DEL_GRAPH_ATTR, graphId, timeId, attribute});
        }
        catch (CannotPostException e) {
            e.printStackTrace();
        }
    }

    public void nodeAttributeAdded(String graphId, long timeId, String nodeId, String attribute, Object value) {
        if (this.maybeUnregister()) {
            return;
        }
        try {
            this.events.post(this.from, new Object[]{GraphEvents.ADD_NODE_ATTR, graphId, timeId, nodeId, attribute, value});
        }
        catch (CannotPostException e) {
            e.printStackTrace();
        }
    }

    public void nodeAttributeChanged(String graphId, long timeId, String nodeId, String attribute, Object oldValue, Object newValue) {
        if (this.maybeUnregister()) {
            return;
        }
        try {
            this.events.post(this.from, new Object[]{GraphEvents.CHG_NODE_ATTR, graphId, timeId, nodeId, attribute, oldValue, newValue});
        }
        catch (CannotPostException e) {
            e.printStackTrace();
        }
    }

    public void nodeAttributeRemoved(String graphId, long timeId, String nodeId, String attribute) {
        if (this.maybeUnregister()) {
            return;
        }
        try {
            this.events.post(this.from, new Object[]{GraphEvents.DEL_NODE_ATTR, graphId, timeId, nodeId, attribute});
        }
        catch (CannotPostException e) {
            e.printStackTrace();
        }
    }

    public void edgeAdded(String graphId, long timeId, String edgeId, String fromNodeId, String toNodeId, boolean directed) {
        if (this.maybeUnregister()) {
            return;
        }
        try {
            this.events.post(this.from, new Object[]{GraphEvents.ADD_EDGE, graphId, timeId, edgeId, fromNodeId, toNodeId, directed});
        }
        catch (CannotPostException e) {
            e.printStackTrace();
        }
    }

    public void edgeRemoved(String graphId, long timeId, String edgeId) {
        if (this.maybeUnregister()) {
            return;
        }
        try {
            this.events.post(this.from, new Object[]{GraphEvents.DEL_EDGE, graphId, timeId, edgeId});
        }
        catch (CannotPostException e) {
            e.printStackTrace();
        }
    }

    public void graphCleared(String graphId, long timeId) {
        if (this.maybeUnregister()) {
            return;
        }
        try {
            this.events.post(this.from, new Object[]{GraphEvents.CLEARED, graphId, timeId});
        }
        catch (CannotPostException e) {
            e.printStackTrace();
        }
    }

    public void nodeAdded(String graphId, long timeId, String nodeId) {
        if (this.maybeUnregister()) {
            return;
        }
        try {
            this.events.post(this.from, new Object[]{GraphEvents.ADD_NODE, graphId, timeId, nodeId});
        }
        catch (CannotPostException e) {
            e.printStackTrace();
        }
    }

    public void nodeRemoved(String graphId, long timeId, String nodeId) {
        if (this.maybeUnregister()) {
            return;
        }
        try {
            this.events.post(this.from, new Object[]{GraphEvents.DEL_NODE, graphId, timeId, nodeId});
        }
        catch (CannotPostException e) {
            e.printStackTrace();
        }
    }

    public void stepBegins(String graphId, long timeId, double step) {
        if (this.maybeUnregister()) {
            return;
        }
        try {
            this.events.post(this.from, new Object[]{GraphEvents.STEP, graphId, timeId, step});
        }
        catch (CannotPostException e) {
            e.printStackTrace();
        }
    }

    public void processMessage(String from, Object[] data) {
        if (data[0].equals((Object)GraphEvents.ADD_NODE)) {
            String graphId = (String)data[1];
            Long timeId = (Long)data[2];
            String nodeId = (String)data[3];
            this.sendNodeAdded(graphId, timeId, nodeId);
        } else if (data[0].equals((Object)GraphEvents.DEL_NODE)) {
            String graphId = (String)data[1];
            Long timeId = (Long)data[2];
            String nodeId = (String)data[3];
            this.sendNodeRemoved(graphId, timeId, nodeId);
        } else if (data[0].equals((Object)GraphEvents.ADD_EDGE)) {
            String graphId = (String)data[1];
            Long timeId = (Long)data[2];
            String edgeId = (String)data[3];
            String fromId = (String)data[4];
            String toId = (String)data[5];
            boolean directed = (Boolean)data[6];
            this.sendEdgeAdded(graphId, timeId, edgeId, fromId, toId, directed);
        } else if (data[0].equals((Object)GraphEvents.DEL_EDGE)) {
            String graphId = (String)data[1];
            Long timeId = (Long)data[2];
            String edgeId = (String)data[3];
            this.sendEdgeRemoved(graphId, timeId, edgeId);
        } else if (data[0].equals((Object)GraphEvents.STEP)) {
            String graphId = (String)data[1];
            Long timeId = (Long)data[2];
            double step = (Double)data[3];
            this.sendStepBegins(graphId, timeId, step);
        } else if (data[0].equals((Object)GraphEvents.ADD_GRAPH_ATTR)) {
            String graphId = (String)data[1];
            Long timeId = (Long)data[2];
            String attribute = (String)data[3];
            Object value = data[4];
            this.sendGraphAttributeAdded(graphId, timeId, attribute, value);
        } else if (data[0].equals((Object)GraphEvents.CHG_GRAPH_ATTR)) {
            String graphId = (String)data[1];
            Long timeId = (Long)data[2];
            String attribute = (String)data[3];
            Object oldValue = data[4];
            Object newValue = data[5];
            this.sendGraphAttributeChanged(graphId, timeId, attribute, oldValue, newValue);
        } else if (data[0].equals((Object)GraphEvents.DEL_GRAPH_ATTR)) {
            String graphId = (String)data[1];
            Long timeId = (Long)data[2];
            String attribute = (String)data[3];
            this.sendGraphAttributeRemoved(graphId, timeId, attribute);
        } else if (data[0].equals((Object)GraphEvents.ADD_EDGE_ATTR)) {
            String graphId = (String)data[1];
            Long timeId = (Long)data[2];
            String edgeId = (String)data[3];
            String attribute = (String)data[4];
            Object value = data[5];
            this.sendEdgeAttributeAdded(graphId, timeId, edgeId, attribute, value);
        } else if (data[0].equals((Object)GraphEvents.CHG_EDGE_ATTR)) {
            String graphId = (String)data[1];
            Long timeId = (Long)data[2];
            String edgeId = (String)data[3];
            String attribute = (String)data[4];
            Object oldValue = data[5];
            Object newValue = data[6];
            this.sendEdgeAttributeChanged(graphId, timeId, edgeId, attribute, oldValue, newValue);
        } else if (data[0].equals((Object)GraphEvents.DEL_EDGE_ATTR)) {
            String graphId = (String)data[1];
            Long timeId = (Long)data[2];
            String edgeId = (String)data[3];
            String attribute = (String)data[4];
            this.sendEdgeAttributeRemoved(graphId, timeId, edgeId, attribute);
        } else if (data[0].equals((Object)GraphEvents.ADD_NODE_ATTR)) {
            String graphId = (String)data[1];
            Long timeId = (Long)data[2];
            String nodeId = (String)data[3];
            String attribute = (String)data[4];
            Object value = data[5];
            this.sendNodeAttributeAdded(graphId, timeId, nodeId, attribute, value);
        } else if (data[0].equals((Object)GraphEvents.CHG_NODE_ATTR)) {
            String graphId = (String)data[1];
            Long timeId = (Long)data[2];
            String nodeId = (String)data[3];
            String attribute = (String)data[4];
            Object oldValue = data[5];
            Object newValue = data[6];
            this.sendNodeAttributeChanged(graphId, timeId, nodeId, attribute, oldValue, newValue);
        } else if (data[0].equals((Object)GraphEvents.DEL_NODE_ATTR)) {
            String graphId = (String)data[1];
            Long timeId = (Long)data[2];
            String nodeId = (String)data[3];
            String attribute = (String)data[4];
            this.sendNodeAttributeRemoved(graphId, timeId, nodeId, attribute);
        } else if (data[0].equals((Object)GraphEvents.CLEARED)) {
            String graphId = (String)data[1];
            Long timeId = (Long)data[2];
            this.sendGraphCleared(graphId, timeId);
        } else {
            System.err.printf("ThreadProxyFilter : Unknown message %s !!%n", data[0]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum GraphEvents {
        ADD_NODE,
        DEL_NODE,
        ADD_EDGE,
        DEL_EDGE,
        STEP,
        CLEARED,
        ADD_GRAPH_ATTR,
        CHG_GRAPH_ATTR,
        DEL_GRAPH_ATTR,
        ADD_NODE_ATTR,
        CHG_NODE_ATTR,
        DEL_NODE_ATTR,
        ADD_EDGE_ATTR,
        CHG_EDGE_ATTR,
        DEL_EDGE_ATTR;

    }
}

