/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.ui.swingViewer.util;

import java.awt.Font;
import java.util.HashMap;
import java.util.Map;
import org.graphstream.ui.graphicGraph.stylesheet.StyleConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FontSlot {
    String name;
    public HashMap<Integer, Font> normal;
    public HashMap<Integer, Font> bold;
    public HashMap<Integer, Font> italic;
    public HashMap<Integer, Font> boldItalic;

    public FontSlot(String name, StyleConstants.TextStyle style, int size) {
        this.name = name;
        this.insert(style, size);
    }

    protected Map<Integer, Font> mapFromStyle(StyleConstants.TextStyle style) {
        switch (style) {
            case BOLD: {
                if (this.bold == null) {
                    this.bold = new HashMap();
                }
                return this.bold;
            }
            case ITALIC: {
                if (this.italic == null) {
                    this.italic = new HashMap();
                }
                return this.italic;
            }
            case BOLD_ITALIC: {
                if (this.boldItalic == null) {
                    this.boldItalic = new HashMap();
                }
                return this.boldItalic;
            }
        }
        if (this.normal == null) {
            this.normal = new HashMap();
        }
        return this.normal;
    }

    protected int toJavaStyle(StyleConstants.TextStyle style) {
        switch (style) {
            case BOLD: {
                return 1;
            }
            case ITALIC: {
                return 2;
            }
            case BOLD_ITALIC: {
                return 3;
            }
        }
        return 0;
    }

    public Font insert(StyleConstants.TextStyle style, int size) {
        return this.insert(this.mapFromStyle(style), this.toJavaStyle(style), size);
    }

    protected Font insert(Map<Integer, Font> map, int style, int size) {
        Font font = map.get(size);
        if (font == null) {
            font = new Font(this.name, style, size);
            map.put(size, font);
        }
        return font;
    }

    protected Font getFont(StyleConstants.TextStyle style, int size) {
        Map<Integer, Font> map = this.mapFromStyle(style);
        Font font = map.get(size);
        if (font == null) {
            font = this.insert(map, this.toJavaStyle(style), size);
        }
        return font;
    }
}

