/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.ui.swingViewer.util;

import java.awt.BasicStroke;
import java.awt.Stroke;
import org.graphstream.ui.graphicGraph.stylesheet.Style;
import org.graphstream.ui.graphicGraph.stylesheet.StyleConstants;
import org.graphstream.ui.swingViewer.util.GraphMetrics;

public class StrokeFactory {
    protected static float[] dots = new float[]{1.0f, 1.0f};
    protected static float[] dashes = new float[]{3.0f, 3.0f};

    public static Stroke generateStroke(Style style, GraphMetrics metrics) {
        if (style.getStrokeWidth().value == 0.0) {
            return null;
        }
        switch (style.getStrokeMode()) {
            case PLAIN: {
                return StrokeFactory.generatePlainStroke(style, metrics);
            }
            case DOTS: {
                return StrokeFactory.generateDotsStroke(style, metrics);
            }
            case DASHES: {
                return StrokeFactory.generateDashesStroke(style, metrics);
            }
        }
        return null;
    }

    protected static Stroke generatePlainStroke(Style style, GraphMetrics metrics) {
        float width = (float)metrics.lengthToGu(style.getStrokeWidth());
        return new BasicStroke(width);
    }

    protected static Stroke generateDotsStroke(Style style, GraphMetrics metrics) {
        float width = (float)metrics.lengthToGu(style.getStrokeWidth());
        StrokeFactory.dots[0] = (float)metrics.lengthToGu(1.0, StyleConstants.Units.PX);
        StrokeFactory.dots[1] = dots[0];
        return new BasicStroke(width, 0, 0, 1.0f, dots, 0.0f);
    }

    protected static Stroke generateDashesStroke(Style style, GraphMetrics metrics) {
        float width = (float)metrics.lengthToGu(style.getStrokeWidth());
        StrokeFactory.dashes[0] = (float)metrics.lengthToGu(3.0, StyleConstants.Units.PX);
        StrokeFactory.dashes[1] = dashes[0];
        return new BasicStroke(width, 0, 0, 1.0f, dashes, 0.0f);
    }
}

