/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.util.set;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FixedArrayList<E>
implements Collection<E>,
RandomAccess {
    protected ArrayList<E> elements = new ArrayList();
    protected ArrayList<Integer> freeIndices = new ArrayList();
    protected int lastIndex = -1;

    public FixedArrayList() {
        this.elements = new ArrayList();
        this.freeIndices = new ArrayList(16);
    }

    public FixedArrayList(int capacity) {
        this.elements = new ArrayList(capacity);
        this.freeIndices = new ArrayList(16);
    }

    @Override
    public int size() {
        return this.elements.size() - this.freeIndices.size();
    }

    public int realSize() {
        return this.elements.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    public E get(int i) {
        E e = this.elements.get(i);
        if (e == null) {
            throw new NoSuchElementException("no element at index " + i);
        }
        return e;
    }

    public E unsafeGet(int i) {
        return this.elements.get(i);
    }

    @Override
    public boolean contains(Object o) {
        int n = this.elements.size();
        for (int i = 0; i < n; ++i) {
            E e = this.elements.get(i);
            if (e == null) continue;
            if (e == o) {
                return true;
            }
            if (!this.elements.equals(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof FixedArrayList) {
            FixedArrayList other = (FixedArrayList)o;
            int n = this.size();
            if (other.size() == n) {
                for (int i = 0; i < n; ++i) {
                    E e1;
                    E e0 = this.elements.get(i);
                    if (e0 == (e1 = other.elements.get(i))) continue;
                    if (e0 == null && e1 != null) {
                        return false;
                    }
                    if (e0 != null && e1 == null) {
                        return false;
                    }
                    if (e0.equals(e1)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public Iterator<E> iterator() {
        return new FixedArrayIterator();
    }

    public int getLastIndex() {
        return this.lastIndex;
    }

    public int getNextAddIndex() {
        int n = this.freeIndices.size();
        if (n > 0) {
            return this.freeIndices.get(n - 1);
        }
        return this.elements.size();
    }

    @Override
    public Object[] toArray() {
        int n = this.size();
        int m = this.elements.size();
        int j = 0;
        Object[] a = new Object[n];
        for (int i = 0; i < m; ++i) {
            E e = this.elements.get(i);
            if (e == null) continue;
            a[j++] = e;
        }
        assert (j == n);
        return a;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        throw new RuntimeException("not implemented yet");
    }

    @Override
    public boolean add(E element) throws NullPointerException {
        if (element == null) {
            throw new NullPointerException("this array cannot contain null value");
        }
        int n = this.freeIndices.size();
        if (n > 0) {
            int i = this.freeIndices.remove(n - 1);
            this.elements.set(i, element);
            this.lastIndex = i;
        } else {
            this.elements.add(element);
            this.lastIndex = this.elements.size() - 1;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) throws UnsupportedOperationException {
        Iterator<E> k = c.iterator();
        while (k.hasNext()) {
            this.add(k.next());
        }
        return true;
    }

    public E remove(int i) {
        int n = this.elements.size();
        if (i < 0 || i >= n) {
            throw new ArrayIndexOutOfBoundsException("index " + i + " does not exist");
        }
        if (n > 0) {
            if (this.elements.get(i) == null) {
                throw new NullPointerException("no element stored at index " + i);
            }
            if (i == n - 1) {
                return this.elements.remove(i);
            }
            E e = this.elements.get(i);
            this.elements.set(i, null);
            this.freeIndices.add(i);
            return e;
        }
        throw new ArrayIndexOutOfBoundsException("index " + i + " does not exist");
    }

    protected void removeIt(int i) {
        this.remove(i);
    }

    @Override
    public boolean remove(Object e) {
        int n = this.elements.size();
        for (int i = 0; i < n; ++i) {
            if (this.elements.get(i) != e) continue;
            this.elements.remove(i);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException("not implemented yet");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("not implemented yet");
    }

    @Override
    public void clear() {
        this.elements.clear();
        this.freeIndices.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class FixedArrayIterator
    implements Iterator<E> {
        int i = -1;

        @Override
        public boolean hasNext() {
            int n = FixedArrayList.this.elements.size();
            for (int j = this.i + 1; j < n; ++j) {
                if (FixedArrayList.this.elements.get(j) == null) continue;
                return true;
            }
            return false;
        }

        @Override
        public E next() {
            int n = FixedArrayList.this.elements.size();
            for (int j = this.i + 1; j < n; ++j) {
                Object e = FixedArrayList.this.elements.get(j);
                if (e == null) continue;
                this.i = j;
                return e;
            }
            throw new NoSuchElementException("no more elements in iterator");
        }

        @Override
        public void remove() throws UnsupportedOperationException {
            if (this.i < 0 || this.i >= FixedArrayList.this.elements.size() || FixedArrayList.this.elements.get(this.i) == null) {
                throw new IllegalStateException("no such element");
            }
            FixedArrayList.this.removeIt(this.i);
        }
    }
}

